/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class WeakPropertyChangeSupport {
    private transient ArrayList listeners = new ArrayList();
    private transient ArrayList interestNames = new ArrayList();

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.addLImpl(null, l);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.addLImpl(propertyName, l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        int cnt = this.listeners.size();
        int i = 0;
        while (i < cnt) {
            Object o = ((WeakReference)this.listeners.get(i)).get();
            if (o == null || o == l) {
                this.listeners.remove(i);
                this.interestNames.remove(i);
                --i;
                --cnt;
            }
            ++i;
        }
    }

    public void firePropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        String[] isa;
        PropertyChangeListener[] la;
        int cnt;
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        WeakPropertyChangeSupport weakPropertyChangeSupport = this;
        synchronized (weakPropertyChangeSupport) {
            cnt = this.listeners.size();
            la = new PropertyChangeListener[cnt];
            int i = 0;
            while (i < cnt) {
                PropertyChangeListener l = (PropertyChangeListener)((WeakReference)this.listeners.get(i)).get();
                if (l == null) {
                    this.listeners.remove(i);
                    this.interestNames.remove(i);
                    --i;
                    --cnt;
                } else {
                    la[i] = l;
                }
                ++i;
            }
            isa = this.interestNames.toArray(new String[cnt]);
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        int i = 0;
        while (i < cnt) {
            if (isa[i] == null || propertyName == null || isa[i].equals(propertyName)) {
                la[i].propertyChange(evt);
            }
            ++i;
        }
    }

    private void addLImpl(String sn, PropertyChangeListener l) {
        this.listeners.add(new WeakReference<PropertyChangeListener>(l));
        this.interestNames.add(sn);
    }
}

