/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;

public interface CompletionQuery {
    public Result query(JTextComponent var1, int var2, SyntaxSupport var3);

    public static class DefaultResultItem
    extends AbstractResultItem {
        static JLabel rubberStamp = new JLabel();
        protected Color foreColor;

        public DefaultResultItem(String text, Color foreColor) {
            super(text);
            this.foreColor = foreColor;
        }

        public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
            rubberStamp.setText(" " + this.text);
            if (isSelected) {
                rubberStamp.setBackground(list.getSelectionBackground());
                rubberStamp.setForeground(list.getSelectionForeground());
            } else {
                rubberStamp.setBackground(list.getBackground());
                rubberStamp.setForeground(this.foreColor);
            }
            return rubberStamp;
        }

        static {
            rubberStamp.setOpaque(true);
        }
    }

    public static abstract class AbstractResultItem
    implements ResultItem {
        protected String text;

        public AbstractResultItem(String text) {
            this.text = text;
        }

        public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            try {
                doc.atomicLock();
                try {
                    doc.remove(offset, len);
                    doc.insertString(offset, this.text.substring(0, subLen), null);
                    Object var7_6 = null;
                    doc.atomicUnlock();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    doc.atomicUnlock();
                    throw throwable;
                }
            }
            catch (BadLocationException exc) {
                return false;
            }
            return true;
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            try {
                doc.atomicLock();
                try {
                    doc.remove(offset, len);
                    doc.insertString(offset, this.text, null);
                    Object var7_6 = null;
                    doc.atomicUnlock();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    doc.atomicUnlock();
                    throw throwable;
                }
            }
            catch (BadLocationException exc) {
                return false;
            }
            return true;
        }

        public String getItemText() {
            return this.text;
        }

        public abstract Component getPaintComponent(JList var1, boolean var2, boolean var3);
    }

    public static interface ResultItem {
        public boolean substituteCommonText(JTextComponent var1, int var2, int var3, int var4);

        public boolean substituteText(JTextComponent var1, int var2, int var3, boolean var4);

        public String getItemText();

        public Component getPaintComponent(JList var1, boolean var2, boolean var3);
    }

    public static class DefaultResult
    extends AbstractResult {
        private JTextComponent component;
        private int offset;
        private int len;

        public DefaultResult(JTextComponent component, String title, List data, int offset, int len) {
            super(data, title);
            this.component = component;
            this.offset = offset;
            this.len = len;
        }

        private int getCommonPrefixLength(char[] commonPrefix, int len, String s) {
            char[] c = s.toCharArray();
            int i = 0;
            if (len > c.length) {
                len = c.length;
            }
            while (i < len) {
                if (commonPrefix[i] != c[i]) break;
                ++i;
            }
            return i;
        }

        public boolean substituteCommonText(int dataIndex) {
            List data = this.getData();
            if (data.size() == 0) {
                return false;
            }
            Iterator i = data.iterator();
            char[] commonPrefix = ((ResultItem)i.next()).getItemText().toCharArray();
            int commonLength = commonPrefix.length;
            while (i.hasNext()) {
                String second = ((ResultItem)i.next()).getItemText();
                commonLength = this.getCommonPrefixLength(commonPrefix, commonLength, second);
            }
            ResultItem actData = (ResultItem)data.get(dataIndex);
            return actData.substituteCommonText(this.component, this.offset, this.len, commonLength);
        }

        public boolean substituteText(int dataIndex, boolean shift) {
            Object actData = this.getData().get(dataIndex);
            return ((ResultItem)actData).substituteText(this.component, this.offset, this.len, shift);
        }
    }

    public static abstract class AbstractResult
    implements Result {
        private List data;
        private String title;

        public AbstractResult(List data, String title) {
            this.data = data;
            this.title = title;
        }

        public List getData() {
            return this.data;
        }

        public String getTitle() {
            return this.title;
        }

        public abstract boolean substituteCommonText(int var1);

        public abstract boolean substituteText(int var1, boolean var2);
    }

    public static interface Result {
        public List getData();

        public String getTitle();

        public boolean substituteText(int var1, boolean var2);

        public boolean substituteCommonText(int var1);
    }

    public static interface SupportsSpeculativeInvocation {
    }
}

