/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.FindDialogPanel;

public class FindDialogSupport
extends WindowAdapter
implements ActionListener {
    private static final String HISTORY_KEY_BASE = "FindDialogSupport.";
    private static final String BOUNDS_FIND = "FindDialogSupport.bounds-find";
    private static final String BOUNDS_REPLACE = "FindDialogSupport.bounds-replace";
    private Object dialogLock = new Object();
    private boolean isReplaceDialog;
    private JButton[] findButtons;
    private FindPanel findPanel;
    private Dialog findDialog;
    protected Timer incSearchTimer;
    private static final String MNEMONIC_SUFFIX = "-mnemonic";
    private static final String A11Y_PREFIX = "ACSD_";

    public FindDialogSupport() {
        int delay = SettingsUtil.getInteger(null, "find-inc-search-delay", 200);
        this.incSearchTimer = new Timer(delay, new WeakTimerListener(this));
        this.incSearchTimer.setRepeats(false);
    }

    private JButton[] createFindButtons() {
        JButton[] buttons = new JButton[]{new JButton(LocaleSupport.getString("find-button-find")), new JButton(LocaleSupport.getString("find-button-replace")), new JButton(LocaleSupport.getString("find-button-replace-all")), new JButton(LocaleSupport.getString("find-button-cancel"))};
        buttons[1].setMnemonic(LocaleSupport.getChar("find-button-replace-mnemonic", 'R'));
        buttons[2].setMnemonic(LocaleSupport.getChar("find-button-replace-all-mnemonic", 'A'));
        buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-find"));
        buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-replace"));
        buttons[2].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-replace-all"));
        buttons[3].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_find-button-cancel"));
        return buttons;
    }

    private void loadBounds(Dialog d, String key) {
        d.pack();
        Rectangle lastBounds = (Rectangle)EditorState.get(key);
        if (lastBounds != null) {
            ((Component)d).setBounds(lastBounds);
        } else {
            Dimension dim = d.getPreferredSize();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int x = Math.max(0, (screen.width - dim.width) / 2);
            int y = Math.max(0, (screen.height - dim.height) / 2);
            ((Component)d).setLocation(x, y);
        }
    }

    private void saveBounds(Dialog d, String key) {
        EditorState.put(key, d.getBounds());
    }

    private Dialog createFindDialog(JPanel findPanel, JButton[] buttons, ActionListener l) {
        Dialog d = DialogSupport.createDialog(this.isReplaceDialog ? LocaleSupport.getString("replace-title") : LocaleSupport.getString("find-title"), findPanel, false, buttons, true, 0, 3, l);
        return d;
    }

    private void showFindDialogImpl(boolean isReplace) {
        Object object = this.dialogLock;
        synchronized (object) {
            if (this.findDialog != null) {
                if (this.isReplaceDialog == isReplace) {
                    this.findDialog.toFront();
                } else {
                    this.saveBounds(this.findDialog, this.isReplaceDialog ? BOUNDS_REPLACE : BOUNDS_FIND);
                    this.isReplaceDialog = isReplace;
                    this.findButtons[1].setVisible(isReplace);
                    this.findButtons[2].setVisible(isReplace);
                    if (isReplace) {
                        this.findDialog.setTitle(LocaleSupport.getString("replace-title"));
                        this.findPanel.updateReplace();
                    } else {
                        this.findDialog.setTitle(LocaleSupport.getString("find-title"));
                        this.findPanel.updateFind();
                    }
                    this.loadBounds(this.findDialog, isReplace ? BOUNDS_REPLACE : BOUNDS_FIND);
                }
            } else {
                this.isReplaceDialog = isReplace;
                this.findButtons = this.createFindButtons();
                this.findButtons[1].setVisible(isReplace);
                this.findButtons[2].setVisible(isReplace);
                this.findPanel = new FindPanel();
                if (isReplace) {
                    this.findPanel.updateReplace();
                } else {
                    this.findPanel.updateFind();
                }
                this.findDialog = this.createFindDialog(this.findPanel, this.findButtons, this);
                this.loadBounds(this.findDialog, isReplace ? BOUNDS_REPLACE : BOUNDS_FIND);
                this.findDialog.addWindowListener(this);
            }
        }
        ((Component)this.findDialog).setVisible(true);
        this.findDialog.requestFocus();
        this.findPanel.updateFocus();
    }

    public void windowActivated(WindowEvent evt) {
        this.incSearchTimer.start();
    }

    public void windowDeactivated(WindowEvent evt) {
        this.incSearchTimer.stop();
        FindSupport.getFindSupport().incSearchReset();
    }

    public void windowClosing(WindowEvent evt) {
        this.hideDialog();
    }

    public void windowClosed(WindowEvent evt) {
        this.incSearchTimer.stop();
        FindSupport.getFindSupport().incSearchReset();
        Utilities.returnFocus();
    }

    public void showFindDialog() {
        this.showFindDialogImpl(false);
    }

    public void showReplaceDialog() {
        this.showFindDialogImpl(true);
    }

    private void hideDialog() {
        Object object = this.dialogLock;
        synchronized (object) {
            if (this.findDialog != null) {
                this.saveBounds(this.findDialog, this.isReplaceDialog ? BOUNDS_REPLACE : BOUNDS_FIND);
                this.findDialog.dispose();
                this.findButtons = null;
                this.findPanel = null;
                this.findDialog = null;
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JButton[] fb = this.findButtons;
        if (fb == null) {
            return;
        }
        Object src = evt.getSource();
        FindSupport fSup = FindSupport.getFindSupport();
        if (src == fb[0]) {
            this.findPanel.updateFindHistory();
            this.findPanel.save();
            if (fSup.find(null, false)) {
                // empty if block
            }
            if (!this.isReplaceDialog) {
                this.hideDialog();
            }
        } else if (src == fb[1]) {
            this.findPanel.updateFindHistory();
            this.findPanel.updateReplaceHistory();
            this.findPanel.save();
            try {
                if (fSup.replace(null, false)) {
                    fSup.find(null, false);
                }
            }
            catch (GuardedException e) {
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (src == fb[2]) {
            this.findPanel.updateFindHistory();
            this.findPanel.updateReplaceHistory();
            this.findPanel.save();
            fSup.replaceAll(null);
        } else if (src == fb[3]) {
            this.hideDialog();
            JTextComponent c = Utilities.getLastActiveComponent();
            if (c != null) {
                c.getCaret().setDot(c.getCaret().getDot());
            }
        } else if (src == this.incSearchTimer) {
            fSup.incSearch(this.findPanel.getFindProps());
        } else {
            JTextComponent c = Utilities.getLastActiveComponent();
            if (c != null) {
                c.getCaret().setDot(c.getCaret().getDot());
            }
        }
    }

    public class FindPanel
    extends FindDialogPanel
    implements ItemListener,
    KeyListener,
    ActionListener {
        Map findProps = Collections.synchronizedMap(new HashMap(20));
        Map objToProps = Collections.synchronizedMap(new HashMap(20));
        FindSupport findSupport = FindSupport.getFindSupport();
        static final long serialVersionUID = 917425125419841466L;

        FindPanel() {
            this.objToProps.put(this.findWhat, "find-what");
            this.objToProps.put(this.replaceWith, "find-replace-with");
            this.objToProps.put(this.highlightSearch, "find-highlight-search");
            this.objToProps.put(this.incSearch, "find-inc-search");
            this.objToProps.put(this.matchCase, "find-match-case");
            this.objToProps.put(this.smartCase, "find-smart-case");
            this.objToProps.put(this.wholeWords, "find-whole-words");
            this.objToProps.put(this.regExp, "find-reg-exp");
            this.objToProps.put(this.bwdSearch, "find-backward-search");
            this.objToProps.put(this.wrapSearch, "find-wrap-search");
            this.regExp.setEnabled(false);
            this.regExp.setVisible(false);
            this.load();
            this.findWhat.getEditor().getEditorComponent().addKeyListener(this);
            this.findWhat.addActionListener(this);
            this.replaceWith.getEditor().getEditorComponent().addKeyListener(this);
            this.replaceWith.addActionListener(this);
            this.highlightSearch.addItemListener(this);
            this.incSearch.addItemListener(this);
            this.matchCase.addItemListener(this);
            this.smartCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.regExp.addItemListener(this);
            this.bwdSearch.addItemListener(this);
            this.wrapSearch.addItemListener(this);
        }

        protected Map getFindProps() {
            return this.findProps;
        }

        void putProperty(Object component, Object value) {
            String prop = (String)this.objToProps.get(component);
            if (prop != null) {
                this.findProps.put(prop, value);
                FindDialogSupport.this.incSearchTimer.restart();
            }
        }

        Object getProperty(Object component) {
            String prop = (String)this.objToProps.get(component);
            return prop != null ? this.findProps.get(prop) : null;
        }

        boolean getBooleanProperty(Object component) {
            Object prop = this.getProperty(component);
            return prop != null ? (Boolean)prop : false;
        }

        private void changeVisibility(boolean v) {
            this.replaceWith.setVisible(v);
            this.replaceWithLabel.setVisible(v);
        }

        protected void updateFocus() {
            JTextComponent c = Utilities.getLastActiveComponent();
            String selText = null;
            if (c != null) {
                selText = c.getSelectedText();
                if (selText != null) {
                    int n = selText.indexOf(10);
                    if (n >= 0) {
                        selText = selText.substring(0, n);
                    }
                    this.updateFindWhat(selText.trim());
                    this.changeFindWhat();
                } else if (this.getProperty(this.findWhat) != null) {
                    this.findWhat.getEditor().setItem(this.getProperty(this.findWhat));
                }
            }
            String selTextFinal = selText;
            SwingUtilities.invokeLater(new Runnable(this, selTextFinal){
                private final /* synthetic */ String val$selTextFinal;
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$selTextFinal = val$selTextFinal;
                }

                public void run() {
                    this.this$1.updateFindWhat(this.val$selTextFinal);
                    this.this$1.findWhat.getEditor().getEditorComponent().requestFocus();
                    this.this$1.findWhat.getEditor().selectAll();
                }
            });
        }

        protected void updateFind() {
            this.changeVisibility(false);
        }

        protected void updateReplace() {
            this.changeVisibility(true);
        }

        private List getHistory(String identifier) {
            ArrayList history = (ArrayList)EditorState.get(FindDialogSupport.HISTORY_KEY_BASE + identifier + "-history");
            if (history == null) {
                history = new ArrayList();
            }
            return history;
        }

        private void putHistory(String identifier, List history) {
            EditorState.put(FindDialogSupport.HISTORY_KEY_BASE + identifier + "-history", history);
        }

        private void updateHistory(JComboBox c, String identifier) {
            Object item = c.getEditor().getItem();
            List history = this.getHistory(identifier);
            if (item != null) {
                int index = history.indexOf(item);
                if (index >= 0) {
                    history.remove(index);
                }
                history.add(0, item);
            }
            this.putHistory(identifier, history);
            DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>(history.toArray());
            c.setModel(m);
        }

        protected void updateFindHistory() {
            this.updateHistory(this.findWhat, "find");
        }

        protected void updateReplaceHistory() {
            this.updateHistory(this.replaceWith, "replace");
        }

        protected void updateFindWhat(String selectedText) {
            this.findWhat.getEditor().setItem(selectedText);
        }

        private void revertMap() {
            Object prop = this.findProps.get("revert-map");
            if (!(prop instanceof Map)) {
                return;
            }
            Map revertMap = (Map)prop;
            Iterator i = revertMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object obj = this.findProps.get(key);
                boolean value = obj != null ? (Boolean)obj : false;
                value = !value;
                this.findProps.put(key, value ? Boolean.TRUE : Boolean.FALSE);
            }
            this.findProps.put("revert-map", null);
        }

        void load() {
            this.findProps.putAll(this.findSupport.getFindProperties());
            this.revertMap();
            List history = this.getHistory("find");
            DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>(history.toArray());
            this.findWhat.setModel(m);
            history = this.getHistory("replace");
            m = new DefaultComboBoxModel<Object>(history.toArray());
            this.replaceWith.setModel(m);
            this.findWhat.getEditor().setItem(this.getProperty(this.findWhat));
            this.replaceWith.getEditor().setItem(this.getProperty(this.replaceWith));
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.smartCase.setSelected(this.getBooleanProperty(this.smartCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            this.regExp.setSelected(this.getBooleanProperty(this.regExp));
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
        }

        void save() {
            this.findSupport.putFindProperties(this.findProps);
        }

        void changeFindWhat() {
            Object old = this.getProperty(this.findWhat);
            Object cur = this.findWhat.getEditor().getItem();
            if (old == null || !old.equals(cur)) {
                this.putProperty(this.findWhat, cur);
            }
        }

        void changeReplaceWith() {
            Object old = this.getProperty(this.replaceWith);
            Object cur = this.replaceWith.getEditor().getItem();
            if (old == null || !old.equals(cur)) {
                this.putProperty(this.replaceWith, cur);
            }
        }

        private void postChangeCombos() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.changeFindWhat();
                    this.this$1.changeReplaceWith();
                    if (this.this$1.regExp.isSelected()) {
                        // empty if block
                    }
                }
            });
        }

        public void keyPressed(KeyEvent evt) {
            this.postChangeCombos();
        }

        public void keyReleased(KeyEvent evt) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.changeFindWhat();
                    this.this$1.changeReplaceWith();
                }
            });
        }

        public void keyTyped(KeyEvent evt) {
            if (evt.getKeyChar() == '\n') {
                FindDialogSupport.this.actionPerformed(new ActionEvent(FindDialogSupport.this.findButtons[0], 0, null));
            }
        }

        public void itemStateChanged(ItemEvent evt) {
            Boolean val = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
            this.putProperty(evt.getSource(), val);
        }

        public void actionPerformed(ActionEvent evt) {
            this.postChangeCombos();
        }
    }
}

