/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.Registry;

public class HTMLSyntaxSupport
extends ExtSyntaxSupport
implements InvalidateListener {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private DTD dtd;
    private String docType;

    public HTMLSyntaxSupport(BaseDocument doc) {
        super(doc);
    }

    public void dtdInvalidated(InvalidateEvent evt) {
        if (this.dtd != null && evt.isInvalidatedIdentifier(this.docType)) {
            this.dtd = null;
        }
    }

    public DTD getDTD() {
        String type = this.getDocType();
        if (type == null) {
            type = FALLBACK_DOCTYPE;
        }
        if (this.dtd != null && type == this.docType) {
            return this.dtd;
        }
        this.docType = type;
        this.dtd = Registry.getDTD(this.docType, null);
        return this.dtd;
    }

    protected String getDocType() {
        try {
            SyntaxElement elem = this.getElementChain(0);
            if (elem == null) {
                return null;
            }
            int type = elem.getType();
            while (type != 1 && type != 4) {
                if ((elem = elem.getNext()) == null) break;
                type = elem.getType();
            }
            if (type == 1) {
                return ((SyntaxElement.Declaration)elem).getPublicIdentifier();
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private final int getTokenEnd(TokenItem item) {
        return item.getOffset() + item.getImage().length();
    }

    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        TokenItem first = this.getTokenChain(offset, Math.min(offset + 10, this.getDocument().getLength()));
        TokenItem item = first;
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        int beginning = item.getOffset();
        if (id == HTMLTokenContext.CHARACTER) {
            while (id != null && id == HTMLTokenContext.CHARACTER) {
                beginning = item.getOffset();
                TokenID tokenID = id = (item = item.getPrevious()) == null ? null : item.getTokenID();
            }
            if (id != HTMLTokenContext.VALUE && id != HTMLTokenContext.TEXT) {
                return this.getNextElement(beginning);
            }
        }
        if (id == HTMLTokenContext.WS || id == HTMLTokenContext.ARGUMENT || id == HTMLTokenContext.OPERATOR || id == HTMLTokenContext.VALUE) {
            while ((id = (item = item.getPrevious()).getTokenID()) != HTMLTokenContext.TAG) {
            }
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.TEXT) {
            while (id != null && (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER)) {
                beginning = item.getOffset();
                TokenID tokenID = id = (item = item.getPrevious()) == null ? null : item.getTokenID();
            }
            return this.getNextElement(beginning);
        }
        if (id == HTMLTokenContext.TAG) {
            if (item.getImage().startsWith("<")) {
                return this.getNextElement(item.getOffset());
            }
            while ((id = (item = item.getPrevious()).getTokenID()) != HTMLTokenContext.TAG) {
            }
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, item.getOffset(), this.getTokenEnd(item), 2);
        }
        if (id == HTMLTokenContext.BLOCK_COMMENT) {
            while (id == HTMLTokenContext.BLOCK_COMMENT && !item.getImage().startsWith("<!--")) {
                item = item.getPrevious();
                id = item.getTokenID();
            }
            return this.getNextElement(item.getOffset());
        }
        if (id == HTMLTokenContext.DECLARATION || id == HTMLTokenContext.SGML_COMMENT) {
            while (id != HTMLTokenContext.DECLARATION || !item.getImage().startsWith("<!")) {
                item = item.getPrevious();
                id = item.getTokenID();
            }
            return this.getNextElement(item.getOffset());
        }
        return null;
    }

    SyntaxElement getPreviousElement(int offset) throws BadLocationException {
        return offset == 0 ? null : this.getElementChain(offset - 1);
    }

    /*
     * Unable to fully structure code
     */
    private static String getQuotedString(StringBuffer data) {
        startIndex = 0;
        if (data != null && data.length() != 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            ++startIndex;
lbl5:
            // 2 sources

            ** while (data.charAt((int)startIndex) == ' ')
        }
lbl6:
        // 1 sources

        if ((stopMark = data.charAt(startIndex++)) == '\"' || stopMark == '\'') {
            index = startIndex;
            while (index < data.length()) {
                if (data.charAt(index) == stopMark) {
                    quoted = data.substring(startIndex, index);
                    data.delete(0, index + 1);
                    return quoted;
                }
                ++index;
            }
        }
        return null;
    }

    public SyntaxElement getNextElement(int offset) throws BadLocationException {
        TokenItem item = this.getTokenChain(offset, Math.min(offset + 10, this.getDocument().getLength()));
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        int lastOffset = this.getTokenEnd(item);
        if (id == HTMLTokenContext.BLOCK_COMMENT) {
            while (id == HTMLTokenContext.BLOCK_COMMENT) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
            }
            return new SyntaxElement(this, offset, lastOffset, 0);
        }
        if (id == HTMLTokenContext.DECLARATION) {
            String si;
            String image;
            StringBuffer sb = new StringBuffer(item.getImage());
            while (id == HTMLTokenContext.DECLARATION || id == HTMLTokenContext.SGML_COMMENT) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
                if (id != HTMLTokenContext.DECLARATION) continue;
                sb.append(item.getImage());
            }
            if (!(image = sb.toString()).startsWith("<!DOCTYPE")) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
            }
            int index = (image = image.substring(9).trim()).indexOf(32);
            if (index < 0) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
            }
            String rootElem = image.substring(0, index);
            if ((image = image.substring(index).trim()).startsWith("PUBLIC")) {
                sb = new StringBuffer(image = image.substring(6).trim());
                String pi = HTMLSyntaxSupport.getQuotedString(sb);
                if (pi != null) {
                    String si2 = HTMLSyntaxSupport.getQuotedString(sb);
                    return new SyntaxElement.Declaration(this, offset, lastOffset, rootElem, pi, si2);
                }
            } else if (image.startsWith("SYSTEM") && (si = HTMLSyntaxSupport.getQuotedString(sb = new StringBuffer(image = image.substring(6).trim()))) != null) {
                return new SyntaxElement.Declaration(this, offset, lastOffset, rootElem, null, si);
            }
            return new SyntaxElement.Declaration(this, offset, lastOffset, null, null, null);
        }
        if (id == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, item.getOffset(), lastOffset, 2);
        }
        if (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER) {
            while (id == HTMLTokenContext.TEXT || id == HTMLTokenContext.CHARACTER) {
                lastOffset = this.getTokenEnd(item);
                if ((item = item.getNext()) == null) break;
                id = item.getTokenID();
            }
            return new SyntaxElement(this, offset, lastOffset, 3);
        }
        String text = item.getImage();
        if (id == HTMLTokenContext.TAG) {
            if (text.startsWith("</")) {
                String name = text.substring(2);
                id = (item = item.getNext()) == null ? null : item.getTokenID();
                while (id == HTMLTokenContext.WS) {
                    lastOffset = this.getTokenEnd(item);
                    TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
                }
                if (id == HTMLTokenContext.TAG && item.getImage().equals(">")) {
                    return new SyntaxElement.Named(this, offset, this.getTokenEnd(item), 5, name);
                }
                return new SyntaxElement.Named(this, offset, lastOffset, 5, name);
            }
            String name = text.substring(1);
            ArrayList<String> attrs = new ArrayList<String>();
            id = (item = item.getNext()) == null ? null : item.getTokenID();
            while (id == HTMLTokenContext.WS || id == HTMLTokenContext.ARGUMENT || id == HTMLTokenContext.OPERATOR || id == HTMLTokenContext.VALUE || id == HTMLTokenContext.CHARACTER) {
                if (id == HTMLTokenContext.ARGUMENT) {
                    attrs.add(item.getImage());
                }
                lastOffset = this.getTokenEnd(item);
                TokenID tokenID = id = (item = item.getNext()) == null ? null : item.getTokenID();
            }
            if (id == HTMLTokenContext.TAG && item.getImage().equals(">")) {
                return new SyntaxElement.Tag(this, offset, this.getTokenEnd(item), name, attrs);
            }
            return new SyntaxElement.Tag(this, offset, lastOffset, name, attrs);
        }
        throw new BadLocationException("Misuse at " + offset, offset);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List getPossibleEndTags(int offset, String prefix) throws BadLocationException {
        prefix = prefix.toUpperCase();
        int prefixLen = prefix.length();
        SyntaxElement elem = this.getElementChain(offset);
        Stack<String> stack = new Stack<String>();
        ArrayList<HTMLCompletionQuery.EndTagItem> result = new ArrayList<HTMLCompletionQuery.EndTagItem>();
        HashSet<String> found = new HashSet<String>();
        DTD dtd = this.getDTD();
        if (elem != null) {
            elem = elem.getPrevious();
        } else {
            if (offset <= 0) return result;
            elem = this.getElementChain(offset - 1);
        }
        while (elem != null) {
            DTD.Element tag;
            if (elem.getType() == 5) {
                stack.push(((SyntaxElement.Named)elem).getName().toUpperCase());
            } else if (elem.getType() == 4 && (tag = dtd.getElement(((SyntaxElement.Tag)elem).getName().toUpperCase())) != null && !tag.isEmpty()) {
                String name = tag.getName();
                if (stack.empty()) {
                    if (name.startsWith(prefix) && !found.contains(name)) {
                        found.add(name);
                        result.add(new HTMLCompletionQuery.EndTagItem(name, offset - 2 - prefixLen, prefixLen + 2));
                    }
                    if (!tag.hasOptionalEnd()) {
                        return result;
                    }
                } else if (stack.peek().equals(name)) {
                    stack.pop();
                } else if (!tag.hasOptionalEnd()) {
                    return result;
                }
            }
            elem = elem.getPrevious();
        }
        return result;
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        if (!visible) {
            int retVal = 1;
            switch (typedText.charAt(typedText.length() - 1)) {
                case '/': {
                    int dotPos = target.getCaret().getDot();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (dotPos < 2) break;
                    try {
                        String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                        if (!txtBeforeSpace.equals("</")) break;
                        retVal = 0;
                    }
                    catch (BadLocationException e) {}
                    break;
                }
                case ' ': 
                case '&': 
                case '<': {
                    retVal = 0;
                }
            }
            return retVal;
        }
        switch (typedText.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }
}

