/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCBaseFinder
extends JavaCompletion.AbstractProvider
implements JCFinder {
    static final Comparator CLASS_NAME_COMPARATOR = new DefaultClassNameComparator();
    static final Comparator INSENSITIVE_CLASS_NAME_COMPARATOR = new InsensitiveClassNameComparator();
    static final Comparator NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator();
    private static final int PACKAGE_PRE_ALLOC = 1009;
    private static final int CLASS_PRE_ALLOC = 5003;
    protected JCPackage[] allPackages;
    protected JCClass[] allClassesByName;
    protected HashMap allPackagesMap = new HashMap(1009);
    protected HashMap allClassesMap = new HashMap(5003);
    private static boolean caseSensitive = true;
    private static boolean showDeprecated = true;
    private static boolean naturalSort = false;
    private Object sorted;

    public Iterator getClasses() {
        return ((AbstractList)new ArrayList<JCClass>(Arrays.asList(this.getAllClasses()))).iterator();
    }

    public synchronized boolean append(JCClassProvider cp) {
        return super.append(cp);
    }

    public synchronized boolean remove(JCClassProvider cp) {
        return super.remove(cp);
    }

    protected boolean removeClass(JCClass cls) {
        this.invalidate();
        return this.allClassesMap.remove(cls.getFullName()) != null;
    }

    protected boolean appendClass(JCClass cls) {
        if (!this.cheapUpdate(cls)) {
            this.invalidate();
        }
        return true;
    }

    public synchronized void reset() {
        this.allClassesMap.clear();
        this.invalidate();
    }

    protected void invalidate() {
        this.allPackagesMap.clear();
        this.allPackages = null;
        this.allClassesByName = null;
    }

    public synchronized JCPackage getExactPackage(String packageName) {
        if (this.allPackages == null) {
            this.build();
        }
        return (JCPackage)this.allPackagesMap.get(packageName);
    }

    public synchronized JCClass getExactClass(String classFullName) {
        return (JCClass)this.allClassesMap.get(classFullName);
    }

    protected JCPackage[] getAllPackages() {
        if (this.allPackages == null) {
            this.build();
        }
        return this.allPackages;
    }

    protected JCClass[] getAllClassesByName() {
        if (this.allClassesByName == null) {
            this.build();
        }
        return this.allClassesByName;
    }

    protected JCClass[] getAllClasses() {
        Object[] allClasses = (JCClass[])this.getAllClassesByName().clone();
        Arrays.sort(allClasses);
        return allClasses;
    }

    private boolean cheapUpdate(JCClass cls) {
        JCClass o = this.allClassesMap.put(cls.getFullName(), cls);
        if (this.allClassesByName != null && o != null) {
            String pkgName = cls.getPackageName();
            JCPackage pkg = (JCPackage)this.allPackagesMap.get(pkgName);
            if (pkg == null) {
                return false;
            }
            Object[] clist = pkg.getClasses();
            int ind = Arrays.binarySearch(clist, cls);
            if (ind < 0) {
                return false;
            }
            clist[ind] = cls;
            int n = ind = caseSensitive ? Arrays.binarySearch(this.allClassesByName, cls, CLASS_NAME_COMPARATOR) : Arrays.binarySearch(this.allClassesByName, cls, INSENSITIVE_CLASS_NAME_COMPARATOR);
            if (ind < 0) {
                ind = -ind - 1;
            }
            String name = cls.getName();
            while (ind >= 0 && ind < this.allClassesByName.length) {
                if (!this.startsWith(this.allClassesByName[ind].getName(), name)) break;
                --ind;
            }
            ++ind;
            boolean updated = false;
            while (ind < this.allClassesByName.length) {
                if (cls.equals(this.allClassesByName[ind])) {
                    this.allClassesByName[ind] = cls;
                    updated = true;
                    break;
                }
                if (!name.equals(this.allClassesByName[ind].getName())) break;
                ++ind;
            }
            return updated;
        }
        return false;
    }

    private void addPackage(JCPackage pkg, boolean force) {
        if (force || !this.allPackagesMap.containsKey(pkg)) {
            if (pkg.getName().length() == 0) {
                return;
            }
            this.allPackagesMap.put(pkg.getName(), pkg);
            String name = pkg.getName();
            int i = name.lastIndexOf(46);
            if (i >= 0) {
                this.addPackage(new JavaCompletion.BasePackage(name.substring(0, i)), false);
            }
        }
    }

    protected void build() {
        Object[] allClasses = new JCClass[this.allClassesMap.size()];
        this.allClassesByName = new JCClass[allClasses.length];
        Iterator itr = this.allClassesMap.values().iterator();
        int ind = 0;
        while (itr.hasNext()) {
            allClasses[ind] = (JCClass)itr.next();
            this.allClassesByName[ind] = allClasses[ind];
            ++ind;
        }
        Arrays.sort(allClasses);
        if (caseSensitive) {
            Arrays.sort(this.allClassesByName, CLASS_NAME_COMPARATOR);
            this.sorted = CLASS_NAME_COMPARATOR;
        } else {
            Arrays.sort(this.allClassesByName, INSENSITIVE_CLASS_NAME_COMPARATOR);
            this.sorted = INSENSITIVE_CLASS_NAME_COMPARATOR;
        }
        this.allPackagesMap.clear();
        this.allPackages = JavaCompletion.EMPTY_PACKAGES;
        if (allClasses.length > 0) {
            ArrayList<Object> pkgClassList = new ArrayList<Object>();
            JavaCompletion.BasePackage curPkg = new JavaCompletion.BasePackage(allClasses[0].getPackageName());
            int i = 0;
            while (i < allClasses.length) {
                String pkgName = allClasses[i].getPackageName();
                if (!((Object)curPkg).equals(pkgName)) {
                    JCClass[] classes = new JCClass[pkgClassList.size()];
                    pkgClassList.toArray(classes);
                    curPkg.setClasses(classes);
                    pkgClassList.clear();
                    this.addPackage(curPkg, true);
                    curPkg = new JavaCompletion.BasePackage(pkgName);
                }
                pkgClassList.add(allClasses[i]);
                ++i;
            }
            JCClass[] classes = new JCClass[pkgClassList.size()];
            pkgClassList.toArray(classes);
            curPkg.setClasses(classes);
            this.addPackage(curPkg, true);
            this.allPackages = new JCPackage[this.allPackagesMap.size()];
            itr = this.allPackagesMap.values().iterator();
            ind = 0;
            while (itr.hasNext()) {
                this.allPackages[ind] = (JCPackage)itr.next();
                ++ind;
            }
        }
        Arrays.sort(this.allPackages);
    }

    public synchronized List findPackages(String name, boolean exactMatch, boolean subPackages) {
        ArrayList<JCPackage> ret = new ArrayList<JCPackage>();
        if (exactMatch) {
            JCPackage pkg = this.getExactPackage(name);
            if (pkg != null) {
                ret.add(pkg);
            }
            if (!subPackages) {
                return ret;
            }
        }
        JCPackage[] packages = this.getAllPackages();
        JavaCompletion.BasePackage key = new JavaCompletion.BasePackage(name);
        if (!caseSensitive) {
            Arrays.sort(packages, INSENSITIVE_CLASS_NAME_COMPARATOR);
        }
        int ind = Arrays.binarySearch(packages, key, caseSensitive ? CLASS_NAME_COMPARATOR : INSENSITIVE_CLASS_NAME_COMPARATOR);
        int nameLen = name.length();
        if (ind < 0) {
            ind = -ind - 1;
        }
        while (ind >= 0 && ind < packages.length) {
            if (!this.startsWith(packages[ind].getName(), name)) break;
            --ind;
        }
        ++ind;
        int reqDotCount = key.getDotCount();
        while (ind < packages.length) {
            String pkgName = packages[ind].getName();
            if (!this.startsWith(pkgName, name)) break;
            boolean bl = exactMatch ? pkgName.length() > nameLen && pkgName.charAt(nameLen) == '.' : subPackages || packages[ind].getDotCount() == reqDotCount;
            if (bl) {
                ret.add(packages[ind]);
            }
            ++ind;
        }
        return ret;
    }

    public synchronized List findClasses(JCPackage pkg, String name, boolean exactMatch) {
        int ind;
        JCClass[] classes;
        ArrayList<JCClass> ret = new ArrayList<JCClass>();
        JavaCompletion.SimpleClass key = new JavaCompletion.SimpleClass(name, "");
        int nameLen = name.length();
        if (pkg != null) {
            classes = pkg.getClasses();
            if (!caseSensitive) {
                Arrays.sort(classes, INSENSITIVE_CLASS_NAME_COMPARATOR);
            }
        } else {
            classes = this.getAllClassesByName();
        }
        if (caseSensitive) {
            if (!this.sorted.equals(CLASS_NAME_COMPARATOR)) {
                Arrays.sort(classes, CLASS_NAME_COMPARATOR);
                this.sorted = CLASS_NAME_COMPARATOR;
            }
            ind = Arrays.binarySearch(classes, key, CLASS_NAME_COMPARATOR);
        } else {
            if (!this.sorted.equals(INSENSITIVE_CLASS_NAME_COMPARATOR)) {
                Arrays.sort(classes, INSENSITIVE_CLASS_NAME_COMPARATOR);
                this.sorted = INSENSITIVE_CLASS_NAME_COMPARATOR;
            }
            ind = Arrays.binarySearch(classes, key, INSENSITIVE_CLASS_NAME_COMPARATOR);
        }
        if (ind < 0) {
            ind = -ind - 1;
        }
        while (ind >= 0 && ind < classes.length) {
            if (!this.startsWith(classes[ind].getName(), name)) break;
            --ind;
        }
        ++ind;
        while (ind < classes.length) {
            String className = classes[ind].getName();
            if (!this.startsWith(className, name)) break;
            if (!(exactMatch && className.length() != nameLen || !showDeprecated && JCUtilities.isDeprecated(classes[ind]))) {
                ret.add(classes[ind]);
            }
            ++ind;
        }
        Collections.sort(ret, naturalSort ? INSENSITIVE_CLASS_NAME_COMPARATOR : CLASS_NAME_COMPARATOR);
        return ret;
    }

    private List getOuterClasses(JCClass cls) {
        JCFinder finder = JavaCompletion.getFinder();
        ArrayList<JCClass> outers = new ArrayList<JCClass>();
        outers.add(cls);
        int lastDotInd = cls.getName().lastIndexOf(46);
        while (lastDotInd >= 0) {
            int pkgLen = cls.getPackageName().length();
            String fullName = cls.getFullName().substring(0, (pkgLen > 0 ? pkgLen + 1 : 0) + lastDotInd);
            if ((cls = finder.getExactClass(fullName)) == null) break;
            if (showDeprecated || !JCUtilities.isDeprecated(cls)) {
                outers.add(cls);
            }
            lastDotInd = cls.getName().lastIndexOf(46);
        }
        return outers;
    }

    public synchronized List findFields(JCClass cls, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses) {
        TreeSet<JCField> ts = naturalSort ? new TreeSet<JCField>(NATURAL_MEMBER_NAME_COMPARATOR) : new TreeSet();
        List clsList = this.getClassList(cls);
        String pkgName = cls.getPackageName();
        HashSet<JCClass> ifaces = new HashSet<JCClass>();
        JCClass innerClass = cls;
        int i = clsList.size() - 1;
        while (i >= 0) {
            cls = this.getExactClass(((JCClass)clsList.get(i)).getFullName());
            if (cls != null) {
                int outerInd;
                if (cls.isInterface()) {
                    ifaces.add(cls);
                }
                ifaces.addAll(JCUtilities.getAllInterfaces(cls));
                boolean difPkg = !cls.getPackageName().equals(pkgName);
                List outerList = i == 0 && inspectOuterClasses && cls.getName().indexOf(46) >= 0 ? this.getOuterClasses(cls) : null;
                int n = outerInd = outerList != null ? outerList.size() - 1 : -1;
                do {
                    if (outerInd >= 0) {
                        cls = (JCClass)outerList.get(outerInd--);
                    }
                    JCField[] fields = cls.getFields();
                    int j = 0;
                    while (j < fields.length) {
                        JCField fld = fields[j];
                        int mods = fld.getModifiers();
                        if (!(staticOnly && (mods & 8) == 0 || i > 0 && (mods & 2) != 0 || difPkg && (mods & 5) == 0 || outerInd > -1 && (innerClass.getModifiers() & 8) != 0 && (mods & 8) == 0 || (!exactMatch ? !this.startsWith(fld.getName(), name) : !fld.getName().equals(name)))) {
                            if (innerClass.equals(cls) && outerInd == -1) {
                                fld = new JavaCompletion.BaseField(cls, fld.getName(), fld.getType(), fld.getModifiers() | 0x20000000);
                            }
                            if (showDeprecated || !JCUtilities.isDeprecated(fld)) {
                                ts.add(fld);
                            }
                        }
                        ++j;
                    }
                } while (outerInd >= 0);
            }
            --i;
        }
        Iterator it = ifaces.iterator();
        while (it.hasNext()) {
            cls = this.getExactClass(((JCClass)it.next()).getFullName());
            if (cls == null) continue;
            JCField[] fields = cls.getFields();
            int j = 0;
            while (j < fields.length) {
                JCField fld = fields[j];
                if (!((exactMatch ? !fld.getName().equals(name) : !this.startsWith(fld.getName(), name)) || !showDeprecated && JCUtilities.isDeprecated(fld))) {
                    ts.add(fld);
                }
                ++j;
            }
        }
        if (staticOnly && (exactMatch && "class".equals(name) || !exactMatch && this.startsWith("class", name))) {
            JavaCompletion.BaseField field = new JavaCompletion.BaseField(JavaCompletion.CLASS_CLASS, "class", JavaCompletion.CLASS_TYPE, 1);
            ts.add(field);
        }
        return new ArrayList(ts);
    }

    public synchronized List findMethods(JCClass cls, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses) {
        TreeSet<JCMethod> ts = naturalSort ? new TreeSet<JCMethod>(NATURAL_MEMBER_NAME_COMPARATOR) : new TreeSet();
        List clsList = this.getClassList(cls);
        String pkgName = cls.getPackageName();
        JCClass innerClass = cls;
        int i = clsList.size() - 1;
        while (i >= 0) {
            cls = this.getExactClass(((JCClass)clsList.get(i)).getFullName());
            if (cls != null) {
                int outerInd;
                boolean difPkg = !cls.getPackageName().equals(pkgName);
                List outerList = i == 0 && inspectOuterClasses && cls.getName().indexOf(46) >= 0 ? this.getOuterClasses(cls) : null;
                int n = outerInd = outerList != null ? outerList.size() - 1 : -1;
                do {
                    if (outerInd >= 0) {
                        cls = (JCClass)outerList.get(outerInd--);
                    }
                    JCMethod[] methods = cls.getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        JCMethod mtd = methods[j];
                        int mods = mtd.getModifiers();
                        if (!(staticOnly && (mods & 8) == 0 || i > 0 && (mods & 2) != 0 || difPkg && (mods & 5) == 0 || outerInd > -1 && (innerClass.getModifiers() & 8) != 0 && (mods & 8) == 0 || (!exactMatch ? !this.startsWith(mtd.getName(), name) : !mtd.getName().equals(name)))) {
                            if (ts.contains(mtd)) {
                                ts.remove(mtd);
                            }
                            if (innerClass.equals(cls) && outerInd == -1) {
                                mtd = new JavaCompletion.BaseMethod(cls, mtd.getName(), mtd.getModifiers() | 0x20000000, mtd.getReturnType(), mtd.getParameters(), mtd.getExceptions());
                            }
                            if (showDeprecated || !JCUtilities.isDeprecated(mtd)) {
                                ts.add(mtd);
                            }
                        }
                        ++j;
                    }
                } while (outerInd >= 0);
            }
            --i;
        }
        return new ArrayList(ts);
    }

    private List getClassList(JCClass cls) {
        List<JCClass> ret;
        boolean deprecated = true;
        JCFinder finder = JavaCompletion.getFinder();
        cls = finder.getExactClass(cls.getFullName());
        if (cls != null) {
            if (cls.isInterface()) {
                ret = JCUtilities.getAllInterfaces(cls, deprecated);
                ret.add(JavaCompletion.OBJECT_CLASS);
            } else {
                ret = JCUtilities.getSuperclasses(cls);
                if ((cls.getModifiers() & 0x400) != 0) {
                    ret.addAll(JCUtilities.getAllInterfaces(cls, deprecated));
                }
            }
            ret.add(0, cls);
        } else {
            ret = new ArrayList();
        }
        return ret;
    }

    public String dumpClasses() {
        StringBuffer sb = new StringBuffer(8192);
        JCClass[] ac = this.getAllClasses();
        int i = 0;
        while (i < ac.length) {
            sb.append(JCUtilities.dumpClass(ac[i]));
            sb.append("\n\n");
            ++i;
        }
        return sb.toString();
    }

    public void setCaseSensitive(boolean sensitive) {
        boolean change = sensitive != caseSensitive;
        caseSensitive = sensitive;
        if (change) {
            this.build();
        }
    }

    public void setNaturalSort(boolean sort) {
        boolean change = sort != naturalSort;
        naturalSort = sort;
        if (change) {
            this.build();
        }
    }

    public void setShowDeprecated(boolean deprecated) {
        showDeprecated = deprecated;
    }

    public boolean getShowDeprecated() {
        return showDeprecated;
    }

    private boolean startsWith(String theString, String prefix) {
        return caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static final class NaturalMemberNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof JCMethod && o2 instanceof JCMethod) {
                JCMethod met1 = (JCMethod)o1;
                JCMethod met2 = (JCMethod)o2;
                int order = met1.getName().compareToIgnoreCase(met2.getName());
                if (order == 0) {
                    JCParameter[] param1 = met1.getParameters();
                    JCParameter[] param2 = met2.getParameters();
                    int commonCnt = Math.min(param1.length, param2.length);
                    int i = 0;
                    while (i < commonCnt) {
                        order = param1[i].getType().getClazz().getName().compareToIgnoreCase(param2[i].getType().getClazz().getName());
                        if (order != 0) {
                            return order;
                        }
                        ++i;
                    }
                    order = param1.length - param2.length;
                }
                return order;
            }
            if (o1 instanceof JCField && o2 instanceof JCField) {
                JCField fld1 = (JCField)o1;
                JCField fld2 = (JCField)o2;
                int order = fld1.getName().compareToIgnoreCase(fld2.getName());
                if (order == 0) {
                    order = fld1.getName().compareTo(fld2.getName());
                }
                return order;
            }
            return 0;
        }
    }

    public static final class InsensitiveClassNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof JCClass && o2 instanceof JCClass) {
                return ((JCClass)o1).getName().compareToIgnoreCase(((JCClass)o2).getName());
            }
            if (o1 instanceof JCPackage && o2 instanceof JCPackage) {
                return ((JCPackage)o1).getName().compareToIgnoreCase(((JCPackage)o2).getName());
            }
            return 0;
        }
    }

    public static final class DefaultClassNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof JCClass && o2 instanceof JCClass) {
                return ((JCClass)o1).getName().compareTo(((JCClass)o2).getName());
            }
            if (o1 instanceof JCPackage && o2 instanceof JCPackage) {
                return ((JCPackage)o1).getName().compareTo(((JCPackage)o2).getName());
            }
            return 0;
        }
    }
}

