/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCCellRenderer
extends JPanel
implements ListCellRenderer {
    public static final int CLASS_ICON = 0;
    public static final int INTERFACE_ICON = 4;
    public static final int FIELD_ICON = 8;
    public static final int FIELD_STATIC_ICON = 12;
    public static final int CONSTRUCTOR_ICON = 16;
    public static final int METHOD_ICON = 20;
    public static final int METHOD_STATIC_ICON = 24;
    public static final int PACKAGE_ICON = 28;
    private static final int END_ICON = 29;
    public static final int CLASS_COLOR = 0;
    public static final int INTERFACE_COLOR = 4;
    public static final int FIELD_COLOR = 8;
    public static final int FIELD_STATIC_COLOR = 12;
    public static final int CONSTRUCTOR_COLOR = 16;
    public static final int METHOD_COLOR = 20;
    public static final int METHOD_STATIC_COLOR = 24;
    public static final int PACKAGE_COLOR = 28;
    public static final int KEYWORD_COLOR = 29;
    public static final int TYPE_COLOR = 30;
    public static final int PARAMETER_NAME_COLOR = 31;
    private static final int END_COLOR = 32;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    static final long serialVersionUID = 4737618682220847017L;
    Map widths;
    Icon[] icons = new Icon[29];
    Color[] colors = new Color[32];
    private FontMetrics fontMetrics;
    private int fontHeight;
    private int ascent;
    private int iconTextGap = 5;
    protected JList list;
    protected Object value;
    protected boolean isSelected;
    protected boolean packageLastNameOnly;
    protected boolean displayStaticWord;
    protected int classDisplayOffset;
    protected boolean classDisplayFullName;
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;

    public JCCellRenderer() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i] = Color.black;
            ++i;
        }
        this.setForeColor(Color.green.darker().darker().darker(), 28);
        this.setForeColor(Color.red.darker().darker().darker(), 0);
        this.setForeColor(Color.darkGray, 4);
        this.setForeColor(Color.blue.darker(), 8);
        this.setForeColor(Color.orange.darker(), 16);
        this.setForeColor(Color.red.darker().darker(), 20);
        this.setForeColor(Color.darkGray, 29);
        this.setForeColor(Color.magenta.darker(), 31);
        this.setPackageLastNameOnly(true);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = ((Component)this).getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        int i = 0;
        while (i < frequentWords.length) {
            this.storeWidth(frequentWords[i]);
            ++i;
        }
        Iterator i2 = JavaCompletion.getPrimitiveClassIterator();
        while (i2.hasNext()) {
            this.storeWidth(((JCClass)i2.next()).getName());
        }
        this.drawFont = font;
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    private void storeWidth(String s) {
        this.fontMetrics.stringWidth(s);
    }

    public void setIcon(Icon icon, int type) {
        if (type < 28) {
            int i = 0;
            while (i < 4) {
                this.icons[type + i] = icon;
                ++i;
            }
        } else {
            this.icons[type] = icon;
        }
    }

    public void setIcon(Icon icon, int type, int level) {
        this.icons[type + level] = icon;
    }

    public void setForeColor(Color color, int type) {
        if (type < 28) {
            int i = 0;
            while (i < 4) {
                this.colors[type + i] = color;
                ++i;
            }
        } else {
            this.colors[type] = color;
        }
    }

    public void setForeColor(Color color, int type, int level) {
        this.colors[type + level] = color;
    }

    public void setPackageLastNameOnly(boolean packageLastNameOnly) {
        this.packageLastNameOnly = packageLastNameOnly;
    }

    public void setDisplayStaticWord(boolean displayStaticWord) {
        this.displayStaticWord = displayStaticWord;
    }

    public void setClassDisplayOffset(int classDisplayOffset) {
        this.classDisplayOffset = classDisplayOffset;
    }

    public void setClassDisplayFullName(boolean classDisplayFullName) {
        this.classDisplayFullName = classDisplayFullName;
    }

    protected Color getColor(String s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    protected int getWidth(String s) {
        Integer i = (Integer)this.widths.get(s);
        if (i != null) {
            return i;
        }
        return this.fontMetrics.stringWidth(s);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.getWidth(s);
        }
        return ((Component)this).getFontMetrics(font).stringWidth(s);
    }

    protected void drawString(Graphics g, String s) {
        this.drawString(g, s, false);
    }

    protected void drawString(Graphics g, String s, boolean strike) {
        if (g != null) {
            g.setColor(this.getForeground());
        }
        this.drawStringToGraphics(g, s, null, strike);
    }

    protected void drawString(Graphics g, String s, int type) {
        this.drawString(g, s, this.colors[type]);
    }

    protected void drawString(Graphics g, String s, int type, boolean strike) {
        this.drawString(g, s, this.colors[type], null, strike);
    }

    protected void drawString(Graphics g, String s, int type, Font font, boolean strike) {
        this.drawString(g, s, this.colors[type], font, strike);
    }

    protected void drawString(Graphics g, String s, Color c) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
        }
        this.drawStringToGraphics(g, s);
    }

    protected void drawString(Graphics g, String s, Color c, Font font, boolean strike) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font, strike);
        if (g != null) {
            g.setFont(this.drawFont);
        }
    }

    protected void drawStringToGraphics(Graphics g, String s) {
        this.drawStringToGraphics(g, s, null, false);
    }

    protected void drawStringToGraphics(Graphics g, String s, Font font, boolean strike) {
        if (g != null) {
            if (!strike) {
                g.drawString(s, this.drawX, this.drawY);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AttributedString strikeText = new AttributedString(s);
                strikeText.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                strikeText.addAttribute(TextAttribute.FONT, g.getFont());
                g2.drawString(strikeText.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(s, font);
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX = i.left;
            this.drawY = i.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (i != null) {
            this.drawHeight += i.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected Color getTypeColor(String s) {
        return this.colors[JavaCompletion.isPrimitiveClassName(s) ? 29 : 30];
    }

    protected void drawType(Graphics g, JCType typ) {
        this.drawType(g, typ, false);
    }

    protected void drawType(Graphics g, JCType typ, boolean strike) {
        Color c = this.getTypeColor(typ.getClazz().getName());
        this.drawString(g, typ.format(false), c, null, strike);
    }

    protected void drawParameter(Graphics g, JCParameter prm) {
        this.drawParameter(g, prm, false);
    }

    protected void drawParameter(Graphics g, JCParameter prm, boolean strike) {
        this.drawType(g, prm.getType(), strike);
        String name = prm.getName();
        if (name.length() > 0) {
            this.drawString(g, " ", strike);
            this.drawString(g, prm.getName(), 31, strike);
        }
    }

    protected void drawParameterList(Graphics g, JCConstructor ctr) {
        this.drawParameterList(g, ctr, false);
    }

    protected void drawParameterList(Graphics g, JCConstructor ctr, boolean strike) {
        this.drawString(g, "(", strike);
        JCParameter[] p = ctr.getParameters();
        int i = 0;
        while (i < p.length) {
            this.drawParameter(g, p[i], strike);
            if (i != p.length - 1) {
                this.drawString(g, ", ", strike);
            }
            ++i;
        }
        this.drawString(g, ")", strike);
    }

    protected void drawExceptions(Graphics g, JCConstructor ctr) {
        this.drawExceptions(g, ctr, false);
    }

    protected void drawExceptions(Graphics g, JCConstructor ctr, boolean strike) {
        JCClass[] exc = ctr.getExceptions();
        if (exc.length > 0) {
            this.drawString(g, THROWS, 29, strike);
            int i = 0;
            while (i < exc.length) {
                String name = exc[i].getName();
                Color c = this.getTypeColor(name);
                this.drawString(g, name, c, null, strike);
                if (i != exc.length - 1) {
                    this.drawString(g, ", ", strike);
                }
                ++i;
            }
        }
    }

    protected void drawPackage(Graphics g, JCPackage pkg) {
        this.drawIcon(g, this.icons[28]);
        String name = pkg.getName();
        if (this.packageLastNameOnly) {
            name = pkg.getLastName();
        }
        this.drawString(g, name, 28);
    }

    protected void drawClass(Graphics g, JCClass cls) {
        boolean ic = cls.isInterface();
        boolean strike = JCUtilities.isDeprecated(cls);
        int level = JavaCompletion.getLevel(cls.getModifiers());
        String text = cls.getName();
        if (this.classDisplayFullName) {
            text = cls.getFullName();
        } else if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
            text = text.substring(this.classDisplayOffset);
        }
        this.drawIcon(g, this.icons[(ic ? 4 : 0) + level]);
        this.drawString(g, text, ic ? 4 : 0, strike);
    }

    protected void drawField(Graphics g, JCField fld) {
        boolean strike = JCUtilities.isDeprecated(fld);
        int level = JavaCompletion.getLevel(fld.getModifiers());
        this.drawIcon(g, (fld.getModifiers() & 8) == 0 ? this.icons[8 + level] : this.icons[12 + level]);
        if (this.displayStaticWord && (fld.getModifiers() & 8) != 0) {
            this.drawString(g, "static ", 29, strike);
        }
        this.drawType(g, fld.getType(), strike);
        this.drawString(g, " ", strike);
        if ((fld.getModifiers() & 0x20000000) != 0) {
            this.drawString(g, fld.getName(), 8 + level, this.drawFont.deriveFont(1), strike);
        } else {
            this.drawString(g, fld.getName(), 8 + level, strike);
        }
    }

    protected void drawConstructor(Graphics g, JCConstructor ctr) {
        boolean strike = JCUtilities.isDeprecated(ctr);
        int level = JavaCompletion.getLevel(ctr.getModifiers());
        this.drawIcon(g, this.icons[16 + level]);
        this.drawString(g, ctr.getClazz().getName(), 16 + level, strike);
        this.drawParameterList(g, ctr, strike);
        this.drawExceptions(g, ctr, strike);
    }

    protected void drawMethod(Graphics g, JCMethod mtd) {
        boolean strike = JCUtilities.isDeprecated(mtd);
        int level = JavaCompletion.getLevel(mtd.getModifiers());
        this.drawIcon(g, (mtd.getModifiers() & 8) == 0 ? this.icons[20 + level] : this.icons[24 + level]);
        if (this.displayStaticWord && (mtd.getModifiers() & 8) != 0) {
            this.drawString(g, "static ", 29, strike);
        }
        this.drawType(g, mtd.getReturnType(), strike);
        this.drawString(g, " ", strike);
        if ((mtd.getModifiers() & 0x20000000) != 0) {
            this.drawString(g, mtd.getName(), 20 + level, this.drawFont.deriveFont(1), strike);
        } else {
            this.drawString(g, mtd.getName(), 20 + level, strike);
        }
        this.drawParameterList(g, mtd, strike);
        this.drawExceptions(g, mtd, strike);
    }

    protected void draw(Graphics g) {
        if (this.value instanceof JCPackage) {
            this.drawPackage(g, (JCPackage)this.value);
        } else if (this.value instanceof JCClass) {
            this.drawClass(g, (JCClass)this.value);
        } else if (this.value instanceof JCField) {
            this.drawField(g, (JCField)this.value);
        } else if (this.value instanceof JCMethod) {
            this.drawMethod(g, (JCMethod)this.value);
        } else if (this.value instanceof JCConstructor) {
            this.drawConstructor(g, (JCConstructor)this.value);
        } else if (this.value instanceof JCParameter) {
            this.drawParameter(g, (JCParameter)this.value);
        } else {
            this.drawString(g, this.value.toString());
        }
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.list = list;
        this.value = value;
        this.isSelected = isSelected;
        this.getAccessibleContext().setAccessibleName(this.value.toString());
        this.getAccessibleContext().setAccessibleDescription(this.value.toString());
        return this;
    }
}

