/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JCExpression {
    private static final int INVALID = -1;
    public static final int CONSTANT = 0;
    public static final int VARIABLE = 1;
    public static final int OPERATOR = 2;
    public static final int UNARY_OPERATOR = 3;
    public static final int DOT = 4;
    public static final int DOT_OPEN = 5;
    public static final int ARRAY_OPEN = 6;
    public static final int ARRAY = 7;
    public static final int PARENTHESIS_OPEN = 8;
    public static final int PARENTHESIS = 9;
    public static final int METHOD_OPEN = 10;
    public static final int METHOD = 11;
    public static final int CONSTRUCTOR = 12;
    public static final int CONVERSION = 13;
    public static final int TYPE = 14;
    public static final int NEW = 15;
    public static final int INSTANCEOF = 16;
    private static final int javaTokenIDsLength = JavaTokenContext.context.getTokenIDs().length;
    private static final int[] OP = new int[javaTokenIDsLength + 16 + 1];
    private static final int RIGHT_ASSOCIATIVE = 32;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private JCExpression parent;
    private int expID;
    private JCType type;
    private int tokenCountM3;
    private Object[] tokenBlocks = EMPTY_OBJECT_ARRAY;
    private ArrayList prmList;

    JCExpression(int expID) {
        this.expID = expID;
    }

    static JCExpression createEmptyVariable(int pos) {
        JCExpression empty = new JCExpression(1);
        empty.addToken(JavaTokenContext.IDENTIFIER, pos, "");
        return empty;
    }

    static int getOperatorID(TokenID tokenID) {
        int id = -1;
        if (tokenID.getCategory() == JavaTokenContext.OPERATORS) {
            id = tokenID.getNumericID();
        } else {
            switch (tokenID.getNumericID()) {
                case 95: {
                    id = javaTokenIDsLength + 15;
                    break;
                }
                case 92: {
                    id = javaTokenIDsLength + 16;
                }
            }
        }
        return id;
    }

    static int getOperatorID(JCExpression exp) {
        int expID = exp != null ? exp.getExpID() : -1;
        switch (expID) {
            case 2: {
                return exp.getTokenID(0).getNumericID();
            }
        }
        return javaTokenIDsLength + expID;
    }

    static int getOperatorPrecedence(int opID) {
        return OP[opID] & 0x1F;
    }

    static boolean isOperatorRightAssociative(int opID) {
        return (OP[opID] & 0x20) != 0;
    }

    static boolean isValidType(JCExpression exp) {
        switch (exp.getExpID()) {
            case 7: {
                if (exp.getParameterCount() == 1) {
                    return JCExpression.isValidType(exp.getParameter(0));
                }
                return false;
            }
            case 4: {
                int prmCnt = exp.getParameterCount();
                int i = 0;
                while (i < prmCnt) {
                    if (exp.getParameter(i).getExpID() != 1) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 1: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public int getExpID() {
        return this.expID;
    }

    void setExpID(int expID) {
        this.expID = expID;
    }

    public JCExpression getParent() {
        return this.parent;
    }

    void setParent(JCExpression parent) {
        this.parent = parent;
    }

    public JCType getType() {
        return this.type;
    }

    void setType(JCType type) {
        this.type = type;
    }

    public int getTokenCount() {
        return this.tokenCountM3 / 3;
    }

    public String getTokenText(int tokenInd) {
        return (String)this.tokenBlocks[(tokenInd *= 3) + 2];
    }

    public int getTokenOffset(int tokenInd) {
        return (Integer)this.tokenBlocks[(tokenInd *= 3) + 1];
    }

    public int getTokenLength(int tokenInd) {
        return ((String)this.tokenBlocks[(tokenInd *= 3) + 2]).length();
    }

    public TokenID getTokenID(int tokenInd) {
        return (TokenID)this.tokenBlocks[tokenInd *= 3];
    }

    void addToken(TokenID tokenID, int tokenOffset, String tokenText) {
        if (this.tokenCountM3 == this.tokenBlocks.length) {
            Object[] tmp = new Object[Math.max(3, this.tokenBlocks.length * 2)];
            if (this.tokenBlocks.length > 0) {
                System.arraycopy(this.tokenBlocks, 0, tmp, 0, this.tokenBlocks.length);
            }
            this.tokenBlocks = tmp;
        }
        this.tokenBlocks[this.tokenCountM3++] = tokenID;
        this.tokenBlocks[this.tokenCountM3++] = new Integer(tokenOffset);
        this.tokenBlocks[this.tokenCountM3++] = tokenText;
    }

    public int getParameterCount() {
        return this.prmList != null ? this.prmList.size() : 0;
    }

    public JCExpression getParameter(int index) {
        return (JCExpression)this.prmList.get(index);
    }

    void addParameter(JCExpression prm) {
        if (this.prmList == null) {
            this.prmList = new ArrayList();
        }
        prm.setParent(this);
        this.prmList.add(prm);
    }

    void swapOperatorParms() {
        if ((this.expID == 2 || this.expID == 16) && this.getParameterCount() == 2) {
            JCExpression exp1 = (JCExpression)this.prmList.remove(0);
            this.prmList.add(exp1);
            exp1.swapOperatorParms();
            ((JCExpression)this.prmList.get(0)).swapOperatorParms();
        }
    }

    private static String getIndentString(int indent) {
        StringBuffer sb = new StringBuffer();
        while (indent-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    static String getIDName(int expID) {
        switch (expID) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "VARIABLE";
            }
            case 2: {
                return "OPERATOR";
            }
            case 3: {
                return "UNARY_OPERATOR";
            }
            case 4: {
                return "DOT";
            }
            case 5: {
                return "DOT_OPEN";
            }
            case 7: {
                return "ARRAY";
            }
            case 6: {
                return "ARRAY_OPEN";
            }
            case 8: {
                return "PARENTHESIS_OPEN";
            }
            case 9: {
                return "PARENTHESIS";
            }
            case 10: {
                return "METHOD_OPEN";
            }
            case 11: {
                return "METHOD";
            }
            case 12: {
                return "CONSTRUCTOR";
            }
            case 13: {
                return "CONVERSION";
            }
            case 14: {
                return "TYPE";
            }
            case 15: {
                return "NEW";
            }
            case 16: {
                return "INSTANCEOF";
            }
        }
        return "Unknown expID " + expID;
    }

    public String toString(int indent) {
        String indentStr = JCExpression.getIndentString(indent);
        StringBuffer sb = new StringBuffer();
        sb.append("expID=" + JCExpression.getIDName(this.expID));
        if (this.type != null) {
            sb.append(", result type=");
            sb.append(this.type);
        }
        int tokenCnt = this.getTokenCount();
        sb.append(", token count=");
        sb.append(tokenCnt);
        if (tokenCnt > 0) {
            int i = 0;
            while (i < this.tokenCountM3) {
                TokenID tokenID = (TokenID)this.tokenBlocks[i++];
                int tokenOffset = (Integer)this.tokenBlocks[i++];
                String tokenText = (String)this.tokenBlocks[i++];
                sb.append(", token" + (i / 3 - 1) + "='" + EditorDebug.debugString(tokenText) + "'");
            }
        }
        int parmCnt = this.getParameterCount();
        sb.append(", parm count=");
        sb.append(parmCnt);
        if (parmCnt > 0) {
            int i = 0;
            while (i < parmCnt) {
                sb.append('\n');
                sb.append(indentStr);
                sb.append("parm" + i + "=[" + this.getParameter(i).toString(indent + 2) + "]");
                ++i;
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    static {
        JCExpression.OP[17] = 34;
        JCExpression.OP[18] = 10;
        JCExpression.OP[19] = 10;
        JCExpression.OP[20] = 11;
        JCExpression.OP[21] = 11;
        JCExpression.OP[22] = 11;
        JCExpression.OP[23] = 12;
        JCExpression.OP[24] = 12;
        JCExpression.OP[25] = 13;
        JCExpression.OP[26] = 13;
        JCExpression.OP[27] = 8;
        JCExpression.OP[28] = 6;
        JCExpression.OP[29] = 7;
        JCExpression.OP[30] = 13;
        JCExpression.OP[31] = 14;
        JCExpression.OP[32] = 14;
        JCExpression.OP[33] = 9;
        JCExpression.OP[34] = 10;
        JCExpression.OP[35] = 10;
        JCExpression.OP[36] = 34;
        JCExpression.OP[37] = 34;
        JCExpression.OP[38] = 34;
        JCExpression.OP[39] = 34;
        JCExpression.OP[40] = 34;
        JCExpression.OP[41] = 34;
        JCExpression.OP[42] = 34;
        JCExpression.OP[43] = 34;
        JCExpression.OP[44] = 34;
        JCExpression.OP[45] = 34;
        JCExpression.OP[46] = 34;
        JCExpression.OP[47] = 9;
        JCExpression.OP[48] = 15;
        JCExpression.OP[50] = 35;
        JCExpression.OP[52] = 35;
        JCExpression.OP[55] = 15;
        JCExpression.OP[56] = 0;
        JCExpression.OP[59] = 15;
        JCExpression.OP[60] = 15;
        JCExpression.OP[61] = 5;
        JCExpression.OP[62] = 4;
        JCExpression.OP[49] = 0;
        JCExpression.OP[51] = 0;
        JCExpression.OP[53] = 16;
        JCExpression.OP[54] = 0;
        JCExpression.OP[57] = 0;
        JCExpression.OP[58] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + -1] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 0] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 1] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 3] = 15;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 4] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 5] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 6] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 7] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 8] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 9] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 10] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 11] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 12] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 13] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 14] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 15] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 16] = 10;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

