/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.java.JavaFastOpen;

class JavaFastOpenPanel
extends JPanel {
    private JavaFastOpen jfo;
    private JPanel listPanel;
    private JLabel expLabel;
    private JLabel foundLabel;
    private JTextField expField;
    private JScrollPane listScrollPane;
    private JPanel queryPanel;

    public JavaFastOpenPanel(JavaFastOpen jfo) {
        this.jfo = jfo;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFO"));
        this.expField.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_expLabel"));
        this.expField.setPreferredSize(null);
        JList jl = jfo.getResultList();
        this.listScrollPane.setViewportView(jl);
        this.foundLabel.setLabelFor(jl);
        jl.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_foundLabel"));
        this.expLabel.setDisplayedMnemonic(LocaleSupport.getString("JFOP_expLabelMnemonic", "C").charAt(0));
        this.expLabel.setLabelFor(this.expField);
        this.expField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                if (!this.checkArrows(evt)) {
                    this.change();
                }
            }

            public void keyReleased(KeyEvent evt) {
                if (!this.isArrows(evt)) {
                    this.change();
                }
            }

            public void keyTyped(KeyEvent evt) {
                if (!this.isArrows(evt)) {
                    this.change();
                }
            }

            private boolean isArrows(KeyEvent evt) {
                return JavaFastOpenPanel.this.jfo.boundScrollingKey(evt);
            }

            private boolean checkArrows(KeyEvent evt) {
                if (this.isArrows(evt)) {
                    JavaFastOpenPanel.this.jfo.delegateScrollingKey(evt);
                    evt.consume();
                    return true;
                }
                return false;
            }

            private void change() {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        this.foundLabel.setDisplayedMnemonic(LocaleSupport.getString("JFOP_foundLabelMnemonic", "F").charAt(0));
        this.foundLabel.setLabelFor(jfo.getResultList());
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        Dimension max = this.getMaximumSize();
        if (pref.width > max.width) {
            pref.width = max.width;
        }
        if (pref.height > max.height) {
            pref.height = max.height;
        }
        return pref;
    }

    void popupNotify() {
        this.expField.requestFocus();
    }

    String getSearchText() {
        return this.expField.getText();
    }

    void setSearchText(String text) {
        this.expField.setText(text);
        this.expField.setCaretPosition(this.expField.getText().length());
    }

    private void initComponents() {
        this.queryPanel = new JPanel();
        this.expLabel = new JLabel();
        this.expField = new JTextField();
        this.listPanel = new JPanel();
        this.foundLabel = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.queryPanel.setLayout(new GridBagLayout());
        this.expLabel.setText(LocaleSupport.getString("JFOP_expLabel", "Class Name:"));
        this.expLabel.setLabelFor(this.expField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.queryPanel.add((Component)this.expLabel, gridBagConstraints);
        this.expField.setPreferredSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.queryPanel.add((Component)this.expField, gridBagConstraints);
        this.add((Component)this.queryPanel, "North");
        this.listPanel.setLayout(new GridBagLayout());
        this.listPanel.setBorder(new EmptyBorder(new Insets(12, 0, 0, 0)));
        this.foundLabel.setText(LocaleSupport.getString("JFOP_foundLabel", "Matching Classes:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.listPanel.add((Component)this.foundLabel, gridBagConstraints);
        this.listScrollPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.listPanel.add((Component)this.listScrollPane, gridBagConstraints);
        this.add((Component)this.listPanel, "Center");
    }
}

