/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.java.JavaFormatSupport;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaFormatter
extends ExtFormatter {
    public JavaFormatter(Class kitClass) {
        super(kitClass);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JavaSyntax;
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        int[] ret = null;
        BaseDocument doc = Utilities.getDocument(target);
        int dotPos = target.getCaret().getDot();
        if (doc != null) {
            if ("e".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite(doc, dotPos);
                    if (fnw >= 0 && fnw + 4 == dotPos && "else".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, fnw + 4};
                    }
                }
                catch (BadLocationException e) {}
            } else if (":".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite(doc, dotPos);
                    if (fnw >= 0 && fnw + 4 <= doc.getLength() && "case".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, fnw + 4};
                    } else if (fnw >= 0 & fnw + 7 <= doc.getLength() && "default".equals(doc.getText(fnw, 7))) {
                        ret = new int[]{fnw, fnw + 7};
                    }
                }
                catch (BadLocationException e) {}
            } else {
                ret = super.getReformatBlock(target, typedText);
            }
        }
        return ret;
    }

    protected void initFormatLayers() {
        this.addFormatLayer(new StripEndWhitespaceLayer());
        this.addFormatLayer(new JavaLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter fw) {
        return new JavaFormatSupport(fw);
    }

    public class JavaLayer
    extends AbstractFormatLayer {
        public JavaLayer() {
            super("java-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new JavaFormatSupport(fw);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void format(FormatWriter fw) {
            try {
                JavaFormatSupport jfs = (JavaFormatSupport)this.createFormatSupport(fw);
                FormatTokenPosition pos = jfs.getFormatStartPosition();
                if (jfs.isIndentOnly()) {
                    jfs.indentLine(pos);
                    return;
                }
                while (true) {
                    if (pos == null) {
                        return;
                    }
                    jfs.indentLine(pos);
                    this.formatLine(jfs, pos);
                    FormatTokenPosition pos2 = jfs.findLineEnd(pos);
                    if (pos2 == null) return;
                    if (pos2.getToken() == null) {
                        return;
                    }
                    pos = jfs.getNextPosition(pos2, Position.Bias.Forward);
                    if (pos == pos2) {
                        return;
                    }
                    if (pos == null) return;
                    if (pos.getToken() == null) {
                        return;
                    }
                    FormatTokenPosition fnw = jfs.findLineFirstNonWhitespace(pos);
                    if (fnw != null) {
                        pos = fnw;
                        continue;
                    }
                    pos = jfs.findLineStart(pos);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        protected void formatLine(JavaFormatSupport jfs, FormatTokenPosition pos) {
            TokenItem token = jfs.findLineStart(pos).getToken();
            while (token != null) {
                if (token.getTokenContextPath() == jfs.getTokenContextPath()) {
                    block0 : switch (token.getTokenID().getNumericID()) {
                        case 57: {
                            FormatTokenPosition ftp;
                            FormatTokenPosition endOfPreviousLine;
                            FormatTokenPosition lbracePos;
                            if (jfs.isIndentOnly()) break;
                            if (jfs.getFormatNewlineBeforeBrace()) {
                                lbracePos = jfs.getPosition(token, 0);
                                FormatTokenPosition imp = jfs.findImportant(lbracePos, null, true, true);
                                if (imp == null || imp.getToken().getTokenContextPath() != jfs.getTokenContextPath()) break;
                                switch (imp.getToken().getTokenID().getNumericID()) {
                                    case 7: 
                                    case 8: {
                                        break block0;
                                    }
                                }
                                FormatTokenPosition next = jfs.findImportant(lbracePos, null, true, false);
                                if (next != null && next.getToken() != null && next.getToken().getTokenID() == JavaTokenContext.RBRACE) break;
                                if (jfs.canInsertToken(token)) {
                                    jfs.insertToken(token, jfs.getValidWhitespaceTokenID(), jfs.getValidWhitespaceTokenContextPath(), "\n");
                                    jfs.removeLineEndWhitespace(imp);
                                    jfs.indentLine(lbracePos);
                                }
                                token = imp.getToken();
                                break;
                            }
                            lbracePos = jfs.getPosition(token, 0);
                            if (jfs.findNonWhitespace(lbracePos, null, true, true) != null || jfs.getNextPosition(lbracePos) != null && jfs.findImportant(jfs.getNextPosition(lbracePos), null, true, false) != null || (endOfPreviousLine = jfs.getPreviousPosition(ftp = jfs.findLineStart(lbracePos))) == null || endOfPreviousLine.getToken().getTokenID() != JavaTokenContext.WHITESPACE) break;
                            ftp = jfs.findLineStart(endOfPreviousLine);
                            if ((ftp = jfs.findImportant(lbracePos, ftp, false, true)) == null || (ftp = jfs.findNonWhitespace(endOfPreviousLine, null, true, true)).getToken().getTokenID() == JavaTokenContext.LINE_COMMENT || ftp.getToken().getTokenID() == JavaTokenContext.LBRACE) break;
                            boolean remove = true;
                            while (remove) {
                                if (token.getPrevious() == endOfPreviousLine.getToken()) {
                                    remove = false;
                                }
                                if (!jfs.canRemoveToken(token.getPrevious())) break;
                                jfs.removeToken(token.getPrevious());
                            }
                            if (!jfs.canInsertToken(token)) break;
                            jfs.insertSpaces(token, 1);
                            break;
                        }
                        case 53: {
                            TokenItem prevprevToken;
                            TokenItem prevToken;
                            if (jfs.getFormatSpaceBeforeParenthesis()) {
                                prevToken = token.getPrevious();
                                if (prevToken == null || prevToken.getTokenID() != JavaTokenContext.IDENTIFIER && prevToken.getTokenID() != JavaTokenContext.THIS && prevToken.getTokenID() != JavaTokenContext.SUPER || !jfs.canInsertToken(token)) break;
                                jfs.insertToken(token, jfs.getWhitespaceTokenID(), jfs.getWhitespaceTokenContextPath(), " ");
                                break;
                            }
                            prevToken = token.getPrevious();
                            if (prevToken == null || prevToken.getTokenID() != JavaTokenContext.WHITESPACE || prevToken.getImage().length() != 1 || (prevprevToken = prevToken.getPrevious()) == null || prevprevToken.getTokenID() != JavaTokenContext.IDENTIFIER && prevprevToken.getTokenID() != JavaTokenContext.THIS && prevprevToken.getTokenID() != JavaTokenContext.SUPER || !jfs.canRemoveToken(prevToken)) break;
                            jfs.removeToken(prevToken);
                        }
                    }
                }
                token = token.getNext();
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("java-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new JavaFormatSupport(fw);
        }

        /*
         * Unable to fully structure code
         */
        public void format(FormatWriter fw) {
            block2: {
                jfs = (JavaFormatSupport)this.createFormatSupport(fw);
                pos = jfs.getFormatStartPosition();
                if (!jfs.isIndentOnly()) ** GOTO lbl9
                break block2;
lbl-1000:
                // 1 sources

                {
                    startPos = pos;
                    if ((pos = jfs.removeLineEndWhitespace(pos)).getToken() != null) {
                        pos = jfs.getNextPosition(pos);
                    }
                    if (startPos.equals(pos)) break;
lbl9:
                    // 2 sources

                    ** while (pos.getToken() != null)
                }
            }
        }
    }
}

