/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaSyntax;

public class JavaImport
implements TokenProcessor {
    private static final int INIT_SCAN_LEN = 4096;
    private static final int INIT = 0;
    private static final int AFTER_IMPORT = 1;
    private static final int INSIDE_EXP = 2;
    private static final int INSIDE_MIXED_EXP = 3;
    private HashMap name2Class = new HashMap(501);
    private char[] buffer;
    private ArrayList infoList = new ArrayList();
    private int state;
    private boolean parsingPackage;
    private int startPos;
    private int expPos;
    private boolean eotReached;
    private StringBuffer exp = new StringBuffer();
    private boolean star;
    private int posEndOfImportSection = -1;
    private boolean disableReparsing = false;
    JavaSyntax debugSyntax = new JavaSyntax();

    public synchronized void update(BaseDocument doc) {
        if (this.disableReparsing) {
            return;
        }
        doc.readLock();
        try {
            int scanLen = 4096;
            int docLen = doc.getLength();
            boolean wholeDoc = false;
            do {
                block7: {
                    if (scanLen >= docLen) {
                        scanLen = docLen;
                        wholeDoc = true;
                    }
                    this.eotReached = false;
                    this.init();
                    try {
                        doc.getSyntaxSupport().tokenizeText(this, 0, scanLen, false);
                    }
                    catch (BadLocationException e) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block7;
                        e.printStackTrace();
                    }
                }
                scanLen *= 4;
                if (wholeDoc) break;
            } while (this.eotReached);
            Object var7_6 = null;
            doc.readUnlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            doc.readUnlock();
            throw throwable;
        }
        this.buffer = null;
    }

    protected void init() {
        this.exp.setLength(0);
        this.state = 0;
        this.star = false;
        this.parsingPackage = false;
        this.infoList.clear();
        this.name2Class.clear();
        JCPackage pkg = JavaCompletion.getFinder().getExactPackage("java.lang");
        if (pkg != null) {
            JCClass[] classes = pkg.getClasses();
            int i = 0;
            while (i < classes.length) {
                this.name2Class.put(classes[i].getName(), classes[i]);
                ++i;
            }
        }
    }

    private JCClass checkForInnerClass(String innerClassName) {
        Iterator it = this.name2Class.values().iterator();
        while (it.hasNext()) {
            JCClass cls = (JCClass)it.next();
            if (cls == null || !cls.getFullName().endsWith("." + innerClassName)) continue;
            return cls;
        }
        return null;
    }

    public List getInnerClasses() {
        Iterator it = this.name2Class.values().iterator();
        ArrayList<JCClass> ret = new ArrayList<JCClass>();
        while (it.hasNext()) {
            JCClass cls = (JCClass)it.next();
            if (cls == null || cls.getName().indexOf(".") <= 0) continue;
            ret.add(cls);
        }
        return ret;
    }

    public JCClass getClazz(String className) {
        JCFinder finder = JavaCompletion.getFinder();
        JCClass ret = (JCClass)this.name2Class.get(className);
        if (ret == null) {
            ret = this.checkForInnerClass(className);
        }
        if (ret == null) {
            ret = finder.getExactClass(className);
        } else if (finder.getExactClass(ret.getFullName()) != null) {
            ret = finder.getExactClass(ret.getFullName());
        }
        return ret;
    }

    protected void packageStatementFound(int packageStartPos, int packageEndPos, String packageExp) {
        JCPackage pkg = JavaCompletion.getFinder().getExactPackage(packageExp);
        if (pkg != null) {
            JCClass[] classes = pkg.getClasses();
            int i = 0;
            while (i < classes.length) {
                this.name2Class.put(classes[i].getName(), classes[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void importStatementFound(int importStartPos, int importEndPos, String importExp, boolean starAtEnd) {
        JCFinder finder = JavaCompletion.getFinder();
        Info info = new Info(importStartPos, importEndPos, starAtEnd);
        JCClass cls = finder.getExactClass(importExp);
        if (cls != null) {
            info.cls = cls;
            if (!this.star) {
                this.name2Class.put(cls.getName(), cls);
            }
        } else {
            JCPackage pkg = finder.getExactPackage(importExp);
            if (pkg != null) {
                info.pkg = pkg;
                if (starAtEnd) {
                    JCClass[] classes = pkg.getClasses();
                    int i = 0;
                    while (i < classes.length) {
                        this.name2Class.put(classes[i].getName(), classes[i]);
                        ++i;
                    }
                }
            } else {
                int ind;
                String pkgName = importExp;
                String simplePkgName = null;
                while ((ind = pkgName.lastIndexOf(46)) >= 0) {
                    void var11_13;
                    pkgName = pkgName.substring(0, (int)var11_13);
                    if (simplePkgName == null) {
                        simplePkgName = pkgName;
                    }
                    if ((pkg = finder.getExactPackage(pkgName)) == null) continue;
                    info.cls = cls = JavaCompletion.getSimpleClass(importExp, pkgName.length());
                    info.unknownImport = importExp;
                    if (this.star) break;
                    this.name2Class.put(cls.getName(), cls);
                    break;
                }
                if (cls == null && simplePkgName != null) {
                    cls = JavaCompletion.getSimpleClass(importExp, simplePkgName.length());
                    if (!this.star) {
                        this.name2Class.put(cls.getName(), cls);
                    }
                }
            }
        }
        if (info.cls == null && info.pkg == null) {
            info.unknownImport = importExp;
        }
        this.infoList.add(info);
    }

    public boolean isUnknownImport(String className) {
        int i = 0;
        while (i < this.infoList.size()) {
            String unknown = ((Info)this.infoList.get((int)i)).unknownImport;
            if (unknown != null && unknown.indexOf(className) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List getUnknownImports() {
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < this.infoList.size()) {
            String unknownImport = ((Info)this.infoList.get((int)i)).unknownImport;
            if (unknownImport != null) {
                if (((Info)this.infoList.get((int)i)).star) {
                    unknownImport = unknownImport + ".*";
                }
                ret.add(unknownImport);
            }
            ++i;
        }
        return ret;
    }

    public boolean isImported(JCClass cls) {
        if (cls == null) {
            return false;
        }
        String clsFullName = cls.getFullName();
        String pkgName = cls.getPackageName();
        if (this.name2Class.containsValue(cls)) {
            return true;
        }
        int i = 0;
        while (i < this.infoList.size()) {
            JCClass infoClass = ((Info)this.infoList.get((int)i)).cls;
            JCPackage infoPackage = ((Info)this.infoList.get((int)i)).pkg;
            if (clsFullName != null && infoClass != null && clsFullName.equals(infoClass.getFullName())) {
                return true;
            }
            if (pkgName != null && infoPackage != null && pkgName.equals(infoPackage.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenOffset, int tokenLen) {
        boolean cont = true;
        block0 : switch (tokenID.getNumericID()) {
            case 6: {
                switch (this.state) {
                    case 1: {
                        this.expPos = tokenOffset;
                        this.state = 2;
                        break;
                    }
                    case 3: {
                        this.exp.append(this.buffer, tokenOffset, tokenLen);
                    }
                    case 2: {
                        if (!this.star) break;
                        cont = false;
                    }
                }
                break;
            }
            case 48: {
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        cont = false;
                        break;
                    }
                    case 3: {
                        this.exp.append('.');
                    }
                    case 2: {
                        if (!this.star) break;
                        cont = false;
                    }
                }
                break;
            }
            case 51: {
                String impExp = null;
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        cont = false;
                        break;
                    }
                    case 2: {
                        impExp = new String(this.buffer, this.expPos, (this.star ? tokenOffset - 2 : tokenOffset) - this.expPos);
                        break;
                    }
                    case 3: {
                        impExp = this.exp.toString();
                        this.exp.setLength(0);
                    }
                }
                if (impExp == null) break;
                if (this.parsingPackage) {
                    this.packageStatementFound(this.startPos, tokenOffset + 1, impExp);
                } else {
                    this.importStatementFound(this.startPos, tokenOffset + 1, impExp, this.star);
                }
                this.star = false;
                this.parsingPackage = false;
                this.state = 0;
                break;
            }
            case 25: {
                if (this.star || this.parsingPackage) {
                    cont = false;
                    break;
                }
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        cont = false;
                        break;
                    }
                    case 2: {
                        this.star = true;
                        if (tokenOffset != 0 && this.buffer[tokenOffset - 1] == '.') break;
                        cont = false;
                        break;
                    }
                    case 3: {
                        int len = this.exp.length();
                        if (len > 0 && this.exp.charAt(len - 1) == '.') {
                            this.exp.setLength(len - 1);
                            this.star = true;
                            break;
                        }
                        cont = false;
                    }
                }
                break;
            }
            case 97: {
                switch (this.state) {
                    case 0: {
                        this.parsingPackage = true;
                        this.state = 1;
                        break block0;
                    }
                }
                cont = false;
                break;
            }
            case 91: {
                switch (this.state) {
                    case 0: {
                        this.parsingPackage = false;
                        this.state = 1;
                        this.startPos = tokenOffset;
                        break block0;
                    }
                }
                cont = false;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                switch (this.state) {
                    case 2: {
                        if (tokenOffset - this.expPos < 0) {
                            cont = false;
                            break;
                        }
                        this.exp.append(this.buffer, this.expPos, tokenOffset - this.expPos);
                        this.state = 3;
                    }
                }
                break;
            }
            default: {
                if (this.posEndOfImportSection == -1 || tokenOffset + tokenLen > this.posEndOfImportSection) {
                    this.posEndOfImportSection = tokenOffset + tokenLen;
                }
                cont = false;
            }
        }
        return cont;
    }

    private String debugState(int state) {
        switch (state) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "AFTER_IMPORT";
            }
            case 2: {
                return "INSIDE_EXP";
            }
            case 3: {
                return "INSIDE_MIXED_EXP";
            }
        }
        return "UNKNOWN STATE";
    }

    public int eot(int offset) {
        this.eotReached = true;
        return 0;
    }

    public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
        this.buffer = buffer;
    }

    public void documentModifiedAtPosition(int offset) {
        if (this.posEndOfImportSection != -1) {
            if (offset > this.posEndOfImportSection) {
                this.disableReparsing = true;
            } else {
                this.disableReparsing = false;
                this.posEndOfImportSection = -1;
            }
        }
    }

    class Info {
        int startPos;
        int endPos;
        boolean star;
        JCPackage pkg;
        JCClass cls;
        String unknownImport;

        Info(int startPos, int endPos, boolean star) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.star = star;
        }
    }
}

