/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.jasper.CommandLineContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;

public class CommandLineCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String packageName;
    String pkgName;
    String className;
    File jsp;
    String outputDir;
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public CommandLineCompiler(CommandLineContext ctxt) {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOptions().getScratchDir().getAbsolutePath();
        this.pkgName = this.packageName = ctxt.getServletPackageName();
        this.setMangler(this);
        this.className = this.getBaseClassName();
        if (ctxt.isOutputInDirs()) {
            String tmpDir = this.outputDir + File.separatorChar + this.pkgName.replace('.', File.separatorChar);
            File f = new File(tmpDir);
            if (!f.exists()) {
                if (f.mkdirs()) {
                    this.outputDir = tmpDir;
                }
            } else {
                this.outputDir = tmpDir;
            }
        }
        this.computeClassFileName();
        this.computeJavaFileName();
    }

    public boolean isOutDated() {
        return true;
    }

    public final void computeJavaFileName() {
        this.javaFileName = this.ctxt.getServletClassName() + ".java";
        if ("null.java".equals(this.javaFileName)) {
            this.javaFileName = this.getBaseClassName() + ".java";
        }
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = this.outputDir + File.separatorChar + this.javaFileName;
        }
    }

    void computeClassFileName() {
        this.classFileName = this.getBaseClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = this.outputDir + File.separatorChar + this.classFileName;
        }
    }

    private final String getInitialClassName() {
        return this.getBaseClassName();
    }

    private final String getBaseClassName() {
        String className = this.ctxt.getServletClassName();
        if (className == null) {
            className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        }
        return CommandLineCompiler.mangleName(className);
    }

    private static final String mangleName(String name) {
        int i = 0;
        while (i < keywords.length) {
            if (name.equals(keywords[i])) {
                name = name + "%";
                break;
            }
            ++i;
        }
        StringBuffer modifiedName = new StringBuffer();
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            modifiedName.append(name.charAt(0));
        } else {
            modifiedName.append(CommandLineCompiler.mangleChar(name.charAt(0)));
        }
        int i2 = 1;
        while (i2 < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i2))) {
                modifiedName.append(name.charAt(i2));
            } else {
                modifiedName.append(CommandLineCompiler.mangleChar(name.charAt(i2)));
            }
            ++i2;
        }
        return modifiedName.toString();
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }

    public static String manglePackage(String name) {
        boolean first = true;
        StringBuffer b = new StringBuffer();
        StringTokenizer t = new StringTokenizer(name, ".");
        while (t.hasMoreTokens()) {
            String nt = t.nextToken();
            if (nt.length() <= 0) continue;
            if (b.length() > 0) {
                b.append('.');
            }
            b.append(CommandLineCompiler.mangleName(nt));
        }
        return b.toString();
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getJavaFileName() {
        return this.javaFileName;
    }

    public final String getClassFileName() {
        return this.classFileName;
    }
}

