/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;

public class TagCache {
    String shortTagName;
    Hashtable methodMaps;
    Hashtable propertyEditorMaps;
    BeanInfo tagClassInfo;
    Class tagHandlerClass;

    TagCache(String shortTagName) {
        this.shortTagName = shortTagName;
        this.methodMaps = new Hashtable();
        this.propertyEditorMaps = new Hashtable();
    }

    private void addSetterMethod(String attrName, Method m) {
        this.methodMaps.put(attrName, m);
    }

    Method getSetterMethod(String attrName) {
        return (Method)this.methodMaps.get(attrName);
    }

    private void addPropertyEditor(String attrName, Class peClass) {
        this.propertyEditorMaps.put(attrName, peClass);
    }

    Class getPropertyEditorClass(String attrName) {
        return (Class)this.propertyEditorMaps.get(attrName);
    }

    void setTagHandlerClass(Class tagHandlerClass) throws JasperException {
        try {
            this.tagClassInfo = Introspector.getBeanInfo(tagHandlerClass);
            this.tagHandlerClass = tagHandlerClass;
            PropertyDescriptor[] pd = this.tagClassInfo.getPropertyDescriptors();
            int i = 0;
            while (i < pd.length) {
                if (pd[i].getWriteMethod() != null) {
                    this.addSetterMethod(pd[i].getName(), pd[i].getWriteMethod());
                }
                if (pd[i].getPropertyEditorClass() != null) {
                    this.addPropertyEditor(pd[i].getName(), pd[i].getPropertyEditorClass());
                }
                ++i;
            }
        }
        catch (IntrospectionException ex) {
            throw new JasperException(Constants.getString((String)"jsp.error.unable.to_introspect", (Object[])new Object[]{tagHandlerClass.getName(), ex.getMessage()}));
        }
    }

    Class getTagHandlerClass() {
        return this.tagHandlerClass;
    }

    BeanInfo getTagClassInfo() {
        return this.tagClassInfo;
    }
}

