/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xerces.util.MessageFormatter;

public class DatatypeMessageProvider
implements MessageFormatter {
    public static final String DATATYPE_DOMAIN = "http://www.w3.org/TR/xml-schema-2";
    private Locale fLocale = null;
    private ResourceBundle fResourceBundle = null;
    private static int counter = 0;
    public static final int MSG_BAD_MAJORCODE = counter++;
    public static final int MSG_FORMAT_FAILURE = counter++;
    public static final int NOT_BOOLEAN = counter++;
    public static final int NOT_DECIMAL = counter++;
    public static final int NOT_FLOAT = counter++;
    public static final int NOT_DOUBLE = counter++;
    public static final int INVALID_ENUM_VALUE = counter++;
    public static final int OUT_OF_BOUNDS = counter++;
    public static final int NOT_ENUM_VALUE = counter++;
    public static final int FRACTION_GREATER_TOTALDIGITS = counter++;
    public static final int FRACTION_EXCEEDED = counter++;
    public static final int TOTALDIGITS_EXCEEDED = counter++;
    public static final int ILLEGAL_FACET_VALUE = counter++;
    public static final int ILLEGAL_ANYURI_FACET = counter++;
    public static final int ILLEGAL_BOOLEAN_FACET = counter++;
    public static final int ILLEGAL_BASE64_FACET = counter++;
    public static final int ILLEGAL_DATETIME_FACET = counter++;
    public static final int ILLEGAL_DECIMAL_FACET = counter++;
    public static final int ILLEGAL_DOUBLE_FACET = counter++;
    public static final int ILLEGAL_FLOAT_FACET = counter++;
    public static final int ILLEGAL_HEXBINARY_FACET = counter++;
    public static final int ILLEGAL_NOTATION_FACET = counter++;
    public static final int ILLEGAL_QNAME_FACET = counter++;
    public static final int ILLEGAL_STRING_FACET = counter++;
    public static final int ILLEGAL_LIST_FACET = counter++;
    public static final int ILLEGAL_UNION_FACET = counter++;
    public static final int ILLEGAL_ANYSIMPLETYPE_FACET = counter++;
    public static final int MSG_MAX_CODE = counter;
    public static final int MSG_NONE = 0;
    public static final String[] fgMessageKeys = new String[]{"BadMajorCode", "FormatFailed", "NotBoolean", "NotDecimal", "NotFloat", "NotDouble", "InvalidEnumValue", "OutOfBounds", "NotAnEnumValue", "FractionDigitsLargerThanTotalDigits", "FractionDigitsExceeded", "TotalDigitsExceeded", "IllegalFacetValue", "IllegalAnyURIFacet", "IllegalBooleanFacet", "IllegalBase64Facet", "IllegalDateTimeFacet", "IllegalDecimalFacet", "IllegalDoubleFacet", "IllegalFloatFacet", "IllegalHexBinaryFacet", "IllegalNotationFacet", "IllegalQNameFacet", "IllegalStringFacet", "IllegalListFacet", "IllegalUnionFacet", "IllegalAnySimpleTypeFacet"};

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public String formatMessage(Locale locale, String string, Object[] objectArray) throws MissingResourceException {
        boolean bl = false;
        if (this.fResourceBundle == null || locale != this.fLocale) {
            if (locale != null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.DatatypeMessages", locale);
            }
            if (this.fResourceBundle == null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.DatatypeMessages");
            }
        }
        int n = -1;
        int n2 = 0;
        while (n2 < fgMessageKeys.length) {
            if (fgMessageKeys[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            n = MSG_BAD_MAJORCODE;
            bl = true;
        }
        String string2 = fgMessageKeys[n];
        String string3 = this.fResourceBundle.getString(string2);
        if (objectArray != null) {
            try {
                string3 = MessageFormat.format(string3, objectArray);
            }
            catch (Exception exception) {
                string3 = this.fResourceBundle.getString(fgMessageKeys[MSG_FORMAT_FAILURE]);
                string3 = string3 + " " + this.fResourceBundle.getString(string2);
            }
        }
        if (bl) {
            throw new RuntimeException(string3);
        }
        return string3;
    }
}

