/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.SchemaSymbols;

public abstract class AbstractNumericFacetValidator
extends AbstractDatatypeValidator {
    protected Object[] fEnumeration;
    protected Object fMaxInclusive;
    protected Object fMaxExclusive;
    protected Object fMinInclusive;
    protected Object fMinExclusive;
    protected static final short INDETERMINATE = 2;

    public AbstractNumericFacetValidator() {
        this(null, null, false, null);
    }

    public AbstractNumericFacetValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl, XMLErrorReporter xMLErrorReporter) {
        block56: {
            this.fEnumeration = null;
            this.fMaxInclusive = null;
            this.fMaxExclusive = null;
            this.fMinInclusive = null;
            this.fMinExclusive = null;
            this.fBaseValidator = datatypeValidator;
            this.fErrorReporter = xMLErrorReporter;
            if (bl) {
                return;
            }
            try {
                int n;
                Object object;
                this.initializeValues();
                if (hashtable == null) break block56;
                Vector vector = null;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    String string = null;
                    if (((String)object).equals(SchemaSymbols.ELT_PATTERN)) {
                        this.fPattern = (String)hashtable.get(object);
                        if (this.fPattern != null) {
                            this.fRegex = new RegularExpression(this.fPattern, "X");
                        }
                        if (this.fRegex == null) continue;
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                        continue;
                    }
                    if (((String)object).equals(SchemaSymbols.ELT_ENUMERATION)) {
                        vector = (Vector)hashtable.get(object);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                        continue;
                    }
                    if (((String)object).equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                        string = (String)hashtable.get(object);
                        this.setMaxInclusive(string);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                        continue;
                    }
                    if (((String)object).equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                        string = (String)hashtable.get(object);
                        this.setMaxExclusive(string);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                        continue;
                    }
                    if (((String)object).equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                        string = (String)hashtable.get(object);
                        this.setMinInclusive(string);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                        continue;
                    }
                    if (((String)object).equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                        string = (String)hashtable.get(object);
                        this.setMinExclusive(string);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                        continue;
                    }
                    if (((String)object).equals("fixed")) {
                        this.fFlags = (Short)hashtable.get(object);
                        continue;
                    }
                    this.assignAdditionalFacets((String)object, hashtable);
                }
                if (this.fFacetsDefined != 0) {
                    if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x20) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
                    }
                    if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x80) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
                    }
                    if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x80) != 0 && ((n = this.compareValues(this.fMinInclusive, this.fMaxInclusive)) == 1 || n == 2)) {
                        throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be <= maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                    }
                    if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && ((n = this.compareValues(this.fMinExclusive, this.fMaxExclusive)) == 1 || n == 2)) {
                        throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be <= maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                    }
                    if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinExclusive, this.fMaxInclusive) != -1) {
                        throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be > maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                    }
                    if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMinInclusive, this.fMaxExclusive) != -1) {
                        throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be < maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                    }
                    this.checkFacetConstraints();
                }
                if (datatypeValidator == null) break block56;
                object = (AbstractNumericFacetValidator)datatypeValidator;
                if (this.fFacetsDefined != 0) {
                    if ((this.fFacetsDefined & 0x20) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0) {
                            n = this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x20) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("maxInclusive value = '" + this.getMaxInclusive(false) + "' must be equal to base.maxInclusive value = '" + this.getMaxInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == 1 || n == 2) {
                                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && ((n = this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMinInclusive)) == -1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxInclusive, ((AbstractNumericFacetValidator)object).fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x40) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0) {
                            n = this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x40) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("maxExclusive value = '" + this.getMaxExclusive(false) + "' must be equal to base.maxExclusive value = '" + this.getMaxExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == 1 || n == 2) {
                                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && ((n = this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive)) == 1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMaxExclusive, ((AbstractNumericFacetValidator)object).fMinInclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x100) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0) {
                            n = this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMinExclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x100) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("minExclusive value = '" + this.getMinExclusive(false) + "' must be equal to base.minExclusive value = '" + this.getMinExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == -1 || n == 2) {
                                throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && ((n = this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive)) == 1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && ((n = this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMinInclusive)) == -1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinExclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x80) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0) {
                            n = this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMinInclusive);
                            if ((((AbstractDatatypeValidator)object).fFlags & 0x80) != 0 && n != 0) {
                                throw new InvalidDatatypeFacetException("minInclusive value = '" + this.getMinInclusive(false) + "' must be equal to base.minInclusive value = '" + this.getMinInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (n == -1 || n == 2) {
                                throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                            }
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && ((n = this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMaxInclusive)) == 1 || n == 2)) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinInclusive, ((AbstractNumericFacetValidator)object).fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    this.checkBaseFacetConstraints();
                }
                if ((this.fFacetsDefined & 0x10) == 0 && (((AbstractDatatypeValidator)object).fFacetsDefined & 0x10) != 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = ((AbstractNumericFacetValidator)object).fEnumeration;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                    this.fMaxExclusive = ((AbstractNumericFacetValidator)object).fMaxExclusive;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                    this.fMaxInclusive = ((AbstractNumericFacetValidator)object).fMaxInclusive;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    this.fMinExclusive = ((AbstractNumericFacetValidator)object).fMinExclusive;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    this.fMinInclusive = ((AbstractNumericFacetValidator)object).fMinInclusive;
                }
                this.inheritAdditionalFacets();
                this.fFlags = (short)(this.fFlags | ((AbstractDatatypeValidator)object).fFlags);
                if ((this.fFacetsDefined & 0x10) == 0 || vector == null) break block56;
                try {
                    this.setEnumeration(vector);
                }
                catch (Exception exception) {
                    throw new InvalidDatatypeFacetException(exception.getMessage());
                }
            }
            catch (Exception exception) {
                if (this.fErrorReporter == null) {
                    throw new RuntimeException("InternalDatatype error ANFV.");
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "DatatypeFacetError", new Object[]{exception.getMessage()}, (short)1);
            }
        }
    }

    protected abstract int compareValues(Object var1, Object var2);

    protected abstract void setMaxInclusive(String var1);

    protected abstract void setMinInclusive(String var1);

    protected abstract void setMaxExclusive(String var1);

    protected abstract void setMinExclusive(String var1);

    protected abstract void setEnumeration(Vector var1) throws InvalidDatatypeValueException;

    protected abstract String getMaxInclusive(boolean var1);

    protected abstract String getMinInclusive(boolean var1);

    protected abstract String getMaxExclusive(boolean var1);

    protected abstract String getMinExclusive(boolean var1);

    protected void initializeValues() {
    }

    public boolean hasEnumeration() {
        return this.fEnumeration != null;
    }

    protected abstract void assignAdditionalFacets(String var1, Hashtable var2) throws InvalidDatatypeFacetException;

    protected void inheritAdditionalFacets() {
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
    }

    protected void checkFacetConstraints() throws InvalidDatatypeFacetException {
    }
}

