/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.AnySimpleType;
import org.apache.xerces.impl.dv.xs.AnyURIDatatypeValidator;
import org.apache.xerces.impl.dv.xs.Base64BinaryDatatypeValidator;
import org.apache.xerces.impl.dv.xs.BooleanDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidatorFactory;
import org.apache.xerces.impl.dv.xs.DateDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DateTimeDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DayDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DecimalDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DoubleDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DurationDatatypeValidator;
import org.apache.xerces.impl.dv.xs.FloatDatatypeValidator;
import org.apache.xerces.impl.dv.xs.HexBinaryDatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDDatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDREFDatatypeValidator;
import org.apache.xerces.impl.dv.xs.ListDatatypeValidator;
import org.apache.xerces.impl.dv.xs.MonthDatatypeValidator;
import org.apache.xerces.impl.dv.xs.MonthDayDatatypeValidator;
import org.apache.xerces.impl.dv.xs.NOTATIONDatatypeValidator;
import org.apache.xerces.impl.dv.xs.QNameDatatypeValidator;
import org.apache.xerces.impl.dv.xs.StringDatatypeValidator;
import org.apache.xerces.impl.dv.xs.TimeDatatypeValidator;
import org.apache.xerces.impl.dv.xs.UnionDatatypeValidator;
import org.apache.xerces.impl.dv.xs.YearDatatypeValidator;
import org.apache.xerces.impl.dv.xs.YearMonthDatatypeValidator;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class DatatypeValidatorFactoryImpl
implements DatatypeValidatorFactory {
    private static final boolean fDebug = false;
    private Hashtable fRegistry = new Hashtable(30);
    private Hashtable fDTDDatatypeRegistry;
    private Hashtable fSchemaDatatypeRegistry = new Hashtable(40);
    private byte fRegistryExpanded = 0;
    private byte fSchemaValidation = 0;
    static /* synthetic */ Class class$org$apache$xerces$impl$dv$xs$DatatypeValidator;
    static /* synthetic */ Class class$java$util$Hashtable;

    public DatatypeValidatorFactoryImpl() {
        this.fDTDDatatypeRegistry = new Hashtable(10);
    }

    public void initializeDTDRegistry() {
        if (this.fRegistryExpanded == 0) {
            this.fDTDDatatypeRegistry.put("string", new StringDatatypeValidator());
            this.fDTDDatatypeRegistry.put("ID", new IDDatatypeValidator());
            this.fDTDDatatypeRegistry.put("IDREF", new IDREFDatatypeValidator());
            this.fDTDDatatypeRegistry.put("NOTATION", new NOTATIONDatatypeValidator());
            this.createDTDDatatypeValidator("IDREFS", new IDREFDatatypeValidator(), null, true);
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("specialToken", "NMTOKEN");
            hashtable.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            this.createDTDDatatypeValidator("NMTOKEN", new StringDatatypeValidator(), hashtable, false);
            this.createDTDDatatypeValidator("NMTOKENS", this.getDatatypeValidator("NMTOKEN"), null, true);
            this.fRegistryExpanded = 1;
        }
    }

    public void expandRegistryToFullSchemaSet() {
        this.fSchemaValidation = 1;
        if (this.fRegistryExpanded != 2) {
            this.fSchemaDatatypeRegistry.put("anySimpleType", new AnySimpleType());
            this.fSchemaDatatypeRegistry.put("boolean", new BooleanDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("float", new FloatDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("double", new DoubleDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("decimal", new DecimalDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("hexBinary", new HexBinaryDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("base64Binary", new Base64BinaryDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("anyURI", new AnyURIDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("QName", new QNameDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("duration", new DurationDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gDay", new DayDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("time", new TimeDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("dateTime", new DateTimeDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("date", new DateDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gMonthDay", new MonthDayDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gYearMonth", new YearMonthDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gYear", new YearDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gMonth", new MonthDatatypeValidator());
            if (this.fRegistryExpanded == 0) {
                this.initializeDTDRegistry();
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put(SchemaSymbols.ELT_WHITESPACE, "replace");
            this.createSchemaDatatypeValidator("normalizedString", this.getDatatypeValidator("string"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            this.createSchemaDatatypeValidator("token", this.getDatatypeValidator("string"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            hashtable.put(SchemaSymbols.ELT_PATTERN, "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
            this.createSchemaDatatypeValidator("language", this.getDatatypeValidator("string"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            hashtable.put("specialToken", "Name");
            this.createSchemaDatatypeValidator("Name", this.getDatatypeValidator("string"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            hashtable.put("specialToken", "NCName");
            this.createSchemaDatatypeValidator("NCName", this.getDatatypeValidator("string"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_FRACTIONDIGITS, "0");
            this.createSchemaDatatypeValidator("integer", this.getDatatypeValidator("decimal"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "0");
            this.createSchemaDatatypeValidator("nonPositiveInteger", this.getDatatypeValidator("integer"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "-1");
            this.createSchemaDatatypeValidator("negativeInteger", this.getDatatypeValidator("nonPositiveInteger"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "9223372036854775807");
            hashtable.put(SchemaSymbols.ELT_MININCLUSIVE, "-9223372036854775808");
            this.createSchemaDatatypeValidator("long", this.getDatatypeValidator("integer"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "2147483647");
            hashtable.put(SchemaSymbols.ELT_MININCLUSIVE, "-2147483648");
            this.createSchemaDatatypeValidator("int", this.getDatatypeValidator("long"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "32767");
            hashtable.put(SchemaSymbols.ELT_MININCLUSIVE, "-32768");
            this.createSchemaDatatypeValidator("short", this.getDatatypeValidator("int"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "127");
            hashtable.put(SchemaSymbols.ELT_MININCLUSIVE, "-128");
            this.createSchemaDatatypeValidator("byte", this.getDatatypeValidator("short"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MININCLUSIVE, "0");
            this.createSchemaDatatypeValidator("nonNegativeInteger", this.getDatatypeValidator("integer"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "18446744073709551615");
            this.createSchemaDatatypeValidator("unsignedLong", this.getDatatypeValidator("nonNegativeInteger"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "4294967295");
            this.createSchemaDatatypeValidator("unsignedInt", this.getDatatypeValidator("unsignedLong"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "65535");
            this.createSchemaDatatypeValidator("unsignedShort", this.getDatatypeValidator("unsignedInt"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MAXINCLUSIVE, "255");
            this.createSchemaDatatypeValidator("unsignedByte", this.getDatatypeValidator("unsignedShort"), hashtable, false);
            hashtable.clear();
            hashtable.put(SchemaSymbols.ELT_MININCLUSIVE, "1");
            this.createSchemaDatatypeValidator("positiveInteger", this.getDatatypeValidator("nonNegativeInteger"), hashtable, false);
            ((IDDatatypeValidator)this.getDatatypeValidator("ID")).setTokenType("ID(NCName)");
            ((IDREFDatatypeValidator)this.getDatatypeValidator("IDREF")).setTokenType("IDREF(NCName)");
            QNameDatatypeValidator.setNCNameValidator(this.getDatatypeValidator("NCName"));
            this.fRegistryExpanded = (byte)2;
        }
    }

    public void resetRegistry() {
        this.fRegistry.clear();
        this.fSchemaValidation = 0;
    }

    public DatatypeValidator createDatatypeValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) {
        if (datatypeValidator == null) {
            return null;
        }
        DatatypeValidator datatypeValidator2 = this.createXMLSchemaValidator(string, datatypeValidator, hashtable, bl);
        this.registerUserDefinedValidator(string, datatypeValidator2);
        return datatypeValidator2;
    }

    public DatatypeValidator createDatatypeValidator(String string, Vector vector) {
        UnionDatatypeValidator unionDatatypeValidator = null;
        if (vector != null) {
            unionDatatypeValidator = new UnionDatatypeValidator(vector, null);
        }
        if (unionDatatypeValidator != null) {
            this.registerUserDefinedValidator(string, unionDatatypeValidator);
        }
        return unionDatatypeValidator;
    }

    public DatatypeValidator getDatatypeValidator(String string) {
        AbstractDatatypeValidator abstractDatatypeValidator = null;
        if (string == null) {
            return null;
        }
        abstractDatatypeValidator = (AbstractDatatypeValidator)this.fDTDDatatypeRegistry.get(string);
        if (abstractDatatypeValidator == null && this.fSchemaValidation == 1 && (abstractDatatypeValidator = (AbstractDatatypeValidator)this.fSchemaDatatypeRegistry.get(string)) == null) {
            return (DatatypeValidator)this.fRegistry.get(string);
        }
        return abstractDatatypeValidator;
    }

    private DatatypeValidator createSchemaDatatypeValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) {
        DatatypeValidator datatypeValidator2 = this.createXMLSchemaValidator(string, datatypeValidator, hashtable, bl);
        this.registerXMLSchemaValidator(string, datatypeValidator2);
        return datatypeValidator2;
    }

    private DatatypeValidator createDTDDatatypeValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) {
        DatatypeValidator datatypeValidator2 = this.createXMLSchemaValidator(string, datatypeValidator, hashtable, bl);
        this.registerDTDValidator(string, datatypeValidator2);
        return datatypeValidator2;
    }

    private DatatypeValidator createXMLSchemaValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) {
        DatatypeValidator datatypeValidator2 = null;
        if (bl) {
            datatypeValidator2 = new ListDatatypeValidator(datatypeValidator, hashtable, bl, null);
        } else {
            try {
                String string2 = (String)hashtable.get(SchemaSymbols.ELT_WHITESPACE);
                if (string2 != null && !(datatypeValidator instanceof StringDatatypeValidator) && !string2.equals("collapse")) {
                    hashtable.remove(SchemaSymbols.ELT_WHITESPACE);
                }
                Class<?> clazz = datatypeValidator.getClass();
                Class[] classArray = new Class[]{class$org$apache$xerces$impl$dv$xs$DatatypeValidator == null ? (class$org$apache$xerces$impl$dv$xs$DatatypeValidator = DatatypeValidatorFactoryImpl.class$("org.apache.xerces.impl.dv.xs.DatatypeValidator")) : class$org$apache$xerces$impl$dv$xs$DatatypeValidator, class$java$util$Hashtable == null ? (class$java$util$Hashtable = DatatypeValidatorFactoryImpl.class$("java.util.Hashtable")) : class$java$util$Hashtable, Boolean.TYPE};
                Object[] objectArray = new Object[]{datatypeValidator, hashtable, Boolean.FALSE};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                datatypeValidator2 = (DatatypeValidator)DatatypeValidatorFactoryImpl.createDatatypeValidator(constructor, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return datatypeValidator2;
    }

    private void registerUserDefinedValidator(String string, DatatypeValidator datatypeValidator) {
        if (datatypeValidator != null) {
            this.fRegistry.put(string, datatypeValidator);
        }
    }

    private void registerXMLSchemaValidator(String string, DatatypeValidator datatypeValidator) {
        if (datatypeValidator != null) {
            this.fSchemaDatatypeRegistry.put(string, datatypeValidator);
        }
    }

    private void registerDTDValidator(String string, DatatypeValidator datatypeValidator) {
        if (datatypeValidator != null) {
            this.fDTDDatatypeRegistry.put(string, datatypeValidator);
        }
    }

    private static Object createDatatypeValidator(Constructor constructor, Object[] objectArray) {
        Object var2_2 = null;
        try {
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return var2_2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

