/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs_new;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs_new.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class FloatDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 1016;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return FloatDV.fValueOf(string);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("'" + string + "' is not a valid float value");
        }
    }

    public int compare(Object object, Object object2) {
        return this.compareFloats((Float)object, (Float)object2);
    }

    private static Float fValueOf(String string) throws NumberFormatException {
        Float f = null;
        try {
            f = Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                f = new Float(Float.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                f = new Float(Float.NEGATIVE_INFINITY);
            }
            if (string.equals("NaN")) {
                f = new Float(Float.NaN);
            }
            throw numberFormatException;
        }
        return f;
    }

    private int compareFloats(Float f, Float f2) {
        int n;
        float f3;
        float f4 = f.floatValue();
        if (f4 < (f3 = f2.floatValue())) {
            return -1;
        }
        if (f4 > f3) {
            return 1;
        }
        int n2 = Float.floatToIntBits(f4);
        return n2 == (n = Float.floatToIntBits(f3)) ? 0 : (n2 < n ? -1 : 1);
    }
}

