/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.Grammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.SymbolTable;

public class SchemaGrammar
extends Grammar {
    private SymbolTable fSymbolTable;
    public String fTargetNamespace;
    SymbolHash fGlobalAttrDecls;
    SymbolHash fGlobalAttrGrpDecls;
    SymbolHash fGlobalElemDecls;
    SymbolHash fGlobalGroupDecls;
    SymbolHash fGlobalNotationDecls;
    SymbolHash fGlobalIDConstraintDecls;
    Hashtable fGlobalTypeDecls;
    private static final int BASICSET_COUNT = 29;
    private static final int FULLSET_COUNT = 46;
    private static final int INITIAL_SIZE = 16;
    private static final int INC_SIZE = 16;
    private int fCTCount = 0;
    private XSComplexTypeDecl[] fComplexTypeDecls = new XSComplexTypeDecl[16];
    private static final int REDEFINED_GROUP_INIT_SIZE = 2;
    private int fRGCount = 0;
    private XSGroupDecl[] fRedefinedGroupDecls = new XSGroupDecl[2];
    boolean fFullChecked = false;
    private int fSubGroupCount = 0;
    private XSElementDecl[] fSubGroups = new XSElementDecl[16];
    public static final XSComplexTypeDecl fAnyType = new XSComplexTypeDecl();
    public static final SchemaGrammar SG_SchemaNS;
    public static final XSSimpleType fAnySimpleType;

    public SchemaGrammar(SymbolTable symbolTable, String string) {
        this.fSymbolTable = symbolTable;
        this.fTargetNamespace = string;
        this.fGlobalAttrDecls = new SymbolHash();
        this.fGlobalAttrGrpDecls = new SymbolHash();
        this.fGlobalElemDecls = new SymbolHash();
        this.fGlobalGroupDecls = new SymbolHash();
        this.fGlobalNotationDecls = new SymbolHash();
        this.fGlobalTypeDecls = new Hashtable();
        this.fGlobalIDConstraintDecls = new SymbolHash();
    }

    protected SchemaGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
        this.fGlobalAttrDecls = new SymbolHash(1);
        this.fGlobalAttrGrpDecls = new SymbolHash(1);
        this.fGlobalElemDecls = new SymbolHash(1);
        this.fGlobalGroupDecls = new SymbolHash(1);
        this.fGlobalNotationDecls = new SymbolHash(1);
        this.fGlobalIDConstraintDecls = new SymbolHash(1);
        SchemaDVFactory schemaDVFactory = SchemaDVFactory.getInstance();
        this.fGlobalTypeDecls = schemaDVFactory.getBuiltInTypes();
        this.addGlobalTypeDecl(fAnyType);
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public final String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public final void addGlobalAttributeDecl(XSAttributeDecl xSAttributeDecl) {
        this.fGlobalAttrDecls.put(xSAttributeDecl.fName, (Object)xSAttributeDecl);
    }

    public final void addGlobalAttributeGroupDecl(XSAttributeGroupDecl xSAttributeGroupDecl) {
        this.fGlobalAttrGrpDecls.put(xSAttributeGroupDecl.fName, (Object)xSAttributeGroupDecl);
    }

    public final void addGlobalElementDecl(XSElementDecl xSElementDecl) {
        this.fGlobalElemDecls.put(xSElementDecl.fName, (Object)xSElementDecl);
        if (xSElementDecl.fSubGroup != null) {
            if (this.fSubGroupCount == this.fSubGroups.length) {
                this.fSubGroups = SchemaGrammar.resize(this.fSubGroups, this.fSubGroupCount + 16);
            }
            this.fSubGroups[this.fSubGroupCount++] = xSElementDecl;
        }
    }

    public final void addGlobalGroupDecl(XSGroupDecl xSGroupDecl) {
        this.fGlobalGroupDecls.put(xSGroupDecl.fName, (Object)xSGroupDecl);
    }

    public final void addGlobalNotationDecl(XSNotationDecl xSNotationDecl) {
        this.fGlobalNotationDecls.put(xSNotationDecl.fName, (Object)xSNotationDecl);
    }

    public final void addGlobalTypeDecl(XSTypeDecl xSTypeDecl) {
        this.fGlobalTypeDecls.put(xSTypeDecl.getTypeName(), xSTypeDecl);
    }

    public final void addIDConstraintDecl(XSElementDecl xSElementDecl, IdentityConstraint identityConstraint) {
        xSElementDecl.addIDConstaint(identityConstraint);
        this.fGlobalIDConstraintDecls.put(identityConstraint.getIdentityConstraintName(), (Object)identityConstraint);
    }

    public final XSAttributeDecl getGlobalAttributeDecl(String string) {
        return (XSAttributeDecl)this.fGlobalAttrDecls.get(string);
    }

    public final XSAttributeGroupDecl getGlobalAttributeGroupDecl(String string) {
        return (XSAttributeGroupDecl)this.fGlobalAttrGrpDecls.get(string);
    }

    public final XSElementDecl getGlobalElementDecl(String string) {
        return (XSElementDecl)this.fGlobalElemDecls.get(string);
    }

    public final XSGroupDecl getGlobalGroupDecl(String string) {
        return (XSGroupDecl)this.fGlobalGroupDecls.get(string);
    }

    public final XSNotationDecl getNotationDecl(String string) {
        return (XSNotationDecl)this.fGlobalNotationDecls.get(string);
    }

    public final XSTypeDecl getGlobalTypeDecl(String string) {
        return (XSTypeDecl)this.fGlobalTypeDecls.get(string);
    }

    public final IdentityConstraint getIDConstraintDecl(String string) {
        return (IdentityConstraint)this.fGlobalIDConstraintDecls.get(string);
    }

    public final void addComplexTypeDecl(XSComplexTypeDecl xSComplexTypeDecl) {
        if (this.fCTCount == this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount + 16);
        }
        this.fComplexTypeDecls[this.fCTCount++] = xSComplexTypeDecl;
    }

    public final void addRedefinedGroupDecl(XSGroupDecl xSGroupDecl, XSGroupDecl xSGroupDecl2) {
        if (this.fRGCount == this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount << 1);
        }
        this.fRedefinedGroupDecls[this.fRGCount++] = xSGroupDecl;
        this.fRedefinedGroupDecls[this.fRGCount++] = xSGroupDecl2;
    }

    final XSComplexTypeDecl[] getUncheckedComplexTypeDecls() {
        if (this.fCTCount < this.fComplexTypeDecls.length) {
            this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
        }
        return this.fComplexTypeDecls;
    }

    final XSGroupDecl[] getRedefinedGroupDecls() {
        if (this.fRGCount < this.fRedefinedGroupDecls.length) {
            this.fRedefinedGroupDecls = SchemaGrammar.resize(this.fRedefinedGroupDecls, this.fRGCount);
        }
        return this.fRedefinedGroupDecls;
    }

    final void setUncheckedTypeNum(int n) {
        this.fCTCount = n;
        this.fComplexTypeDecls = SchemaGrammar.resize(this.fComplexTypeDecls, this.fCTCount);
    }

    final XSElementDecl[] getSubstitutionGroups() {
        if (this.fSubGroupCount < this.fSubGroups.length) {
            this.fSubGroups = SchemaGrammar.resize(this.fSubGroups, this.fSubGroupCount);
        }
        return this.fSubGroups;
    }

    static final XSComplexTypeDecl[] resize(XSComplexTypeDecl[] xSComplexTypeDeclArray, int n) {
        XSComplexTypeDecl[] xSComplexTypeDeclArray2 = new XSComplexTypeDecl[n];
        System.arraycopy(xSComplexTypeDeclArray, 0, xSComplexTypeDeclArray2, 0, Math.min(xSComplexTypeDeclArray.length, n));
        return xSComplexTypeDeclArray2;
    }

    static final XSGroupDecl[] resize(XSGroupDecl[] xSGroupDeclArray, int n) {
        XSGroupDecl[] xSGroupDeclArray2 = new XSGroupDecl[n];
        System.arraycopy(xSGroupDeclArray, 0, xSGroupDeclArray2, 0, Math.min(xSGroupDeclArray.length, n));
        return xSGroupDeclArray2;
    }

    static final XSElementDecl[] resize(XSElementDecl[] xSElementDeclArray, int n) {
        XSElementDecl[] xSElementDeclArray2 = new XSElementDecl[n];
        System.arraycopy(xSElementDeclArray, 0, xSElementDeclArray2, 0, Math.min(xSElementDeclArray.length, n));
        return xSElementDeclArray2;
    }

    static {
        SchemaGrammar.fAnyType.fName = "anyType";
        SchemaGrammar.fAnyType.fTargetNamespace = SchemaSymbols.URI_SCHEMAFORSCHEMA;
        SchemaGrammar.fAnyType.fBaseType = fAnyType;
        SchemaGrammar.fAnyType.fDerivedBy = (short)2;
        SchemaGrammar.fAnyType.fContentType = (short)2;
        XSWildcardDecl xSWildcardDecl = new XSWildcardDecl();
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fMinOccurs = 0;
        xSParticleDecl.fMaxOccurs = -1;
        xSParticleDecl.fType = (short)2;
        xSParticleDecl.fValue = xSWildcardDecl;
        SchemaGrammar.fAnyType.fParticle = xSParticleDecl;
        SchemaGrammar.fAnyType.fAttrGrp.fAttributeWC = xSWildcardDecl;
        SG_SchemaNS = new SchemaGrammar(null);
        fAnySimpleType = (XSSimpleType)SG_SchemaNS.getGlobalTypeDecl("anySimpleType");
    }
}

