/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.AbstractXMLDocumentParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class AbstractDOMParser
extends AbstractXMLDocumentParser {
    protected static final String CREATE_ENTITY_REF_NODES = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String INCLUDE_COMMENTS_FEATURE = "include-comments";
    protected static final String CREATE_CDATA_NODES_FEATURE = "create-cdata-nodes";
    protected static final String INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final String DEFER_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    protected static final String DOCUMENT_CLASS_NAME = "http://apache.org/xml/properties/dom/document-class-name";
    protected static final String DEFAULT_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DocumentImpl";
    private static final boolean DEBUG_ENTITY_REF = false;
    protected boolean fCreateEntityRefNodes;
    protected boolean fIncludeIgnorableWhitespace;
    protected boolean fIncludeComments;
    protected boolean fCreateCDATANodes;
    protected Document fDocument;
    protected DocumentImpl fDocumentImpl;
    protected String fDocumentClassName;
    protected DocumentType fDocumentType;
    protected Node fCurrentNode;
    protected CDATASection fCurrentCDATASection;
    protected StringBuffer fInternalSubset;
    protected boolean fDeferNodeExpansion;
    protected boolean fNamespaceAware;
    protected DeferredDocumentImpl fDeferredDocumentImpl;
    protected int fDocumentIndex;
    protected int fDocumentTypeIndex;
    protected int fCurrentNodeIndex;
    protected int fCurrentCDATASectionIndex;
    protected boolean fInDTDExternalSubset;
    protected boolean fInDocument;
    protected boolean fInCDATASection;
    private QName fAttrQName = new QName();
    static /* synthetic */ Class class$org$w3c$dom$Document;

    protected AbstractDOMParser(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        String[] stringArray = new String[]{CREATE_ENTITY_REF_NODES, INCLUDE_IGNORABLE_WHITESPACE, DEFER_NODE_EXPANSION, INCLUDE_COMMENTS_FEATURE, CREATE_CDATA_NODES_FEATURE};
        this.fConfiguration.addRecognizedFeatures(stringArray);
        this.fConfiguration.setFeature(CREATE_ENTITY_REF_NODES, true);
        this.fConfiguration.setFeature(INCLUDE_IGNORABLE_WHITESPACE, true);
        this.fConfiguration.setFeature(DEFER_NODE_EXPANSION, true);
        this.fConfiguration.setFeature(INCLUDE_COMMENTS_FEATURE, true);
        this.fConfiguration.setFeature(CREATE_CDATA_NODES_FEATURE, true);
        String[] stringArray2 = new String[]{DOCUMENT_CLASS_NAME};
        this.fConfiguration.addRecognizedProperties(stringArray2);
        this.fConfiguration.setProperty(DOCUMENT_CLASS_NAME, DEFAULT_DOCUMENT_CLASS_NAME);
    }

    protected void setDocumentClassName(String string) {
        if (string == null) {
            string = DEFAULT_DOCUMENT_CLASS_NAME;
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (!(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = AbstractDOMParser.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("PAR002 Class, \"" + string + "\", is not of type org.w3c.dom.Document.\n" + string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("PAR003 Class, \"" + string + "\", not found.\n" + string);
        }
        this.fDocumentClassName = string;
        if (!string.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
            this.fDeferNodeExpansion = false;
        }
    }

    public Document getDocument() {
        return this.fDocument;
    }

    public void reset() throws XNIException {
        super.reset();
        this.fCreateEntityRefNodes = this.fConfiguration.getFeature(CREATE_ENTITY_REF_NODES);
        this.fIncludeIgnorableWhitespace = this.fConfiguration.getFeature(INCLUDE_IGNORABLE_WHITESPACE);
        this.fDeferNodeExpansion = this.fConfiguration.getFeature(DEFER_NODE_EXPANSION);
        this.fNamespaceAware = this.fConfiguration.getFeature(NAMESPACES);
        this.fIncludeComments = this.fConfiguration.getFeature(INCLUDE_COMMENTS_FEATURE);
        this.fCreateCDATANodes = this.fConfiguration.getFeature(CREATE_CDATA_NODES_FEATURE);
        this.setDocumentClassName((String)this.fConfiguration.getProperty(DOCUMENT_CLASS_NAME));
        this.fDocument = null;
        this.fDocumentImpl = null;
        this.fDocumentType = null;
        this.fDocumentTypeIndex = -1;
        this.fDeferredDocumentImpl = null;
        this.fCurrentNode = null;
        this.fInDocument = false;
        this.fInDTD = false;
        this.fInDTDExternalSubset = false;
        this.fInCDATASection = false;
        this.fCurrentCDATASection = null;
        this.fCurrentCDATASectionIndex = -1;
    }

    public void startEntity(String string, String string2, String string3, String string4, String string5, Augmentations augmentations) throws XNIException {
        if (this.fInDocument && !this.fInDTD && this.fCreateEntityRefNodes) {
            if (!this.fDeferNodeExpansion) {
                EntityReference entityReference = this.fDocument.createEntityReference(string);
                this.fCurrentNode.appendChild(entityReference);
                this.fCurrentNode = entityReference;
            } else {
                int n = this.fDeferredDocumentImpl.createDeferredEntityReference(string);
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
                this.fCurrentNodeIndex = n;
            }
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            String string3;
            NamedNodeMap namedNodeMap;
            EntityImpl entityImpl;
            if (this.fDocumentType != null && (entityImpl = (EntityImpl)(namedNodeMap = this.fDocumentType.getEntities()).getNamedItem(string3 = this.fCurrentNode.getNodeName())) != null) {
                entityImpl.setVersion(string);
                entityImpl.setEncoding(string2);
            }
        } else {
            String string4 = this.fDeferredDocumentImpl.getNodeName(this.fCurrentNodeIndex, false);
            if (this.fDocumentTypeIndex != -1 && string4 != null) {
                boolean bl = false;
                int n = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                while (n != -1) {
                    String string5;
                    short s = this.fDeferredDocumentImpl.getNodeType(n, false);
                    if (s == 6 && (string5 = this.fDeferredDocumentImpl.getNodeName(n, false)).equals(string4)) {
                        bl = true;
                        break;
                    }
                    n = this.fDeferredDocumentImpl.getRealPrevSibling(n, false);
                }
                if (bl) {
                    this.fDeferredDocumentImpl.setEntityInfo(n, string, string2);
                }
            }
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fIncludeComments) {
            return;
        }
        if (!this.fDeferNodeExpansion) {
            Comment comment = this.fDocument.createComment(xMLString.toString());
            this.fCurrentNode.appendChild(comment);
        } else {
            int n = this.fDeferredDocumentImpl.createDeferredComment(xMLString.toString());
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            ProcessingInstruction processingInstruction = this.fDocument.createProcessingInstruction(string, xMLString.toString());
            this.fCurrentNode.appendChild(processingInstruction);
        } else {
            int n = this.fDeferredDocumentImpl.createDeferredProcessingInstruction(string, xMLString.toString());
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
        }
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.fInDocument = true;
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
                this.fDocument = new DocumentImpl();
                this.fDocumentImpl = (DocumentImpl)this.fDocument;
                this.fDocumentImpl.setStrictErrorChecking(false);
                this.fDocumentImpl.setActualEncoding(string);
            } else {
                try {
                    Class<?> clazz = Class.forName(this.fDocumentClassName);
                    this.fDocument = (Document)clazz.newInstance();
                    Class<?> clazz2 = Class.forName(DEFAULT_DOCUMENT_CLASS_NAME);
                    if (clazz2.isAssignableFrom(clazz)) {
                        this.fDocumentImpl = (DocumentImpl)this.fDocument;
                        this.fDocumentImpl.setStrictErrorChecking(false);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to create document object of class: " + this.fDocumentClassName);
                }
            }
            this.fCurrentNode = this.fDocument;
        } else {
            this.fDeferredDocumentImpl = new DeferredDocumentImpl(this.fNamespaceAware);
            this.fDocument = this.fDeferredDocumentImpl;
            this.fCurrentNodeIndex = this.fDocumentIndex = this.fDeferredDocumentImpl.createDeferredDocument();
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentImpl.setVersion(string);
                this.fDocumentImpl.setEncoding(string2);
                this.fDocumentImpl.setStandalone("true".equals(string3));
            }
        } else {
            this.fDeferredDocumentImpl.setVersion(string);
            this.fDeferredDocumentImpl.setEncoding(string2);
            this.fDeferredDocumentImpl.setStandalone("true".equals(string3));
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentType = this.fDocumentImpl.createDocumentType(string, string2, string3);
                this.fCurrentNode.appendChild(this.fDocumentType);
            }
        } else {
            this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDeferredDocumentType(string, string2, string3);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, this.fDocumentTypeIndex);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            Object object;
            Element element = this.fNamespaceAware ? this.fDocument.createElementNS(qName.uri, qName.rawname) : this.fDocument.createElement(qName.rawname);
            int n = xMLAttributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                xMLAttributes.getName(n2, this.fAttrQName);
                String string = this.fAttrQName.rawname;
                if (string != null && (string.startsWith("xmlns:") || string.equals("xmlns"))) {
                    this.fAttrQName.uri = "http://www.w3.org/2000/xmlns/";
                }
                object = this.fNamespaceAware ? this.fDocument.createAttributeNS(this.fAttrQName.uri, this.fAttrQName.rawname) : this.fDocument.createAttribute(this.fAttrQName.rawname);
                String string2 = xMLAttributes.getValue(n2);
                object.setValue(string2);
                element.setAttributeNode((Attr)object);
                if (this.fDocumentImpl != null) {
                    AttrImpl attrImpl = (AttrImpl)object;
                    boolean bl = xMLAttributes.isSpecified(n2);
                    attrImpl.setSpecified(bl);
                }
                ++n2;
            }
            this.fCurrentNode.appendChild(element);
            this.fCurrentNode = element;
            int n3 = 0;
            while (n3 < n) {
                if (xMLAttributes.getType(n3).equals("ID")) {
                    object = xMLAttributes.getValue(n3);
                    this.fDocumentImpl.putIdentifier((String)object, element);
                }
                ++n3;
            }
        } else {
            int n = this.fDeferredDocumentImpl.createDeferredElement(this.fNamespaceAware ? qName.uri : null, qName.rawname, xMLAttributes);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
            this.fCurrentNodeIndex = n;
            int n4 = xMLAttributes.getLength();
            int n5 = 0;
            while (n5 < n4) {
                if (xMLAttributes.getType(n5).equals("ID")) {
                    String string = xMLAttributes.getValue(n5);
                    this.fDeferredDocumentImpl.putIdentifier(string, n);
                }
                ++n5;
            }
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fInCDATASection && this.fCreateCDATANodes) {
                if (this.fCurrentCDATASection == null) {
                    this.fCurrentCDATASection = this.fDocument.createCDATASection(xMLString.toString());
                    this.fCurrentNode.appendChild(this.fCurrentCDATASection);
                    this.fCurrentNode = this.fCurrentCDATASection;
                } else {
                    this.fCurrentCDATASection.appendData(xMLString.toString());
                }
            } else if (!this.fInDTD) {
                Node node = this.fCurrentNode.getLastChild();
                if (node != null && node.getNodeType() == 3) {
                    Text text = (Text)node;
                    text.appendData(xMLString.toString());
                } else {
                    Text text = this.fDocument.createTextNode(xMLString.toString());
                    this.fCurrentNode.appendChild(text);
                }
            }
        } else if (this.fInCDATASection && this.fCreateCDATANodes) {
            if (this.fCurrentCDATASectionIndex == -1) {
                int n = this.fDeferredDocumentImpl.createDeferredCDATASection(xMLString.toString());
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
                this.fCurrentCDATASectionIndex = n;
                this.fCurrentNodeIndex = n;
            } else {
                int n = this.fDeferredDocumentImpl.createDeferredTextNode(xMLString.toString(), false);
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
            }
        } else if (!this.fInDTD) {
            int n = this.fDeferredDocumentImpl.createDeferredTextNode(xMLString.toString(), false);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fIncludeIgnorableWhitespace) {
            return;
        }
        if (!this.fDeferNodeExpansion) {
            Node node = this.fCurrentNode.getLastChild();
            if (node != null && node.getNodeType() == 3) {
                Text text = (Text)node;
                text.appendData(xMLString.toString());
            } else {
                Text text = this.fDocument.createTextNode(xMLString.toString());
                if (this.fDocumentImpl != null) {
                    TextImpl textImpl = (TextImpl)text;
                    textImpl.setIgnorableWhitespace(true);
                }
                this.fCurrentNode.appendChild(text);
            }
        } else {
            int n = this.fDeferredDocumentImpl.createDeferredTextNode(xMLString.toString(), true);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            this.fCurrentNode = this.fCurrentNode.getParentNode();
        } else {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
        }
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = true;
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = false;
        if (!this.fDeferNodeExpansion) {
            if (this.fCurrentCDATASection != null) {
                this.fCurrentNode = this.fCurrentNode.getParentNode();
                this.fCurrentCDATASection = null;
            }
        } else if (this.fCurrentCDATASectionIndex != -1) {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            this.fCurrentCDATASectionIndex = -1;
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        this.fInDocument = false;
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentImpl.setStrictErrorChecking(true);
            }
            this.fCurrentNode = null;
        } else {
            this.fCurrentNodeIndex = -1;
        }
    }

    public void endEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fInDocument && !this.fInDTD && this.fCreateEntityRefNodes) {
            if (!this.fDeferNodeExpansion) {
                NamedNodeMap namedNodeMap;
                NodeImpl nodeImpl;
                if (this.fDocumentType != null && (nodeImpl = (NodeImpl)(namedNodeMap = this.fDocumentType.getEntities()).getNamedItem(string)) != null && nodeImpl.getFirstChild() == null) {
                    nodeImpl.setReadOnly(false, true);
                    Node node = this.fCurrentNode.getFirstChild();
                    while (node != null) {
                        Node node2 = node.cloneNode(true);
                        nodeImpl.appendChild(node2);
                        node = node.getNextSibling();
                    }
                    nodeImpl.setReadOnly(true, true);
                    namedNodeMap.setNamedItem((Node)nodeImpl);
                }
                this.fCurrentNode = this.fCurrentNode.getParentNode();
            } else {
                int n;
                int n2 = -1;
                int n3 = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                while (n3 != -1) {
                    String string2;
                    n = this.fDeferredDocumentImpl.getNodeType(n3, false);
                    if (n == 6 && (string2 = this.fDeferredDocumentImpl.getNodeName(n3, false)).equals(string)) {
                        if (this.fDeferredDocumentImpl.getLastChild(n3, false) != -1) break;
                        n2 = n3;
                        break;
                    }
                    n3 = this.fDeferredDocumentImpl.getRealPrevSibling(n3, false);
                }
                if (n2 != -1) {
                    n = -1;
                    int n4 = this.fDeferredDocumentImpl.getLastChild(this.fCurrentNodeIndex, false);
                    while (n4 != -1) {
                        int n5 = this.fDeferredDocumentImpl.cloneNode(n4, true);
                        this.fDeferredDocumentImpl.insertBefore(n2, n5, n);
                        n = n5;
                        n4 = this.fDeferredDocumentImpl.getRealPrevSibling(n4, false);
                    }
                }
                this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            }
        }
    }

    public void startDTD(XMLLocator xMLLocator) throws XNIException {
        super.startDTD(xMLLocator);
        if (this.fDeferNodeExpansion || this.fDocumentImpl != null) {
            this.fInternalSubset = new StringBuffer(1024);
        }
    }

    public void endDTD() throws XNIException {
        String string;
        super.endDTD();
        String string2 = string = this.fInternalSubset != null && this.fInternalSubset.length() > 0 ? this.fInternalSubset.toString() : null;
        if (this.fDeferNodeExpansion) {
            if (string != null) {
                this.fDeferredDocumentImpl.setInternalSubset(this.fDocumentTypeIndex, string);
            }
        } else if (this.fDocumentImpl != null && string != null) {
            ((DocumentTypeImpl)this.fDocumentType).setInternalSubset(string);
        }
    }

    public void startEntity(String string, String string2, String string3, String string4, String string5) throws XNIException {
        if (string.equals("[dtd]")) {
            this.fInDTDExternalSubset = true;
        }
    }

    public void endEntity(String string) throws XNIException {
        if (string.equals("[dtd]")) {
            this.fInDTDExternalSubset = false;
        }
    }

    public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2) throws XNIException {
        EntityImpl entityImpl;
        int n;
        Object object;
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ENTITY ");
            if (string.startsWith("%")) {
                this.fInternalSubset.append("% ");
                this.fInternalSubset.append(string.substring(1));
            } else {
                this.fInternalSubset.append(string);
            }
            this.fInternalSubset.append(' ');
            object = xMLString2.toString();
            n = ((String)object).indexOf(39) == -1 ? 1 : 0;
            this.fInternalSubset.append(n != 0 ? (char)'\'' : '\"');
            this.fInternalSubset.append((String)object);
            this.fInternalSubset.append(n != 0 ? (char)'\'' : '\"');
            this.fInternalSubset.append(">\n");
        }
        if (string.startsWith("%")) {
            return;
        }
        if (this.fDocumentType != null && (entityImpl = (EntityImpl)(object = this.fDocumentType.getEntities()).getNamedItem(string)) == null) {
            entityImpl = (EntityImpl)this.fDocumentImpl.createEntity(string);
            object.setNamedItem((Node)entityImpl);
        }
        if (this.fDocumentTypeIndex != -1) {
            int n2;
            boolean bl = false;
            n = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (n != -1) {
                String string2;
                n2 = this.fDeferredDocumentImpl.getNodeType(n, false);
                if (n2 == 6 && (string2 = this.fDeferredDocumentImpl.getNodeName(n, false)).equals(string)) {
                    bl = true;
                    break;
                }
                n = this.fDeferredDocumentImpl.getRealPrevSibling(n, false);
            }
            if (!bl) {
                n2 = this.fDeferredDocumentImpl.createDeferredEntity(string, null, null, null);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n2);
            }
        }
    }

    public void externalEntityDecl(String string, String string2, String string3, String string4) throws XNIException {
        NamedNodeMap namedNodeMap;
        EntityImpl entityImpl;
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ENTITY ");
            if (string.startsWith("%")) {
                this.fInternalSubset.append("% ");
                this.fInternalSubset.append(string.substring(1));
            } else {
                this.fInternalSubset.append(string);
            }
            this.fInternalSubset.append(' ');
            if (string2 != null) {
                this.fInternalSubset.append("PUBLIC '");
                this.fInternalSubset.append(string2);
                this.fInternalSubset.append("' '");
            } else {
                this.fInternalSubset.append("SYSTEM '");
            }
            this.fInternalSubset.append(string3);
            this.fInternalSubset.append("'>\n");
        }
        if (string.startsWith("%")) {
            return;
        }
        if (this.fDocumentType != null && (entityImpl = (EntityImpl)(namedNodeMap = this.fDocumentType.getEntities()).getNamedItem(string)) == null) {
            entityImpl = (EntityImpl)this.fDocumentImpl.createEntity(string);
            entityImpl.setPublicId(string2);
            entityImpl.setSystemId(string3);
            namedNodeMap.setNamedItem((Node)entityImpl);
        }
        if (this.fDocumentTypeIndex != -1) {
            int n;
            boolean bl = false;
            int n2 = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (n2 != -1) {
                String string5;
                n = this.fDeferredDocumentImpl.getNodeType(n2, false);
                if (n == 6 && (string5 = this.fDeferredDocumentImpl.getNodeName(n2, false)).equals(string)) {
                    bl = true;
                    break;
                }
                n2 = this.fDeferredDocumentImpl.getRealPrevSibling(n2, false);
            }
            if (!bl) {
                n = this.fDeferredDocumentImpl.createDeferredEntity(string, string2, string3, null);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n);
            }
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws XNIException {
        NamedNodeMap namedNodeMap;
        EntityImpl entityImpl;
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ENTITY ");
            this.fInternalSubset.append(string);
            this.fInternalSubset.append(' ');
            if (string2 != null) {
                this.fInternalSubset.append("PUBLIC '");
                this.fInternalSubset.append(string2);
                if (string3 != null) {
                    this.fInternalSubset.append("' '");
                    this.fInternalSubset.append(string3);
                }
            } else {
                this.fInternalSubset.append("SYSTEM '");
                this.fInternalSubset.append(string3);
            }
            this.fInternalSubset.append("' NDATA ");
            this.fInternalSubset.append(string4);
            this.fInternalSubset.append(">\n");
        }
        if (this.fDocumentType != null && (entityImpl = (EntityImpl)(namedNodeMap = this.fDocumentType.getEntities()).getNamedItem(string)) == null) {
            entityImpl = (EntityImpl)this.fDocumentImpl.createEntity(string);
            entityImpl.setPublicId(string2);
            entityImpl.setSystemId(string3);
            entityImpl.setNotationName(string4);
            namedNodeMap.setNamedItem((Node)entityImpl);
        }
        if (this.fDocumentTypeIndex != -1) {
            int n;
            boolean bl = false;
            int n2 = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (n2 != -1) {
                String string5;
                n = this.fDeferredDocumentImpl.getNodeType(n2, false);
                if (n == 6 && (string5 = this.fDeferredDocumentImpl.getNodeName(n2, false)).equals(string)) {
                    bl = true;
                    break;
                }
                n2 = this.fDeferredDocumentImpl.getRealPrevSibling(n2, false);
            }
            if (!bl) {
                n = this.fDeferredDocumentImpl.createDeferredEntity(string, string2, string3, string4);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n);
            }
        }
    }

    public void notationDecl(String string, String string2, String string3) throws XNIException {
        NamedNodeMap namedNodeMap;
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!NOTATION ");
            if (string2 != null) {
                this.fInternalSubset.append("PUBLIC '");
                this.fInternalSubset.append(string2);
                if (string3 != null) {
                    this.fInternalSubset.append("' '");
                    this.fInternalSubset.append(string3);
                }
            } else {
                this.fInternalSubset.append("SYSTEM '");
                this.fInternalSubset.append(string3);
            }
            this.fInternalSubset.append("'>\n");
        }
        if (this.fDocumentType != null && (namedNodeMap = this.fDocumentType.getNotations()).getNamedItem(string) == null) {
            NotationImpl notationImpl = (NotationImpl)this.fDocumentImpl.createNotation(string);
            notationImpl.setPublicId(string2);
            notationImpl.setSystemId(string3);
            namedNodeMap.setNamedItem((Node)notationImpl);
        }
        if (this.fDocumentTypeIndex != -1) {
            int n;
            boolean bl = false;
            int n2 = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (n2 != -1) {
                String string4;
                n = this.fDeferredDocumentImpl.getNodeType(n2, false);
                if (n == 12 && (string4 = this.fDeferredDocumentImpl.getNodeName(n2, false)).equals(string)) {
                    bl = true;
                    break;
                }
                n2 = this.fDeferredDocumentImpl.getPrevSibling(n2, false);
            }
            if (!bl) {
                n = this.fDeferredDocumentImpl.createDeferredNotation(string, string2, string3);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n);
            }
        }
    }

    public void elementDecl(String string, String string2) throws XNIException {
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ELEMENT ");
            this.fInternalSubset.append(string);
            this.fInternalSubset.append(' ');
            this.fInternalSubset.append(string2);
            this.fInternalSubset.append(">\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString) throws XNIException {
        int n;
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ATTLIST ");
            this.fInternalSubset.append(string);
            this.fInternalSubset.append(' ');
            this.fInternalSubset.append(string2);
            this.fInternalSubset.append(' ');
            if (string3.equals("ENUMERATION")) {
                this.fInternalSubset.append('(');
                n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        this.fInternalSubset.append('|');
                    }
                    this.fInternalSubset.append(stringArray[n]);
                    ++n;
                }
                this.fInternalSubset.append(')');
            } else {
                this.fInternalSubset.append(string3);
            }
            if (string4 != null) {
                this.fInternalSubset.append(' ');
                this.fInternalSubset.append(string4);
            }
            if (xMLString != null) {
                this.fInternalSubset.append(" '");
                n = 0;
                while (n < xMLString.length) {
                    char c = xMLString.ch[xMLString.offset + n];
                    if (c == '\'') {
                        this.fInternalSubset.append("&apos;");
                    } else {
                        this.fInternalSubset.append(c);
                    }
                    ++n;
                }
                this.fInternalSubset.append('\'');
            }
            this.fInternalSubset.append(">\n");
        }
        if (this.fDeferredDocumentImpl != null) {
            if (xMLString != null) {
                n = this.fDeferredDocumentImpl.lookupElementDefinition(string);
                if (n == -1) {
                    n = this.fDeferredDocumentImpl.createDeferredElementDefinition(string);
                    this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n);
                }
                int elementDefinitionImpl = this.fDeferredDocumentImpl.createDeferredAttribute(string2, xMLString.toString(), false);
                this.fDeferredDocumentImpl.appendChild(n, elementDefinitionImpl);
            }
        } else if (this.fDocumentImpl != null && xMLString != null) {
            void var8_13;
            AttrImpl attrImpl;
            boolean bl;
            NamedNodeMap namedNodeMap = ((DocumentTypeImpl)this.fDocumentType).getElements();
            ElementDefinitionImpl elementDefinitionImpl = (ElementDefinitionImpl)namedNodeMap.getNamedItem(string);
            if (elementDefinitionImpl == null) {
                ElementDefinitionImpl elementDefinitionImpl2 = this.fDocumentImpl.createElementDefinition(string);
                ((DocumentTypeImpl)this.fDocumentType).getElements().setNamedItem((Node)elementDefinitionImpl2);
            }
            if (bl = this.fNamespaceAware) {
                String string5 = null;
                if (string2.startsWith("xmlns:") || string2.equals("xmlns")) {
                    string5 = "http://www.w3.org/2000/xmlns/";
                }
                attrImpl = (AttrImpl)this.fDocumentImpl.createAttributeNS(string5, string2);
            } else {
                attrImpl = (AttrImpl)this.fDocumentImpl.createAttribute(string2);
            }
            attrImpl.setValue(xMLString.toString());
            attrImpl.setSpecified(false);
            if (bl) {
                var8_13.getAttributes().setNamedItemNS((Node)attrImpl);
            } else {
                var8_13.getAttributes().setNamedItem((Node)attrImpl);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

