/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PatchByteCode {
    private static final String ATTR_SUPERCLASS = "org.netbeans.superclass";
    private static final byte[] BYTE_SUPERCLASS;
    private static final String ATTR_MEMBER = "org.netbeans.member";
    private static final byte[] BYTE_MEMBER;
    private static final String ATTR_NAME = "org.netbeans.name";
    private static final byte[] BYTE_NAME;
    private static final String ATTR_INIT = "<init>";
    private static final byte[] BYTE_INIT;
    private static final String ATTR_INIT_TYPE = "()V";
    private static final byte[] BYTE_INIT_TYPE;
    private byte[] arr;
    private int cpCount;
    private int cpEnd;
    private int atCount;
    private int atEnd;
    private int superClassNameIndex;
    private int superClassNameAttr;
    private int memberNameIndex = -1;
    private int memberClassAttr = -1;
    private int initIndex = -1;
    private int initIndexType = -1;
    private int initNameTypeIndex = -1;
    private int initAttr = -1;
    private int renameNameIndex = -1;
    private HashMap nameIndexes;

    private PatchByteCode(byte[] arr, HashMap nameIndexes) {
        this.arr = arr;
        this.nameIndexes = nameIndexes;
        this.scan();
        this.scan();
    }

    public static byte[] enhanceClass(byte[] arr, Map args) {
        HashMap<String, int[]> m;
        if (PatchByteCode.isPatched(arr)) {
            return null;
        }
        String superClass = (String)args.get("netbeans.superclass");
        List methods = (List)args.get("netbeans.public");
        List rename = (List)args.get("netbeans.rename");
        if (methods != null || rename != null) {
            Iterator it;
            m = new HashMap<String, int[]>();
            if (methods != null) {
                it = methods.iterator();
                while (it.hasNext()) {
                    m.put((String)it.next(), new int[1]);
                }
            }
            if (rename != null) {
                it = rename.iterator();
                while (it.hasNext()) {
                    m.put((String)it.next(), new int[1]);
                }
            }
        } else {
            m = null;
        }
        PatchByteCode pc = new PatchByteCode(arr, m);
        boolean patched = false;
        if (superClass != null) {
            int x = pc.addClass(superClass);
            byte[] sup = new byte[2];
            PatchByteCode.writeU2(sup, 0, x);
            pc.addAttribute(ATTR_SUPERCLASS, sup);
            patched = true;
        }
        if (!pc.isPublic()) {
            pc.markPublic();
            patched = true;
        }
        if (methods != null) {
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                patched |= pc.markMemberPublic((String)it.next());
            }
        }
        if (rename != null) {
            Iterator it = rename.iterator();
            while (it.hasNext()) {
                patched |= pc.renameMember((String)it.next(), (String)it.next());
            }
        }
        if (!patched) {
            return null;
        }
        byte[] patch = new byte[]{110, 98};
        pc.addAttribute("org.netbeans.enhanced", patch);
        return pc.getClassFile();
    }

    public static byte[] patch(byte[] arr, String name) {
        if (!PatchByteCode.isPatched(arr)) {
            return arr;
        }
        PatchByteCode pc = new PatchByteCode(arr, null);
        if (pc.superClassNameAttr > 0) {
            int classindex = pc.readU2(pc.superClassNameAttr + 6);
            PatchByteCode.writeU2(pc.getClassFile(), pc.cpEnd + 4, classindex);
            if (pc.initAttr != -1) {
                PatchByteCode.writeU2(pc.getClassFile(), pc.initAttr + 1, classindex);
            }
        }
        if (pc.memberClassAttr > 0) {
            if (pc.readU4(pc.memberClassAttr + 2) != 2) {
                throw new IllegalArgumentException("Size of a attribute org.netbeans.member should be 2");
            }
            int access = pc.readU2(pc.memberClassAttr + 6);
            int now = pc.readU2(pc.cpEnd);
            PatchByteCode.writeU2(pc.getClassFile(), pc.cpEnd, access);
        }
        if (pc.memberNameIndex > 0 || pc.renameNameIndex > 0) {
            pc.applyMemberAccessAndNameChanges();
        }
        return pc.getClassFile();
    }

    private static boolean isPatched(byte[] arr) {
        if (arr == null || arr.length < 2) {
            return false;
        }
        int base = arr.length - 2;
        if (arr[base + 1] != 98) {
            return false;
        }
        return arr[base + 0] == 110;
    }

    private byte[] getClassFile() {
        return this.arr;
    }

    private int addClass(String s) {
        int x = this.addConstant(s);
        byte[] t = new byte[]{7, 0, 0};
        PatchByteCode.writeU2(t, 1, x);
        return this.addPool(t);
    }

    private int addConstant(String s) {
        byte[] t;
        try {
            t = s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("UTF-8 shall be always supported");
        }
        byte[] add = new byte[t.length + 3];
        System.arraycopy(t, 0, add, 3, t.length);
        add[0] = 1;
        PatchByteCode.writeU2(add, 1, t.length);
        return this.addPool(add);
    }

    private int addPool(byte[] add) {
        byte[] res = new byte[this.arr.length + add.length];
        System.arraycopy(this.arr, 0, res, 0, this.cpEnd);
        int index = this.readU2(this.cpCount);
        PatchByteCode.writeU2(res, this.cpCount, index + 1);
        System.arraycopy(add, 0, res, this.cpEnd, add.length);
        System.arraycopy(this.arr, this.cpEnd, res, this.cpEnd + add.length, this.arr.length - this.cpEnd);
        this.arr = res;
        this.cpEnd += add.length;
        this.atCount += add.length;
        this.atEnd += add.length;
        return index;
    }

    private boolean isPublic() {
        int x = this.readU2(this.cpEnd);
        return (x & 1) != 0;
    }

    private boolean markPublic() {
        if (this.isPublic()) {
            return false;
        }
        if (this.memberNameIndex == -1) {
            this.memberNameIndex = this.addConstant(ATTR_MEMBER);
        }
        int x = this.readU2(this.cpEnd) | 1;
        byte[] sup = new byte[2];
        PatchByteCode.writeU2(sup, 0, x);
        this.addAttribute(ATTR_MEMBER, sup);
        return true;
    }

    private boolean markMemberPublic(String name) {
        int constantPoolIndex = ((int[])this.nameIndexes.get(name))[0];
        int patchCount = 0;
        boolean modified = false;
        if (this.memberNameIndex == -1) {
            this.memberNameIndex = this.addConstant(ATTR_MEMBER);
        }
        int pos = this.cpEnd;
        pos += 6;
        pos += 2 * this.readU2(pos);
        pos += 2;
        int fieldsAndMethods = 0;
        while (fieldsAndMethods < 2) {
            int fieldsOrMethods = this.readU2(pos);
            pos += 2;
            while (fieldsOrMethods-- > 0) {
                int nameIndex = this.readU2(pos + 2);
                if (nameIndex == constantPoolIndex) {
                    int access = this.readU2(pos);
                    if ((access & 1) == 0 || (access & 0x10) != 0) {
                        access = (access | 1) & 0xFFFFFFE9;
                        int cnt = this.readU2(pos + 6) + 1;
                        byte[] res = new byte[this.arr.length + 2 + 6];
                        System.arraycopy(this.arr, 0, res, 0, pos + 6);
                        PatchByteCode.writeU2(res, pos + 6, cnt);
                        PatchByteCode.writeU2(res, pos + 8, this.memberNameIndex);
                        PatchByteCode.writeU4(res, pos + 10, 2);
                        PatchByteCode.writeU2(res, pos + 14, access);
                        System.arraycopy(this.arr, pos + 8, res, pos + 8 + 6 + 2, this.arr.length - pos - 8);
                        this.atEnd += 8;
                        this.atCount += 8;
                        this.arr = res;
                        modified = true;
                    }
                    ++patchCount;
                }
                pos += this.memberSize(pos, null);
            }
            ++fieldsAndMethods;
        }
        if (patchCount == 0) {
            throw new IllegalArgumentException("Member " + name + " not found!");
        }
        return modified;
    }

    private boolean renameMember(String name, String rename) {
        int newPoolIndex;
        int constantPoolIndex = ((int[])this.nameIndexes.get(name))[0];
        int[] arr = (int[])this.nameIndexes.get(rename);
        if (arr != null && arr[0] > 0) {
            newPoolIndex = arr[0];
        } else {
            newPoolIndex = this.addConstant(rename);
            this.nameIndexes.put(rename, new int[]{newPoolIndex});
        }
        int patchCount = 0;
        boolean modified = false;
        if (this.renameNameIndex == -1) {
            this.renameNameIndex = this.addConstant(ATTR_NAME);
        }
        int pos = this.cpEnd;
        pos += 6;
        pos += 2 * this.readU2(pos);
        pos += 2;
        int fieldsAndMethods = 0;
        while (fieldsAndMethods < 2) {
            int fieldsOrMethods = this.readU2(pos);
            pos += 2;
            while (fieldsOrMethods-- > 0) {
                int nameIndex = this.readU2(pos + 2);
                if (nameIndex == constantPoolIndex) {
                    int[] attributes = new int[]{-1, -1};
                    this.memberSize(pos, attributes);
                    if (attributes[1] == -1) {
                        int cnt = this.readU2(pos + 6) + 1;
                        byte[] res = new byte[this.arr.length + 2 + 6];
                        System.arraycopy(this.arr, 0, res, 0, pos + 6);
                        PatchByteCode.writeU2(res, pos + 6, cnt);
                        PatchByteCode.writeU2(res, pos + 8, this.renameNameIndex);
                        PatchByteCode.writeU4(res, pos + 10, 2);
                        PatchByteCode.writeU2(res, pos + 14, newPoolIndex);
                        System.arraycopy(this.arr, pos + 8, res, pos + 8 + 6 + 2, this.arr.length - pos - 8);
                        this.atEnd += 8;
                        this.atCount += 8;
                        this.arr = res;
                        modified = true;
                    }
                    ++patchCount;
                }
                pos += this.memberSize(pos, null);
            }
            ++fieldsAndMethods;
        }
        if (patchCount == 0) {
            throw new IllegalArgumentException("Member " + name + " not found!");
        }
        return modified;
    }

    private void applyMemberAccessAndNameChanges() {
        int[] result = new int[2];
        int pos = this.cpEnd;
        pos += 6;
        pos += 2 * this.readU2(pos);
        pos += 2;
        int fieldsAndMethods = 0;
        while (fieldsAndMethods < 2) {
            int fieldsOrMethods = this.readU2(pos);
            pos += 2;
            while (fieldsOrMethods-- > 0) {
                result[0] = -1;
                result[1] = -1;
                int size = this.memberSize(pos, result);
                if (result[0] != -1) {
                    if (this.readU4(result[0] + 2) != 2) {
                        throw new IllegalArgumentException("Size of a attribute org.netbeans.member should be 2");
                    }
                    int access = this.readU2(result[0] + 6);
                    PatchByteCode.writeU2(this.arr, pos, access);
                }
                if (result[1] != -1) {
                    if (this.readU4(result[1] + 2) != 2) {
                        throw new IllegalArgumentException("Size of a attribute org.netbeans.name should be 2");
                    }
                    int newName = this.readU2(result[1] + 6);
                    PatchByteCode.writeU2(this.arr, pos + 2, newName);
                }
                pos += size;
            }
            ++fieldsAndMethods;
        }
    }

    private void addAttribute(String name, byte[] b) {
        int index = -1;
        if (ATTR_SUPERCLASS.equals(name) && this.superClassNameIndex > 0) {
            index = this.superClassNameIndex;
        }
        if (ATTR_MEMBER.equals(name) && this.memberNameIndex > 0) {
            index = this.memberNameIndex;
        }
        if (index == -1) {
            index = this.addConstant(name);
        }
        byte[] res = new byte[this.arr.length + b.length + 6];
        System.arraycopy(this.arr, 0, res, 0, this.arr.length);
        PatchByteCode.writeU2(res, this.arr.length, index);
        PatchByteCode.writeU4(res, this.arr.length + 2, b.length);
        int begin = this.arr.length + 6;
        System.arraycopy(b, 0, res, begin, b.length);
        this.atEnd += b.length + 6;
        PatchByteCode.writeU2(res, this.atCount, this.readU2(this.atCount) + 1);
        this.arr = res;
    }

    private int get(int pos) {
        if (pos >= this.arr.length) {
            throw new ArrayIndexOutOfBoundsException("Size: " + this.arr.length + " index: " + pos);
        }
        int x = this.arr[pos];
        return x >= 0 ? x : 256 + x;
    }

    private void scan() {
        if (this.get(0) != 202 && this.get(1) != 254 && this.get(2) != 186 && this.get(3) != 190) {
            throw new IllegalStateException("Not a class file!");
        }
        int pos = 10;
        this.cpCount = 8;
        int cp = this.readU2(8);
        int[] i = new int[]{1};
        while (i[0] < cp) {
            int len = this.constantPoolSize(pos, i);
            pos += len;
            i[0] = i[0] + 1;
        }
        this.cpEnd = pos;
        pos += 6;
        pos += 2 * this.readU2(pos);
        int fields = this.readU2(pos += 2);
        pos += 2;
        while (fields-- > 0) {
            pos += this.memberSize(pos, null);
        }
        int methods = this.readU2(pos);
        pos += 2;
        while (methods-- > 0) {
            pos += this.memberSize(pos, null);
        }
        int[] memberAccess = new int[]{-1, -1};
        this.atCount = pos;
        int attrs = this.readU2(pos);
        pos += 2;
        while (attrs-- > 0) {
            pos += this.attributeSize(pos, memberAccess);
        }
        if (memberAccess[0] != -1) {
            this.memberClassAttr = memberAccess[0];
        }
        this.atEnd = pos;
    }

    private int readU2(int pos) {
        int b1 = this.get(pos);
        int b2 = this.get(pos + 1);
        return b1 * 256 + b2;
    }

    private int readU4(int pos) {
        return this.readU2(pos) * 256 * 256 + this.readU2(pos + 2);
    }

    private static void writeU2(byte[] arr, int pos, int value) {
        int v1 = (value & 0xFF00) >> 8;
        int v2 = value & 0xFF;
        if (v1 < 0) {
            v1 += 256;
        }
        if (v2 < 0) {
            v2 += 256;
        }
        arr[pos] = (byte)v1;
        arr[pos + 1] = (byte)v2;
    }

    private static void writeU4(byte[] arr, int pos, int value) {
        PatchByteCode.writeU2(arr, pos, (value & 0xFF00) >> 16);
        PatchByteCode.writeU2(arr, pos + 2, value & 0xFF);
    }

    private int constantPoolSize(int pos, int[] cnt) {
        switch (this.get(pos)) {
            case 7: 
            case 8: {
                return 3;
            }
            case 12: {
                int descriptorIndex;
                int nameIndex = this.readU2(pos + 1);
                if (nameIndex == this.initIndex && (descriptorIndex = this.readU2(pos + 3)) == this.initIndexType) {
                    if (this.initNameTypeIndex > 0 && this.initNameTypeIndex != cnt[0]) {
                        throw new IllegalArgumentException("Second initialization of name type index");
                    }
                    this.initNameTypeIndex = cnt[0];
                }
                return 5;
            }
            case 10: {
                int superclass;
                int classname = this.readU2(pos + 1);
                int nameAndType = this.readU2(pos + 3);
                if (nameAndType == this.initNameTypeIndex && (superclass = this.readU2(this.cpEnd + 4)) == classname) {
                    if (this.initAttr > 0 && this.initAttr != pos) {
                        throw new IllegalStateException("Second initialization of position of <init> invocation");
                    }
                    this.initAttr = pos;
                }
                return 5;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: {
                return 5;
            }
            case 5: 
            case 6: {
                cnt[0] = cnt[0] + 1;
                return 9;
            }
            case 1: {
                int len = this.readU2(pos + 1);
                if (this.compareUtfEntry(BYTE_INIT, pos)) {
                    if (this.initIndex > 0 && this.initIndex != cnt[0]) {
                        throw new IllegalArgumentException("Second initialization of <init>");
                    }
                    this.initIndex = cnt[0];
                }
                if (this.compareUtfEntry(BYTE_INIT_TYPE, pos)) {
                    if (this.initIndexType > 0 && this.initIndexType != cnt[0]) {
                        throw new IllegalArgumentException("Second initialization of ()V");
                    }
                    this.initIndexType = cnt[0];
                }
                if (this.compareUtfEntry(BYTE_SUPERCLASS, pos)) {
                    if (this.superClassNameIndex > 0 && this.superClassNameIndex != cnt[0]) {
                        throw new IllegalStateException("org.netbeans.superclass registered for the second time!");
                    }
                    this.superClassNameIndex = cnt[0];
                }
                if (this.compareUtfEntry(BYTE_MEMBER, pos)) {
                    if (this.memberNameIndex > 0 && this.memberNameIndex != cnt[0]) {
                        throw new IllegalStateException("org.netbeans.member registered for the second time!");
                    }
                    this.memberNameIndex = cnt[0];
                }
                if (this.compareUtfEntry(BYTE_NAME, pos)) {
                    if (this.renameNameIndex > 0 && this.renameNameIndex != cnt[0]) {
                        throw new IllegalStateException("org.netbeans.name registered for the second time!");
                    }
                    this.renameNameIndex = cnt[0];
                }
                if (this.nameIndexes != null) {
                    String s;
                    try {
                        s = new String(this.arr, pos + 3, len, "utf-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IllegalStateException("utf-8 is always supported");
                    }
                    int[] index = (int[])this.nameIndexes.get(s);
                    if (index != null) {
                        index[0] = cnt[0];
                    }
                }
                return len + 3;
            }
        }
        throw new IllegalStateException("Unknown pool type: " + this.get(pos));
    }

    private int memberSize(int pos, int[] containsPatchAttributeAndRename) {
        int s = 8;
        int name = this.readU2(pos + 2);
        int cnt = this.readU2(pos + 6);
        while (cnt-- > 0) {
            s += this.attributeSize(pos + s, containsPatchAttributeAndRename);
        }
        return s;
    }

    private int attributeSize(int pos, int[] containsPatchAttributeAndRename) {
        int name = this.readU2(pos);
        if (name == this.superClassNameIndex) {
            if (this.superClassNameAttr > 0 && this.superClassNameAttr != pos) {
                throw new IllegalStateException("Two attributes with name org.netbeans.superclass");
            }
            this.superClassNameAttr = pos;
        }
        if (name == this.memberNameIndex && containsPatchAttributeAndRename != null) {
            if (containsPatchAttributeAndRename[0] != -1) {
                throw new IllegalStateException("Second attribute org.netbeans.member");
            }
            containsPatchAttributeAndRename[0] = pos;
        }
        if (name == this.renameNameIndex && containsPatchAttributeAndRename != null) {
            if (containsPatchAttributeAndRename[1] != -1) {
                throw new IllegalStateException("Second attribute org.netbeans.name");
            }
            containsPatchAttributeAndRename[1] = pos;
        }
        int len = this.readU4(pos + 2);
        return len + 6;
    }

    private boolean compareUtfEntry(byte[] pattern, int pos) {
        int len = this.readU2(pos + 1);
        if (pattern.length != len) {
            return false;
        }
        int base = pos + 3;
        int i = 0;
        while (i < len) {
            if (pattern[i] != this.arr[base + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        try {
            BYTE_SUPERCLASS = ATTR_SUPERCLASS.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        try {
            BYTE_MEMBER = ATTR_MEMBER.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        try {
            BYTE_NAME = ATTR_NAME.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        try {
            BYTE_INIT = ATTR_INIT.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        try {
            BYTE_INIT_TYPE = ATTR_INIT_TYPE.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }
}

