/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.FileDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.ExitSecurityException;

public class TopSecurityManager
extends SecurityManager {
    private static boolean check = !Boolean.getBoolean("netbeans.security.nocheck");
    private Permission allPermission;
    private static final Class classLoaderClass = class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = TopSecurityManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
    private static final Class URLClass = class$java$net$URL == null ? (class$java$net$URL = TopSecurityManager.class$("java.net.URL")) : class$java$net$URL;
    private static final Class runtimePermissionClass = class$java$lang$RuntimePermission == null ? (class$java$lang$RuntimePermission = TopSecurityManager.class$("java.lang.RuntimePermission")) : class$java$lang$RuntimePermission;
    private static final Class accessControllerClass = class$java$security$AccessController == null ? (class$java$security$AccessController = TopSecurityManager.class$("java.security.AccessController")) : class$java$security$AccessController;
    private static List delegates = new ArrayList();
    private static boolean officialExit = false;
    private final Set warnedClassesNDE = new HashSet(25);
    static URL URL_UNKNOWN;
    private static Field urlField;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$RuntimePermission;
    static /* synthetic */ Class class$java$security$AccessController;
    static /* synthetic */ Class class$org$netbeans$TopSecurityManager;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static void register(SecurityManager sm) throws SecurityException {
        if (check) {
            try {
                AccessController.checkPermission(new RuntimePermission("TopSecurityManager.register"));
            }
            catch (SecurityException se) {
                System.err.println("Code source of attempted secman: " + sm.getClass().getProtectionDomain().getCodeSource().getLocation().toExternalForm());
                throw se;
            }
        }
        List list = delegates;
        synchronized (list) {
            if (delegates.contains(sm)) {
                throw new SecurityException();
            }
            delegates.add(sm);
        }
    }

    public static void unregister(SecurityManager sm) throws SecurityException {
        if (check) {
            AccessController.checkPermission(new RuntimePermission("TopSecurityManager.unregister"));
        }
        List list = delegates;
        synchronized (list) {
            if (!delegates.contains(sm)) {
                throw new SecurityException();
            }
            delegates.remove(sm);
        }
    }

    public TopSecurityManager() {
        this.allPermission = new AllPermission();
    }

    public void checkExit(int status) throws SecurityException {
        if (!check) {
            return;
        }
        List list = delegates;
        synchronized (list) {
            Iterator it = delegates.iterator();
            while (it.hasNext()) {
                ((SecurityManager)it.next()).checkExit(status);
            }
        }
        PrivilegedCheck.checkExit(status, this);
    }

    public static void exit(int status) {
        officialExit = true;
        System.exit(status);
    }

    final void checkExitImpl(int status, AccessControlContext acc) throws SecurityException {
        if (!officialExit) {
            throw new ExitSecurityException("Illegal attempt to exit early");
        }
        super.checkExit(status);
    }

    public boolean checkTopLevelWindow(Object window) {
        List list = delegates;
        synchronized (list) {
            Iterator it = delegates.iterator();
            while (it.hasNext()) {
                ((SecurityManager)it.next()).checkTopLevelWindow(window);
            }
        }
        return super.checkTopLevelWindow(window);
    }

    public final void checkPropertyAccess(String x) {
        if ("netbeans.debug.exceptions".equals(x)) {
            Class<?>[] ctxt = this.getClassContext();
            int i = 0;
            while (i < ctxt.length) {
                Class<?> c = ctxt[i];
                if (c != (class$org$netbeans$TopSecurityManager == null ? TopSecurityManager.class$("org.netbeans.TopSecurityManager") : class$org$netbeans$TopSecurityManager) && c != (class$java$lang$System == null ? TopSecurityManager.class$("java.lang.System") : class$java$lang$System) && c != (class$java$lang$Boolean == null ? TopSecurityManager.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    String n = c.getName();
                    Set set = this.warnedClassesNDE;
                    synchronized (set) {
                        if (this.warnedClassesNDE.add(n)) {
                            System.err.println("Warning: use of system property netbeans.debug.exceptions in " + n + " has been obsoleted in favor of ErrorManager");
                        }
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void checkRead(String file) {
    }

    public void checkRead(FileDescriptor fd) {
    }

    public void checkWrite(FileDescriptor fd) {
    }

    public void checkDelete(String file) {
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException e) {
            super.checkDelete(file);
            return;
        }
    }

    public void checkWrite(String file) {
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException e) {
            super.checkWrite(file);
            return;
        }
    }

    public void checkConnect(String host, int port) {
        if (!check) {
            return;
        }
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException e) {
            try {
                super.checkConnect(host, port);
                return;
            }
            catch (SecurityException securityException) {
                PrivilegedCheck.checkConnect(host, port, this);
                return;
            }
        }
    }

    final void checkConnectImpl(String host, int port) {
        Class insecure = this.getInsecureClass();
        if (insecure != null) {
            URL ctx = TopSecurityManager.getClassURL(insecure);
            if (ctx == URL_UNKNOWN) {
                throw new SecurityException();
            }
            if (ctx != null) {
                try {
                    String fromHost = ctx.getHost();
                    InetAddress ia2 = InetAddress.getByName(host);
                    InetAddress ia3 = InetAddress.getByName(fromHost);
                    if (ia2.equals(ia3)) {
                        return;
                    }
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
            throw new SecurityException();
        }
    }

    public void checkConnect(String s, int port, Object context) {
        this.checkConnect(s, port);
    }

    public void checkPermission(Permission perm) {
        TopSecurityManager.checkSetSecurityManager(perm);
        if (!check) {
            return;
        }
        super.checkPermission(perm);
    }

    public void checkPermission(Permission perm, Object context) {
        TopSecurityManager.checkSetSecurityManager(perm);
        if (!check) {
            return;
        }
        super.checkPermission(perm, context);
    }

    private static void checkSetSecurityManager(Permission perm) {
        if (runtimePermissionClass.isInstance(perm) && "setSecurityManager".equals(perm.getName())) {
            throw new SecurityException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class getInsecureClass() {
        Class<?>[] ctx = this.getClassContext();
        boolean firstACClass = false;
        int i = 0;
        while (i < ctx.length) {
            if (ctx[i] == accessControllerClass) {
                if (firstACClass) {
                    return null;
                }
                firstACClass = true;
            } else {
                ClassLoader cloader = ctx[i].getClassLoader();
                if (cloader != null) {
                    Class<?> hisClass = cloader.getClass();
                    if (!TopSecurityManager.isSecureClass(ctx[i])) return ctx[i];
                    if (classLoaderClass.isAssignableFrom(ctx[i])) {
                        return null;
                    }
                } else if (classLoaderClass.isAssignableFrom(ctx[i])) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    static boolean isSecureClass(Class clazz) {
        URL source = TopSecurityManager.getClassURL(clazz);
        if (source == URL_UNKNOWN) {
            return false;
        }
        if (source != null) {
            return TopSecurityManager.isSecureProtocol(source.getProtocol());
        }
        return true;
    }

    static URL getClassURL(Class clazz) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        if (cs != null) {
            URL url = cs.getLocation();
            if (url != null) {
                return url;
            }
            ClassLoader him = clazz.getClassLoader();
            Class<?> hisClass = him.getClass();
            if (hisClass.getName().indexOf("ice.iblite.BrowserClassLoader") >= 0) {
                try {
                    Field fld = TopSecurityManager.getUrlField(hisClass);
                    if (fld == null) {
                        return null;
                    }
                    return (URL)fld.get(him);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return URL_UNKNOWN;
        }
        return null;
    }

    static Field getUrlField(Class clazz) {
        if (urlField == null) {
            try {
                Field[] fds = clazz.getDeclaredFields();
                int i = 0;
                while (i < fds.length) {
                    if (fds[i].getType() == URLClass) {
                        ((AccessibleObject)fds[i]).setAccessible(true);
                        urlField = fds[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urlField;
    }

    static boolean isSecureProtocol(String protocol) {
        return !protocol.equals("http") && !protocol.equals("ftp") && !protocol.equals("rmi");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            URL_UNKNOWN = new URL("http", "UNKNOWN", -1, "UNKNOWN");
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class PrivilegedCheck
    implements PrivilegedExceptionAction {
        int action;
        TopSecurityManager tsm;
        int status;
        AccessControlContext acc;
        String host;
        int port;

        public PrivilegedCheck(int action, TopSecurityManager tsm) {
            this.action = action;
            this.tsm = tsm;
            if (action == 0) {
                this.acc = AccessController.getContext();
            }
        }

        public Object run() throws Exception {
            switch (this.action) {
                case 0: {
                    this.tsm.checkExitImpl(this.status, this.acc);
                    break;
                }
                case 1: {
                    this.tsm.checkConnectImpl(this.host, this.port);
                    break;
                }
            }
            return null;
        }

        static void checkExit(int status, TopSecurityManager tsm) {
            PrivilegedCheck pea = new PrivilegedCheck(0, tsm);
            pea.status = status;
            PrivilegedCheck.check(pea);
        }

        static void checkConnect(String host, int port, TopSecurityManager tsm) {
            PrivilegedCheck pea = new PrivilegedCheck(1, tsm);
            pea.host = host;
            pea.port = port;
            PrivilegedCheck.check(pea);
        }

        private static void check(PrivilegedCheck action) {
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Exception orig = e.getException();
                if (orig instanceof RuntimeException) {
                    throw (RuntimeException)orig;
                }
                orig.printStackTrace();
            }
        }
    }
}

