/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.java.Util;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;

public class ClassPathConfigurator {
    private static final boolean DEBUG = false;
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static ClassPathConfigurator classPathConfigurator = null;
    private HashMap fileSystemCache = new HashMap(10);
    private static final Object TAG_INVALID = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$java$ClassPathConfigurator;

    private ClassPathConfigurator() {
    }

    public static ClassPathConfigurator getInstance() {
        if (classPathConfigurator == null) {
            Class clazz = class$org$netbeans$modules$java$ClassPathConfigurator == null ? (class$org$netbeans$modules$java$ClassPathConfigurator = ClassPathConfigurator.class$("org.netbeans.modules.java.ClassPathConfigurator")) : class$org$netbeans$modules$java$ClassPathConfigurator;
            synchronized (clazz) {
                if (classPathConfigurator == null) {
                    classPathConfigurator = new ClassPathConfigurator();
                }
            }
        }
        return classPathConfigurator;
    }

    public Collection getFileSystems(NbClassPath classPath) {
        if (classPath == null) {
            return Collections.EMPTY_LIST;
        }
        String cp = classPath.getClassPath();
        if (cp.length() >= 2 && cp.charAt(0) == '\"') {
            cp = cp.substring(1, cp.length() - 1);
        }
        return this.getFileSystems(cp);
    }

    public Collection getFileSystems(String path) {
        if (path == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getCachedFileSystems(new StringTokenizer(path, PATH_SEPARATOR));
    }

    synchronized FileSystem createFileSystem(String fsRootName) throws IOException {
        Object fs = null;
        boolean report = true;
        if (this.fileSystemCache.containsKey(fsRootName)) {
            Object o = this.fileSystemCache.get(fsRootName);
            if (o == TAG_INVALID) {
                fs = null;
                report = false;
            } else {
                fs = (FileSystem)((Reference)o).get();
            }
        }
        if (fs == null) {
            try {
                fs = this.isJarFile(fsRootName) ? this.getJarFileSystem(fsRootName) : this.getLocalFileSystem(fsRootName);
            }
            catch (IOException ex) {
                if (report) {
                    this.fileSystemCache.put(fsRootName, TAG_INVALID);
                    throw ex;
                }
                return null;
            }
            this.fileSystemCache.put(fsRootName, new SoftReference<JarFileSystem>((JarFileSystem)fs));
        }
        return fs;
    }

    private Vector getCachedFileSystems(Enumeration path) {
        Vector<FileSystem> result = new Vector<FileSystem>();
        if (path == null) {
            return result;
        }
        String pathName = null;
        FileSystem fs = null;
        while (path.hasMoreElements()) {
            pathName = (String)path.nextElement();
            if (pathName == null || pathName.length() <= 0) continue;
            try {
                fs = this.createFileSystem(pathName);
            }
            catch (IOException ex) {
                Util.getErrorManager().log(1, "WARNING: " + pathName + " cannot be opened");
                Util.getErrorManager().log(1, ex.toString());
            }
            if (fs == null || result.contains(fs)) continue;
            result.add(fs);
        }
        return result;
    }

    private JarFileSystem getJarFileSystem(String jarFileName) throws IOException {
        JarFileSystem result = new JarFileSystem();
        try {
            result.setJarFile(new File(jarFileName));
        }
        catch (PropertyVetoException e) {
            System.err.println("Unable to set Jar file " + jarFileName + ". " + e.getMessage());
        }
        result.setHidden(true);
        return result;
    }

    private LocalFileSystem getLocalFileSystem(String dirName) throws IOException {
        LocalFileSystem result = new LocalFileSystem();
        try {
            result.setRootDirectory(new File(dirName));
        }
        catch (PropertyVetoException e) {
            System.err.println("Unable to set Root directory " + dirName + ". " + e.getMessage());
        }
        result.setHidden(true);
        return result;
    }

    private boolean isJarFile(String fileName) {
        boolean result = false;
        if (fileName != null) {
            result = fileName.endsWith(ZIP_FILE_EXTENSION) || fileName.endsWith(JAR_FILE_EXTENSION);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

