/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Format;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.text.FilterDocument;
import org.openide.text.IndentEngine;

public abstract class IndentFileEntry
extends FileEntry.Format {
    private static final String NEWLINE = "\n";
    private static final String EA_PREFORMATTED = "org-netbeans-modules-java-preformattedSource";
    private ThreadLocal indentEngine;

    IndentFileEntry(MultiDataObject dobj, FileObject file) {
        super(dobj, file);
    }

    private EditorKit createEditorKit(String mimeType) {
        EditorKit kit = JEditorPane.createEditorKitForContentType(mimeType);
        if (kit == null) {
            kit = new DefaultEditorKit();
        }
        return kit;
    }

    final void setIndentEngine(IndentEngine engine) {
        IndentFileEntry indentFileEntry = this;
        synchronized (indentFileEntry) {
            if (this.indentEngine == null) {
                this.indentEngine = new ThreadLocal();
            }
        }
        this.indentEngine.set(engine);
    }

    final void initializeIndentEngine() {
        StyledDocument doc = this.createDocument(this.createEditorKit(this.getFile().getMIMEType()));
        IndentEngine engine = IndentEngine.find((Document)doc);
        this.setIndentEngine(engine);
    }

    private StyledDocument createDocument(EditorKit kit) {
        Document doc = kit.createDefaultDocument();
        if (doc instanceof StyledDocument) {
            return (StyledDocument)doc;
        }
        return new FilterDocument(doc);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileObject createFromTemplate(FileObject f, String name) throws IOException {
        String ext = this.getFile().getExt();
        if (name == null) {
            name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)ext);
        }
        FileObject fo = f.createData(name, ext);
        Format frm = this.createFormat(f, name, ext);
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
        StyledDocument doc = this.createDocument(this.createEditorKit(fo.getMIMEType()));
        IndentEngine eng = (IndentEngine)this.indentEngine.get();
        if (eng == null) {
            eng = IndentEngine.find((Document)doc);
        }
        Object attr = this.getFile().getAttribute(EA_PREFORMATTED);
        boolean preformatted = false;
        if (attr != null && attr instanceof Boolean) {
            preformatted = (Boolean)attr;
        }
        try {
            FileLock lock = fo.lock();
            try {
                block16: {
                    OutputStreamWriter w = new OutputStreamWriter(fo.getOutputStream(lock));
                    try {
                        try {
                            String line = null;
                            int offset = 0;
                            while (true) {
                                void var14_16;
                                String current;
                                if ((current = r.readLine()) == null) {
                                    doc.insertString(doc.getLength(), NEWLINE, null);
                                    w.write(doc.getText(0, doc.getLength()));
                                    break;
                                }
                                if (line != null) {
                                    doc.insertString(offset, NEWLINE, null);
                                    ++offset;
                                }
                                line = frm.format(var14_16);
                                if (!preformatted || !line.equals(var14_16)) {
                                    line = IndentFileEntry.fixupGuardedBlocks(IndentFileEntry.safeIndent(eng, line, doc, offset));
                                }
                                doc.insertString(offset, line, null);
                                offset += line.length();
                            }
                        }
                        catch (BadLocationException e) {
                            Object var17_18 = null;
                            w.close();
                            break block16;
                        }
                        Object var17_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        w.close();
                        throw throwable;
                    }
                    w.close();
                }
                Object var19_21 = null;
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            r.close();
            throw throwable;
        }
        r.close();
        FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
        fo.setAttribute("template", null);
        return fo;
    }

    static String fixupGuardedBlocks(String indentedLine) {
        int offset = indentedLine.indexOf("//GEN-");
        if (offset == -1) {
            return indentedLine;
        }
        int firstLineEnd = indentedLine.indexOf(10);
        if (firstLineEnd == -1 || firstLineEnd > offset) {
            return indentedLine;
        }
        int guardedLineEnd = indentedLine.indexOf(10, offset);
        StringBuffer sb = new StringBuffer(indentedLine.length());
        sb.append(indentedLine.substring(0, firstLineEnd));
        if (guardedLineEnd != -1) {
            sb.append(indentedLine.substring(offset, guardedLineEnd));
        } else {
            sb.append(indentedLine.substring(offset));
        }
        sb.append(indentedLine.substring(firstLineEnd, offset));
        if (guardedLineEnd != -1) {
            sb.append(indentedLine.substring(guardedLineEnd));
        }
        return sb.toString();
    }

    public static String safeIndent(IndentEngine engine, String text, StyledDocument doc, int offset) {
        if (engine == null) {
            return text;
        }
        try {
            StringWriter writer = new StringWriter();
            Writer indentator = engine.createWriter((Document)doc, offset, (Writer)writer);
            indentator.write(text);
            indentator.close();
            return writer.toString();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().annotate((Throwable)ex, 16, "Indentation engine error", Util.getString("EXMSG_IndentationEngineError"), (Throwable)ex, null);
            ErrorManager.getDefault().notify((Throwable)ex);
            return text;
        }
    }
}

