/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.netbeans.modules.java.JavaConnections;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.Util;
import org.openide.ErrorManager;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

class InterfaceConnection {
    private static final boolean DEBUG = false;

    InterfaceConnection() {
    }

    static boolean synchronizeInterfaces(JavaConnections.Event evt, LinkedList changeProcessors, SourceElement source) {
        JavaConnections.Change[] changes = evt.getChanges();
        TreeMap cacheMap = new TreeMap();
        int origCPSize = changeProcessors.size();
        HashMap<MethodElement.Key, MethodElement> changedMethodMap = new HashMap<MethodElement.Key, MethodElement>();
        int i = 0;
        while (i < changes.length) {
            try {
                switch (changes[i].getChangeType()) {
                    case 16: {
                        Element[] elements = changes[i].getElements();
                        int j = 0;
                        while (j < elements.length) {
                            MethodElement.Key key;
                            MethodElement m = (MethodElement)elements[j];
                            ClassElement interf = m.getDeclaringClass();
                            Vector classes = InterfaceConnection.findClassImplementing(interf, source, cacheMap);
                            if (!(classes.isEmpty() || changedMethodMap.containsKey(key = new MethodElement.Key(m = InterfaceConnection.createEmptyMethodFrom(m))) && InterfaceConnection.compareMethods((MethodElement)changedMethodMap.get(key), m))) {
                                Enumeration classesEn = classes.elements();
                                while (classesEn.hasMoreElements()) {
                                    ClassElement c = (ClassElement)classesEn.nextElement();
                                    MethodElement updatedMethod = InterfaceConnection.findMatchingMethod(c, m);
                                    if (updatedMethod == null) {
                                        changeProcessors.add(new AddMethodProcessor(interf, c, m));
                                    } else if (!InterfaceConnection.compareMethods(updatedMethod, m)) {
                                        changeProcessors.add(new ChangeMethodProcessor(interf, c, updatedMethod, m));
                                    }
                                    changedMethodMap.put(key, m);
                                }
                            }
                            ++j;
                        }
                        break;
                    }
                    case 64: {
                        MethodElement oldMethod = (MethodElement)changes[i].getOldElement();
                        MethodElement newMethod = (MethodElement)changes[i].getNewElement();
                        ClassElement interf = newMethod.getDeclaringClass();
                        Vector classes = InterfaceConnection.findClassImplementing(interf, source, cacheMap);
                        if (classes.isEmpty()) break;
                        MethodElement addingMethod = null;
                        Enumeration classesEn = classes.elements();
                        while (classesEn.hasMoreElements()) {
                            MethodElement.Key key;
                            ClassElement c = (ClassElement)classesEn.nextElement();
                            MethodElement updatedMethod = InterfaceConnection.findMatchingMethod(c, oldMethod);
                            if (updatedMethod == null && (updatedMethod = InterfaceConnection.findMatchingMethod(c, newMethod)) == null) {
                                if (addingMethod == null) {
                                    addingMethod = InterfaceConnection.createEmptyMethodFrom(newMethod);
                                }
                                if (changedMethodMap.containsKey(key = new MethodElement.Key(addingMethod)) && InterfaceConnection.compareMethods((MethodElement)changedMethodMap.get(key), addingMethod)) continue;
                                changeProcessors.add(new AddMethodProcessor(interf, c, addingMethod));
                                changedMethodMap.put(key, addingMethod);
                                continue;
                            }
                            if (InterfaceConnection.compareMethods(updatedMethod, newMethod) || updatedMethod == null || changedMethodMap.containsKey(key = new MethodElement.Key(newMethod)) && InterfaceConnection.compareMethods((MethodElement)changedMethodMap.get(key), newMethod)) continue;
                            changeProcessors.add(new ChangeMethodProcessor(interf, c, updatedMethod, newMethod));
                            changedMethodMap.put(key, newMethod);
                        }
                        break;
                    }
                }
            }
            catch (SourceException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            ++i;
        }
        return origCPSize != changeProcessors.size();
    }

    private static MethodElement createEmptyMethodFrom(MethodElement m) throws SourceException {
        MethodElement newMet = (MethodElement)m.clone();
        newMet.setBody(JavaConnections.SETTINGS.getGenerateReturnAsString(newMet.getReturn()));
        newMet.setModifiers(1);
        return newMet;
    }

    private static MethodElement findMatchingMethod(ClassElement clazz, MethodElement elem) {
        MethodParameter[] params = elem.getParameters();
        Type[] paramTypes = new Type[params.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = params[i].getType();
            ++i;
        }
        return clazz.getMethod(elem.getName(), paramTypes);
    }

    private static Vector findClassImplementing(ClassElement interf, SourceElement source, Map cache) {
        Identifier id = interf.getName();
        String key = id.getFullName();
        Vector<ClassElement> ret = (Vector<ClassElement>)cache.get(key);
        if (ret == null) {
            Vector<ClassElement> list = new Vector<ClassElement>();
            ClassElement[] classes = source.getAllClasses();
            int i = 0;
            while (i < classes.length) {
                if (!classes[i].isInterface()) {
                    Identifier[] interfaces = classes[i].getInterfaces();
                    int j = 0;
                    while (j < interfaces.length) {
                        if (interfaces[j].compareTo(id, false)) {
                            list.add(classes[i]);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            cache.put(key, list);
            ret = list;
        }
        return ret;
    }

    static void interfacesAdded(Identifier[] interfaces, ClassElement cl, JavaDataObject jdo) {
        if (!JavaConnections.SETTINGS.isEnabled()) {
            return;
        }
        if (jdo.getSynchronizationType() == 0) {
            return;
        }
        LinkedList methodList = new LinkedList();
        InterfaceConnection.addAllMethods(interfaces, methodList);
        HashMap<MethodElement.Key, MethodElement> changedMethods = new HashMap<MethodElement.Key, MethodElement>();
        LinkedList<JavaConnections.ChangeProcessor> changesProcessors = new LinkedList<JavaConnections.ChangeProcessor>();
        Iterator methodsEn = methodList.iterator();
        while (methodsEn.hasNext()) {
            MethodElement m = (MethodElement)methodsEn.next();
            ClassElement interf = m.getDeclaringClass();
            try {
                m = InterfaceConnection.createEmptyMethodFrom(m);
            }
            catch (SourceException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return;
            }
            MethodElement updatedMethod = InterfaceConnection.findMatchingMethod(cl, m);
            MethodElement.Key key = new MethodElement.Key(m);
            if (changedMethods.containsKey(key) && InterfaceConnection.compareMethods((MethodElement)changedMethods.get(key), m)) continue;
            if (updatedMethod == null) {
                changesProcessors.add(new AddMethodProcessor(interf, cl, m));
            } else {
                if (InterfaceConnection.compareMethods(updatedMethod, m)) continue;
                changesProcessors.add(new ChangeMethodProcessor(interf, cl, updatedMethod, m));
            }
            changedMethods.put(key, m);
        }
        if (!changesProcessors.isEmpty()) {
            jdo.startChangeProcessors(changesProcessors);
        }
    }

    private static void addAllMethods(Identifier[] interfaces, LinkedList allMethods) {
        int i = 0;
        while (i < interfaces.length) {
            ClassElement interf = ClassElement.forName((String)interfaces[i].getFullName());
            if (interf != null && interf.isInterface()) {
                MethodElement[] methods = interf.getMethods();
                int j = 0;
                while (j < methods.length) {
                    allMethods.add(methods[j]);
                    ++j;
                }
                Identifier[] recurseInterfaces = interf.getInterfaces();
                if (recurseInterfaces.length > 0) {
                    InterfaceConnection.addAllMethods(recurseInterfaces, allMethods);
                }
            }
            ++i;
        }
    }

    static boolean sourceCheck(LinkedList changeProcessors, SourceElement source) {
        ClassElement[] classes = source.getAllClasses();
        boolean changed = false;
        try {
            int i = 0;
            while (i < classes.length) {
                ClassElement cls = classes[i];
                if (cls.isClassOrInterface()) {
                    MethodElement m;
                    int j;
                    ClassElement superClass = null;
                    HashSet allInterfaces = new HashSet(13);
                    HashSet implInterfaces = new HashSet(13);
                    Identifier superid = cls.getSuperclass();
                    InterfaceConnection.collectInterfaces(cls, allInterfaces, implInterfaces, true, false);
                    if (superid != null) {
                        superClass = ClassElement.forName((String)superid.getFullName());
                        allInterfaces.removeAll(implInterfaces);
                    }
                    TreeMap<MethodElement, ClassElement> implement = new TreeMap<MethodElement, ClassElement>(new DefaultMethodComparator());
                    Iterator itfIter = allInterfaces.iterator();
                    while (itfIter.hasNext()) {
                        ClassElement itf = (ClassElement)itfIter.next();
                        MethodElement[] methods = itf.getMethods();
                        j = 0;
                        while (j < methods.length) {
                            m = methods[j];
                            if (!implement.containsKey(m)) {
                                implement.put(m, itf);
                            }
                            ++j;
                        }
                    }
                    ClassElement s = superClass;
                    while (s != null && (s.getModifiers() & 0x400) > 0) {
                        MethodElement[] mets = s.getMethods();
                        j = 0;
                        while (j < mets.length) {
                            m = mets[j];
                            if ((m.getModifiers() & 0x400) > 0 && !implement.containsKey(m)) {
                                implement.put(m, s);
                            }
                            ++j;
                        }
                        ClassElement classElement = s = s.getSuperclass() == null ? null : ClassElement.forName((String)s.getSuperclass().getFullName());
                    }
                    itfIter = implInterfaces.iterator();
                    while (itfIter.hasNext()) {
                        ClassElement itf = (ClassElement)itfIter.next();
                        MethodElement[] methods = itf.getMethods();
                        int j2 = 0;
                        while (j2 < methods.length) {
                            MethodElement m2 = methods[j2];
                            implement.remove(m2);
                            ++j2;
                        }
                    }
                    Iterator mIter = implement.keySet().iterator();
                    LinkedList<MethodElement> unimplemented = new LinkedList<MethodElement>();
                    while (mIter.hasNext()) {
                        ClassElement implementingSuper;
                        MethodElement m3 = (MethodElement)mIter.next();
                        MethodParameter[] params = m3.getParameters();
                        Type[] paramTypes = new Type[params.length];
                        int j3 = 0;
                        while (j3 < params.length) {
                            paramTypes[j3] = params[j3].getType();
                            ++j3;
                        }
                        ClassElement classElement = implementingSuper = superClass == null ? null : InterfaceConnection.findMethodInSuperclasses(superClass, m3.getName(), paramTypes);
                        if (implementingSuper != null) continue;
                        unimplemented.add(m3);
                    }
                    if (!unimplemented.isEmpty()) {
                        changed |= InterfaceConnection.implementMethods(cls, unimplemented, changeProcessors);
                    }
                }
                ++i;
            }
        }
        catch (SourceException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return changed;
    }

    private static boolean implementMethods(ClassElement cls, List unimplemented, LinkedList changeProcessors) throws SourceException {
        boolean changed = false;
        MethodElement[] oldMethods = cls.getMethods();
        MethodElement[] newMethods = unimplemented.toArray(new MethodElement[0]);
        int[] results = new int[]{};
        int i = 0;
        while (i < results.length) {
            MethodElement newm = newMethods[i];
            ClassElement itf = newm.getDeclaringClass();
            if (results[i] == -1) {
                newm = InterfaceConnection.createEmptyMethodFrom(newm);
                changeProcessors.add(new AddMethodProcessor(itf, cls, newm));
                changed = true;
            } else {
                MethodElement oldm = oldMethods[results[i]];
                if (!InterfaceConnection.compareMethods(oldm, newm)) {
                    newm = InterfaceConnection.createEmptyMethodFrom(newm);
                    changeProcessors.add(new ChangeMethodProcessor(itf, cls, oldm, newm));
                    changed = true;
                }
            }
            ++i;
        }
        return changed;
    }

    static int[] pairElements(MemberElement[] oldArray, MemberElement[] newArray, Comparator[] comps) {
        int oldSize = oldArray.length;
        int newSize = newArray.length;
        if (newArray.length > 0 && !(newArray[0] instanceof MemberElement)) {
            throw new IllegalArgumentException("Got " + newArray[0].getClass());
        }
        int[] result = new int[newSize];
        int i = 0;
        while (i < newSize) {
            result[i] = -1;
            ++i;
        }
        if (oldSize == 0 || newSize == 0) {
            return result;
        }
        int match = 0;
        BitSet used = new BitSet(oldArray.length);
        int k = 0;
        while (k < comps.length) {
            Comparator comp = comps[k];
            int i2 = 0;
            int j = 0;
            while (i2 < newSize && j < oldSize) {
                if (used.get(j)) {
                    ++j;
                    continue;
                }
                if (result[i2] != -1) {
                    ++i2;
                    continue;
                }
                if (comp.compare(newArray[i2], oldArray[j]) == 0) {
                    result[i2] = j;
                    used.set(j);
                    ++match;
                }
                ++i2;
                ++j;
            }
            i2 = newSize - 1;
            j = oldSize - 1;
            while (i2 >= 0 && j >= 0) {
                if (used.get(j)) {
                    --j;
                    continue;
                }
                if (result[i2] != -1) {
                    --i2;
                    continue;
                }
                if (comp.compare(newArray[i2], oldArray[j]) == 0) {
                    result[i2] = j;
                    used.set(j);
                    ++match;
                }
                --i2;
                --j;
            }
            i2 = 0;
            while (i2 < newSize && match < newSize) {
                if (result[i2] == -1) {
                    j = 0;
                    while (j < oldSize) {
                        if (!used.get(j) && comp.compare(newArray[i2], oldArray[j]) == 0) {
                            result[i2] = j;
                            used.set(j);
                            ++match;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            ++k;
        }
        return result;
    }

    private static boolean compareMethods(MethodElement a, MethodElement b) {
        Identifier[] excB;
        MethodParameter[] paramB;
        if (!a.getName().compareTo(b.getName(), false)) {
            return false;
        }
        if (!a.getReturn().compareTo(b.getReturn(), false)) {
            return false;
        }
        MethodParameter[] paramA = a.getParameters();
        if (paramA.length != (paramB = b.getParameters()).length) {
            return false;
        }
        int i = 0;
        while (i < paramA.length) {
            if (!paramA[i].compareTo(paramB[i], true, false)) {
                return false;
            }
            ++i;
        }
        Identifier[] excA = a.getExceptions();
        if (excA.length != (excB = b.getExceptions()).length) {
            return false;
        }
        i = 0;
        while (i < excA.length) {
            if (!excA[i].compareTo(excB[i], false)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static ClassElement findMethodInSuperclasses(ClassElement cls, Identifier name, Type[] paramTypes) {
        MethodElement el = cls.getMethod(name, paramTypes);
        if (el != null) {
            return (el.getModifiers() & 0x400) > 0 ? null : cls;
        }
        Identifier superclass = cls.getSuperclass();
        if (superclass == null) {
            return null;
        }
        cls = ClassElement.forName((String)superclass.getFullName());
        if (cls != null) {
            return InterfaceConnection.findMethodInSuperclasses(cls, name, paramTypes);
        }
        return null;
    }

    private static void collectInterfaces(ClassElement cls, Set include, Set exclude, boolean first, boolean excludeOnly) {
        ClassElement c;
        Identifier[] itfs = cls.getInterfaces();
        Identifier s = cls.getSuperclass();
        if (s != null && (c = ClassElement.forName((String)s.getFullName())) != null) {
            InterfaceConnection.collectInterfaces(c, include, exclude, false, false);
        }
        if (!excludeOnly && (first || (cls.getModifiers() & 0x600) > 0) || cls.isInterface()) {
            int i = 0;
            while (i < itfs.length) {
                c = ClassElement.forName((String)itfs[i].getFullName());
                if (c != null && !exclude.contains(c)) {
                    include.add(c);
                    InterfaceConnection.collectInterfaces(c, include, exclude, false, false);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < itfs.length) {
                c = ClassElement.forName((String)itfs[i].getFullName());
                if (c != null) {
                    exclude.add(c);
                    InterfaceConnection.collectInterfaces(c, include, exclude, false, true);
                }
                ++i;
            }
        }
    }

    private static MethodParameter[] fillNames(MethodParameter[] params) {
        boolean paramIndex = true;
        int i = 0;
        while (i < params.length) {
            if (params[i].getName().length() == 0) {
                params[i] = new MethodParameter("p" + (i + 1), params[i].getType(), params[i].isFinal());
            }
            ++i;
        }
        return params;
    }

    static class ChangeMethodProcessor
    extends JavaConnections.ChangeProcessor {
        static final MessageFormat format = new MessageFormat(Util.getString("MSG_UpdateMethod"));
        MethodElement clazzMethod;
        MethodElement interfMethod;

        ChangeMethodProcessor(ClassElement interf, ClassElement clazz, MethodElement clazzMethod, MethodElement interfMethod) {
            super(format.format(new Object[]{interf.getName().getName(), clazz.getName().getName(), clazzMethod.getName().getName()}));
            this.clazzMethod = clazzMethod;
            this.interfMethod = interfMethod;
        }

        public void process() throws SourceException {
            SourceElement src = this.clazzMethod.getDeclaringClass().getSource();
            SourceException[] ex = new SourceException[]{null};
            src.runAtomicAsUser(new Runnable(this, ex){
                private final /* synthetic */ SourceException[] val$ex;
                private final /* synthetic */ ChangeMethodProcessor this$0;
                {
                    this.this$0 = this$0;
                    this.val$ex = val$ex;
                }

                public void run() {
                    int oldModif = this.this$0.clazzMethod.getModifiers();
                    try {
                        if ((oldModif & 1) == 0) {
                            this.this$0.clazzMethod.setModifiers(oldModif | 1);
                        }
                        this.this$0.clazzMethod.setName(this.this$0.interfMethod.getName());
                        this.this$0.clazzMethod.setExceptions(this.this$0.interfMethod.getExceptions());
                        this.this$0.clazzMethod.setParameters(InterfaceConnection.access$100(this.this$0.interfMethod.getParameters()));
                        this.this$0.clazzMethod.setReturn(this.this$0.interfMethod.getReturn());
                    }
                    catch (SourceException e) {
                        this.val$ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    static class AddMethodProcessor
    extends JavaConnections.ChangeProcessor {
        static final MessageFormat format = new MessageFormat(Util.getString("MSG_AddMethod"));
        MethodElement method;
        ClassElement clazz;

        AddMethodProcessor(ClassElement interf, ClassElement clazz, MethodElement method) {
            super(format.format(new Object[]{interf.getName().getName(), clazz.getName().getName(), method.getName().getName()}));
            this.clazz = clazz;
            this.method = method;
        }

        public void process() throws SourceException {
            SourceElement src = this.clazz.getSource();
            final SourceException[] ex = new SourceException[]{null};
            src.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        method.setParameters(InterfaceConnection.fillNames(method.getParameters()));
                        clazz.addMethod(method);
                    }
                    catch (SourceException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    private static class DefaultMethodComparator
    implements Comparator {
        private DefaultMethodComparator() {
        }

        public int compare(Object a, Object b) {
            MethodElement ma = (MethodElement)a;
            MethodElement mb = (MethodElement)b;
            if (ma == mb) {
                return 0;
            }
            int result = ma.getName().getSourceName().compareTo(mb.getName().getSourceName());
            if (result != 0) {
                return result;
            }
            result = ma.getParameters().length - mb.getParameters().length;
            if (result != 0) {
                return result;
            }
            MethodParameter[] paramA = ma.getParameters();
            MethodParameter[] paramB = mb.getParameters();
            int i = 0;
            while (i < paramA.length) {
                result = paramA[i].getFullString().compareTo(paramB[i].getFullString());
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }

        public boolean equals(Object ob) {
            return ob instanceof DefaultMethodComparator;
        }
    }
}

