/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Enumeration;
import org.netbeans.modules.java.BogusCompiler;
import org.netbeans.modules.java.CleanCompiler;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaMakeCG;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.ErrorManager;
import org.openide.compiler.Compilable;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerType;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.WeakListener;

public abstract class JavaCompilerType
extends CompilerType
implements Cloneable {
    static final long serialVersionUID = -1426544702124944362L;
    protected static final int currentVersion = 1;
    protected int version;
    public static final Object COMPILE = class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = JavaCompilerType.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile;
    public static final Object BUILD = class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = JavaCompilerType.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build;
    public static final Object CLEAN = class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = JavaCompilerType.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean;
    public static final String PROP_F_DEPRECATION = "deprecation";
    public static final String PROP_F_DEBUG = "debug";
    public static final String PROP_F_OPTIMIZE = "optimize";
    public static final String PROP_F_WARNINGS = "warnings";
    public static final String PROP_CHAR_ENCODING = "charEncoding";
    public static final String PROP_FLAGS = "flag";
    public static final String PROP_TARGET_FILESYSTEM = "targetFileSystem";
    private static final String INVALID_TARGET_NAME = "InvalidTarget";
    private static final String DEFAULT_ENCODING = "null";
    public static final String PROP_CLASSPATH = "classPath";
    public static final String PROP_BOOTCLASSPATH = "bootClassPath";
    public static final FileSystem TARGET_INVALID = new LocalFileSystem();
    private static final int F_WARNINGS = 4;
    private static final int F_DEBUG_LINES = 4096;
    private static final int F_DEBUG_VARS = 8192;
    private static final int F_DEBUG_SOURCE = 262144;
    private static final int F_OPT = 16384;
    private static final int F_OPT_INTERCLASS = 32768;
    private static final int F_DEPENDENCIES = 32;
    private static final int F_DEPRECATION = 512;
    private static transient int generationCount = 1;
    private int flag = 274436;
    private String charEncoding;
    private transient FileSystem targetFileSystem;
    private transient boolean listenerRegistered;
    private String targetFSName;
    private NbClassPath classPath;
    private NbClassPath bootClassPath;
    private transient NbClassPath defaultBootClassPath;
    private transient NbClassPath defaultClassPath;
    private transient R repoL;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;
    static /* synthetic */ Class class$org$openide$ServiceType;

    public Object clone() throws CloneNotSupportedException {
        JavaCompilerType other = (JavaCompilerType)super.clone();
        try {
            Field f = (class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = JavaCompilerType.class$("org.openide.ServiceType")) : class$org$openide$ServiceType).getDeclaredField("supp");
            ((AccessibleObject)f).setAccessible(true);
            f.set(other, null);
        }
        catch (IllegalAccessException ex) {
            this.throwCloneException(ex);
        }
        catch (NoSuchFieldException ex) {
            this.throwCloneException(ex);
        }
        other.setName("");
        return other;
    }

    public NbClassPath getClassPath() {
        NbClassPath p = this.classPath;
        if (p != null) {
            return p;
        }
        return this.createDefaultClassPath();
    }

    protected NbClassPath createDefaultClassPath() {
        if (this.defaultClassPath != null) {
            return this.defaultClassPath;
        }
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (this.defaultClassPath == null) {
                this.defaultClassPath = new NbClassPath("");
            }
        }
        return this.defaultClassPath;
    }

    public void setClassPath(NbClassPath path) {
        NbClassPath old;
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (path == this.getClassPath() || path != null && path.equals((Object)this.getClassPath())) {
                return;
            }
            old = this.classPath;
            this.classPath = path;
        }
        this.firePropertyChange(PROP_CLASSPATH, old, path);
    }

    public NbClassPath getBootClassPath() {
        NbClassPath bcp = this.bootClassPath;
        if (bcp != null) {
            return bcp;
        }
        return this.bootClassPath == null ? this.getDefaultBootClassPath() : this.bootClassPath;
    }

    protected NbClassPath getDefaultBootClassPath() {
        if (this.defaultBootClassPath != null) {
            return this.defaultBootClassPath;
        }
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (this.defaultBootClassPath != null) {
                NbClassPath nbClassPath = this.defaultBootClassPath;
                return nbClassPath;
            }
        }
        this.defaultBootClassPath = new NbClassPath("");
        return this.defaultBootClassPath;
    }

    public void setBootClassPath(NbClassPath path) {
        NbClassPath old;
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (path == this.getBootClassPath() || path != null && path.equals((Object)this.getBootClassPath())) {
                return;
            }
            old = this.bootClassPath;
            this.bootClassPath = path;
        }
        this.firePropertyChange(PROP_BOOTCLASSPATH, old, path);
    }

    public static boolean isUpToDate(FileObject fo, FileSystem target) {
        try {
            DataObject mdo = DataObject.find((FileObject)fo);
            if (mdo.isModified()) {
                return false;
            }
            FileObject primary = mdo.getPrimaryFile();
            FileObject folder = primary.getParent();
            if (target != null && (folder = target.find(folder.getPackageName('.'), null, null)) == null) {
                return false;
            }
            FileObject clazz = folder.getFileObject(primary.getName(), "class");
            if (clazz != null) {
                clazz.refresh();
                primary.refresh();
                if (clazz.getSize() > 0L && clazz.lastModified().compareTo(primary.lastModified()) >= 0) {
                    return true;
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private void throwCloneException(Throwable t) throws CloneNotSupportedException {
        ErrorManager err = ErrorManager.getDefault();
        CloneNotSupportedException x = new CloneNotSupportedException();
        err.annotate((Throwable)x, t);
        throw x;
    }

    public int flag() {
        return this.flag;
    }

    private void orFlag(int f) {
        int oldflag = this.flag;
        this.flag |= f;
        this.firePropertyChange(PROP_FLAGS, new Integer(oldflag), new Integer(this.flag));
    }

    private void andFlag(int f) {
        int oldflag = this.flag;
        this.flag &= f;
        this.firePropertyChange(PROP_FLAGS, new Integer(oldflag), new Integer(this.flag));
    }

    public void setWarnings(boolean x) {
        boolean old;
        boolean bl = old = (this.flag & 4) != 0;
        if (x) {
            if (!old) {
                this.orFlag(4);
            }
        } else if (old) {
            this.andFlag(-5);
        }
        if (x != old) {
            this.firePropertyChange(PROP_F_WARNINGS, old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getWarnings() {
        return (this.flag & 4) != 0;
    }

    public void setDebug(boolean x) {
        boolean old;
        boolean bl = old = (this.flag & 0x43000) != 0;
        if (x) {
            if (!old) {
                this.orFlag(274432);
            }
        } else if (old) {
            this.andFlag(-274433);
        }
        if (x != old) {
            this.firePropertyChange(PROP_F_DEBUG, old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getDebug() {
        return (this.flag & 0x43000) != 0;
    }

    public void setOptimize(boolean x) {
        boolean old;
        boolean bl = old = (this.flag & 0xC000) != 0;
        if (x) {
            if (!old) {
                this.orFlag(49152);
            }
        } else if (old) {
            this.andFlag(-49153);
        }
        if (x != old) {
            this.firePropertyChange(PROP_F_OPTIMIZE, old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getOptimize() {
        return (this.flag & 0xC000) != 0;
    }

    public void setDeprecation(boolean x) {
        boolean old;
        boolean bl = old = (this.flag & 0x200) != 0;
        if (x) {
            if (!old) {
                this.orFlag(512);
            }
        } else if (old) {
            this.andFlag(-513);
        }
        if (x != old) {
            this.firePropertyChange(PROP_F_DEPRECATION, old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getDeprecation() {
        return (this.flag & 0x200) != 0;
    }

    public void setDependencies(boolean x) {
        boolean old;
        boolean bl = old = (this.flag & 0x20) != 0;
        if (x) {
            if (!old) {
                this.orFlag(32);
            }
        } else if (old) {
            this.andFlag(-33);
        }
        if (x != old) {
            this.firePropertyChange("dependencies", old ? Boolean.TRUE : Boolean.FALSE, x ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getDependencies() {
        return (this.flag & 0x20) != 0;
    }

    public void setCharEncoding(String enc) {
        if (enc != null) {
            if ((enc = enc.trim()).equals("")) {
                enc = null;
            } else if (DEFAULT_ENCODING.equalsIgnoreCase(enc)) {
                enc = null;
            }
        }
        String old = this.charEncoding;
        this.charEncoding = enc;
        this.firePropertyChange(PROP_CHAR_ENCODING, old, this.charEncoding);
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setTargetFileSystem(FileSystem target) {
        FileSystem fs;
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            fs = this.getTargetFileSystem();
            if (target == fs || target != null && fs != null && target.equals(fs)) {
                return;
            }
            if (target != null) {
                if (target != TARGET_INVALID) {
                    this.targetFSName = target.getSystemName();
                }
                this.registerRepositoryListener();
            } else {
                this.targetFSName = null;
            }
            this.targetFileSystem = target;
        }
        this.firePropertyChange(PROP_TARGET_FILESYSTEM, fs, target);
        this.incrementGenCount();
    }

    public void assureValidTargetFS() throws IOException {
        FileSystem fs = this.getTargetFileSystem();
        if (fs == null) {
            return;
        }
        String key = null;
        if (fs == TARGET_INVALID) {
            key = "MSG_FS_Invalid";
        } else {
            Enumeration en = Repository.getDefault().fileSystems();
            boolean match = false;
            while (en.hasMoreElements()) {
                FileSystem xfs = (FileSystem)en.nextElement();
                if (xfs != fs) continue;
                match = true;
                break;
            }
            if (!match) {
                key = "MSG_FS_NotMounted";
            }
        }
        if (key == null) {
            if (fs.isReadOnly()) {
                key = "MSG_FS_ReadOnly";
            } else {
                return;
            }
        }
        String msg = MessageFormat.format(JavaCompilerType.getString(key), fs.getDisplayName());
        throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(msg), 256, null, msg, null, null);
    }

    public FileSystem getTargetFileSystem() {
        if (!this.isCrossCompile()) {
            return null;
        }
        JavaCompilerType javaCompilerType = this;
        synchronized (javaCompilerType) {
            if (this.targetFileSystem == null) {
                FileSystem f = this.findFileSystem();
                this.targetFileSystem = f == null ? TARGET_INVALID : f;
                this.registerRepositoryListener();
            }
        }
        return this.targetFileSystem;
    }

    int getGenCount() {
        if (!this.isCrossCompile()) {
            return 0;
        }
        return generationCount;
    }

    protected void incrementGenCount() {
        ++generationCount;
    }

    private void registerRepositoryListener() {
        if (!this.listenerRegistered) {
            Repository repo = Repository.getDefault();
            this.repoL = new R();
            repo.addRepositoryListener(WeakListener.repository((RepositoryListener)this.repoL, (Object)repo));
            this.listenerRegistered = true;
        }
    }

    private FileSystem findFileSystem() {
        Repository repo = Repository.getDefault();
        Enumeration en = repo.fileSystems();
        FileSystem target = null;
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            if (!fs.getSystemName().equals(this.targetFSName)) continue;
            target = fs;
            break;
        }
        return target;
    }

    public boolean isCrossCompile() {
        return this.targetFSName != null;
    }

    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        Compiler compiler;
        if (obj instanceof JavaDataObject) {
            JavaDataObject jobj = (JavaDataObject)obj;
            if (type == CLEAN) {
                new CleanCompiler(job, jobj, this.getTargetFileSystem());
                return;
            }
            FileObject sourceFile = jobj.getPrimaryFile();
            try {
                compiler = this.createCompiler(type, sourceFile);
                if (type == BUILD) {
                    compiler.dependsOn((Compilable)new CleanCompiler(job, jobj, this.getTargetFileSystem()));
                }
                this.linkToJavaMake(job, compiler);
            }
            catch (IllegalArgumentException ex) {
                compiler = new BogusCompiler(sourceFile, ex);
            }
        } else {
            String message = MessageFormat.format(Util.getString("MSG_InvalidCompiler"), this.getName(), obj.getPrimaryFile().toString());
            Throwable t = ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, message, null, null);
            compiler = new BogusCompiler(obj.getPrimaryFile(), t);
        }
        job.add(compiler);
    }

    void linkToJavaMake(CompilerJob j, Compiler c) {
        JavaSettings js = JavaSettings.getDefault();
        if (!js.isUseJavaMake() || !j.getInitialDepth().equals(Compiler.DEPTH_INFINITE)) {
            return;
        }
        Compiler c2 = JavaMakeCG.createCompiler(j, this.getTargetFileSystem());
        c2.dependsOn((Compilable)c);
        j.add(c2);
    }

    public void prepareJobForFileObject(CompilerJob job, Class type, FileObject fo) {
        if (type == CLEAN) {
            throw new IllegalArgumentException();
        }
        Compiler c = this.createCompiler(type, fo);
        job.add(c);
    }

    public IndirectCompiler prepareIndirectCompiler(Class type, FileSystem fs, String resource) {
        return new IndirectCompiler(type, fs, resource);
    }

    public IndirectCompiler prepareIndirectCompiler(Class type, String resource) {
        return new IndirectCompiler(type, null, resource);
    }

    protected abstract Class getCompilerGroupClass();

    protected abstract Compiler createCompiler(Class var1, FileObject var2);

    static final String getString(String name) {
        return Util.getString(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final class IndirectCompiler
    extends Compiler {
        private final FileSystem dir;
        private final String res;
        private final Class type;
        private FileObject resolvedResource;

        public IndirectCompiler(Class type, FileSystem dir, String res) {
            this.dir = dir;
            this.type = type;
            if (res != null && File.separatorChar != '/') {
                res = res.replace(File.separatorChar, '/');
            }
            this.res = res;
        }

        public boolean isUpToDate() {
            return false;
        }

        public Class compilerGroupClass() {
            return JavaCompilerType.this.getCompilerGroupClass();
        }

        public boolean equals(Object other) {
            return this == other;
        }

        public int hashCode() {
            return this.res == null ? 4371234 : this.res.hashCode();
        }

        public Compiler getCompiler() {
            FileObject fo = this.getResolved();
            if (fo == null) {
                return null;
            }
            return JavaCompilerType.this.createCompiler(this.type, fo);
        }

        public FileObject getResolved() {
            if (this.resolvedResource == null && this.res != null) {
                this.resolvedResource = this.dir == null ? FileSystemCapability.COMPILE.findResource(this.res) : this.dir.findResource(this.res);
            }
            return this.resolvedResource;
        }

        public void setResolved(FileObject fo) {
            this.resolvedResource = fo;
        }
    }

    private class R
    extends RepositoryAdapter {
        private R() {
        }

        public void fileSystemAdded(RepositoryEvent ev) {
            String fsName = JavaCompilerType.this.targetFSName;
            if (fsName == null || JavaCompilerType.this.targetFileSystem != TARGET_INVALID) {
                return;
            }
            FileSystem fs = ev.getFileSystem();
            if (fs.getSystemName().equals(fsName)) {
                JavaCompilerType.this.setTargetFileSystem(fs);
            }
        }

        public void fileSystemRemoved(RepositoryEvent ev) {
            if (ev.getFileSystem() != JavaCompilerType.this.targetFileSystem) {
                return;
            }
            JavaCompilerType.this.setTargetFileSystem(TARGET_INVALID);
        }
    }
}

