/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.apache.regexp.CharacterArrayCharacterIterator;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.ParserAnnotation;
import org.netbeans.modules.java.ParserMessage;
import org.netbeans.modules.java.Parsing;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.parser.ParseSourceRequest;
import org.netbeans.modules.java.settings.JavaSettings;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SourceCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditor;
import org.openide.text.EditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class JavaEditor
extends EditorSupport
implements Parsing.Listener {
    static final String MAGIC_PREFIX = "//GEN-";
    private static String[] SECTION_MAGICS;
    private static final int LONGEST_ITEM = 10;
    private static final int T_LINE = 0;
    private static final int T_BEGIN = 1;
    private static final int T_END = 2;
    private static final int T_HEADER = 3;
    private static final int T_HEADEREND = 4;
    private static final int T_FIRST = 5;
    private static final int T_LAST = 6;
    HashMap sections = null;
    Timer timer;
    static final byte NEW_LINE_N = 0;
    static final byte NEW_LINE_R = 1;
    static final byte NEW_LINE_RN = 2;
    byte newLineType;
    Object parsedHook;
    private transient boolean hasAnnotations = false;
    private boolean reloading = false;
    private static final Comparator SECTION_COMPARATOR;
    private ArrayList annotations = new ArrayList();
    private static Repository repository;
    private boolean parsingAttached;
    private Parsing.Listener wParsingL;
    static /* synthetic */ Class class$org$netbeans$modules$java$parser$JavaParser;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;

    public JavaEditor(MultiDataObject.Entry entry) {
        super(entry);
        this.addChangeListener(new JavaEditorChangeListener());
    }

    private JavaParser findParser() {
        return (JavaParser)this.findDataObject().getCookie(class$org$netbeans$modules$java$parser$JavaParser == null ? (class$org$netbeans$modules$java$parser$JavaParser = JavaEditor.class$("org.netbeans.modules.java.parser.JavaParser")) : class$org$netbeans$modules$java$parser$JavaParser);
    }

    private void changeTimeoutElapsed() {
        this.parseSource(2, false);
    }

    private void fileSystemChanged(FileSystem fs) {
        if (fs == null || fs.getCapability().capableOf(FileSystemCapability.COMPILE)) {
            this.parseSource(1, true);
        }
    }

    private void parsingErrorsChanged(PropertyChangeEvent evt) {
        int errors = JavaSettings.getDefault().getParsingErrors();
        Integer old = (Integer)evt.getOldValue();
        int oldErrors = 10;
        if (old != null) {
            oldErrors = old;
        }
        if (oldErrors == errors) {
            return;
        }
        if (errors == 0 && !this.annotations.isEmpty()) {
            JavaEditor.detachAnnotations(this.annotations);
            this.annotations.clear();
            return;
        }
        if (oldErrors == this.annotations.size() || errors < this.annotations.size()) {
            this.parseSource(1, true);
        }
    }

    private void parseSource(int priority, boolean ignoreClean) {
        ParseSourceRequest req;
        JavaParser parser = this.findParser();
        if (parser == null) {
            return;
        }
        if (this.getOpenedPanes() != null && JavaSettings.getDefault().getParsingErrors() > 0) {
            req = new ParseSourceRequest((Object)"deep");
            if (!this.hasAnnotations) {
                ignoreClean = true;
            }
            this.hasAnnotations = true;
        } else {
            req = new ParseSourceRequest();
        }
        parser.parse(priority, ignoreClean, false, req);
    }

    private synchronized void attachParsingListener() {
        if (!this.parsingAttached) {
            if (this.wParsingL == null) {
                this.wParsingL = new WParsingListener(this);
            }
            Parsing.addParsingListener(this.wParsingL);
            this.parsingAttached = true;
        }
    }

    void restartTimer(boolean onlyIfRunning) {
        if (onlyIfRunning && (this.timer == null || !this.timer.isRunning())) {
            return;
        }
        int delay = JavaSettings.getDefault().getAutoParsingDelay();
        if (delay <= 0) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaEditor.this.changeTimeoutElapsed();
                }
            });
            this.timer.setRepeats(false);
        }
        this.timer.setInitialDelay(delay);
        this.timer.restart();
    }

    protected EditorSupport.Editor openAt(PositionRef pos) {
        EditorSupport.Editor ed = super.openAt(pos);
        ed.requestFocus();
        return ed;
    }

    protected void notifyClosed() {
        JavaEditor javaEditor = this;
        synchronized (javaEditor) {
            Parsing.removeParsingListener(this.wParsingL);
            this.parsingAttached = false;
        }
        CloneableTopComponent.Ref ref = ((CloneableOpenSupport)this).allEditors;
        synchronized (ref) {
            super.notifyClosed();
            this.clearSections();
        }
        this.parsedHook = null;
    }

    protected void notifyParsingDone() {
    }

    public void objectParsed(final Parsing.Event info) {
        if (info.getSource() == this.findDataObject()) {
            this.parsedHook = this.findParser().getSourceImpl();
            if (this.getOpenedPanes() != null && JavaSettings.getDefault().getParsingErrors() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JavaEditor.this.processAnnotations(info.getMessages());
                    }
                });
            }
            this.notifyParsingDone();
        }
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        boolean filling = false;
        if (this.sections == null) {
            this.sections = new HashMap(10);
            filling = true;
        }
        if (filling) {
            GuardedReader reader = new GuardedReader(stream, false, Util.getFileEncoding(((OpenSupport)this).entry.getFile()));
            kit.read(reader, (Document)doc, 0);
            this.fillSections(reader, doc);
            this.newLineType = reader.getNewLineType();
        } else {
            kit.read(stream, (Document)doc, 0);
        }
        final boolean forceUpdate = this.reloading;
        this.reloading = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaEditor.this.parseSource(2, forceUpdate);
            }
        });
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        ArrayList list;
        NewLineOutputStream os = new NewLineOutputStream(stream, this.newLineType);
        String encoding = Util.getFileEncoding(((OpenSupport)this).entry.getFile());
        if (this.sections != null && (list = new ArrayList(this.sections.values())).size() > 0) {
            GuardedWriter writer = new GuardedWriter(os, list, encoding);
            kit.write(writer, (Document)doc, 0, doc.getLength());
            return;
        }
        OutputStreamWriter w = encoding == null ? new OutputStreamWriter(os) : new OutputStreamWriter((OutputStream)os, encoding);
        kit.write(w, (Document)doc, 0, doc.getLength());
    }

    protected Task reloadDocumentTask() {
        StyledDocument doc = null;
        try {
            doc = this.openDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (doc != null) {
            this.clearSections();
            NbDocument.unmarkGuarded((StyledDocument)doc, (int)0, (int)doc.getLength());
            this.reloading = true;
            return super.reloadDocumentTask();
        }
        return null;
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true, true);
    }

    protected void saveDocumentIfNecessary(boolean parse) throws IOException {
        this.saveDocument(parse, false);
    }

    private void saveDocument(boolean parse, boolean forceSave) throws IOException {
        if (forceSave || this.isModified()) {
            super.saveDocument();
        }
    }

    private void processAnnotations(ParserMessage[] errors) {
        if (errors == null) {
            ErrorManager.getDefault().log("request for " + this.findDataObject().getPrimaryFile().getPath() + " processed by someone else");
            this.parseSource(2, true);
            return;
        }
        Collection newAnnotations = this.getAnnotations(errors);
        ArrayList added = new ArrayList(newAnnotations);
        ((AbstractCollection)added).removeAll(this.annotations);
        ArrayList unchanged = new ArrayList(this.annotations);
        ((AbstractCollection)unchanged).retainAll(newAnnotations);
        ArrayList removed = this.annotations;
        ((AbstractCollection)removed).removeAll(newAnnotations);
        JavaEditor.detachAnnotations(removed);
        if (!added.isEmpty()) {
            LineCookie cookie = (LineCookie)this.findDataObject().getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = JavaEditor.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            Line.Set lines = cookie.getLineSet();
            Iterator i = ((AbstractList)added).iterator();
            while (i.hasNext()) {
                ParserAnnotation ann = (ParserAnnotation)i.next();
                ann.attachToLineSet(lines);
            }
        }
        this.annotations = unchanged;
        this.annotations.addAll(added);
    }

    private Collection getAnnotations(ParserMessage[] errors) {
        HashMap<Integer, ParserAnnotation> map = new HashMap<Integer, ParserAnnotation>(2 * errors.length);
        int maxErrors = JavaSettings.getDefault().getParsingErrors();
        int i = 0;
        while (i < errors.length) {
            ParserMessage err = errors[i];
            int line = err.getLineNumber();
            if (err.getSeverity() == ParserMessage.ERROR && line > 0) {
                int column = err.getColumn();
                String message = err.getDescription();
                ParserAnnotation anno = new ParserAnnotation(line, column, message);
                Integer lineInt = new Integer(line);
                ParserAnnotation prev = (ParserAnnotation)map.get(lineInt);
                if (prev != null) {
                    prev.chain(anno);
                } else if (map.size() < maxErrors) {
                    map.put(lineInt, anno);
                }
            }
            ++i;
        }
        return map.values();
    }

    private static void detachAnnotations(Collection anns) {
        Iterator i = anns.iterator();
        while (i.hasNext()) {
            Annotation ann = (Annotation)i.next();
            ann.detach();
        }
    }

    public SourceElement getSource() {
        return ((JavaDataObject)this.findDataObject()).getSource();
    }

    public Element sourceToText(org.openide.src.Element element) {
        return null;
    }

    public org.openide.src.Element textToSource(Element element) throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    public org.openide.src.Element findElement(int offset) {
        return null;
    }

    public SimpleSection createSimpleSection(PositionRef pos, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(pos);
        return this.doCreateSimpleSection(pos, name);
    }

    public SimpleSection createSimpleSection(PositionBounds bounds, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(bounds);
        return this.doCreateSimpleSection(bounds, name);
    }

    private void checkOverlap(PositionRef pos) {
        Iterator it = this.sections.values().iterator();
        while (it.hasNext()) {
            GuardedSection s = (GuardedSection)it.next();
            if (!s.contains(pos, false)) continue;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    public boolean testOverlap(PositionBounds bounds) {
        try {
            StyledDocument loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        try {
            this.checkOverlap(bounds, true);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private void checkOverlap(PositionBounds bounds) throws IllegalArgumentException {
        this.checkOverlap(bounds, false);
    }

    private void checkOverlap(PositionBounds bounds, boolean allowHoles) throws IllegalArgumentException {
        TreeSet c = new TreeSet(new GuardedPositionComparator());
        c.addAll(this.sections.values());
        Iterator it = c.iterator();
        PositionRef begin = bounds.getBegin();
        PositionRef end = bounds.getEnd();
        int beginOffset = begin.getOffset();
        int endOffset = end.getOffset();
        Object starting = null;
        boolean overlapOK = false;
        while (it.hasNext()) {
            GuardedSection s = (GuardedSection)it.next();
            if (s.contains(begin, allowHoles) || s.contains(end, allowHoles)) {
                throw new IllegalArgumentException("Sections overlap");
            }
            if (s.getBegin().getOffset() <= beginOffset) continue;
            if (s.getBegin().getOffset() >= endOffset) break;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    private SimpleSection doCreateSimpleSection(final PositionBounds bounds, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument doc = loadedDoc;
        final SimpleSection[] sect = new SimpleSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                sect[0] = new SimpleSection(name, JavaEditor.this.createBounds(bounds.getBegin().getOffset(), bounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    private SimpleSection doCreateSimpleSection(final PositionRef pos, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        final StyledDocument doc = loadedDoc;
        final SimpleSection[] sect = new SimpleSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int where = pos.getOffset();
                doc.insertString(where, "\n \n", null);
                sect[0] = new SimpleSection(name, JavaEditor.this.createBounds(where + 1, where + 3, false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    public SimpleSection createSimpleSectionAfter(GuardedSection previous, String name) throws IllegalArgumentException, BadLocationException {
        PositionBounds bounds = previous instanceof SimpleSection ? ((SimpleSection)previous).bounds : ((InteriorSection)previous).bottom;
        if (previous == null || !previous.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateSimpleSection(bounds.getEnd(), name);
    }

    public InteriorSection createInteriorSection(PositionRef pos, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(pos);
        return this.doCreateInteriorSection(pos, name);
    }

    public InteriorSection createInteriorSectionAfter(GuardedSection previous, String name) throws IllegalArgumentException, BadLocationException {
        PositionBounds bounds = previous instanceof SimpleSection ? ((SimpleSection)previous).bounds : ((InteriorSection)previous).bottom;
        if (previous == null || !previous.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateInteriorSection(bounds.getEnd(), name);
    }

    public InteriorSection createInteriorSection(PositionBounds bounds, PositionBounds interior, String name) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(bounds);
        if (bounds.getBegin().getOffset() > interior.getEnd().getOffset() || bounds.getEnd().getOffset() < interior.getEnd().getOffset()) {
            throw new IllegalArgumentException("Interior is not nested.");
        }
        return this.doCreateInteriorSection(bounds, interior, name);
    }

    private InteriorSection doCreateInteriorSection(final PositionBounds bounds, final PositionBounds interiorBounds, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument doc = loadedDoc;
        final InteriorSection[] sect = new InteriorSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() {
                sect[0] = new InteriorSection(name, JavaEditor.this.createBounds(bounds.getBegin().getOffset(), interiorBounds.getBegin().getOffset(), false), JavaEditor.this.createBounds(interiorBounds.getBegin().getOffset(), interiorBounds.getEnd().getOffset(), true), JavaEditor.this.createBounds(interiorBounds.getEnd().getOffset(), bounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    private InteriorSection doCreateInteriorSection(final PositionRef pos, final String name) throws IllegalArgumentException, BadLocationException {
        StyledDocument loadedDoc = null;
        try {
            loadedDoc = this.openDocument();
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        final StyledDocument doc = loadedDoc;
        final InteriorSection[] sect = new InteriorSection[]{null};
        Util.ExceptionRunnable run = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int where = pos.getOffset();
                doc.insertString(where, "\n \n \n \n", null);
                sect[0] = new InteriorSection(name, JavaEditor.this.createBounds(where + 1, where + 3, false), JavaEditor.this.createBounds(where + 3, where + 5, true), JavaEditor.this.createBounds(where + 5, where + 7, false));
                JavaEditor.this.sections.put(sect[0].getName(), sect[0]);
                sect[0].markGuarded(doc);
            }
        };
        try {
            Util.runAtomic(doc, run);
            this.notifyModified();
        }
        catch (Exception e) {
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new IllegalArgumentException();
        }
        return sect[0];
    }

    public SimpleSection findSimpleSection(String name) {
        GuardedSection s = this.findSection(name);
        return s instanceof SimpleSection ? (SimpleSection)s : null;
    }

    public InteriorSection findInteriorSection(String name) {
        GuardedSection s = this.findSection(name);
        return s instanceof InteriorSection ? (InteriorSection)s : null;
    }

    public GuardedSection findSection(String name) {
        try {
            StyledDocument doc = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    GuardedSection guardedSection = (GuardedSection)this.sections.get(name);
                    return guardedSection;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Iterator getGuardedSections() {
        try {
            StyledDocument doc = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    Iterator iterator = ((HashMap)this.sections.clone()).values().iterator();
                    return iterator;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.EMPTY_SET.iterator();
    }

    public Iterator getGuardedSectionNames() {
        try {
            StyledDocument doc = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                if (this.sections != null) {
                    Iterator iterator = ((HashMap)this.sections.clone()).keySet().iterator();
                    return iterator;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public PositionRef findFreePosition(PositionBounds bnds) {
        try {
            StyledDocument doc = this.openDocument();
        }
        catch (IOException ex) {
            return null;
        }
        PositionRef beginPos = bnds.getBegin();
        int startOffs = beginPos.getOffset();
        TreeSet set = new TreeSet(SECTION_COMPARATOR);
        set.addAll(this.sections.values());
        Iterator it = set.iterator();
        while (it.hasNext()) {
            GuardedSection s = (GuardedSection)it.next();
            PositionRef start = s.getBegin();
            if (start.getOffset() > startOffs) break;
            if (!s.contains(beginPos, false)) continue;
            PositionRef after = s.getPositionAfter();
            if (after.getOffset() > bnds.getEnd().getOffset()) {
                return null;
            }
            return after;
        }
        return beginPos;
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        return this.createJavaEditorComponent();
    }

    JavaEditorComponent createJavaEditorComponent() {
        MultiDataObject obj = this.findDataObject();
        JavaEditorComponent editor = new JavaEditorComponent((DataObject)obj);
        Workspace current = WindowManager.getDefault().getCurrentWorkspace();
        Mode editorMode = current.findMode("editor");
        if (editorMode != null) {
            editorMode.dockInto((TopComponent)editor);
        }
        return editor;
    }

    synchronized void clearSections() {
        if (this.sections != null) {
            Iterator it = ((HashMap)this.sections.clone()).values().iterator();
            while (it.hasNext()) {
                GuardedSection sect = (GuardedSection)it.next();
                sect.valid = false;
            }
            this.sections = null;
        }
    }

    PositionRef findUnguarded(PositionRef fromWhere, boolean allowHoles, boolean after) {
        Iterator it = this.getGuardedSections();
        while (it.hasNext()) {
            GuardedSection sect = (GuardedSection)it.next();
            if (!sect.contains(fromWhere, allowHoles)) continue;
            if (after) {
                return sect.getPositionAfter();
            }
            return sect.getPositionBefore();
        }
        return fromWhere;
    }

    private void fillSections(GuardedReader is, StyledDocument doc) {
        SectionDesc descBegin = null;
        Iterator it = is.list.iterator();
        while (it.hasNext()) {
            SectionDesc descCurrent = (SectionDesc)it.next();
            GuardedSection sect = null;
            switch (descCurrent.type) {
                case 0: {
                    sect = new SimpleSection(descCurrent.name, this.createBounds(descCurrent.begin, descCurrent.end, false));
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    descBegin = descCurrent;
                    break;
                }
                case 4: {
                    if (descBegin != null && (descBegin.type == 3 || descBegin.type == 5) && descCurrent.name.equals(descBegin.name)) {
                        descBegin.end = descCurrent.end;
                        break;
                    }
                    descBegin = null;
                    break;
                }
                case 2: 
                case 6: {
                    if (descBegin != null && descBegin.name.equals(descCurrent.name)) {
                        if (descBegin.type == 1 && descCurrent.type == 2) {
                            sect = new SimpleSection(descCurrent.name, this.createBounds(descBegin.begin, descCurrent.end, false));
                            break;
                        }
                        if (descBegin.type == 5 && descCurrent.type == 6 || descBegin.type == 3 && descCurrent.type == 2) {
                            sect = new InteriorSection(descCurrent.name, this.createBounds(descBegin.begin, descBegin.end, false), this.createBounds(descBegin.end, descCurrent.begin, true), this.createBounds(descCurrent.begin, descCurrent.end, false));
                            break;
                        }
                    }
                    descBegin = null;
                }
            }
            if (sect == null) continue;
            this.sections.put(sect.getName(), sect);
            descBegin = null;
            sect.markGuarded(doc);
        }
    }

    public PositionBounds createBounds(int begin, int end, boolean dir) {
        if (dir) {
            return new PositionBounds(this.createPositionRef(begin, Position.Bias.Forward), this.createPositionRef(end, Position.Bias.Backward));
        }
        return new PositionBounds(this.createPositionRef(begin, Position.Bias.Backward), this.createPositionRef(end, Position.Bias.Forward));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$1800(JavaEditor x0, FileSystem x1) {
        x0.fileSystemChanged(x1);
    }

    static /* synthetic */ void access$1900(JavaEditor x0, PropertyChangeEvent x1) {
        x0.parsingErrorsChanged(x1);
    }

    static {
        StringBuffer sb = new StringBuffer(MAGIC_PREFIX);
        int size = sb.length();
        SECTION_MAGICS = new String[7];
        JavaEditor.SECTION_MAGICS[0] = sb.append("LINE:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[1] = sb.append("BEGIN:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[2] = sb.append("END:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[3] = sb.append("HEADER:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[4] = sb.append("HEADEREND:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[5] = sb.append("FIRST:").toString();
        sb.setLength(size);
        JavaEditor.SECTION_MAGICS[6] = sb.append("LAST:").toString();
        SECTION_COMPARATOR = new GuardedPositionComparator();
    }

    private static class WParsingListener
    extends WeakReference
    implements Parsing.Listener,
    Runnable {
        WParsingListener(Parsing.Listener orig) {
            super(orig, Utilities.activeReferenceQueue());
        }

        public void run() {
            Parsing.removeParsingListener(this);
        }

        Parsing.Listener getListener() {
            Object o = this.get();
            if (o == null) {
                Parsing.removeParsingListener(this);
            }
            return (Parsing.Listener)o;
        }

        public void objectParsed(Parsing.Event evt) {
            Parsing.Listener l = this.getListener();
            if (l != null) {
                l.objectParsed(evt);
            }
        }
    }

    private static class NewLineOutputStream
    extends OutputStream {
        OutputStream stream;
        byte newLineType;

        public NewLineOutputStream(OutputStream stream, byte newLineType) {
            this.stream = stream;
            this.newLineType = newLineType;
        }

        public void write(int b) throws IOException {
            if (b == 10) {
                switch (this.newLineType) {
                    case 1: {
                        this.stream.write(13);
                        break;
                    }
                    case 2: {
                        this.stream.write(13);
                    }
                    case 0: {
                        this.stream.write(10);
                    }
                }
            } else {
                this.stream.write(b);
            }
        }
    }

    static class GuardedWriter
    extends Writer {
        BufferedWriter writer;
        Iterator sections;
        SectionDesc current;
        int offsetCounter;
        boolean wasNewLine;

        GuardedWriter(OutputStream os, ArrayList list, String encoding) throws IOException {
            this.writer = encoding == null ? new BufferedWriter(new OutputStreamWriter(os)) : new BufferedWriter(new OutputStreamWriter(os, encoding));
            this.offsetCounter = 0;
            this.sections = this.prepareSections(list);
            this.nextSection();
            this.wasNewLine = false;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                this.writeOneChar(cbuf[i + off]);
                ++i;
            }
        }

        public void close() throws IOException {
            this.writer.flush();
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        private Iterator prepareSections(ArrayList list) {
            LinkedList<SectionDesc> dest = new LinkedList<SectionDesc>();
            Collections.sort(list, new GuardedPositionComparator());
            Iterator it = ((AbstractList)list).iterator();
            while (it.hasNext()) {
                SectionDesc desc;
                GuardedSection o = (GuardedSection)it.next();
                if (o instanceof SimpleSection) {
                    desc = new SectionDesc(0);
                    desc.name = o.name;
                    desc.begin = ((SimpleSection)o).bounds.getBegin().getOffset();
                    desc.end = ((SimpleSection)o).bounds.getEnd().getOffset();
                    dest.add(desc);
                    continue;
                }
                desc = new SectionDesc(3);
                desc.begin = ((InteriorSection)o).header.getBegin().getOffset();
                desc.end = ((InteriorSection)o).header.getEnd().getOffset();
                desc.name = o.name;
                dest.add(desc);
                desc = new SectionDesc(2);
                desc.begin = ((InteriorSection)o).bottom.getBegin().getOffset();
                desc.end = ((InteriorSection)o).bottom.getEnd().getOffset();
                desc.name = o.name;
                dest.add(desc);
            }
            return dest.iterator();
        }

        void writeOneChar(int b) throws IOException {
            if (b == 13) {
                return;
            }
            if (this.current != null) {
                if (this.offsetCounter == this.current.begin) {
                    this.wasNewLine = false;
                }
                if (b == 10 && this.current.begin <= this.offsetCounter) {
                    switch (this.current.type) {
                        case 0: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(0, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(1, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(2, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 3: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(5, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(5, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(4, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 2: {
                            this.writeMagic(6, this.current.name);
                            this.nextSection();
                        }
                    }
                }
            }
            this.writer.write(b);
            ++this.offsetCounter;
        }

        private void nextSection() {
            this.current = this.sections.hasNext() ? this.sections.next() : null;
        }

        private void writeMagic(int type, String name) throws IOException {
            this.writer.write(SECTION_MAGICS[type], 0, SECTION_MAGICS[type].length());
            this.writer.write(name, 0, name.length());
        }
    }

    static class GuardedReader
    extends Reader {
        Reader reader;
        char[] charBuff;
        char[] readBuff;
        int howmany;
        RE magicsAsRE;
        boolean justFilter;
        int position;
        LinkedList list;
        final int[] newLineTypes;

        GuardedReader(InputStream is, boolean justFilter) throws IOException {
            this(is, justFilter, null);
        }

        GuardedReader(InputStream is, boolean justFilter, String encoding) throws IOException {
            this.reader = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
            this.justFilter = justFilter;
            this.position = 0;
            this.list = new LinkedList();
            this.newLineTypes = new int[]{0, 0, 0};
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.charBuff == null) {
                this.readCharBuff();
                this.translateToCharBuff();
            }
            if (this.howmany <= 0) {
                return -1;
            }
            int min = Math.min(len, this.howmany);
            System.arraycopy(this.charBuff, this.position, cbuf, off, min);
            this.howmany -= min;
            this.position += min;
            return min;
        }

        final void readCharBuff() throws IOException {
            int read;
            char[] tmp = new char[2048];
            ArrayList<char[]> buffs = new ArrayList<char[]>(20);
            while (true) {
                read = this.readFully(tmp);
                buffs.add(tmp);
                if (read < 2048) break;
                tmp = new char[2048];
            }
            int listsize = buffs.size() - 1;
            int size = listsize * 2048 + read;
            this.readBuff = new char[size];
            this.charBuff = new char[size];
            int copy = 0;
            int i = 0;
            while (i < listsize) {
                char[] tmp2 = (char[])buffs.get(i);
                System.arraycopy(tmp2, 0, this.readBuff, copy, 2048);
                copy += 2048;
                ++i;
            }
            System.arraycopy(tmp, 0, this.readBuff, copy, read);
        }

        final int readFully(char[] buff) throws IOException {
            int read = 0;
            int sum = 0;
            while ((sum += (read = this.reader.read(buff, sum, buff.length - sum))) < buff.length && read > 0) {
            }
            return sum + 1;
        }

        final void translateToCharBuff() {
            char c;
            this.position = 0;
            int charBuffPtr = 0;
            int stop = this.readBuff.length - 1;
            int i = 0;
            int lastNewLine = 0;
            int fatpos = 0;
            int MAGICLEN = JavaEditor.MAGIC_PREFIX.length();
            while (i < stop) {
                int searchLen;
                CharacterArrayCharacterIterator chi;
                c = this.readBuff[i];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[charBuffPtr++] = 10;
                        lastNewLine = charBuffPtr;
                        ++i;
                        break;
                    }
                    case '\r': {
                        char c2 = this.readBuff[i + 1];
                        if (c2 != '\n') {
                            this.newLineTypes[1] = this.newLineTypes[1] + 1;
                            ++i;
                        } else {
                            i += 2;
                            this.newLineTypes[2] = this.newLineTypes[2] + 1;
                        }
                        this.charBuff[charBuffPtr++] = 10;
                        lastNewLine = charBuffPtr;
                        break;
                    }
                    default: {
                        this.charBuff[charBuffPtr++] = this.readBuff[i++];
                    }
                }
                switch (fatpos) {
                    case 0: {
                        if (c == '/') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 1: {
                        if (c == '/') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 2: {
                        if (c == 'G') {
                            ++fatpos;
                            break;
                        }
                        if (c == '/') {
                            fatpos = 2;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 3: {
                        if (c == 'E') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 4: {
                        if (c == 'N') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    case 5: {
                        if (c == '-') {
                            ++fatpos;
                            break;
                        }
                        fatpos = 0;
                        break;
                    }
                    default: {
                        fatpos = 0;
                    }
                }
                if (fatpos != MAGICLEN) continue;
                fatpos = 0;
                RE magics = this.getMagicsAsRE();
                if (!magics.match((CharacterIterator)(chi = new CharacterArrayCharacterIterator(this.readBuff, i, searchLen = Math.min(10, this.readBuff.length - i))), 0)) continue;
                String match = magics.getParen(0).toString();
                charBuffPtr -= JavaEditor.MAGIC_PREFIX.length();
                i += match.length();
                if (!this.justFilter) {
                    int type = GuardedReader.string2Type(match);
                    SectionDesc desc = new SectionDesc(type);
                    int start = charBuffPtr + SECTION_MAGICS[type].length();
                    desc.begin = lastNewLine;
                    desc.end = charBuffPtr + 1;
                    int toNl = this.toNewLine(i);
                    desc.name = new String(this.readBuff, i, toNl);
                    this.list.add(desc);
                    i += toNl;
                    continue;
                }
                i += this.toNewLine(i);
            }
            if (i == stop) {
                c = this.readBuff[i];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[charBuffPtr++] = 10;
                        break;
                    }
                    case '\r': {
                        this.newLineTypes[1] = this.newLineTypes[1] + 1;
                        this.charBuff[charBuffPtr++] = 10;
                        break;
                    }
                    default: {
                        this.charBuff[charBuffPtr++] = this.readBuff[i++];
                    }
                }
            }
            if (!this.justFilter && this.list.size() > 0) {
                SectionDesc desc = (SectionDesc)this.list.getLast();
                if (desc.end > charBuffPtr) {
                    desc.end = charBuffPtr;
                }
            }
            this.howmany = charBuffPtr;
            this.readBuff = null;
        }

        static int string2Type(String match) {
            StringBuffer sb = new StringBuffer(JavaEditor.MAGIC_PREFIX);
            sb.append(match);
            match = sb.toString();
            int len = SECTION_MAGICS.length;
            int i = 0;
            while (i < len) {
                if (match.equals(SECTION_MAGICS[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        final int toNewLine(int i) {
            int counter = i;
            int len = this.readBuff.length;
            while (counter < len) {
                char c;
                if ((c = this.readBuff[counter++]) != '\r' && c != '\n') continue;
                --counter;
                break;
            }
            return counter - i;
        }

        final RE getMagicsAsRE() {
            if (this.magicsAsRE == null) {
                try {
                    RECompiler rec = new RECompiler();
                    this.magicsAsRE = new RE(rec.compile(this.makeOrRegexp()));
                }
                catch (RESyntaxException e) {
                    throw new IllegalStateException();
                }
            }
            return this.magicsAsRE;
        }

        final String makeOrRegexp() {
            StringBuffer sb = new StringBuffer(100);
            int len = JavaEditor.MAGIC_PREFIX.length();
            int slen = SECTION_MAGICS.length - 1;
            int i = 0;
            while (i < slen) {
                sb.append(SECTION_MAGICS[i].substring(len));
                sb.append('|');
                ++i;
            }
            sb.append(SECTION_MAGICS[slen].substring(len));
            return sb.toString();
        }

        byte getNewLineType() {
            if (this.newLineTypes[0] == this.newLineTypes[1] && this.newLineTypes[1] == this.newLineTypes[2]) {
                String s = System.getProperty("line.separator");
                if ("\r".equals(s)) {
                    return 1;
                }
                if ("\r\n".equals(s)) {
                    return 2;
                }
                return 0;
            }
            if (this.newLineTypes[0] > this.newLineTypes[1]) {
                return this.newLineTypes[0] > this.newLineTypes[2] ? (byte)0 : 2;
            }
            return this.newLineTypes[1] > this.newLineTypes[2] ? (byte)1 : 2;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class SectionDesc {
        int type;
        String name;
        int begin;
        int end;

        SectionDesc(int type) {
            this.type = type;
            this.name = null;
            this.begin = 0;
            this.end = 0;
        }
    }

    private static class GuardedPositionComparator
    implements Comparator {
        private GuardedPositionComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.getOffset(o1) - this.getOffset(o2);
        }

        private int getOffset(Object o) {
            if (o instanceof SimpleSection) {
                return ((SimpleSection)o).bounds.getBegin().getOffset();
            }
            return ((InteriorSection)o).header.getBegin().getOffset();
        }
    }

    private class JavaEditorChangeListener
    implements ChangeListener {
        private RepositoryListener repListener;
        private PropertyChangeListener settingListener;

        private JavaEditorChangeListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            JavaSettings js = JavaSettings.getDefault();
            if (this.repListener == null) {
                this.repListener = new RepositoryListener(this){
                    private final /* synthetic */ JavaEditorChangeListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void fileSystemAdded(RepositoryEvent ev2) {
                        JavaEditor.access$1800(JavaEditorChangeListener.access$1700(this.this$1), ev2.getFileSystem());
                    }

                    public void fileSystemRemoved(RepositoryEvent ev2) {
                        JavaEditor.access$1800(JavaEditorChangeListener.access$1700(this.this$1), ev2.getFileSystem());
                    }

                    public void fileSystemPoolReordered(RepositoryReorderedEvent ev2) {
                        JavaEditor.access$1800(JavaEditorChangeListener.access$1700(this.this$1), null);
                    }
                };
            }
            if (this.settingListener == null) {
                this.settingListener = new PropertyChangeListener(this){
                    private final /* synthetic */ JavaEditorChangeListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("parsingErrors".equals(evt.getPropertyName())) {
                            JavaEditor.access$1900(JavaEditorChangeListener.access$1700(this.this$1), evt);
                        }
                    }
                };
            }
            if (repository == null) {
                repository = Repository.getDefault();
            }
            repository.removeRepositoryListener(this.repListener);
            js.removePropertyChangeListener(this.settingListener);
            if (JavaEditor.this.isDocumentLoaded()) {
                repository.addRepositoryListener(this.repListener);
                js.addPropertyChangeListener(this.settingListener);
            }
        }

        static /* synthetic */ JavaEditor access$1700(JavaEditorChangeListener x0) {
            return x0.JavaEditor.this;
        }
    }

    public final class InteriorSection
    extends GuardedSection {
        PositionBounds header;
        PositionBounds body;
        PositionBounds bottom;

        InteriorSection(String name, PositionBounds header, PositionBounds body, PositionBounds bottom) {
            super(name);
            this.header = header;
            this.body = body;
            this.bottom = bottom;
        }

        public boolean setBody(String text) {
            return this.setText(this.body, text, false);
        }

        public boolean setHeader(String text) {
            return this.setText(this.header, text, true);
        }

        public String getHeader() {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.header.getText();
            }
            catch (IOException ex) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public boolean setBottom(String text) {
            int lastEol;
            boolean endsWithEol = text.endsWith("\n");
            int firstEol = text.indexOf(10);
            if (firstEol != (lastEol = text.lastIndexOf(10)) || endsWithEol && firstEol != -1) {
                if (endsWithEol) {
                    text = text.substring(0, text.length() - 1);
                }
                text = text.replace('\n', ' ');
            }
            return this.setText(this.bottom, text, true);
        }

        public String getBottom() throws IOException, BadLocationException {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.bottom.getText();
            }
            catch (IOException ex) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public PositionRef getBegin() {
            return this.body.getBegin();
        }

        void deleteText() throws BadLocationException, IOException {
            this.header.setText("");
            this.body.setText("");
            this.bottom.setText("");
            this.deleteNewLineBeforeBlock(this.header.getBegin().getOffset());
        }

        void markGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.header, true);
            this.markGuarded(doc, this.bottom, true);
        }

        void unmarkGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.header, false);
            this.markGuarded(doc, this.bottom, false);
            JavaEditor.super.notifyModified();
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            try {
                buf.append(this.header.getText());
                buf.append(this.body.getText());
                buf.append(this.bottom.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return buf.toString();
        }

        public boolean contains(PositionRef pos, boolean allowHoles) {
            if (!allowHoles) {
                return this.header.getBegin().getOffset() <= pos.getOffset() && this.bottom.getEnd().getOffset() >= pos.getOffset();
            }
            if (this.header.getBegin().getOffset() <= pos.getOffset() && this.header.getEnd().getOffset() >= pos.getOffset()) {
                return true;
            }
            return this.bottom.getBegin().getOffset() <= pos.getOffset() && this.bottom.getEnd().getOffset() >= pos.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.header.getBegin().getOffset(), Position.Bias.Forward);
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bottom.getEnd().getOffset(), Position.Bias.Backward);
        }
    }

    public final class SimpleSection
    extends GuardedSection {
        PositionBounds bounds;

        SimpleSection(String name, PositionBounds bounds) {
            super(name);
            this.bounds = bounds;
        }

        public boolean setText(String text) {
            return this.setText(this.bounds, text, true);
        }

        void deleteText() throws BadLocationException, IOException {
            this.bounds.setText("");
            this.deleteNewLineBeforeBlock(this.bounds.getBegin().getOffset());
        }

        void markGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.bounds, true);
        }

        void unmarkGuarded(StyledDocument doc) {
            this.markGuarded(doc, this.bounds, false);
            JavaEditor.super.notifyModified();
        }

        public PositionRef getBegin() {
            return this.bounds.getBegin();
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            try {
                buf.append(this.bounds.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return buf.toString();
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bounds.getEnd().getOffset(), Position.Bias.Backward);
        }

        public boolean contains(PositionRef pos, boolean allowHoles) {
            return this.bounds.getBegin().getOffset() <= pos.getOffset() && this.bounds.getEnd().getOffset() >= pos.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.bounds.getBegin().getOffset(), Position.Bias.Forward);
        }
    }

    public abstract class GuardedSection {
        String name;
        boolean valid;

        public String getName() {
            return this.name;
        }

        GuardedSection(String name) {
            this.name = name;
            this.valid = true;
        }

        public void setName(String name) throws PropertyVetoException {
            if (!this.name.equals(name)) {
                JavaEditor javaEditor = JavaEditor.this;
                synchronized (javaEditor) {
                    if (this.valid) {
                        if (JavaEditor.this.sections.get(name) != null) {
                            throw new PropertyVetoException("", new PropertyChangeEvent(this, "name", this.name, name));
                        }
                        JavaEditor.this.sections.remove(this.name);
                        this.name = name;
                        JavaEditor.this.sections.put(name, this);
                    }
                }
            }
        }

        public boolean deleteSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                if (this.valid) {
                    try {
                        JavaEditor.this.sections.remove(this.name);
                        this.unmarkGuarded(JavaEditor.this.getDocument());
                        this.deleteText();
                        this.valid = false;
                        boolean bl = true;
                        return bl;
                    }
                    catch (BadLocationException e) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                boolean bl = false;
                return bl;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean removeSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                if (!this.valid) {
                    boolean bl = false;
                    return bl;
                }
                JavaEditor.this.sections.remove(this.name);
                this.unmarkGuarded(JavaEditor.this.getDocument());
                this.valid = false;
                boolean bl = true;
                return bl;
            }
        }

        void deleteNewLineBeforeBlock(int offset) {
            if (offset > 1) {
                try {
                    PositionBounds b = JavaEditor.this.createBounds(offset - 1, offset, true);
                    String s = b.getText();
                    if (s.equals("\n")) {
                        b.setText("");
                    }
                }
                catch (IOException e) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void openAt() {
            JavaEditor.this.openAt(this.getBegin());
        }

        protected boolean setText(PositionBounds bounds, String text, boolean minLen) {
            if (!this.valid) {
                return false;
            }
            if (minLen) {
                if (text.length() == 0) {
                    text = " \n";
                } else if (text.length() == 1) {
                    String string = text = text.equals("\n") ? " \n" : text + "\n";
                }
            }
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            try {
                bounds.setText(text);
                return true;
            }
            catch (BadLocationException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }

        void markGuarded(StyledDocument doc, PositionBounds bounds, boolean mark) {
            int begin = bounds.getBegin().getOffset();
            int end = bounds.getEnd().getOffset();
            if (mark) {
                NbDocument.markGuarded((StyledDocument)doc, (int)begin, (int)(end - begin));
            } else {
                NbDocument.unmarkGuarded((StyledDocument)doc, (int)begin, (int)(end - begin));
            }
        }

        abstract void markGuarded(StyledDocument var1);

        abstract void unmarkGuarded(StyledDocument var1);

        abstract void deleteText() throws BadLocationException, IOException;

        public abstract PositionRef getBegin();

        public abstract String getText();

        public abstract boolean contains(PositionRef var1, boolean var2);

        public abstract PositionRef getPositionAfter();

        public abstract PositionRef getPositionBefore();
    }

    public static class JavaEditorComponent
    extends EditorSupport.Editor {
        static final int SELECTED_NODES_DELAY = 1000;
        Timer timerSelNodes;
        JavaEditor support;
        CaretListener caretListener;
        Parsing.Listener parsingListener;
        Component toolBar;
        int lastCaretOffset = -1;
        static final long serialVersionUID = 6223349196427270209L;
        private transient RequestProcessor.Task selectionTask = null;
        static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
        static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;

        public JavaEditorComponent() {
        }

        public JavaEditorComponent(DataObject obj) {
            super(obj);
            this.initialize();
        }

        void selectElementsAtOffset(int offset) {
            Node[] nodeArray;
            SourceElement.Impl holder = this.support.findParser().getSourceImpl();
            if (holder == null) {
                return;
            }
            if (TopComponent.getRegistry().getActivated() != this || !JavaEditor.super.findDataObject().isValid()) {
                return;
            }
            SourceCookie.Editor seditor = (SourceCookie.Editor)JavaEditor.super.findDataObject().getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = JavaEditorComponent.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
            org.openide.src.Element element = seditor.findElement(offset);
            ElementNodeFactory factory = JavaDataObject.getExplorerFactory();
            Node n = null;
            if (element instanceof MethodElement) {
                n = factory.createMethodNode((MethodElement)element);
            } else if (element instanceof ClassElement) {
                n = factory.createClassNode((ClassElement)element);
            } else if (element instanceof ConstructorElement) {
                n = factory.createConstructorNode((ConstructorElement)element);
            } else if (element instanceof FieldElement) {
                n = factory.createFieldNode((FieldElement)element);
            } else if (element instanceof InitializerElement) {
                n = factory.createInitializerNode((InitializerElement)element);
            } else if (element instanceof SourceElement) {
                n = JavaEditor.super.findDataObject().getNodeDelegate();
            }
            if (n != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            } else {
                nodeArray = new Node[]{};
            }
            this.setActivatedNodes(nodeArray);
        }

        protected void notifyParsingDone() {
            if (this.lastCaretOffset != -1) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ JavaEditorComponent this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        this.this$0.selectElementsAtOffset(this.this$0.lastCaretOffset);
                    }
                });
            }
        }

        public SystemAction[] getSystemActions() {
            this.selectElementsAtOffset(this.lastCaretOffset);
            this.timerSelNodes.stop();
            return super.getSystemActions();
        }

        private void initialize() {
            this.support = (JavaEditor)this.obj.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = JavaEditorComponent.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor);
            this.timerSelNodes = new Timer(100, new ActionListener(this){
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    Caret caret;
                    if (this.this$0.lastCaretOffset == -1 && JavaEditorComponent.access$901(this.this$0) != null && (caret = JavaEditorComponent.access$1001(this.this$0).getCaret()) != null) {
                        this.this$0.lastCaretOffset = caret.getDot();
                    }
                    this.this$0.selectElementsAtOffset(this.this$0.lastCaretOffset);
                }
            });
            this.timerSelNodes.setInitialDelay(100);
            this.timerSelNodes.setRepeats(false);
            this.caretListener = new CaretListener(this){
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = this$0;
                }

                public void caretUpdate(CaretEvent e) {
                    this.this$0.support.restartTimer(true);
                    this.this$0.restartTimerSelNodes(e.getDot());
                }
            };
            this.timerSelNodes.restart();
            this.parsingListener = new Parsing.Listener(this){
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = this$0;
                }

                public void objectParsed(Parsing.Event info) {
                    if (info.getSource() == JavaEditorComponent.access$1101(this.this$0)) {
                        this.this$0.notifyParsingDone();
                    }
                }
            };
            this.support.attachParsingListener();
            ((JComponent)((Object)this)).getActionMap().put("org.netbeans.modules.debugger.support.actions.ToggleBreakpointAction", new ToggleBreakpointAction());
        }

        void restartTimerSelNodes(int pos) {
            this.timerSelNodes.setInitialDelay(1000);
            this.timerSelNodes.restart();
            this.lastCaretOffset = pos;
        }

        private JEditorPane getEditorPane() {
            return ((CloneableEditor)this).pane;
        }

        protected CloneableTopComponent createClonedObject() {
            return this.support.createJavaEditorComponent();
        }

        protected void componentActivated() {
            JEditorPane p = this.getEditorPane();
            if (p != null) {
                p.addCaretListener(this.caretListener);
            }
            Parsing.addParsingListener(this.parsingListener);
            super.componentActivated();
            if (p != null) {
                p.requestFocus();
            }
            if (!this.support.hasAnnotations) {
                this.support.parseSource(1, true);
            }
        }

        public void requestFocus() {
            super.requestFocus();
            JEditorPane p = this.getEditorPane();
            if (p != null) {
                p.requestFocus();
            }
        }

        protected void componentDeactivated() {
            JEditorPane p = this.getEditorPane();
            if (p != null) {
                p.removeCaretListener(this.caretListener);
            }
            Parsing.removeParsingListener(this.parsingListener);
            JavaEditorComponent javaEditorComponent = this;
            synchronized (javaEditorComponent) {
                if (this.selectionTask != null) {
                    this.selectionTask.cancel();
                    this.selectionTask = null;
                }
            }
            super.componentDeactivated();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ JEditorPane access$901(JavaEditorComponent x0) {
            return ((CloneableEditor)x0).pane;
        }

        static /* synthetic */ JEditorPane access$1001(JavaEditorComponent x0) {
            return ((CloneableEditor)x0).pane;
        }

        static /* synthetic */ DataObject access$1101(JavaEditorComponent x0) {
            return x0.obj;
        }

        private final class ToggleBreakpointAction
        extends AbstractAction
        implements LookupListener {
            private final Lookup.Result debuggerR = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = ToggleBreakpointAction.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger));
            static /* synthetic */ Class class$org$openide$debugger$Debugger;
            static /* synthetic */ Class class$org$openide$util$LookupListener;

            public ToggleBreakpointAction() {
                this.debuggerR.addLookupListener((LookupListener)WeakListener.create((Class)(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = ToggleBreakpointAction.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener), (EventListener)this, (Object)this.debuggerR));
                this.resultChanged(null);
            }

            public void actionPerformed(ActionEvent e) {
                int lineNumber = NbDocument.findLineNumber((StyledDocument)JavaEditorComponent.this.support.getDocument(), (int)JavaEditorComponent.this.getEditorPane().getCaret().getDot());
                Line line = JavaEditorComponent.this.support.getLineSet().getCurrent(lineNumber);
                ToggleBreakpointAction toggleBreakpointAction = this;
                synchronized (toggleBreakpointAction) {
                    Iterator it = this.debuggerR.allInstances().iterator();
                    if (it.hasNext()) {
                        Debugger debugger = (Debugger)it.next();
                        Breakpoint breakpoint = debugger.findBreakpoint(line);
                        if (breakpoint == null) {
                            debugger.createBreakpoint(line);
                        } else {
                            breakpoint.remove();
                        }
                    }
                }
            }

            public void resultChanged(LookupEvent e) {
                this.setEnabled(!this.debuggerR.allInstances().isEmpty());
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

