/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.openide.cookies.ArgumentsCookie;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public final class JavaProcessExecutor
extends ProcessExecutor {
    private static final long serialVersionUID = 1449216248334461454L;
    private static final NbClassPath EMPTY_CLASSPATH = new NbClassPath("");
    public static final String PROP_ASSERT_ENABLED = "assertEnabled";
    private transient boolean classPathSet;
    private transient boolean bootClassPathSet;
    private boolean assertEnabled = false;
    static /* synthetic */ Class class$org$openide$execution$ProcessExecutor;

    public synchronized NbProcessDescriptor getExternalExecutor() {
        if (this.externalExecutor == null) {
            this.externalExecutor = new NbProcessDescriptor("{java.home}{/}bin{/}java", "{assertEnabled} -cp {filesystems}{:}{classpath} {classname} {arguments}", NbBundle.getBundle((Class)(class$org$openide$execution$ProcessExecutor == null ? (class$org$openide$execution$ProcessExecutor = JavaProcessExecutor.class$("org.openide.execution.ProcessExecutor")) : class$org$openide$execution$ProcessExecutor)).getString("MSG_ExecutorHint"));
        }
        return this.externalExecutor;
    }

    public void setClassPath(NbClassPath cp) {
        if (EMPTY_CLASSPATH.equals((Object)cp)) {
            cp = null;
        }
        this.classPathSet = cp != null;
        super.setClassPath(cp);
    }

    public void setBootClassPath(NbClassPath bcp) {
        if (EMPTY_CLASSPATH.equals((Object)bcp)) {
            bcp = null;
        }
        this.bootClassPathSet = bcp != null;
        super.setBootClassPath(bcp);
    }

    public NbClassPath getClassPath() {
        return this.classPathSet ? super.getClassPath() : EMPTY_CLASSPATH;
    }

    public NbClassPath getBootClassPath() {
        return this.bootClassPathSet ? super.getBootClassPath() : EMPTY_CLASSPATH;
    }

    public boolean isAssertEnabled() {
        return this.assertEnabled;
    }

    public void setAssertEnabled(boolean assertFlag) {
        this.assertEnabled = assertFlag;
    }

    private final Class getKlass(String name) {
        try {
            return Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getLocalizedMessage());
        }
    }

    protected Process createProcess(ExecInfo info) throws IOException {
        String cName = info.getClassName();
        String[] params = info.getArguments();
        return this.getExternalExecutor().exec((java.text.Format)((Object)new Format(cName, params, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.isAssertEnabled())), this.getEnvironmentVariables(), this.getAppendEnvironmentVariables(), this.getWorkingDirectory());
    }

    protected Process createProcess(DataObject obj) throws IOException {
        ArgumentsCookie ac = (ArgumentsCookie)obj.getCookie(this.getKlass("org.openide.cookies.ArgumentsCookie"));
        String[] params = ac != null ? ac.getArguments() : new String[]{};
        String pName = obj.getPrimaryFile().getParent().getPath().replace('/', '.');
        String cName = (pName.length() == 0 ? "" : pName + ".") + obj.getPrimaryFile().getName();
        return this.getExternalExecutor().exec((java.text.Format)((Object)new Format(cName, params, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.isAssertEnabled())), this.getEnvironmentVariables(), this.getAppendEnvironmentVariables(), this.getWorkingDirectory());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.java.JavaProcessExecutor");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Field f = (class$org$openide$execution$ProcessExecutor == null ? (class$org$openide$execution$ProcessExecutor = JavaProcessExecutor.class$("org.openide.execution.ProcessExecutor")) : class$org$openide$execution$ProcessExecutor).getDeclaredField("classPath");
            ((AccessibleObject)f).setAccessible(true);
            this.classPathSet = f.get((Object)this) != null;
            f = (class$org$openide$execution$ProcessExecutor == null ? (class$org$openide$execution$ProcessExecutor = JavaProcessExecutor.class$("org.openide.execution.ProcessExecutor")) : class$org$openide$execution$ProcessExecutor).getDeclaredField("bootClassPath");
            ((AccessibleObject)f).setAccessible(true);
            this.bootClassPathSet = f.get((Object)this) != null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Format
    extends MapFormat {
        public static final String TAG_ASSERT_ENABLED = "assertEnabled";
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_CLASSNAME = "classname";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = -1524637220865300100L;

        public Format(String className, String[] args, NbClassPath classPath, NbClassPath bootClassPath, NbClassPath repository, NbClassPath library, boolean isAssertEnabled) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, classPath.getClassPath());
            map.put(TAG_BOOTCLASSPATH, bootClassPath.getClassPath());
            map.put(TAG_REPOSITORY, repository.getClassPath());
            map.put(TAG_LIBRARY, library.getClassPath());
            map.put(TAG_CLASSNAME, className);
            map.put(TAG_JAVAHOME, System.getProperty(TAG_JAVAHOME));
            map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            map.put(TAG_SEPARATOR, File.separator);
            map.put(TAG_PATHSEPARATOR, File.pathSeparator);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                sb.append('\"');
                sb.append(args[i]);
                sb.append('\"');
                sb.append(' ');
                ++i;
            }
            map.put(TAG_ARGUMENTS, sb.toString());
            map.put("assertEnabled", isAssertEnabled ? "-ea " : "");
        }
    }
}

