/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.OperationAdapter;
import org.openide.loaders.OperationEvent;
import org.openide.util.Utilities;

class PackageHandler
extends OperationAdapter {
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;

    PackageHandler() {
    }

    public void operationRename(OperationEvent.Rename ev) {
        DataObject obj = ev.getObject();
        DataFolder fld = (DataFolder)obj.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PackageHandler.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (fld == null || fld != obj || obj.getName().equals(ev.getOriginalName())) {
            return;
        }
        FileObject fo = obj.getPrimaryFile().getParent();
        String prefix = fo.getPackageName('.');
        if (!fo.isRoot() && !Utilities.isJavaIdentifier((String)prefix) || !Utilities.isJavaIdentifier((String)ev.getOriginalName())) {
            return;
        }
        if (!this.discoverJavaSources(fld)) {
            return;
        }
        if (!Utilities.isJavaIdentifier((String)obj.getName())) {
            this.warnIllegalName(obj, obj.getName(), ev.getOriginalName());
            return;
        }
        this.handlePackageRename(fld, ev.getOriginalName());
    }

    boolean discoverJavaSources(DataFolder f) {
        LinkedList<FileObject> c = new LinkedList<FileObject>();
        c.add(f.getPrimaryFile());
        return this.discoverJavaSources(c);
    }

    boolean discoverJavaSources(List folders) {
        while (!folders.isEmpty()) {
            FileObject fld = (FileObject)folders.remove(0);
            FileObject[] children = fld.getChildren();
            int i = 0;
            while (i < children.length) {
                FileObject f = children[i];
                if (!f.isFolder()) {
                    if ("java".equals(f.getExt())) {
                        try {
                            DataObject target = DataObject.find((FileObject)f);
                            if (target.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? PackageHandler.class$("org.openide.cookies.SourceCookie$Editor") : class$org$openide$cookies$SourceCookie$Editor) != null) {
                                return true;
                            }
                        }
                        catch (DataObjectNotFoundException ex) {}
                    }
                } else {
                    folders.add(f);
                }
                ++i;
            }
        }
        return false;
    }

    protected void handlePackageRename(DataFolder parent, String originalName) {
        FileObject parent2 = parent.getPrimaryFile().getParent();
        String parentName = parent2.isRoot() ? "" : parent2.getPackageName('.') + ".";
        String message = MessageFormat.format(Util.getString("FMT_RenameConfirmation"), parentName + originalName, parentName + parent.getName());
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, 0, 1);
        SwingUtilities.invokeLater(new Runnable((NotifyDescriptor)desc, parent, originalName){
            private final /* synthetic */ NotifyDescriptor val$desc;
            private final /* synthetic */ DataFolder val$parent;
            private final /* synthetic */ String val$originalName;
            {
                this.val$desc = val$desc;
                this.val$parent = val$parent;
                this.val$originalName = val$originalName;
            }

            public void run() {
                if (DialogDisplayer.getDefault().notify(this.val$desc) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                PackageHandler.this.repackage(this.val$parent, this.val$originalName);
            }
        });
    }

    private void warnIllegalName(DataObject pack, String newName, String oldName) {
        String fNewName;
        FileObject fo = pack.getPrimaryFile().getParent();
        String prefix = fo.getPackageName('.');
        if (!"".equals(prefix)) {
            fNewName = prefix + "." + newName;
            oldName = prefix + "." + oldName;
        } else {
            fNewName = newName;
        }
        String message = MessageFormat.format(Util.getString("FMT_RenameIllegalPackage"), oldName, fNewName, newName);
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 2);
        SwingUtilities.invokeLater(new Runnable((NotifyDescriptor)desc){
            private final /* synthetic */ NotifyDescriptor val$desc;
            {
                this.val$desc = val$desc;
            }

            public void run() {
                DialogDisplayer.getDefault().notify(this.val$desc);
            }
        });
    }

    private void repackage(DataFolder parent, String oldName) {
        DataObject[] children = parent.getChildren();
        LinkedList<DataFolder> subfolders = null;
        int i = 0;
        while (i < children.length) {
            DataFolder subfolder = (DataFolder)children[i].getCookie(class$org$openide$loaders$DataFolder == null ? PackageHandler.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (subfolder != null) {
                if (subfolders == null) {
                    subfolders = new LinkedList<DataFolder>();
                }
                subfolders.add(subfolder);
            } else {
                JavaDataObject jdo = (JavaDataObject)children[i].getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? PackageHandler.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
                if (jdo != null) {
                    JavaDataObject.updateSource(jdo, jdo.getPrimaryFile(), jdo.getPrimaryFile().getName(), true);
                }
            }
            ++i;
        }
        if (subfolders != null) {
            Iterator it = subfolders.iterator();
            while (it.hasNext()) {
                this.repackage((DataFolder)it.next(), oldName);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

