/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codegen;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.codegen.ElementBinding;
import org.netbeans.modules.java.codegen.SourceText;
import org.openide.src.SourceException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.IndentEngine;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

class CodeGenerator {
    static final int BOUNDS_ALL = 0;
    static final int BOUNDS_JAVADOC = 1;
    static final int BOUNDS_HEADER = 2;
    static final int BOUNDS_BODY = 3;
    static final int BOUNDS_PACKAGE = 10;
    static final int BOUNDS_IMPORT = 11;

    CodeGenerator() {
    }

    static Writer findIndentWriter(Document doc, int offset, Writer writer) {
        if (Boolean.getBoolean("org.netbeans.modules.java.DontUseIndentEngine")) {
            return new FilterWriter(writer){};
        }
        IndentEngine engine = IndentEngine.find((Document)doc);
        return engine.createWriter(doc, offset, writer);
    }

    static StyledDocument getDocument(ElementBinding b) throws SourceException {
        return CodeGenerator.getDocument(b.wholeBounds.getBegin());
    }

    static StyledDocument getDocument(PositionRef pos) throws SourceException {
        try {
            CloneableEditorSupport supp = pos.getCloneableEditorSupport();
            return supp.openDocument();
        }
        catch (IOException ex) {
            SourceText.rethrowException(ex);
            return null;
        }
    }

    static final void fillTextBounds(PositionBounds range, String text) throws BadLocationException, IOException {
        range.setText(text);
    }

    static final String readTextBounds(PositionBounds range) throws SourceException {
        try {
            return range.getText();
        }
        catch (Exception ex) {
            SourceText.rethrowException(ex);
            return null;
        }
    }

    public static String safeIndent(String text, Document doc, int offset) {
        try {
            StringWriter writer = new StringWriter();
            Writer indentator = CodeGenerator.findIndentWriter(doc, offset, writer);
            indentator.write(text);
            indentator.close();
            return writer.toString();
        }
        catch (Exception ex) {
            return text;
        }
    }

    static PositionBounds createNewLineBounds(PositionRef where, int boundsType) throws SourceException {
        boolean empty = boundsType == 0;
        return CodeGenerator.createNewLineBounds(where, boundsType, empty, empty);
    }

    static PositionBounds createNewLineBounds(PositionRef where, int boundsType, boolean emptyBefore, boolean emptyAfter) throws SourceException {
        CloneableEditorSupport support = where.getCloneableEditorSupport();
        StyledDocument doc = CodeGenerator.getDocument(where);
        try {
            Position.Bias endBias;
            Position.Bias startBias;
            int newBlockOffset;
            int beginText = where.getOffset();
            int lineIndex = NbDocument.findLineNumber((StyledDocument)doc, (int)beginText);
            Element rootElement = NbDocument.findLineRootElement((StyledDocument)doc);
            Element line = rootElement.getElement(lineIndex);
            int lineBegin = line.getStartOffset();
            int lineEnd = line.getEndOffset();
            int myLineIndex = lineIndex;
            String lineText = doc.getText(lineBegin, lineEnd - lineBegin);
            String trimmedText = lineText.trim();
            int textOffset = lineText.lastIndexOf(trimmedText);
            int insertionOffset = beginText - lineBegin;
            if (trimmedText.length() == 0 || textOffset >= insertionOffset) {
                Element prevLine;
                String prevContents;
                if (emptyBefore && lineBegin > 0 && !"".equals(prevContents = doc.getText((prevLine = rootElement.getElement(myLineIndex - 1)).getStartOffset(), prevLine.getEndOffset() - prevLine.getStartOffset()).trim())) {
                    doc.insertString(lineBegin, "\n", null);
                    line = rootElement.getElement(++myLineIndex);
                    lineBegin = line.getStartOffset();
                }
                doc.insertString(lineBegin, CodeGenerator.formatText(doc, lineBegin, "\n"), null);
                String formatted = CodeGenerator.formatText(doc, lineBegin, "\n");
                formatted = formatted.substring(formatted.indexOf(10) + 1);
                doc.insertString(lineBegin, formatted, null);
                newBlockOffset = lineBegin + formatted.length();
            } else if (textOffset + trimmedText.length() <= insertionOffset) {
                boolean includingNewline = emptyBefore;
                if (doc.getLength() >= lineEnd && emptyBefore) {
                    Element nextLine = rootElement.getElement(myLineIndex + 1);
                    String nextContents = doc.getText(nextLine.getStartOffset(), nextLine.getEndOffset() - nextLine.getStartOffset()).trim();
                    if ("".equals(nextContents)) {
                        lineEnd = nextLine.getEndOffset();
                        lineBegin = nextLine.getStartOffset();
                        includingNewline = false;
                    }
                    ++myLineIndex;
                }
                if (doc.getLength() < lineEnd) {
                    String formatted;
                    if (emptyBefore && includingNewline) {
                        formatted = CodeGenerator.formatText(doc, lineEnd - 1, "\n\n");
                        myLineIndex += 2;
                    } else {
                        formatted = CodeGenerator.formatText(doc, lineEnd - 1, "\n");
                        ++myLineIndex;
                    }
                    doc.insertString(lineEnd - 1, formatted, null);
                    newBlockOffset = lineEnd - 1 + formatted.length();
                    myLineIndex += emptyBefore ? 2 : 1;
                } else {
                    String formatted = CodeGenerator.formatText(doc, lineEnd, "\n");
                    if (!includingNewline) {
                        formatted = formatted.substring(formatted.indexOf(10) + 1);
                    }
                    doc.insertString(lineEnd, formatted, null);
                    newBlockOffset = lineEnd + formatted.length();
                    ++myLineIndex;
                    doc.insertString(newBlockOffset, CodeGenerator.formatText(doc, newBlockOffset, "\n"), null);
                }
            } else {
                String formatted;
                if (emptyBefore) {
                    formatted = CodeGenerator.formatText(doc, beginText, "\n\n");
                    ++myLineIndex;
                } else {
                    formatted = CodeGenerator.formatText(doc, beginText, "\n");
                }
                doc.insertString(beginText, formatted, null);
                newBlockOffset = beginText + formatted.length();
                ++myLineIndex;
                doc.insertString(newBlockOffset, CodeGenerator.formatText(doc, newBlockOffset, "\n"), null);
            }
            if (emptyAfter) {
                if (doc.getLength() > newBlockOffset + 1) {
                    line = rootElement.getElement(myLineIndex + 1);
                    lineBegin = line.getStartOffset();
                    lineText = doc.getText(lineBegin, (lineEnd = line.getEndOffset()) - lineBegin);
                    trimmedText = lineText.trim();
                    if (!"".equals(trimmedText)) {
                        doc.insertString(newBlockOffset, "\n", null);
                    }
                } else {
                    doc.insertString(newBlockOffset, "\n", null);
                }
            }
            switch (boundsType) {
                case 3: {
                    startBias = Position.Bias.Forward;
                    endBias = Position.Bias.Backward;
                    break;
                }
                default: {
                    startBias = Position.Bias.Backward;
                    endBias = Position.Bias.Forward;
                }
            }
            PositionRef posBegin = support.createPositionRef(newBlockOffset, startBias);
            PositionRef posEnd = support.createPositionRef(newBlockOffset, endBias);
            PositionBounds blockBounds = new PositionBounds(posBegin, posEnd);
            return blockBounds;
        }
        catch (Exception e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            SourceText.rethrowException(e);
            return null;
        }
    }

    static String normalizeBody(String s, boolean braces) {
        int l = s.length();
        char c = '\u0000';
        char c2 = '\u0000';
        int begin = 0;
        while (begin < l) {
            c = s.charAt(begin);
            if (c == '\n' || c > ' ') break;
            ++begin;
        }
        int end = l - 1;
        while (end >= begin) {
            c2 = s.charAt(end);
            if (c2 == '\n' || c2 > ' ') break;
            --end;
        }
        if (begin > end || begin == end && c == '\n') {
            if (braces) {
                return "{\n}";
            }
            return "\n";
        }
        if (c == '\n' && c2 == '\n' && !braces) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        if (braces) {
            sb.append("{");
        }
        if (c != '\n') {
            sb.append('\n');
        }
        sb.append(s.substring(begin, end + 1));
        if (c2 != '\n') {
            sb.append('\n');
        }
        if (braces) {
            sb.append('}');
        }
        return sb.toString();
    }

    static void clearBounds(PositionBounds bounds, boolean collapseLines) throws BadLocationException {
        StyledDocument doc = bounds.getBegin().getCloneableEditorSupport().getDocument();
        int p1 = bounds.getBegin().getOffset();
        int p2 = bounds.getEnd().getOffset();
        boolean p3 = false;
        doc.remove(p1, p2 - p1);
        int lineIndex = NbDocument.findLineNumber((StyledDocument)doc, (int)p1);
        Element lineRoot = NbDocument.findLineRootElement((StyledDocument)doc);
        int lineCount = lineRoot.getElementCount();
        Element line = lineRoot.getElement(lineIndex);
        p1 = line.getStartOffset();
        p2 = line.getEndOffset();
        try {
            if (doc.getText(p1, p2 - p1).trim().length() != 0) {
                return;
            }
            doc.remove(p1, p2 - p1);
        }
        catch (BadLocationException e) {
            return;
        }
        if (collapseLines) {
            line = lineRoot.getElement(lineIndex);
            try {
                p1 = line.getStartOffset();
                p2 = line.getEndOffset();
                if ("".equals(doc.getText(p1, p2 - line.getStartOffset()).trim())) {
                    doc.remove(p1, p2 - p1);
                } else if (lineIndex > 0 && "".equals(doc.getText(p1 = (line = lineRoot.getElement(lineIndex - 1)).getStartOffset(), (p2 = line.getEndOffset()) - line.getStartOffset()).trim())) {
                    doc.remove(p1, p2 - p1);
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    static String formatText(StyledDocument doc, PositionRef pos, String text) {
        return CodeGenerator.formatText(doc, pos.getOffset(), text);
    }

    static String formatText(StyledDocument doc, int pos, String text) {
        try {
            StringWriter stringWriter = new StringWriter();
            Writer indentWriter = CodeGenerator.findIndentWriter(doc, pos, stringWriter);
            indentWriter.write(text);
            indentWriter.close();
            Object context = null;
            return stringWriter.toString();
        }
        catch (Exception ex) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.err.println("Error in Indentation engine: ");
                ex.printStackTrace(System.err);
            }
            return text;
        }
    }
}

