/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codesync;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openide.src.Element;

public abstract class ChangeCache {
    Set created;
    Map changed;

    public Collection elementsChanged(Map changeMap) {
        LinkedList<Element> changes = null;
        Iterator it = changeMap.entrySet().iterator();
        while (it.hasNext()) {
            Element ancientValue;
            Map.Entry en = it.next();
            Element newValue = this.getNewValue(en);
            Element oldValue = this.getOldValue(en);
            Element ref = this.getEntityReference(en);
            if (!this.isMature(newValue, oldValue)) {
                this.enterChange(ref, oldValue);
                continue;
            }
            boolean c = this.created != null && this.created.remove(ref);
            Element element = ancientValue = c ? null : this.removeChange(ref);
            if (changes == null) {
                changes = new LinkedList<Element>();
            }
            changes.add(ref);
            if (!c && ancientValue == null) {
                changes.add(oldValue);
                continue;
            }
            changes.add(ancientValue);
        }
        return changes;
    }

    private Element getOldValue(Map.Entry en) {
        return (Element)((Object[])en.getValue())[0];
    }

    private Element getNewValue(Map.Entry en) {
        return (Element)((Object[])en.getValue())[1];
    }

    private Element getEntityReference(Map.Entry en) {
        return (Element)en.getKey();
    }

    protected Element removeChange(Element ref) {
        if (this.created != null && this.created.remove(ref)) {
            return null;
        }
        if (this.changed != null) {
            return (Element)this.changed.remove(ref);
        }
        return null;
    }

    protected void enterChange(Element ref, Element oldState) {
        if (this.created != null && this.created.contains(ref)) {
            return;
        }
        if (this.changed != null && this.changed.containsKey(ref)) {
            return;
        }
        if (this.changed == null) {
            this.changed = new HashMap(17);
        }
        this.changed.put(ref, oldState);
    }

    public Collection elementsCreated(Collection col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        LinkedList<Element> changes = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (!this.isMature(el, null)) {
                if (this.created == null) {
                    this.created = new HashSet(11);
                }
                this.created.add(el);
                continue;
            }
            if (changes == null) {
                changes = new LinkedList<Element>();
            }
            changes.add(el);
        }
        return changes;
    }

    public Collection elementsRemoved(Collection rem) {
        if (rem == null || rem.isEmpty()) {
            return null;
        }
        Iterator it = rem.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            this.removeChange(el);
            if (this.created == null) continue;
            this.created.remove(el);
        }
        return rem;
    }

    protected abstract boolean isMature(Element var1, Element var2);
}

