/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codesync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.comparators.JavaElementComparator;
import org.netbeans.modules.java.JavaConnections;
import org.netbeans.modules.java.codesync.Registrar;
import org.netbeans.modules.java.codesync.SourceConnectionSupport;
import org.netbeans.modules.java.model.CommitListener;
import org.netbeans.modules.java.settings.JavaSynchronizationSettings;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class ClassDependencyImpl
implements PropertyChangeListener,
CommitListener {
    private static final int MODIFIERS_ACCESS = 7;
    private static ElementFormat methodFormat;
    private static final boolean DEBUG = false;
    Registrar registrar;
    private JavaSynchronizationSettings SYNC_SETTINGS = null;
    private static Comparator CHANGEITEM_COMPARATOR;
    static /* synthetic */ Class class$org$netbeans$modules$java$settings$JavaSynchronizationSettings;
    static /* synthetic */ Class class$org$openide$src$Element$Impl2;

    public ClassDependencyImpl(Registrar r) {
        if (this.SYNC_SETTINGS == null) {
            this.SYNC_SETTINGS = (JavaSynchronizationSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$java$settings$JavaSynchronizationSettings == null ? (class$org$netbeans$modules$java$settings$JavaSynchronizationSettings = ClassDependencyImpl.class$("org.netbeans.modules.java.settings.JavaSynchronizationSettings")) : class$org$netbeans$modules$java$settings$JavaSynchronizationSettings), (boolean)true);
        }
        if (CHANGEITEM_COMPARATOR == null) {
            CHANGEITEM_COMPARATOR = new ChangeItemComparator();
        }
        this.registrar = r;
    }

    private Collection getDirectSupertypes(ClassElement c) {
        LinkedList<Identifier> col = new LinkedList<Identifier>();
        col.addAll(Arrays.asList(c.getInterfaces()));
        if (c.getSuperclass() != null) {
            col.add(c.getSuperclass());
        }
        return col;
    }

    private void destroy(ClassElement c) {
        Collection col = this.getDirectSupertypes(c);
        this.supertypesRemoved(c, col);
        c.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private void registerNewClass(ClassElement c) {
        Collection col = this.getDirectSupertypes(c);
        this.supertypesAdded(c, col, false);
        c.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        ClassElement c;
        String propName = evt.getPropertyName();
        if ("interfaces".equals(propName)) {
            this.interfacesChanged(evt);
        } else if ("superclass".equals(propName)) {
            this.superclassChanged((ClassElement)evt.getSource(), (Identifier)evt.getOldValue(), (Identifier)evt.getNewValue());
        } else if ("classOrInterface".equals(propName) && (c = (ClassElement)evt.getSource()).isClassOrInterface()) {
            this.supertypesAdded(c, this.getDirectSupertypes(c), false);
        }
    }

    public void refreshClass(ClassElement c, boolean first) {
        if (!first) {
            Collection sups = this.getDirectSupertypes(c);
            this.supertypesAdded(c, sups, first);
        }
        ClassDependencyImpl classDependencyImpl = this;
        synchronized (classDependencyImpl) {
            c.removePropertyChangeListener((PropertyChangeListener)this);
            c.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void synchronizeClass(ClassElement target) {
        Element.Impl2 impl2 = (Element.Impl2)target.getCookie(class$org$openide$src$Element$Impl2 == null ? (class$org$openide$src$Element$Impl2 = ClassDependencyImpl.class$("org.openide.src.Element$Impl2")) : class$org$openide$src$Element$Impl2);
        if (impl2 != null && !impl2.isValid()) {
            return;
        }
        if (!target.isClassOrInterface()) {
            return;
        }
        Identifier[] ids = target.getInterfaces();
        ArrayList<Identifier> c = new ArrayList<Identifier>(ids.length + 1);
        c.addAll(Arrays.asList(ids));
        if (target.getSuperclass() != null) {
            c.add(target.getSuperclass());
        }
        this.supertypesAdded(target, c, true);
        String caption = MessageFormat.format(ClassDependencyImpl.getString("MSG_SynchronizeExplicit"), target.getName().getFullName(), "");
        Synchronizer sync = new Synchronizer(target, c);
        sync.overrideDisable();
        sync.setCaption(caption);
        RequestProcessor.postRequest((Runnable)sync);
    }

    protected void supertypesRemoved(ClassElement c, Collection removed) {
        Iterator it = removed.iterator();
        while (it.hasNext()) {
            Identifier id = (Identifier)it.next();
            this.registrar.removeDependency(c, id);
        }
    }

    protected void supertypesAdded(ClassElement c, Collection added, boolean refreshOnly) {
        LinkedList<Identifier> resolved = null;
        if (c.isClass()) {
            Iterator it = added.iterator();
            while (it.hasNext()) {
                Identifier id = (Identifier)it.next();
                if (id.getResolutionStatus() != 1) continue;
                if (resolved == null) {
                    resolved = new LinkedList<Identifier>();
                }
                if (!this.registrar.addDependency(c, id)) continue;
                resolved.add(id);
            }
        }
        if (resolved == null || resolved.isEmpty()) {
            return;
        }
        if (refreshOnly || !c.isClassOrInterface() || (c.getModifiers() & 0x400) > 0) {
            return;
        }
        byte syncMode = this.getSynchronizationMode(c);
        if (syncMode == 0) {
            return;
        }
        String caption = MessageFormat.format(ClassDependencyImpl.getString("MSG_SynchronizeAddInterfaces"), c.getName().getFullName(), "");
        Synchronizer sync = new Synchronizer(c, resolved);
        sync.setCaption(caption);
        RequestProcessor.postRequest((Runnable)sync);
    }

    private void interfacesChanged(PropertyChangeEvent evt) {
        MultiPropertyChangeEvent e = (MultiPropertyChangeEvent)evt;
        MultiPropertyChangeEvent addEvent = null;
        MultiPropertyChangeEvent removeEvent = null;
        Iterator changes = e.getIterator();
        while (changes.hasNext()) {
            MultiPropertyChangeEvent part = (MultiPropertyChangeEvent)changes.next();
            int type = part.getEventType();
            if (type == 2) {
                removeEvent = part;
                continue;
            }
            if (type != 1) continue;
            addEvent = part;
        }
        if (removeEvent != null) {
            this.supertypesRemoved((ClassElement)evt.getSource(), removeEvent.getAffectedItems());
        }
        if (addEvent != null) {
            this.supertypesAdded((ClassElement)evt.getSource(), addEvent.getAffectedItems(), false);
        }
    }

    public boolean dependsOn(ClassElement c, Identifier id) {
        Identifier s = c.getSuperclass();
        if (id == null) {
            return false;
        }
        if (s != null && s.compareTo(id, false)) {
            return true;
        }
        Identifier[] ss = c.getInterfaces();
        int i = 0;
        while (i < ss.length) {
            s = ss[i];
            if (s.compareTo(id, false)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void superclassChanged(ClassElement c, Identifier old, Identifier now) {
        if (old != null) {
            this.supertypesRemoved(c, Collections.singletonList(old));
        }
        if (now != null) {
            this.supertypesAdded(c, Collections.singletonList(now), false);
        }
    }

    public void changesCommited(Set added, Set removed, Map changed) {
        ClassElement c;
        Element el;
        Iterator it;
        if (removed != null) {
            it = removed.iterator();
            while (it.hasNext()) {
                el = (Element)it.next();
                if (!(el instanceof ClassElement)) continue;
                c = (ClassElement)el;
                this.destroy(c);
            }
        }
        if (added != null) {
            it = added.iterator();
            while (it.hasNext()) {
                el = (Element)it.next();
                if (!(el instanceof ClassElement)) continue;
                c = (ClassElement)el;
                this.registerNewClass(c);
            }
        }
    }

    private static MethodElement findMatchingMethod(ClassElement clazz, MethodElement elem, boolean superclasses, boolean acceptAbstract) {
        MethodParameter[] params = elem.getParameters();
        Type[] paramTypes = new Type[params.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = params[i].getType();
            ++i;
        }
        MethodElement m = clazz.getMethod(elem.getName(), paramTypes);
        if (!acceptAbstract && m != null && (m.getModifiers() & 0x400) > 0) {
            m = null;
        }
        if (m != null || !superclasses) {
            return m;
        }
        Identifier s = clazz.getSuperclass();
        if (s == null) {
            s = ClassElement.ROOT_OBJECT;
        }
        if (clazz.getName().equals((Object)s)) {
            return null;
        }
        clazz = ClassElement.forName((String)s.getFullName());
        if (clazz == null) {
            return null;
        }
        return ClassDependencyImpl.findMatchingMethod(clazz, elem, superclasses, false);
    }

    private static String getString(String key) {
        return SourceConnectionSupport.getString(key);
    }

    private static JavaConnections.ChangeProcessor createUpdateProcessor(MethodElement desired, MethodElement found) {
        boolean same = true;
        same = desired.getName().equals((Object)found.getName()) && desired.getReturn().getFullString().equals(found.getReturn().getFullString()) && desired.getParameters().length == found.getParameters().length;
        int access = desired.getDeclaringClass().isClassOrInterface() ? desired.getModifiers() & 7 : 1;
        int foundAccess = found.getModifiers() & 7;
        if (same &= foundAccess == access || foundAccess == 1 && access == 4 || foundAccess == 4 && access == 0) {
            MethodParameter[] pars1 = desired.getParameters();
            MethodParameter[] pars2 = found.getParameters();
            int i = 0;
            while (same && i < pars1.length) {
                same = pars1[i].getType().getFullString().equals(pars2[i].getType().getFullString());
                ++i;
            }
        }
        if (same) {
            return null;
        }
        MethodElement c = (MethodElement)desired.clone();
        try {
            c.setModifiers(found.getModifiers() & 0xFFFFFFF8 | access);
            c.getJavaDoc().clearJavaDoc();
        }
        catch (SourceException ex) {
            // empty catch block
        }
        String updateFormat = ClassDependencyImpl.getString("MSG_UpdateMethod");
        String msg = MessageFormat.format(updateFormat, ClassDependencyImpl.formatMethod(found), ClassDependencyImpl.formatMethod(c), desired.getDeclaringClass().getName().getFullName());
        return new UpdateProcessor(msg, found, desired);
    }

    private static JavaConnections.ChangeProcessor createAddProcessor(ClassElement target, MethodElement t) {
        if (t.getDeclaringClass().isClassOrInterface() && (t.getModifiers() & 0x400) == 0) {
            return null;
        }
        MethodElement c = (MethodElement)t.clone();
        try {
            c.getJavaDoc().clearJavaDoc();
            if (t.getDeclaringClass().isInterface()) {
                c.setModifiers(c.getModifiers() & 0xFFFFFFF8 | 1);
            }
        }
        catch (SourceException ex) {
            // empty catch block
        }
        String addMessageFormat = ClassDependencyImpl.getString("MSG_AddMethod");
        String msg = MessageFormat.format(addMessageFormat, t.getDeclaringClass().getName().getFullName(), ClassDependencyImpl.formatMethod(t));
        return new AddProcessor(msg, t, c, target);
    }

    private static String formatMethod(MethodElement m) {
        if (methodFormat == null) {
            methodFormat = new ElementFormat(ClassDependencyImpl.getString("FMT_MethodSignature"));
        }
        return methodFormat.format((Element)m);
    }

    public void connectionNotify(ClassElement target, ClassElement source, Enumeration newItems, Enumeration changeEvents) {
        byte syncMode = this.getSynchronizationMode(target);
        if (syncMode == 0) {
            return;
        }
        if (!target.isClassOrInterface()) {
            return;
        }
        Collection changes = this.synchronizeMethods(target, newItems, changeEvents, true);
        if (changes == null || changes.isEmpty()) {
            return;
        }
        String caption = MessageFormat.format(ClassDependencyImpl.getString("MSG_SynchronizeCaption"), target.getName().getFullName(), source.getName().getFullName());
        this.applyChanges(target, caption, changes);
    }

    private void applyChanges(ClassElement target, String caption, Collection changes) {
        this.applyChanges(target, caption, changes, false);
    }

    private void applyChanges(ClassElement target, String caption, Collection changes, boolean ignoreNot) {
        byte syncMode = this.getSynchronizationMode(target);
        if (!(ignoreNot || syncMode != 0 && this.SYNC_SETTINGS.isEnabled())) {
            return;
        }
        Collections.sort((List)changes, CHANGEITEM_COMPARATOR);
        if (syncMode == 2) {
            RequestProcessor.postRequest((Runnable)new Synchronizer(changes));
        } else {
            ArrayList l = new ArrayList(changes);
            JavaConnections.SyncRequest req = JavaConnections.scheduleShowChangesDialog(caption, l, syncMode);
            req.getTask().addTaskListener((TaskListener)new SyncRequestListener(target, req));
        }
    }

    private void autoApplyChanges(Collection changes) {
        LinkedList<JavaConnections.ChangeProcessor> failed = null;
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            JavaConnections.ChangeProcessor proc = (JavaConnections.ChangeProcessor)it.next();
            try {
                proc.process();
            }
            catch (SourceException ex) {
                if (failed == null) {
                    failed = new LinkedList<JavaConnections.ChangeProcessor>();
                }
                failed.add(proc);
            }
        }
        if (failed == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(MessageFormat.format(ClassDependencyImpl.getString("MSG_ChangesFailed"), new Integer(failed.size())));
        Iterator it2 = failed.iterator();
        while (it2.hasNext()) {
            sb.append('\n');
            sb.append(((JavaConnections.ChangeProcessor)it2.next()).getDisplayName());
        }
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)sb.toString(), 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
    }

    protected Collection synchronizeMethods(ClassElement target, Enumeration neededMethods, boolean deepScan) {
        return this.synchronizeMethods(target, neededMethods, null, deepScan);
    }

    public Collection synchronizeMethods(ClassElement target, Enumeration newItems, Enumeration changeEvents, boolean deepScan) {
        JavaConnections.ChangeProcessor proc;
        LinkedList<JavaConnections.ChangeProcessor> changes = null;
        if (newItems != null) {
            while (newItems.hasMoreElements()) {
                Object o = newItems.nextElement();
                if (!(o instanceof MethodElement)) continue;
                MethodElement m = (MethodElement)o;
                MethodElement found = ClassDependencyImpl.findMatchingMethod(target, m, deepScan, true);
                proc = null;
                if (found != null) {
                    if (found.getDeclaringClass() != target || (proc = ClassDependencyImpl.createUpdateProcessor(m, found)) == null) {
                        continue;
                    }
                } else {
                    proc = ClassDependencyImpl.createAddProcessor(target, m);
                }
                if (proc == null) continue;
                if (changes == null) {
                    changes = new LinkedList<JavaConnections.ChangeProcessor>();
                }
                changes.add(proc);
            }
        }
        if (changeEvents != null) {
            while (changeEvents.hasMoreElements()) {
                JavaConnections.Change ch = (JavaConnections.Change)changeEvents.nextElement();
                if (ch.getChangeType() != 64) continue;
                MethodElement oldState = (MethodElement)ch.getOldElement();
                MethodElement newState = (MethodElement)ch.getNewElement();
                proc = null;
                MethodElement found = ClassDependencyImpl.findMatchingMethod(target, newState, deepScan, true);
                if (found != null) {
                    if (target != found.getDeclaringClass() || (proc = ClassDependencyImpl.createUpdateProcessor(newState, found)) == null) {
                        continue;
                    }
                } else {
                    found = ClassDependencyImpl.findMatchingMethod(target, oldState, deepScan, true);
                    if (found != null) {
                        if (target != found.getDeclaringClass() || (proc = ClassDependencyImpl.createUpdateProcessor(newState, found)) == null) {
                            continue;
                        }
                    } else {
                        proc = ClassDependencyImpl.createAddProcessor(target, newState);
                    }
                }
                if (proc == null) continue;
                if (changes == null) {
                    changes = new LinkedList();
                }
                changes.add(proc);
            }
        }
        return changes;
    }

    private void addSupertypeMethods(Identifier superID, Map methods, Set seen) {
        if (seen.contains(superID)) {
            return;
        }
        ClassElement c = ClassElement.forName((String)superID.getFullName());
        seen.add(superID);
        if (c == null) {
            return;
        }
        MethodElement[] ms = c.getMethods();
        boolean clazz = c.isClassOrInterface();
        Identifier[] itfs = c.getInterfaces();
        int i = 0;
        while (i < itfs.length) {
            this.addSupertypeMethods(itfs[i], methods, seen);
            ++i;
        }
        if (clazz && c.getSuperclass() != null) {
            this.addSupertypeMethods(c.getSuperclass(), methods, seen);
        }
        int i2 = 0;
        while (i2 < ms.length) {
            MethodElement m = ms[i2];
            MethodElement.Key key = new MethodElement.Key(m);
            if (!clazz || (m.getModifiers() & 0x400) > 0) {
                if (!methods.containsKey(key)) {
                    methods.put(key, m);
                }
            } else if (methods.remove(key) != null) {
                // empty if block
            }
            ++i2;
        }
    }

    private Collection implementFromSuper(ClassElement target, Collection supertypes) {
        HashMap methods = new HashMap(31);
        Iterator it = supertypes.iterator();
        while (it.hasNext()) {
            Identifier id = (Identifier)it.next();
            this.addSupertypeMethods(id, methods, new HashSet(11));
        }
        Collection c = this.synchronizeMethods(target, Collections.enumeration(methods.values()), null, true);
        if (c == null || c.isEmpty()) {
            return null;
        }
        return c;
    }

    protected byte getSynchronizationMode(ClassElement t) {
        return (byte)this.registrar.getSynchronizationMode(t);
    }

    protected void setSynchronizationMode(ClassElement t, byte value) {
        this.registrar.setSynchronizationMode(t, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ChangeItemComparator
    implements Comparator {
        private static Comparator METHOD_COMPARATOR;

        ChangeItemComparator() {
            if (METHOD_COMPARATOR == null) {
                METHOD_COMPARATOR = JavaElementComparator.createConstructorComparator(true, new int[]{12});
            }
        }

        public int compare(Object obj, Object obj1) {
            JavaConnections.ChangeProcessor p = (JavaConnections.ChangeProcessor)obj;
            JavaConnections.ChangeProcessor p1 = (JavaConnections.ChangeProcessor)obj1;
            Element model = p.getModel();
            Element model1 = p1.getModel();
            return METHOD_COMPARATOR.compare(model, model1);
        }
    }

    private class SyncRequestListener
    implements TaskListener {
        JavaConnections.SyncRequest request;
        ClassElement target;

        SyncRequestListener(ClassElement t, JavaConnections.SyncRequest r) {
            this.request = r;
            this.target = t;
        }

        public void taskFinished(Task t) {
            t.removeTaskListener((TaskListener)this);
            ClassDependencyImpl.this.setSynchronizationMode(this.target, this.request.getSyncType());
        }
    }

    private static class UpdateProcessor
    extends JavaConnections.ChangeProcessor
    implements Runnable {
        MethodElement target;
        SourceException excpt;

        UpdateProcessor(String message, MethodElement target, MethodElement model) {
            super(message, (Element)model);
            this.target = target;
        }

        public void process() throws SourceException {
            this.target.getDeclaringClass().getSource().runAtomicAsUser((Runnable)this);
            if (this.excpt != null) {
                throw this.excpt;
            }
        }

        public void run() {
            try {
                this.updateMethod();
            }
            catch (SourceException ex) {
                this.excpt = ex;
            }
        }

        private void updateMethod() throws SourceException {
            MethodElement model = (MethodElement)this.getModel();
            int mods = this.target.getModifiers() & 0xFFFFFFF8;
            if (model.getDeclaringClass().isClassOrInterface()) {
                mods |= model.getModifiers() & 7;
                mods &= 0xFFFFFBFF;
            } else {
                mods |= 1;
            }
            this.target.setModifiers(mods);
            this.target.setName(model.getName());
            this.target.setReturn(model.getReturn());
            MethodParameter[] pars1 = this.target.getParameters();
            MethodParameter[] pars2 = model.getParameters();
            MethodParameter[] targetPars = null;
            if (pars2.length != pars1.length) {
                targetPars = pars2;
            } else {
                int i = 0;
                while (i < pars1.length) {
                    if (!pars1[i].getType().getFullString().equals(pars2[i].getType().getFullString())) {
                        targetPars = pars2;
                        break;
                    }
                    ++i;
                }
            }
            if (targetPars != null) {
                this.target.setParameters(targetPars);
            }
        }
    }

    private static class AddProcessor
    extends JavaConnections.ChangeProcessor
    implements Runnable {
        private ClassElement targetClass;
        private MethodElement addMethod;
        private SourceException excpt;

        AddProcessor(String description, MethodElement model, MethodElement add, ClassElement target) {
            super(description, (Element)model);
            this.addMethod = add;
            this.targetClass = target;
        }

        public void process() throws SourceException {
            SourceElement el = this.targetClass.getSource();
            el.runAtomicAsUser((Runnable)this);
            if (this.excpt != null) {
                throw this.excpt;
            }
        }

        public void run() {
            try {
                InheritanceSupport.overrideMethod(this.targetClass, this.addMethod, true, false);
            }
            catch (SourceException ex) {
                this.excpt = ex;
            }
        }
    }

    private class Synchronizer
    implements Runnable {
        ClassElement target;
        Collection superIDs;
        boolean overrideDisable;
        int mode;
        Collection changeList;
        String caption;

        Synchronizer(ClassElement target, Collection superIDs) {
            this.target = target;
            this.superIDs = superIDs;
            this.mode = 1;
        }

        Synchronizer(Collection changeList) {
            this.changeList = changeList;
            this.mode = 2;
        }

        public void overrideDisable() {
            this.overrideDisable = true;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public void run() {
            switch (this.mode) {
                case 1: {
                    this.collectSupertypeMethods();
                    break;
                }
                case 2: {
                    this.confirmChanges();
                }
            }
        }

        private void collectSupertypeMethods() {
            Collection c = ClassDependencyImpl.this.implementFromSuper(this.target, this.superIDs);
            if (c == null || c.isEmpty()) {
                return;
            }
            ClassDependencyImpl.this.applyChanges(this.target, this.caption, c, this.overrideDisable);
        }

        private void confirmChanges() {
            ClassDependencyImpl.this.autoApplyChanges(this.changeList);
        }
    }
}

