/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codesync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.java.JavaConnections;
import org.netbeans.modules.java.codesync.ClassDependencyImpl;
import org.netbeans.modules.java.codesync.Registrar;
import org.netbeans.modules.java.codesync.SynchronizeCodeCookie;
import org.netbeans.modules.java.model.LangModel;
import org.openide.cookies.ConnectionCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class SourceConnectionSupport
implements PropertyChangeListener,
Registrar,
ConnectionCookie.Listener,
SynchronizeCodeCookie {
    private static final String[] SKIP_REGISTRATION_PREFIXES = new String[]{"java.", "javax."};
    private static final boolean DEBUG = false;
    public static final int CONNECT_NOT = 0;
    public static final int CONNECT_CONFIRM = 1;
    public static final int CONNECT_AUTO = 2;
    public static final int CONNECT_DEFAULT = 1;
    SourceElement src;
    ClassDependencyImpl classDeps;
    Map dependencies;
    Node listenerNode;
    boolean initialized;
    int suspended;
    String supportID;
    LangModel model;
    int syncMode = -1;
    boolean relinkEnabled;
    boolean fullRefresh;
    Collection classList;
    public static final ConnectionCookie.Type DEPENDENCY_IMPLEMENTATION = JavaConnections.IMPLEMENTS;
    ClassElement[] NO_CLASSES = new ClassElement[0];
    static /* synthetic */ Class class$org$netbeans$modules$java$codesync$SourceConnectionSupport;
    static /* synthetic */ Class class$org$openide$cookies$ConnectionCookie;

    public SourceConnectionSupport(SourceElement src, LangModel model, String id) {
        this.src = src;
        this.supportID = id;
        this.model = model;
        this.suspended = 1;
    }

    static String getString(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$codesync$SourceConnectionSupport == null ? (class$org$netbeans$modules$java$codesync$SourceConnectionSupport = SourceConnectionSupport.class$("org.netbeans.modules.java.codesync.SourceConnectionSupport")) : class$org$netbeans$modules$java$codesync$SourceConnectionSupport), (String)key);
    }

    private void initialize() {
        this.classDeps = new ClassDependencyImpl(this);
        this.model.addPostCommitListener(this.classDeps);
        this.src.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void checkState() {
        this.loadModel();
        if (!this.fullRefresh) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    SourceConnectionSupport.this.refreshLinks(false);
                }
            });
        }
    }

    public void suspend() {
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            boolean s = this.suspended == 0;
            ++this.suspended;
            if (!s || !this.initialized) {
                return;
            }
            if (this.classList != null) {
                Iterator it = this.classList.iterator();
                while (it.hasNext()) {
                    ClassElement c = (ClassElement)((Reference)it.next()).get();
                    if (c == null) continue;
                    c.removePropertyChangeListener((PropertyChangeListener)this.classDeps);
                }
                this.classList = null;
            }
            this.src.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public synchronized void resume(boolean refresh) {
        if (--this.suspended == 0) {
            this.initialize();
            if (refresh && this.src.getStatus() == 3) {
                this.refreshLinks(true);
            } else {
                this.initialized = false;
            }
        }
    }

    public void syncConnections() {
        boolean old = this.relinkEnabled;
        this.relinkEnabled = true;
        if (!old) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    SourceConnectionSupport.this.refreshLinks(false);
                }
            });
        }
    }

    protected boolean isSuspended() {
        return this.suspended > 0;
    }

    protected abstract void saveDependencies(String var1, String[] var2);

    protected abstract String[] readDependencyList();

    protected abstract String[] readDependencies(String var1);

    protected abstract Node.Handle createListenerHandle(Node var1);

    private void loadModel() {
        if (this.dependencies != null) {
            return;
        }
        String[] dependencyNames = this.readDependencyList();
        int hashSize = dependencyNames == null || dependencyNames.length == 0 ? 7 : dependencyNames.length * 4 / 3;
        HashMap m = new HashMap(hashSize);
        int i = 0;
        while (i < dependencyNames.length) {
            String[] deps = this.readDependencies(dependencyNames[i]);
            if (deps != null && deps.length != 0) {
                Identifier srcId = Identifier.create((String)dependencyNames[i]);
                HashSet<String> c = new HashSet<String>(deps.length * 4 / 3);
                c.addAll(Arrays.asList(deps));
                m.put(srcId, c);
            }
            ++i;
        }
        this.dependencies = m;
    }

    public Node getListenerNode() {
        if (this.listenerNode != null) {
            return this.listenerNode;
        }
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            if (this.listenerNode != null) {
                Node node = this.listenerNode;
                return node;
            }
            this.listenerNode = new ListenerNode();
        }
        return this.listenerNode;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() != this.src) {
            return;
        }
        String propName = evt.getPropertyName();
        if (propName == null) {
            return;
        }
        if ("status".equals(propName)) {
            this.handleStatusChange((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
    }

    protected String getName() {
        return "[" + this.supportID + "] ";
    }

    private void refreshLinks(boolean first) {
        ClassElement c;
        int i;
        if (this.fullRefresh) {
            return;
        }
        this.loadModel();
        this.fullRefresh |= !first;
        ClassElement[] allClasses = this.src.getAllClasses();
        ArrayList<WeakReference<ClassElement>> l = new ArrayList<WeakReference<ClassElement>>(allClasses.length);
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            i = 0;
            while (i < allClasses.length) {
                c = allClasses[i];
                l.add(new WeakReference<ClassElement>(c));
                ++i;
            }
            this.classList = l;
        }
        i = 0;
        while (i < allClasses.length) {
            c = allClasses[i];
            this.classDeps.refreshClass(c, first);
            ++i;
        }
        Vector entryList = new Vector(this.dependencies.entrySet());
        LinkedList<Identifier> cleanDeps = null;
        Iterator entries = entryList.iterator();
        while (entries.hasNext()) {
            Map.Entry en = (Map.Entry)entries.next();
            Identifier srcIdent = (Identifier)en.getKey();
            Collection deps = (Collection)en.getValue();
            LinkedList<String> removed = null;
            Iterator depClasses = deps.iterator();
            while (depClasses.hasNext()) {
                String relName = (String)depClasses.next();
                ClassElement cl = this.findRelativeClass(relName);
                if (cl != null && this.classDeps.dependsOn(cl, srcIdent)) continue;
                if (removed == null) {
                    removed = new LinkedList<String>();
                }
                removed.add(relName);
            }
            if (removed == null) continue;
            if (cleanDeps == null) {
                cleanDeps = new LinkedList<Identifier>();
            }
            cleanDeps.add(srcIdent);
            cleanDeps.add((Identifier)removed);
        }
        if (cleanDeps == null) {
            return;
        }
        Iterator clean = cleanDeps.iterator();
        while (clean.hasNext()) {
            Identifier source = (Identifier)clean.next();
            Iterator rel = ((Collection)clean.next()).iterator();
            while (rel.hasNext()) {
                this.removeDependency((String)rel.next(), source);
            }
        }
    }

    private void handleStatusChange(int oldStatus, int newStatus) {
        if (this.initialized || this.isSuspended() || newStatus != 3) {
            return;
        }
        this.fullRefresh = false;
        this.refreshLinks(oldStatus == 0);
        this.initialized = true;
    }

    protected synchronized Node createListenerNode() {
        if (this.listenerNode != null) {
            return this.listenerNode;
        }
        this.listenerNode = new ListenerNode();
        return this.listenerNode;
    }

    private ClassElement findClass(Identifier className) {
        if (!this.relinkEnabled) {
            return null;
        }
        ClassElement cls = ClassElement.forName((String)className.getFullName());
        return cls;
    }

    private boolean eligibleToRegistration(Identifier id) {
        String fn = id.getFullName();
        int i = 0;
        while (i < SKIP_REGISTRATION_PREFIXES.length) {
            if (fn.startsWith(SKIP_REGISTRATION_PREFIXES[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void registerDependency(ClassElement source) {
        if (source == null || this.isSuspended()) {
            return;
        }
        ConnectionCookie ck = (ConnectionCookie)source.getCookie(class$org$openide$cookies$ConnectionCookie == null ? (class$org$openide$cookies$ConnectionCookie = SourceConnectionSupport.class$("org.openide.cookies.ConnectionCookie")) : class$org$openide$cookies$ConnectionCookie);
        if (ck == null) {
            return;
        }
        try {
            ck.register(DEPENDENCY_IMPLEMENTATION, this.getListenerNode());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void unregisterDependency(ClassElement source) {
        if (source == null || this.isSuspended()) {
            return;
        }
        ConnectionCookie ck = (ConnectionCookie)source.getCookie(class$org$openide$cookies$ConnectionCookie == null ? (class$org$openide$cookies$ConnectionCookie = SourceConnectionSupport.class$("org.openide.cookies.ConnectionCookie")) : class$org$openide$cookies$ConnectionCookie);
        if (ck == null) {
            return;
        }
        try {
            ck.unregister(DEPENDENCY_IMPLEMENTATION, this.getListenerNode());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Enumeration getDependencies(Identifier source) {
        ArrayList c;
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            c = (ArrayList)this.dependencies.get(source);
            if (c != null) {
                c = new ArrayList(c);
            }
        }
        if (c == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        ArrayList<ClassElement> els = new ArrayList<ClassElement>(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            String relName = (String)it.next();
            ClassElement clel = this.findRelativeClass(relName);
            els.add(clel);
        }
        return Collections.enumeration(els);
    }

    public boolean addDependency(ClassElement target, Identifier source) {
        HashSet<String> c;
        String relName = this.findRelativeName(target);
        boolean changed = false;
        this.checkState();
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            c = (HashSet<String>)this.dependencies.get(source);
            if (c == null) {
                c = new HashSet<String>(7);
                this.dependencies.put(source, c);
            }
            changed = c.add(relName);
        }
        if (changed) {
            this.saveDependencies(source.getFullName(), c.toArray(new String[c.size()]));
        }
        if (this.eligibleToRegistration(source)) {
            this.registerDependency(this.findClass(source));
        }
        return changed;
    }

    private void removeDependency(String relName, Identifier source) {
        Collection c;
        boolean changed = false;
        this.checkState();
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            c = (Collection)this.dependencies.get(source);
            if (c != null && c.remove(relName)) {
                changed = true;
            }
        }
        if (changed) {
            this.saveDependencies(source.getFullName(), c.isEmpty() ? null : c.toArray(new String[c.size()]));
        }
        if (this.eligibleToRegistration(source)) {
            this.unregisterDependency(this.findClass(source));
        }
    }

    public void removeDependency(ClassElement target, Identifier source) {
        String relName = this.findRelativeName(target);
        this.removeDependency(relName, source);
    }

    private ClassElement findRelativeClass(String relName) {
        StringTokenizer tok = new StringTokenizer(relName, ".");
        String name = tok.nextToken();
        Identifier id = Identifier.create((String)name);
        ClassElement cls = this.src.getClass(id);
        while (cls != null && tok.hasMoreTokens()) {
            id = Identifier.create((String)tok.nextToken());
            cls = cls.getClass(id);
        }
        return cls;
    }

    private String findRelativeName(ClassElement el) {
        String fullName = el.getName().getFullName();
        ClassElement outer = el.getDeclaringClass();
        while (outer != null) {
            el = outer;
            outer = el.getDeclaringClass();
        }
        String outerQualifier = el.getName().getQualifier();
        if ("".equals(outerQualifier)) {
            return fullName;
        }
        return fullName.substring(outerQualifier.length() + 1);
    }

    private void classChanged(ClassElement oldState, ClassElement newState, Collection searchFor, Collection replaceWith) {
        Identifier[] oldIts = oldState.getInterfaces();
        Identifier[] newIts = newState.getInterfaces();
    }

    public void notify(ConnectionCookie.Event ev) {
        if (!(ev instanceof JavaConnections.Event)) {
            return;
        }
        JavaConnections.Change[] changes = ((JavaConnections.Event)ev).getChanges();
        this.loadModel();
        if (!this.fullRefresh) {
            this.refreshLinks(false);
        }
        HashMap newItems = new HashMap(17);
        HashMap changeEvents = new HashMap(17);
        int i = 0;
        while (i < changes.length) {
            JavaConnections.Change ch = changes[i];
            int type = ch.getChangeType();
            if (type == 16) {
                this.splitNewMethods(ch.getElements(), newItems);
            } else if (type == 64) {
                this.splitMethodChange(ch, changeEvents);
            }
            ++i;
        }
        ClassElement[] allClasses = this.src.getAllClasses();
        Object result = null;
        int i2 = 0;
        while (i2 < allClasses.length) {
            ClassElement recipient = allClasses[i2];
            Collection added = (Collection)newItems.get(recipient);
            Collection changeEvs = (Collection)changeEvents.get(recipient);
            MemberElement me = null;
            if (added != null && !added.isEmpty()) {
                me = (MemberElement)added.iterator().next();
            } else if (changeEvs != null && !changeEvs.isEmpty()) {
                me = (MemberElement)((JavaConnections.Change)changeEvs.iterator().next()).getNewElement();
            }
            if (me != null) {
                this.classDeps.connectionNotify(recipient, me.getDeclaringClass(), added == null ? null : Collections.enumeration(added), changeEvs == null ? null : Collections.enumeration(changeEvs));
            }
            ++i2;
        }
    }

    private void splitMethodChange(JavaConnections.Change ch, Map dist) {
        if (!(ch.getNewElement() instanceof MethodElement)) {
            return;
        }
        MethodElement m = (MethodElement)ch.getNewElement();
        ClassElement src = m.getDeclaringClass();
        Enumeration deps = this.getDependencies(src.getName());
        while (deps.hasMoreElements()) {
            ClassElement target = (ClassElement)deps.nextElement();
            LinkedList<JavaConnections.Change> c = (LinkedList<JavaConnections.Change>)dist.get(target);
            if (c == null) {
                c = new LinkedList<JavaConnections.Change>();
                dist.put(target, c);
            }
            c.add(ch);
        }
    }

    private void splitNewMethods(Element[] els, Map targetMap) {
        int i = 0;
        while (i < els.length) {
            MethodElement m;
            ClassElement source;
            if (els[i] instanceof MethodElement && (source = (m = (MethodElement)els[i]).getDeclaringClass()) != null) {
                Identifier srcID = source.getName();
                Enumeration deps = this.getDependencies(srcID);
                while (deps.hasMoreElements()) {
                    ClassElement c = (ClassElement)deps.nextElement();
                    LinkedList<MethodElement> col = (LinkedList<MethodElement>)targetMap.get(c);
                    if (col == null) {
                        col = new LinkedList<MethodElement>();
                        targetMap.put(c, col);
                    }
                    col.add(m);
                }
            }
            ++i;
        }
    }

    protected void storeSynchronizationMode(int mode) {
    }

    protected int readSynchronizationMode() {
        return 1;
    }

    public void setSynchronizationMode(ClassElement t, int mode) {
        this.storeSynchronizationMode(mode);
        this.syncMode = mode;
    }

    public int getSynchronizationMode(ClassElement t) {
        if (this.syncMode == -1) {
            this.syncMode = this.readSynchronizationMode();
            return this.syncMode;
        }
        return this.syncMode;
    }

    public void synchronize() throws SourceException {
        this.checkState();
        ClassElement[] classes = this.src.getAllClasses();
        int i = 0;
        while (i < classes.length) {
            this.classDeps.synchronizeClass(classes[i]);
            ++i;
        }
    }

    public SynchronizeCodeCookie createClassSyncCookie(ClassElement cls) {
        if (cls.isClassOrInterface()) {
            return new ClassSyncImpl(cls);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ClassSyncImpl
    implements SynchronizeCodeCookie {
        ClassElement target;

        ClassSyncImpl(ClassElement target) {
            this.target = target;
        }

        public void synchronize() throws SourceException {
            SourceConnectionSupport.this.classDeps.synchronizeClass(this.target);
        }
    }

    private class ListenerNode
    extends AbstractNode {
        private Node.Handle myHandle;

        public ListenerNode() {
            super(Children.LEAF);
        }

        public Node.Handle getHandle() {
            if (this.myHandle != null) {
                return this.myHandle;
            }
            ListenerNode listenerNode = this;
            synchronized (listenerNode) {
                if (this.myHandle == null) {
                    this.myHandle = SourceConnectionSupport.this.createListenerHandle((Node)this);
                }
            }
            return this.myHandle;
        }

        public Node.Cookie getCookie(Class clazz) {
            Node.Cookie x = super.getCookie(clazz);
            if (x != null) {
                return x;
            }
            if (clazz.isInstance(SourceConnectionSupport.this)) {
                return SourceConnectionSupport.this;
            }
            return null;
        }
    }
}

