/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.java.imptool.AbstractProp;
import org.netbeans.modules.java.imptool.ChoicePropertyEditor;
import org.netbeans.modules.java.imptool.SourceImport;
import org.netbeans.modules.java.imptool.Util;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.Identifier;

public class ImportLineNode
extends AbstractNode {
    private SourceImport sourceImp;
    private PropertyEditor choiceEditor1;
    private PropertyEditor choiceEditor2;
    private PropertyEditor choiceEditor3;

    public ImportLineNode(SourceImport imp) {
        this(imp, Children.LEAF);
    }

    public ImportLineNode(SourceImport imp, Children ch) {
        super(ch);
        Identifier id = imp.getIdentifier();
        String name = imp.getName();
        this.sourceImp = imp;
        this.setName(id.getFullName());
        if (imp.isPackage()) {
            name = imp.getPackage();
            this.setIconBase("org/netbeans/modules/java/resources/importPackage");
        } else {
            this.setIconBase("org/netbeans/modules/java/resources/importLine");
        }
        this.setDisplayName(name);
    }

    static ImportLineNode createPackageNode(Collection impArray) {
        Iterator impIt = impArray.iterator();
        Children.Array ch = new Children.Array();
        int i = 0;
        SourceImport packageImp = null;
        if (impArray.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Node[] childrens = new Node[impArray.size() - 1];
        while (impIt.hasNext()) {
            SourceImport imp = (SourceImport)impIt.next();
            if (!imp.isPackage()) {
                childrens[i++] = new ImportLineNode(imp);
                continue;
            }
            packageImp = imp;
        }
        if (childrens.length == 0) {
            ch = Children.LEAF;
        } else {
            ch.add(childrens);
        }
        return new ImportLineNode(packageImp, (Children)ch);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ps = Sheet.createPropertiesSet();
        sheet.put(ps);
        if (this.sourceImp.isClass()) {
            if (this.sourceImp.isUsed()) {
                ps.put((Node.Property)new NoActionProp());
            } else {
                ps.put((Node.Property)new AddRemoveActionProp());
            }
        } else {
            ps.put((Node.Property)new PackageActionProp(this.getChildren() == Children.LEAF));
        }
        return sheet;
    }

    class PackageActionProp
    extends AbstractProp {
        private boolean noSingleNameImport;

        PackageActionProp(boolean noSingle) {
            super("RESOLVE_ACTION", Integer.TYPE, true);
            this.noSingleNameImport = noSingle;
        }

        public Object getValue() {
            return new Integer(ImportLineNode.this.sourceImp.isUse() ? 1 : 0);
        }

        public void setValue(Object val) {
            ImportLineNode.this.sourceImp.setUse((Integer)val != 0);
            ImportLineNode.super.firePropertyChange("propertySets", null, null);
        }

        public PropertyEditor getPropertyEditor() {
            if (ImportLineNode.this.choiceEditor3 == null) {
                String[] chText = new String[]{this.noSingleNameImport ? Util.getString("PROP_RESOLVE_ACTION_REMOVE") : Util.getString("PROP_RESOLVE_ACTION_SINGLE"), Util.getString("PROP_RESOLVE_ACTION_PACKAGE")};
                ImportLineNode.this.choiceEditor3 = new ChoicePropertyEditor(new int[]{0, 1}, chText);
            }
            return ImportLineNode.this.choiceEditor3;
        }
    }

    class NoActionProp
    extends AbstractProp {
        NoActionProp() {
            super("RESOLVE_ACTION", Integer.TYPE, false);
        }

        public Object getValue() {
            return new Integer(0);
        }

        public PropertyEditor getPropertyEditor() {
            if (ImportLineNode.this.choiceEditor2 == null) {
                ImportLineNode.this.choiceEditor2 = new ChoicePropertyEditor(new int[]{0}, new String[]{Util.getString("PROP_RESOLVE_ACTION_NOACTION")});
            }
            return ImportLineNode.this.choiceEditor2;
        }
    }

    class AddRemoveActionProp
    extends AbstractProp {
        AddRemoveActionProp() {
            super("RESOLVE_ACTION", Integer.TYPE, true);
        }

        public Object getValue() {
            return new Integer(ImportLineNode.this.sourceImp.isUse() ? 1 : 0);
        }

        public void setValue(Object val) {
            ImportLineNode.this.sourceImp.setUse((Integer)val != 0);
            ImportLineNode.super.firePropertyChange("propertySets", null, null);
        }

        public PropertyEditor getPropertyEditor() {
            if (ImportLineNode.this.choiceEditor1 == null) {
                ImportLineNode.this.choiceEditor1 = new ChoicePropertyEditor(new int[]{0, 1}, new String[]{Util.getString("PROP_RESOLVE_ACTION_REMOVE"), Util.getString("PROP_RESOLVE_ACTION_USE")});
            }
            return ImportLineNode.this.choiceEditor1;
        }
    }
}

