/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openide.src.ClassElement;

public class PackageResolver {
    private static final String DOT_SEPARATOR = ".";
    private Map resolvedClasses = null;
    private Collection packageNames = null;

    PackageResolver(Collection packages) {
        this.initialize();
        this.packageNames = packages;
    }

    String getPackageForClass(String className) {
        String result = null;
        if (this.packageNames != null && this.resolvedClasses != null) {
            result = this.resolvedClasses.containsKey(className) ? (String)this.resolvedClasses.get(className) : this.getPackageForClassName(className);
        }
        if (result != null && !this.resolvedClasses.containsKey(className)) {
            this.resolvedClasses.put(className, result);
        }
        return result;
    }

    void setResolvedClasses(String className, String packageName) {
        if (this.resolvedClasses == null) {
            this.initialize();
        }
        if (!this.resolvedClasses.containsKey(className)) {
            this.resolvedClasses.put(className, packageName);
        }
    }

    private void initialize() {
        if (this.resolvedClasses == null) {
            this.resolvedClasses = new HashMap();
        }
        if (this.packageNames == null) {
            this.packageNames = new ArrayList(10);
        }
        this.resolvedClasses.clear();
        this.packageNames.clear();
    }

    private String getPackageForClassName(String className) {
        String result = null;
        String packageName = null;
        Iterator it = this.packageNames.iterator();
        while (it.hasNext()) {
            packageName = (String)it.next();
            result = this.resolvePackageForClass(packageName, className);
            if (result != null) break;
        }
        return result;
    }

    private String resolvePackageForClass(String packageName, String className) {
        String result = null;
        ClassElement classElement = ClassElement.forName((String)(packageName + DOT_SEPARATOR + className));
        if (classElement != null) {
            result = packageName;
        }
        classElement = null;
        return result;
    }
}

