/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.imptool.ImpDataSource;
import org.netbeans.modules.java.imptool.Util;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

abstract class RootPanel
extends JPanel {
    ImpDataSource dataSource;
    boolean initialized = false;
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private TreeTableView ltv;
    private TreeTableView ttv;

    void initialize() {
        if (!this.initialized) {
            this.initAllComponents();
            this.setPreferredSize(new Dimension(560, 350));
            this.initialized = true;
        }
    }

    void addTableView(Node masterNode, JScrollPane tv) {
        ExplorerManager em = new ExplorerManager();
        em.setRootContext(masterNode);
        ExplorerPanel ep = new ExplorerPanel(em);
        ep.setLayout(new BorderLayout());
        ep.add("Center", tv);
        this.add((Component)ep, "Center");
    }

    void initListTableView(Node masterNode, int width) {
        this.ltv = new TreeTableView();
        if (masterNode.getChildren().getNodesCount() != 0) {
            AccessibleContext ac = this.ltv.getAccessibleContext();
            ac.setAccessibleName(Util.getString("ACS_ListTableViewA11yName"));
            ac.setAccessibleDescription(Util.getString("ACS_ListTableViewA11yDesc"));
            this.ltv.setPopupAllowed(false);
            this.ltv.setTableAutoResizeMode(4);
            this.ltv.setRootVisible(false);
            Node.Property[] props = this.getPropertiesFrom(masterNode);
            if (props != null) {
                this.ltv.setProperties(props);
            }
            this.addTableView(masterNode, (JScrollPane)this.ltv);
            this.ltv.setTreePreferredWidth(width);
        } else {
            this.addNoRowsLabel();
        }
    }

    protected final TreeTableView getListTableView() {
        return this.ltv;
    }

    protected final TreeTableView getTreeTableView() {
        return this.ttv;
    }

    void initTreeTableView(Node masterNode) {
        this.ttv = new TreeTableView();
        if (masterNode.getChildren().getNodesCount() != 0) {
            AccessibleContext ac = this.ttv.getAccessibleContext();
            ac.setAccessibleName(Util.getString("ACS_TreeTableViewA11yName"));
            ac.setAccessibleDescription(Util.getString("ACS_TreeTableViewA11yDesc"));
            this.ttv.setPopupAllowed(false);
            this.ttv.setTableAutoResizeMode(4);
            Node.Property[] props = this.getPropertiesFrom(masterNode);
            if (props != null) {
                this.ttv.setProperties(props);
            }
            this.addTableView(masterNode, (JScrollPane)this.ttv);
            this.ttv.setTreePreferredWidth(320);
        } else {
            this.addNoRowsLabel();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.ttv != null) {
            this.ttv.expandAll();
            this.ttv = null;
        }
    }

    Node.Property[] getPropertiesFrom(Node masterNode) {
        Node.PropertySet[] sets;
        Node[] nodes = masterNode.getChildren().getNodes();
        if (nodes.length > 0 && (sets = nodes[0].getPropertySets()).length > 0) {
            return sets[0].getProperties();
        }
        return null;
    }

    void addNoRowsLabel() {
        JLabel noRowText = new JLabel();
        noRowText.setText(Util.getString(this.noRowsText()));
        this.add((Component)noRowText, "North");
    }

    abstract void initAllComponents();

    abstract String noRowsText();

    static class WizPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishPanel {
        RootPanel component;
        HelpCtx helpCtx;
        Class clazz;
        ImpDataSource dataSource;
        int number;
        String name;

        WizPanel(Class panelClass, HelpCtx help, String name, int number) {
            this.clazz = panelClass;
            this.helpCtx = help;
            this.name = name;
        }

        public Component getComponent() {
            if (this.component != null) {
                return this.component;
            }
            try {
                RootPanel c = (RootPanel)this.clazz.newInstance();
                c.dataSource = this.dataSource;
                c.initialize();
                c.putClientProperty(RootPanel.PROP_CONTENT_SELECTED_INDEX, new Integer(this.number));
                this.component = c;
                return this.component;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public void setHighlight(int number) {
        }

        public HelpCtx getHelp() {
            return new HelpCtx("java.import");
        }

        public void readSettings(Object settings) {
            this.dataSource = (ImpDataSource)settings;
            if (this.component != null) {
                this.component.dataSource = this.dataSource;
            }
        }

        public void storeSettings(Object settings) {
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public String getName() {
            return this.name;
        }
    }
}

