/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.java.imptool.BodyIdentifier;
import org.netbeans.modules.java.imptool.MethodParameterOwner;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class SourceIdentifier {
    private Identifier identifier;
    private int type;
    private Object owner;
    private String resolvedPackage;
    private int useFQN = 0;
    static final int USE_FQN_NO_CHANGE = 0;
    static final int USE_FQN_TRUE = 1;
    static final int USE_FQN_FALSE = 2;
    static final int TYPE_TYPE = 0;
    static final int TYPE_SUPERCLASS = 1;
    static final int TYPE_INTERFACE = 2;
    static final int TYPE_EXCEPTION = 3;
    static final int TYPE_BODY = 4;
    static final String EMPTY_PACKAGE = "";

    public SourceIdentifier(Identifier id, int t, Object o) {
        this.identifier = id;
        this.type = t;
        this.owner = o;
    }

    void commit() throws SourceException, IOException, BadLocationException {
        Identifier newId = null;
        if (this.resolvedPackage == null && this.useFQN == 0) {
            return;
        }
        String newSourceText = this.getSourceText();
        if (newSourceText.equals(this.identifier.getSourceName())) {
            return;
        }
        newId = Identifier.create((String)this.getFQN(), (String)newSourceText);
        if (this.owner instanceof ClassElement) {
            ClassElement clEl = (ClassElement)this.owner;
            switch (this.type) {
                case 1: {
                    clEl.setSuperclass(newId);
                    break;
                }
                case 2: {
                    clEl.removeInterface(this.identifier);
                    clEl.addInterface(newId);
                }
            }
        } else if (this.owner instanceof MethodElement) {
            MethodElement mEl = (MethodElement)this.owner;
            switch (this.type) {
                case 3: {
                    Identifier[] exs = mEl.getExceptions();
                    this.replaceIdentifierIn(exs, newId);
                    mEl.setExceptions(exs);
                    break;
                }
                case 0: {
                    Type newType = this.createTypeFrom(mEl.getReturn(), newId);
                    mEl.setReturn(newType);
                }
            }
        } else if (this.owner instanceof ConstructorElement) {
            ConstructorElement cEl = (ConstructorElement)this.owner;
            switch (this.type) {
                case 3: {
                    Identifier[] exs = cEl.getExceptions();
                    this.replaceIdentifierIn(exs, newId);
                    cEl.setExceptions(exs);
                }
            }
        } else if (this.owner instanceof FieldElement) {
            FieldElement fEl = (FieldElement)this.owner;
            Type newType = this.createTypeFrom(fEl.getType(), newId);
            fEl.setType(newType);
        } else if (this.owner instanceof MethodParameterOwner) {
            MethodParameterOwner mpo = (MethodParameterOwner)this.owner;
            Type newType = this.createTypeFrom(mpo.getMethodParameterType(), newId);
            mpo.setMethodParameterType(newType);
        } else if (this.owner instanceof BodyIdentifier) {
            BodyIdentifier bId = (BodyIdentifier)this.owner;
            bId.getBounds().setText(this.getSourceText());
        } else {
            throw new IllegalArgumentException();
        }
    }

    void rollback() {
        this.resolvedPackage = null;
        this.useFQN = 0;
    }

    int resolve(int type) {
        return 0;
    }

    String getSourceText() {
        if (this.resolvedPackage != null) {
            if (this.useFQN == 1) {
                return this.getFQN();
            }
            return this.getName();
        }
        if (this.useFQN == 1) {
            return this.identifier.getFullName();
        }
        if (this.useFQN == 2) {
            return this.identifier.getName();
        }
        return this.identifier.getSourceName();
    }

    String getFQN() {
        if (this.resolvedPackage != null) {
            return this.resolvedPackage.concat(".").concat(this.getName());
        }
        return this.identifier.getFullName();
    }

    String getPackage() {
        if (this.resolvedPackage != null) {
            return this.resolvedPackage;
        }
        if (this.identifier.getResolutionStatus() == 2) {
            return EMPTY_PACKAGE;
        }
        String pck = this.identifier.getQualifier();
        if (pck != null && pck.length() > 0) {
            return pck;
        }
        return EMPTY_PACKAGE;
    }

    void setPackage(String packageName) {
        this.resolvedPackage = packageName.equals(EMPTY_PACKAGE) ? null : packageName;
    }

    String getName() {
        return this.identifier.getName();
    }

    int getResolveStatus() {
        return 0;
    }

    int getUseFQN() {
        return this.useFQN;
    }

    void setUseFQN(int use) {
        this.useFQN = use;
    }

    boolean reallyUseFQN() {
        return !this.getSourceText().equals(this.getName());
    }

    private Type createTypeFrom(Type type, Identifier newId) {
        if (type.isClass()) {
            if (type.getTypeIdentifier().equals((Object)this.identifier)) {
                return Type.createClass((Identifier)newId);
            }
            throw new IllegalArgumentException();
        }
        if (type.isArray()) {
            return Type.createArray((Type)this.createTypeFrom(type.getElementType(), newId));
        }
        throw new IllegalArgumentException();
    }

    private void replaceIdentifierIn(Identifier[] ids, Identifier newId) {
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals((Object)this.identifier)) {
                ids[i] = newId;
                break;
            }
            ++i;
        }
    }
}

