/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.zip.CRC32;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.DefaultLangModel;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.FlyweightIndexedProperty;
import org.netbeans.modules.java.model.IdentifierArrayProperty;
import org.netbeans.modules.java.model.JavaDocImpl;
import org.netbeans.modules.java.model.MemberElementImpl;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodParameter;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;
import org.openide.src.Type;

abstract class CallableImpl
extends MemberElementImpl
implements ConstructorElement.Impl {
    private static final boolean DEBUG = false;
    static final MethodParameter[] NO_PARAMETERS = new MethodParameter[0];
    private MethodParameter[] parameters = NO_PARAMETERS;
    private Identifier[] exceptions = IdentifierArrayProperty.EMPTY;
    private static IdentifierArrayProperty exceptionSupport;
    private static MethodParamSupport paramSupport;
    private String cachedBody;
    private transient long bodyHash = -1L;
    private static final long serialVersionUID = -357084137587082234L;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$CallableImpl;

    CallableImpl(DefaultLangModel model) {
        super(model);
        if (paramSupport == null) {
            paramSupport = new MethodParamSupport();
            exceptionSupport = new ExceptionSupport();
        }
        this.javadoc = new JavaDocImpl.Method(null, this);
    }

    public JavaDoc.Method getJavaDoc() {
        return (JavaDoc.Method)this.javadoc;
    }

    protected void copyBody(String bodyContent) {
        this.cachedBody = bodyContent;
    }

    void updateBody(String content) {
        if (content == null) {
            this.bodyHash = -1L;
            return;
        }
        long newHash = this.computeHash(content);
        if (newHash == this.bodyHash) {
            return;
        }
        if (this.bodyHash != -1L) {
            this.addPropertyChange(new PropertyChangeEvent(this.getElement(), "body", null, null));
        }
        this.bodyHash = newHash;
    }

    public final MethodParameter[] getParameters() {
        if (this.parameters == NO_PARAMETERS) {
            return this.parameters;
        }
        MethodParameter[] cloneParams = new MethodParameter[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            MethodParameter p = this.parameters[i];
            cloneParams[i] = new MethodParameter(p.getName(), p.getType(), p.isFinal());
            ++i;
        }
        return cloneParams;
    }

    public final Identifier[] getExceptions() {
        if (this.exceptions == IdentifierArrayProperty.EMPTY) {
            return this.exceptions;
        }
        return (Identifier[])this.exceptions.clone();
    }

    public final String getBody() {
        try {
            if (this.cachedBody != null) {
                return this.cachedBody;
            }
            return this.getMethodBinding().getBodyContent();
        }
        catch (SourceException ex) {
            return null;
        }
    }

    protected void notifyCreate() {
        super.notifyCreate();
        if (this.cachedBody != null) {
            this.cachedBody = null;
            String body = this.getBody();
            if (body != null) {
                this.bodyHash = this.computeHash(body);
            }
        }
    }

    private long computeHash(String bodyContent) {
        CRC32 crc = new CRC32();
        crc.update(bodyContent.getBytes());
        return crc.getValue();
    }

    protected void createFromModel(Element model) throws SourceException {
        super.createFromModel(model);
        ConstructorElement m = (ConstructorElement)model;
        this.setParameters(m.getParameters());
        this.setExceptions(m.getExceptions());
        this.copyBody(m.getBody());
        this.setJavaDocText(m.getJavaDoc().getRawText(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameters(MethodParameter[] params) throws SourceException {
        Object token;
        block5: {
            block4: {
                token = this.takeLock();
                try {
                    if (!this.isCreated()) {
                        params = this.resolveParams(params);
                        MultiPropertyChangeEvent evt = paramSupport.createChangeEvent(this.getElement(), this.parameters == null ? NO_PARAMETERS : this.parameters, params);
                        if (evt == null) {
                            Object var5_4 = null;
                            break block4;
                        }
                        this.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                        this.getMethodBinding().changeParameters(params);
                        this.fireOwnPropertyChange((PropertyChangeEvent)evt);
                    }
                    this.parameters = params;
                    this.commit();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.releaseLock(token);
                    throw throwable;
                }
            }
            this.releaseLock(token);
            return;
        }
        Object var5_5 = null;
        this.releaseLock(token);
    }

    private MethodParameter resolveParameter(MethodParameter par) {
        Type t = this.resolveType(par.getType());
        if (t == par.getType()) {
            return par;
        }
        return new MethodParameter(par.getName(), t, par.isFinal());
    }

    private MethodParameter[] resolveParams(MethodParameter[] params) {
        if (!this.isConstrained()) {
            return params;
        }
        int[] map = paramSupport.pairItems(this.parameters, params);
        MethodParameter[] newParams = null;
        int i = 0;
        while (i < map.length) {
            MethodParameter p;
            if (map[i] == -1 && (p = this.resolveParameter(params[i])) != params[i]) {
                if (newParams == null) {
                    newParams = new MethodParameter[params.length];
                    System.arraycopy(params, 0, newParams, 0, params.length);
                }
                newParams[i] = p;
            }
            ++i;
        }
        return newParams == null ? params : newParams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setExceptions(Identifier[] except) throws SourceException {
        Object token;
        block5: {
            block4: {
                token = this.takeLock();
                try {
                    if (!this.isCreated()) {
                        except = this.resolveIdentifiers(except);
                        MultiPropertyChangeEvent evt = exceptionSupport.createChangeEvent(this.getElement(), this.exceptions == null ? IdentifierArrayProperty.EMPTY : this.exceptions, except);
                        if (evt == null) {
                            Object var5_4 = null;
                            break block4;
                        }
                        this.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                        this.getMethodBinding().changeExceptions(except);
                        this.fireOwnPropertyChange((PropertyChangeEvent)evt);
                    }
                    this.exceptions = except;
                    this.commit();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.releaseLock(token);
                    throw throwable;
                }
            }
            this.releaseLock(token);
            return;
        }
        Object var5_5 = null;
        this.releaseLock(token);
    }

    public final void setBody(String body) throws SourceException {
        String oldBody;
        Object token = this.takeLock();
        try {
            block10: {
                if (this.isCreated()) break block9;
                oldBody = this.getMethodBinding().getBodyContent();
                if (oldBody == body) break block10;
                if (oldBody == null || body == null || !oldBody.equals(body)) break block11;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseLock(token);
            throw throwable;
        }
        this.releaseLock(token);
        {
            block9: {
                block11: {
                    return;
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "body", oldBody, body);
                this.checkVetoablePropertyChange(evt);
                if (body == null) {
                    this.getMethodBinding().makeAbstract();
                } else if (oldBody == null) {
                    this.getMethodBinding().createBody(body);
                } else {
                    this.getMethodBinding().changeBody(body);
                }
                body = this.getBody();
                evt = new PropertyChangeEvent(this.getElement(), "body", oldBody, body);
                this.addPropertyChange(evt);
            }
            this.bodyHash = this.computeHash(body);
            this.commit();
        }
        Object var6_5 = null;
        this.releaseLock(token);
    }

    protected void initializeListenerSupport() {
        Class clazz;
        if (exceptionSupport == null) {
            clazz = class$org$netbeans$modules$java$model$CallableImpl == null ? (class$org$netbeans$modules$java$model$CallableImpl = CallableImpl.class$("org.netbeans.modules.java.model.CallableImpl")) : class$org$netbeans$modules$java$model$CallableImpl;
            synchronized (clazz) {
                if (exceptionSupport == null) {
                    exceptionSupport = new ExceptionSupport();
                }
            }
        }
        if (paramSupport == null) {
            clazz = class$org$netbeans$modules$java$model$CallableImpl == null ? (class$org$netbeans$modules$java$model$CallableImpl = CallableImpl.class$("org.netbeans.modules.java.model.CallableImpl")) : class$org$netbeans$modules$java$model$CallableImpl;
            synchronized (clazz) {
                if (paramSupport == null) {
                    paramSupport = new MethodParamSupport();
                }
            }
        }
    }

    protected final Binding.Method getMethodBinding() {
        return (Binding.Method)this.getBinding();
    }

    protected void copyCallableProperties(ConstructorElement el) {
        try {
            el.setName(this.getName());
            el.setModifiers(this.getModifiers());
            el.setParameters(this.getParameters());
            el.setExceptions(this.getExceptions());
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ExceptionSupport
    extends IdentifierArrayProperty {
        ExceptionSupport() {
            super("exceptions");
        }

        public Object[] getAsArray(ElementImpl bean) {
            return ((CallableImpl)bean).exceptions;
        }

        protected final Object[] getValue(ElementImpl impl) {
            return ((CallableImpl)impl).exceptions;
        }

        public boolean compareValues(Object one, Object two) {
            return MemberElementImpl.compareSourceIdentifiers((Identifier)one, (Identifier)two);
        }
    }

    private static final class MethodParamSupport
    extends FlyweightIndexedProperty {
        MethodParamSupport() {
            super("parameters");
        }

        protected final Object[] createEmpty() {
            return NO_PARAMETERS;
        }

        protected final Object[] createValue(int size) {
            if (size == 0) {
                return this.createEmpty();
            }
            return new MethodParameter[size];
        }

        protected boolean compareValues(Object a, Object b) {
            MethodParameter par1 = (MethodParameter)a;
            MethodParameter par2 = (MethodParameter)b;
            Type t1 = par1.getType();
            Type t2 = par2.getType();
            if (!par1.getName().equals(par2.getName())) {
                return false;
            }
            if (par1.isFinal() != par2.isFinal()) {
                return false;
            }
            return MemberElementImpl.compareSourceTypes(t1, t2);
        }

        protected final Object[] getValue(ElementImpl impl) {
            return ((CallableImpl)impl).parameters;
        }
    }
}

