/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.DefaultLangModel;
import org.netbeans.modules.java.model.ElementEvents;
import org.netbeans.modules.java.model.EventQueue;
import org.netbeans.modules.java.model.ExceptionRunnable;
import org.netbeans.modules.java.model.JavaDocImpl;
import org.netbeans.modules.java.model.NullBinding;
import org.netbeans.modules.java.model.SourceElementImpl;
import org.netbeans.modules.java.model.Util;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.src.Element;
import org.openide.src.ElementProperties;
import org.openide.src.Identifier;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.SourceVetoException;
import org.openide.src.Type;

public abstract class ElementImpl
implements Element.Impl,
Element.Impl2,
ElementProperties,
Node.Cookie,
ElementEvents {
    private transient Element element;
    private transient Collection propListeners;
    private transient VetoableChangeSupport vetoSupport;
    private transient Binding binding;
    private transient boolean valid;
    private CookieSet cookieSet;
    private transient DefaultLangModel model;
    private transient boolean inCreation;
    protected JavaDocImpl javadoc;
    private static final Binding NULL_BINDING = new NullBinding();
    private static final boolean DEBUG_EVENTS = false;
    private static final long serialVersionUID = -6337836874152020892L;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$ElementImpl;

    protected ElementImpl(DefaultLangModel model) {
        this.model = model;
        this.inCreation = true;
    }

    public void attachedToElement(Element el) {
        this.element = el;
    }

    public void setBinding(Binding b) {
        if (this.binding != null) {
            return;
        }
        if (b instanceof Node.Cookie) {
            this.getCookieSet().add((Node.Cookie)b);
        }
        this.binding = b;
    }

    private String describeEvent(PropertyChangeEvent evt) {
        StringBuffer sb = new StringBuffer();
        sb.append(evt.getPropertyName());
        Object oldV = evt.getOldValue();
        sb.append(" old = " + this.describeValue(evt.getOldValue()));
        sb.append(" new = " + this.describeValue(evt.getNewValue()));
        return sb.toString();
    }

    private String describeValue(Object o) {
        if (o instanceof Identifier) {
            Identifier id = (Identifier)o;
            return id.getSourceName() + "/" + id.getFullName() + "/" + id.getResolutionStatus();
        }
        if (o instanceof Identifier[]) {
            StringBuffer sb = new StringBuffer();
            sb.append("[ ");
            Identifier[] ids = (Identifier[])o;
            int i = 0;
            while (i < ids.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.describeValue(ids[i]));
                ++i;
            }
            sb.append(" ]");
            return sb.toString();
        }
        if (o instanceof MethodParameter[]) {
            MethodParameter[] pars = (MethodParameter[])o;
            if (pars.length == 0) {
                return "()";
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < pars.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(pars[i].getSourceString());
                sb.append("/");
                Type t = pars[i].getType();
                sb.append(t.getFullString());
                while (t.isArray()) {
                    t = t.getElementType();
                }
                if (t.isClass()) {
                    sb.append('/');
                    sb.append(new Integer(t.getTypeIdentifier().getResolutionStatus()).toString());
                }
                ++i;
            }
            return sb.toString();
        }
        if (o instanceof Type) {
            Type t = (Type)o;
            String s = t.getSourceString() + "/" + t.getFullString();
            while (t.isArray()) {
                t = t.getElementType();
            }
            if (t.isClass()) {
                s = s + "/" + t.getTypeIdentifier().getResolutionStatus();
            }
            return s;
        }
        if (o != null) {
            return o.toString();
        }
        return "null";
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        Object object;
        if (this.propListeners == null) {
            object = this;
            synchronized (object) {
                if (this.propListeners == null) {
                    this.propListeners = new LinkedList();
                    this.initializeListenerSupport();
                }
            }
        }
        object = this.propListeners;
        synchronized (object) {
            this.propListeners.add(l);
        }
    }

    protected boolean isCreated() {
        return this.inCreation;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propListeners != null) {
            Collection collection = this.propListeners;
            synchronized (collection) {
                this.propListeners.remove(l);
            }
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoSupport == null) {
            ElementImpl elementImpl = this;
            synchronized (elementImpl) {
                if (this.vetoSupport == null) {
                    this.vetoSupport = new VetoableChangeSupport(this.element);
                    this.initializeListenerSupport();
                }
            }
        }
        this.vetoSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoSupport != null) {
            this.vetoSupport.removeVetoableChangeListener(l);
        }
    }

    public void markCurrent(boolean beforeAfter) {
    }

    public final Element getElement() {
        return this.element;
    }

    public final CookieSet getCookieSet() {
        if (this.cookieSet == null) {
            ElementImpl elementImpl = this;
            synchronized (elementImpl) {
                if (this.cookieSet == null) {
                    this.cookieSet = new CookieSet();
                    this.initializeCookies(this.cookieSet);
                }
            }
        }
        return this.cookieSet;
    }

    protected void initializeCookies(CookieSet set) {
        set.add((Node.Cookie)this);
    }

    public boolean isValid() {
        return this.valid;
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        this.fireOwnPropertyChange(new PropertyChangeEvent(this.getElement(), name, o, n));
    }

    protected final void firePropertyChangeEvent(PropertyChangeEvent evt) {
        Vector listeners;
        if (this.propListeners == null) {
            return;
        }
        Collection collection = this.propListeners;
        synchronized (collection) {
            listeners = new Vector(this.propListeners);
        }
        int i = 0;
        while (i < listeners.size()) {
            PropertyChangeListener l = (PropertyChangeListener)listeners.elementAt(i);
            l.propertyChange(evt);
            ++i;
        }
    }

    protected final void fireOwnPropertyChange(PropertyChangeEvent evt) {
        if (this.isCreated()) {
            return;
        }
        EventQueue q = this.getModelImpl().getEventQueue();
        q.elementChanged(this);
        this.addPropertyChange(evt);
    }

    protected Element cloneSelf() {
        throw new UnsupportedOperationException("clone unsupported on " + this.getClass());
    }

    protected abstract Binding createBinding(Element var1);

    public final void addPropertyChange(PropertyChangeEvent evt) {
        if (this.isCreated()) {
            return;
        }
        this.getModelImpl().getEventQueue().addPropertyChange(this, evt);
    }

    protected final void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        if (this.isCreated()) {
            return;
        }
        if (this.vetoSupport != null) {
            try {
                this.getModelImpl().notifyEventsDispatched(true);
                this.vetoSupport.fireVetoableChange(name, o, n);
                Object var5_4 = null;
                this.getModelImpl().notifyEventsDispatched(false);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.getModelImpl().notifyEventsDispatched(false);
                throw throwable;
            }
        }
    }

    public final void fireVetoableChange(PropertyChangeEvent evt) throws SourceException {
        if (this.isCreated()) {
            return;
        }
        this.checkVetoablePropertyChange(evt);
    }

    private void doFireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.vetoSupport != null) {
            try {
                this.getModelImpl().notifyEventsDispatched(true);
                this.vetoSupport.fireVetoableChange(evt);
                Object var3_2 = null;
                this.getModelImpl().notifyEventsDispatched(false);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.getModelImpl().notifyEventsDispatched(false);
                throw throwable;
            }
        }
    }

    protected void checkVetoablePropertyChange(PropertyChangeEvent evt) throws SourceException {
        if (this.isCreated() || !this.isConstrained()) {
            return;
        }
        try {
            this.doFireVetoableChange(evt);
        }
        catch (SourceVetoException ex) {
            throw ex.getNestedException();
        }
        catch (PropertyVetoException ex) {
            throw new SourceException(ex.getMessage());
        }
    }

    public final Binding getBinding() {
        if (this.isCreated()) {
            return NULL_BINDING;
        }
        return this.binding;
    }

    public final Binding getRawBinding() {
        return this.binding;
    }

    protected void invalidate() {
        this.setValid(false);
    }

    private void setValid(boolean valid) {
        boolean old = this.valid;
        if (old == valid) {
            return;
        }
        this.valid = valid;
        if (old) {
            this.addPropertyChange(new PropertyChangeEvent(this.getEventSource(), "valid", valid ? Boolean.FALSE : Boolean.TRUE, valid ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    protected void checkValid(Object lockToken) throws SourceException {
        if (this.isValid()) {
            return;
        }
        this.releaseLock(lockToken);
        Util.throwException("Element was deleted", "EXC_ElementInvalid");
    }

    public Node.Cookie getCookie(Class desired) {
        if (desired.isAssignableFrom(this.getClass())) {
            return this;
        }
        Node.Cookie ret = this.getCookieSet().getCookie(desired);
        if (ret != null) {
            return ret;
        }
        return this.getModelImpl().findElementCookie(this.getElement(), desired);
    }

    protected abstract SourceElementImpl findSource();

    protected void createAfter(Binding.Container cb, Binding refBinding) throws SourceException {
        this.inCreation = false;
        cb.insert(this.binding, refBinding);
        this.setValid(true);
    }

    protected abstract boolean parentValid();

    protected void notifyCreate() {
        this.inCreation = false;
        this.setValid(true);
        if (this.parentValid()) {
            this.notifyElementCreated();
        }
    }

    protected void notifyElementCreated() {
        this.getModelImpl().getEventQueue().elementCreated(this.getElement());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setJavaDocText(String content, boolean raw) throws SourceException {
        if (this.isCreated()) {
            this.javadoc.changeJavaDocText(content, raw);
            return;
        }
        Object token = this.takeLock();
        boolean OK = false;
        String oldContent = raw ? this.javadoc.getRawText() : this.javadoc.getText();
        try {
            block6: {
                if (content == oldContent) break block6;
                if (content == null || oldContent == null || !content.equals(oldContent)) break block7;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseLock(token);
            if (OK) throw throwable;
            this.javadoc.changeJavaDocText(oldContent, raw);
            throw throwable;
        }
        this.releaseLock(token);
        if (OK) return;
        this.javadoc.changeJavaDocText(oldContent, raw);
        {
            block7: {
                return;
            }
            this.javadoc.changeJavaDocText(content, raw);
            this.getBinding().changeJavaDoc(this.javadoc);
            OK = true;
            this.addPropertyChange(new PropertyChangeEvent(this.getEventSource(), "javadoc", null, null));
            this.commit();
        }
        Object var7_7 = null;
        this.releaseLock(token);
        if (OK) return;
        this.javadoc.changeJavaDocText(oldContent, raw);
        return;
    }

    protected void changeJavaDocTags(JavaDocTag[] tags, int action) throws SourceException {
        if (this.isCreated()) {
            this.javadoc.changeJavaDocTags(tags, action);
            return;
        }
        Object token = this.takeLock();
        boolean OK = false;
        String oldContent = this.javadoc.getRawText();
        try {
            this.javadoc.changeJavaDocTags(tags, action);
            this.getBinding().changeJavaDoc(this.javadoc);
            this.addPropertyChange(new PropertyChangeEvent(this.getEventSource(), "javadoc", null, null));
            this.commit();
            OK = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseLock(token);
            if (!OK) {
                this.javadoc.changeJavaDocText(oldContent, true);
            }
            throw throwable;
        }
        this.releaseLock(token);
        if (!OK) {
            this.javadoc.changeJavaDocText(oldContent, true);
        }
    }

    protected void notifyRemove() {
        this.invalidate();
        this.getModelImpl().getEventQueue().elementRemoved(this.getElement());
    }

    protected void checkRemove() throws SourceException {
        if (this.isCreated() || !this.isConstrained()) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "valid", Boolean.TRUE, Boolean.FALSE);
        this.checkVetoablePropertyChange(evt);
    }

    protected boolean hasListeners(String propName) {
        if (this.vetoSupport.hasListeners(propName)) {
            return true;
        }
        if (this.propListeners == null) {
            return false;
        }
        Collection collection = this.propListeners;
        synchronized (collection) {
            boolean bl = !this.propListeners.isEmpty();
            return bl;
        }
    }

    protected void runAtomic(ExceptionRunnable r) throws SourceException {
        this.model.runAtomic(r);
    }

    protected void initializeListenerSupport() {
    }

    public final Object getEventSource() {
        return this.getElement();
    }

    public final ElementImpl getElementImpl() {
        return this;
    }

    protected abstract void setParent(ElementImpl var1);

    protected void setParent(Element parent) {
        this.setParent((ElementImpl)parent.getCookie(class$org$netbeans$modules$java$model$ElementImpl == null ? (class$org$netbeans$modules$java$model$ElementImpl = ElementImpl.class$("org.netbeans.modules.java.model.ElementImpl")) : class$org$netbeans$modules$java$model$ElementImpl));
        this.setBinding(this.createBinding(this.element));
    }

    protected final DefaultLangModel getModelImpl() {
        return this.model;
    }

    protected final Object takeLock() throws SourceException {
        if (this.isCreated()) {
            return null;
        }
        Object o = this.getModelImpl().writeLock();
        this.checkValid(o);
        return o;
    }

    protected final void releaseLock(Object o) throws SourceException {
        if (this.isCreated()) {
            return;
        }
        this.getModelImpl().releaseWriteLock(o);
    }

    protected final Object takeMasterLock() throws SourceException {
        if (this.isCreated()) {
            return null;
        }
        Object l = this.getModelImpl().masterWriteLock();
        this.checkValid(l);
        return l;
    }

    protected abstract void createFromModel(Element var1) throws SourceException;

    protected final void commit() {
        if (!this.isValid()) {
            return;
        }
        this.getModelImpl().commitChanges();
    }

    protected final boolean isConstrained() {
        return this.getModelImpl().isConstrained();
    }

    protected Identifier createLocalIdentifier(Identifier id, int status) {
        if (id.getResolutionStatus() == status) {
            return id;
        }
        return Identifier.create((String)id.getFullName(), (String)id.getSourceName(), (int)status);
    }

    protected boolean checkIdentifierContext(Identifier id) {
        return false;
    }

    public abstract Object readResolve();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

