/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.java.model.ElementImpl;
import org.openide.src.Element;

class EventQueue {
    Collection eventQueue;
    Map sourceMap;
    Map changedElements;
    Set newElements;
    Set removedElements;
    EventQueue parent;
    private boolean firingEvents;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$ElementImpl;

    public EventQueue(EventQueue parent) {
        this.parent = parent;
    }

    public void elementChanged(Element el, Element oldVersion) {
        if (this.containsChanges(el)) {
            return;
        }
        if (this.changedElements == null) {
            this.changedElements = new HashMap(17);
        }
        this.changedElements.put(el, oldVersion);
    }

    public void elementChanged(ElementImpl impl) {
        Element el = impl.getElement();
        if (this.containsChanges(el)) {
            return;
        }
        if (this.changedElements == null) {
            this.changedElements = new HashMap(17);
        }
        this.changedElements.put(el, impl.cloneSelf());
    }

    public void elementCreated(Element el) {
        if (this.newElements == null) {
            this.newElements = new HashSet(17);
        }
        this.newElements.add(el);
    }

    public void elementRemoved(Element el) {
        if (this.newElements != null) {
            this.newElements.remove(el);
        }
        if (this.removedElements == null) {
            this.removedElements = new HashSet(17);
        }
        this.removedElements.add(el);
    }

    public boolean containsChanges(Element el) {
        if (this.newElements != null && this.newElements.contains(el)) {
            return true;
        }
        return this.changedElements != null && this.changedElements.containsKey(el);
    }

    public synchronized void addPropertyChange(ElementImpl impl, PropertyChangeEvent evt) {
        ElementImpl source = impl;
        Collection queue = this.getQueue(source);
        queue.add(evt);
        if (this.eventQueue == null) {
            this.eventQueue = new LinkedList();
        }
        this.eventQueue.add(impl);
        this.eventQueue.add(evt);
    }

    public void fireEvents() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.firingEvents) {
                return;
            }
            this.firingEvents = true;
        }
        Collection col = this.pollEventQueue();
        while (col != null && !col.isEmpty()) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ElementImpl impl = (ElementImpl)it.next();
                PropertyChangeEvent evt = (PropertyChangeEvent)it.next();
                impl.firePropertyChangeEvent(evt);
            }
            col = this.pollEventQueue();
        }
        EventQueue eventQueue2 = this;
        synchronized (eventQueue2) {
            this.firingEvents = false;
        }
    }

    private void fireElementEvents(ElementImpl impl, Collection eventQueue) {
        Iterator it = eventQueue.iterator();
        while (it.hasNext()) {
            PropertyChangeEvent evt = (PropertyChangeEvent)it.next();
            impl.firePropertyChangeEvent(evt);
        }
    }

    private synchronized Map pollEvents() {
        Map m = this.sourceMap;
        this.sourceMap = null;
        return m;
    }

    private synchronized Collection pollEventQueue() {
        Collection c = this.eventQueue;
        this.eventQueue = null;
        this.sourceMap = null;
        return c;
    }

    private synchronized Collection getQueue(Object source) {
        LinkedList c;
        if (this.sourceMap == null) {
            this.sourceMap = new HashMap(17);
            c = null;
        } else {
            c = (LinkedList)this.sourceMap.get(source);
        }
        if (c != null) {
            return c;
        }
        c = new LinkedList();
        this.sourceMap.put(source, c);
        return c;
    }

    public void fixupChanges() {
        if (this.changedElements == null) {
            return;
        }
        Iterator it = this.changedElements.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            Element source = (Element)en.getKey();
            Element oldSnapshot = (Element)en.getValue();
            ElementImpl impl = (ElementImpl)source.getCookie(class$org$netbeans$modules$java$model$ElementImpl == null ? EventQueue.class$("org.netbeans.modules.java.model.ElementImpl") : class$org$netbeans$modules$java$model$ElementImpl);
            Element newSnapshot = impl.cloneSelf();
            en.setValue(new Object[]{oldSnapshot, newSnapshot});
        }
    }

    private void mergeChild(EventQueue other) {
        if (other.removedElements != null) {
            if (this.newElements != null) {
                HashSet copy = new HashSet(other.removedElements);
                other.removedElements.removeAll(this.newElements);
                this.newElements.removeAll(copy);
            }
            if (this.removedElements == null) {
                this.removedElements = other.removedElements;
            } else {
                this.removedElements.addAll(other.removedElements);
            }
        }
        if (other.newElements != null) {
            if (this.newElements == null) {
                this.newElements = other.newElements;
            } else {
                this.newElements.addAll(other.newElements);
            }
        }
        if (other.changedElements != null) {
            if (this.newElements != null) {
                other.changedElements.keySet().removeAll(this.newElements);
            }
            if (this.changedElements != null) {
                other.changedElements.putAll(this.changedElements);
            }
            this.changedElements = other.changedElements;
        }
        if (other.sourceMap != null) {
            this.mergePropertyEventMaps(other.sourceMap);
        }
        if (other.eventQueue != null) {
            if (this.eventQueue == null) {
                this.eventQueue = other.eventQueue;
            } else {
                this.eventQueue.addAll(other.eventQueue);
            }
        }
    }

    private synchronized void mergePropertyEventMaps(Map otherMap) {
        if (this.sourceMap == null) {
            this.sourceMap = otherMap;
            return;
        }
        Iterator otherIterator = otherMap.entrySet().iterator();
        while (otherIterator.hasNext()) {
            Map.Entry otherEntry = otherIterator.next();
            Object otherKey = otherEntry.getKey();
            Collection myQueue = (Collection)this.sourceMap.get(otherKey);
            if (myQueue == null) {
                this.sourceMap.put(otherKey, otherEntry.getValue());
                continue;
            }
            myQueue.addAll((Collection)otherEntry.getValue());
        }
    }

    public void mergeToParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.mergeChild(this);
    }

    public final Map getChangedElements() {
        return this.changedElements;
    }

    public final Set getCreatedElements() {
        return this.newElements;
    }

    public final Set getRemovedElements() {
        return this.removedElements;
    }

    public final EventQueue getParent() {
        return this.parent;
    }

    public void clearSummary() {
        this.removedElements = null;
        this.newElements = null;
        this.changedElements = null;
    }

    public boolean isEmpty() {
        if (this.newElements != null && !this.newElements.isEmpty()) {
            return false;
        }
        if (this.changedElements != null && !this.changedElements.isEmpty()) {
            return false;
        }
        return this.removedElements == null || this.removedElements.isEmpty();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

