/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.ElementCreator;
import org.netbeans.modules.java.model.ElementEvents;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.ImportElement;
import org.netbeans.modules.java.model.ImportImpl;
import org.netbeans.modules.java.model.IndexedPropertyBase;
import org.netbeans.modules.java.model.ObjectCollection;
import org.netbeans.modules.java.model.Positioner;
import org.openide.src.Element;
import org.openide.src.Import;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;

class ImportCollection
extends ObjectCollection {
    Import[] importCache;
    static final ImportElement[] NO_IMPORT_ELEMENTS = new ImportElement[0];
    static final Import[] NO_IMPORTS = new Import[0];

    public ImportCollection(Binding.Container binding, ElementCreator creator, ElementEvents events) {
        super(binding, creator, events, "imports");
    }

    protected ElementImpl createElement(Element parent) {
        return null;
    }

    protected Element copyElement(Element el) {
        return el;
    }

    private ImportElement createElement(Import im) throws SourceException {
        ImportImpl iimpl = this.creator.createImport((SourceElement)this.events.getEventSource());
        iimpl.setImport(im);
        return (ImportElement)iimpl.getElement();
    }

    public Element[] createEmpty(int size) {
        return size == 0 ? NO_IMPORT_ELEMENTS : new ImportElement[size];
    }

    protected void fireVetoableChange(PropertyChangeEvent e) throws SourceException {
    }

    public void importsChanged() {
        this.importCache = null;
    }

    protected void doSetMembers(Element[] newElements, IndexedPropertyBase.Change chng) throws SourceException {
        super.doSetMembers(newElements, chng);
        this.importCache = null;
    }

    private void addImports(Import[] els) throws SourceException {
        ArrayList<Import> unique = new ArrayList<Import>(els.length);
        ImportElement[] imps = (ImportElement[])this.getElements();
        int i = 0;
        while (i < els.length) {
            boolean matches = false;
            int j = 0;
            while (j < imps.length) {
                if (els[i].equals((Object)imps[j].getImport())) {
                    matches = true;
                    break;
                }
                ++j;
            }
            if (!matches) {
                unique.add(els[i]);
            }
            ++i;
        }
        if (unique.isEmpty()) {
            return;
        }
        Element[] importEls = new ImportElement[unique.size()];
        Iterator it = unique.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            importEls[i2] = this.createElement((Import)it.next());
            ++i2;
        }
        super.addMembers(importEls);
    }

    private void removeImports(Import[] els) throws SourceException {
        ArrayList<ImportElement> toRemove = new ArrayList<ImportElement>(els.length);
        ImportElement[] ims = (ImportElement[])this.getElements();
        BitSet used = new BitSet(ims.length);
        int i = 0;
        while (i < els.length) {
            int j = 0;
            while (j < ims.length) {
                if (!used.get(j) && ims[j].getImport().equals((Object)els[i])) {
                    used.set(j);
                    toRemove.add(ims[j]);
                }
                ++j;
            }
            ++i;
        }
        if (toRemove.isEmpty()) {
            return;
        }
        Element[] ee = toRemove.toArray(this.createEmpty(0));
        super.removeMembers(ee);
    }

    public void updateMembers(Element[] members, int[] map) {
        super.updateMembers(members, map);
        this.importCache = null;
    }

    private void setImports(Import[] imports) throws SourceException {
        Object[] members = this.getElements();
        int[] map = this.pairItems(members, imports);
        Element[] newEls = new ImportElement[imports.length];
        int i = 0;
        while (i < map.length) {
            newEls[i] = map[i] == -1 ? this.createElement(imports[i]) : members[map[i]];
            ++i;
        }
        IndexedPropertyBase.Change chng = IndexedPropertyBase.computeChanges2(members, newEls, map);
        if (chng.phaseCount == 0) {
            return;
        }
        this.doSetMembers(newEls, chng);
    }

    protected boolean compareValues(Object o1, Object o2) {
        if (!(o1 instanceof ImportElement) || !(o2 instanceof Import)) {
            return false;
        }
        Import i2 = (Import)o2;
        ImportElement i1 = (ImportElement)((Object)o1);
        return i1.getImport().equals((Object)i2);
    }

    public void changeMembers(Import[] elements, int operation) throws SourceException {
        switch (operation) {
            case 1: {
                this.addImports(elements);
                break;
            }
            case -1: {
                this.removeImports(elements);
                break;
            }
            case 0: {
                this.setImports(elements);
            }
        }
    }

    public Element[] findPositions(Element[] elements) {
        Element[] markers = new Element[elements.length];
        Element[] cur = this.getElements();
        Element foundImpEl = null;
        int i = 0;
        while (i < markers.length) {
            Import newImp = ((ImportElement)elements[i]).getImport();
            int c = 0;
            while (c < cur.length) {
                Import imp = ((ImportElement)cur[c]).getImport();
                if (imp.getIdentifier().getFullName().compareTo(newImp.getIdentifier().getFullName()) < 0) {
                    foundImpEl = cur[c];
                }
                ++c;
            }
            markers[i] = foundImpEl != null ? foundImpEl : Positioner.FIRST;
            ++i;
        }
        return markers;
    }

    public Import[] getImports() {
        Import[] cached = this.importCache;
        if (cached != null) {
            return cached;
        }
        ImportCollection importCollection = this;
        synchronized (importCollection) {
            cached = this.importCache;
            if (cached != null) {
                Import[] importArray = cached;
                return importArray;
            }
            ImportElement[] elems = (ImportElement[])this.getElements();
            Import[] imp = new Import[elems.length];
            int i = 0;
            while (i < elems.length) {
                imp[i] = elems[i].getImport();
                ++i;
            }
            this.importCache = imp;
            Import[] importArray = imp;
            return importArray;
        }
    }

    protected MultiPropertyChangeEvent createPropertyEvent(IndexedPropertyBase.Change chng, Object source, Object[] elems, Object[] newV) {
        Import[] oldImports = this.getImports();
        Import[] newImports = new Import[newV.length];
        chng = (IndexedPropertyBase.Change)chng.clone();
        int i = 0;
        while (i < newImports.length) {
            newImports[i] = ((ImportElement)((Object)newV[i])).getImport();
            ++i;
        }
        this.mapImports(chng.inserted);
        this.mapImports(chng.removed);
        return super.createPropertyEvent(chng, source, oldImports, newImports);
    }

    private Collection mapImports(Collection o) {
        if (o == null) {
            return null;
        }
        ArrayList<Import> c = new ArrayList<Import>(o.size());
        Iterator it = o.iterator();
        while (it.hasNext()) {
            c.add(((ImportElement)((Object)it.next())).getImport());
        }
        return c;
    }
}

