/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.ElementCreator;
import org.netbeans.modules.java.model.ElementEvents;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.ElementOrder;
import org.netbeans.modules.java.model.IndexedPropertyBase;
import org.netbeans.modules.java.model.Positioner;
import org.openide.src.Element;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;

abstract class ObjectCollection
extends IndexedPropertyBase
implements ElementOrder {
    public static final int SMALL_THRESHOLD = 500;
    Binding.Container containerBinding;
    ElementEvents events;
    Element[] elements;
    ElementCreator creator;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$ElementImpl;

    public ObjectCollection(Binding.Container container, ElementCreator creator, ElementEvents events, String propertyName) {
        super(propertyName);
        this.events = events;
        this.creator = creator;
        this.containerBinding = container;
    }

    public Element[] getElements() {
        if (this.elements == null) {
            return this.createEmpty(0);
        }
        return this.elements;
    }

    protected abstract Element[] findPositions(Element[] var1);

    protected abstract ElementImpl createElement(Element var1);

    protected abstract Element[] createEmpty(int var1);

    protected Element copyElement(Element model) {
        ElementImpl impl = this.createElement((Element)this.events.getEventSource());
        try {
            impl.createFromModel(model);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return impl.getElement();
    }

    public void addMembers(Element[] els) throws SourceException {
        Element[] insertingEls = new Element[els.length];
        Element[] elements = this.getElements();
        int i = 0;
        while (i < els.length) {
            insertingEls[i] = this.copyElement(els[i]);
            ++i;
        }
        Element[] precedings = this.findPositions(insertingEls);
        Element[] newElems = this.createEmpty(insertingEls.length + elements.length);
        int[] insertIndices = new int[newElems.length];
        HashMap m = new HashMap(precedings.length * 4 / 3);
        int i2 = 0;
        while (i2 < precedings.length) {
            Object o = m.get(precedings[i2]);
            if (o != null) {
                LinkedList<Object> c;
                if (!(o instanceof Collection)) {
                    c = new LinkedList<Object>();
                    c.add(o);
                    m.put(precedings[i2], c);
                } else {
                    c = (LinkedList<Object>)o;
                }
                c.add(insertingEls[i2]);
            } else {
                m.put(precedings[i2], insertingEls[i2]);
            }
            ++i2;
        }
        Element prevElem = Positioner.FIRST;
        int newPos = 0;
        int oldPos = 0;
        int inserted = 0;
        oldPos = 0;
        while (oldPos <= elements.length) {
            Object dependent = m.get(prevElem);
            if (dependent != null) {
                LinkedList toInsert = new LinkedList();
                do {
                    if (dependent != null) {
                        if (dependent instanceof Collection) {
                            toInsert.addAll((Collection)dependent);
                        } else {
                            toInsert.add(dependent);
                        }
                    }
                    Element newEl = (Element)toInsert.removeFirst();
                    insertIndices[inserted] = newPos;
                    newElems[newPos] = newEl;
                    ++inserted;
                    ++newPos;
                    dependent = m.get(newEl);
                } while (!toInsert.isEmpty() || dependent != null);
            }
            if (oldPos >= elements.length) break;
            prevElem = elements[oldPos];
            newElems[newPos] = elements[oldPos];
            ++newPos;
            ++oldPos;
        }
        if (inserted < insertingEls.length) {
            throw new IllegalArgumentException("Inconsistent insertion strategy");
        }
        IndexedPropertyBase.Change chng = new IndexedPropertyBase.Change();
        chng.insertIndices = insertIndices;
        chng.inserted = Arrays.asList(insertingEls);
        chng.phaseCount = 1;
        chng.sizeDiff = insertingEls.length;
        this.doSetMembers(newElems, chng);
    }

    public void removeMembers(Element[] els) throws SourceException {
        Element[] elements = this.getElements();
        int[] removeIndices = this.createIdentityMap(els);
        int i = 0;
        while (i < removeIndices.length) {
            if (removeIndices[i] == -1) {
                throw new SourceException("Element does not exist");
            }
            ++i;
        }
        Element[] newElems = this.createEmpty(elements.length - els.length);
        int[] offsets = new int[elements.length];
        int newPos = 0;
        int removed = 0;
        int nextRemove = removeIndices[0];
        int i2 = 0;
        while (i2 < elements.length) {
            if (i2 == nextRemove) {
                offsets[i2] = -i2 - 1;
                nextRemove = ++removed < removeIndices.length ? removeIndices[removed] : -1;
            } else {
                offsets[i2] = newPos - i2;
                newElems[newPos] = elements[i2];
                ++newPos;
            }
            ++i2;
        }
        IndexedPropertyBase.Change ch = new IndexedPropertyBase.Change();
        ch.removed = Arrays.asList(els);
        ch.removeIndices = removeIndices;
        ch.offsets = offsets;
        ch.sizeDiff = -els.length;
        ch.phaseCount = 1;
        this.doSetMembers(newElems, ch);
    }

    public void updateMembers(Element[] members, int[] map) {
        Collection<Object> newMembers = null;
        if (this.elements != null) {
            Collection removedMembers;
            Object[] els = this.getElements();
            if (els != null) {
                if (map == null) {
                    map = this.createIdentityMap(members);
                }
                IndexedPropertyBase.Change chng = IndexedPropertyBase.computeChanges2(els, members, map);
                if (chng.phaseCount == 0) {
                    return;
                }
                this.events.addPropertyChange((PropertyChangeEvent)this.createPropertyEvent(chng, this.events.getEventSource(), els, members));
                newMembers = chng.inserted;
                removedMembers = chng.removed;
            } else {
                newMembers = Arrays.asList(members);
                removedMembers = null;
            }
            ElementImpl parent = this.events.getElementImpl();
            boolean fire = parent.isValid();
            if (fire) {
                ElementImpl impl;
                Element el;
                Iterator it;
                if (removedMembers != null && !removedMembers.isEmpty()) {
                    it = removedMembers.iterator();
                    while (it.hasNext()) {
                        el = (Element)it.next();
                        impl = this.getElementImpl(el);
                        impl.notifyRemove();
                    }
                }
                if (newMembers != null && !newMembers.isEmpty()) {
                    it = newMembers.iterator();
                    while (it.hasNext()) {
                        el = (Element)it.next();
                        impl = this.getElementImpl(el);
                        impl.notifyCreate();
                    }
                }
            }
        } else if (!this.events.getElementImpl().isCreated() && members.length > 0) {
            ElementImpl parent = this.events.getElementImpl();
            boolean fire = parent.isValid();
            int i = 0;
            while (i < members.length) {
                Element el = members[i];
                ElementImpl impl = this.getElementImpl(el);
                impl.notifyCreate();
                ++i;
            }
        }
        this.elements = members;
    }

    public void setMembers(Element[] members) throws SourceException {
        Object[] els = this.getElements();
        Object[] newEls = this.createEmpty(members.length);
        int[] map = this.createIdentityMap(members);
        boolean memberPos = false;
        boolean copied = false;
        int i = 0;
        while (i < map.length) {
            if (map[i] == -1) {
                newEls[i] = this.copyElement(members[i]);
                copied = true;
            } else {
                newEls[i] = members[i];
            }
            ++i;
        }
        IndexedPropertyBase.Change chng = IndexedPropertyBase.computeChanges2(els, newEls, map);
        this.doSetMembers((Element[])newEls, chng);
    }

    protected Binding getBinding(Object o) {
        return this.getBinding((Element)o);
    }

    protected Binding getBinding(Element el) {
        ElementImpl impl = this.getElementImpl(el);
        return impl == null ? null : impl.getBinding();
    }

    protected ElementImpl getElementImpl(Element el) {
        return (ElementImpl)el.getCookie(class$org$netbeans$modules$java$model$ElementImpl == null ? (class$org$netbeans$modules$java$model$ElementImpl = ObjectCollection.class$("org.netbeans.modules.java.model.ElementImpl")) : class$org$netbeans$modules$java$model$ElementImpl);
    }

    public void changeMembers(Element[] members, int operation) throws SourceException {
        switch (operation) {
            case 1: {
                this.addMembers(members);
                break;
            }
            case 0: {
                this.setMembers(members);
                break;
            }
            case -1: {
                this.removeMembers(members);
            }
        }
    }

    protected void doSetMembers(Element[] newMembers, IndexedPropertyBase.Change chg) throws SourceException {
        if (chg.phaseCount == 0) {
            return;
        }
        Element[] elements = this.getElements();
        boolean deferredCreation = this.events.getElementImpl().isCreated();
        if (!deferredCreation) {
            Iterator it;
            if (this.events.getElementImpl().isConstrained() && chg.removed != null) {
                it = chg.removed.iterator();
                while (it.hasNext()) {
                    this.getElementImpl((Element)it.next()).checkRemove();
                }
            }
            MultiPropertyChangeEvent evt = this.createPropertyEvent(chg, this.events.getEventSource(), this.getElements(), newMembers);
            this.fireVetoableChange((PropertyChangeEvent)evt);
            this.containerBinding.changeMembers(evt);
            if (chg.inserted != null) {
                it = chg.inserted.iterator();
                while (it.hasNext()) {
                    this.getElementImpl((Element)it.next()).notifyCreate();
                }
            }
            if (chg.removed != null) {
                Iterator it2 = chg.removed.iterator();
                while (it2.hasNext()) {
                    this.getElementImpl((Element)it2.next()).notifyRemove();
                }
            }
            this.addPropertyChange((PropertyChangeEvent)evt);
        }
        this.elements = newMembers;
    }

    protected void fireVetoableChange(PropertyChangeEvent evt) throws SourceException {
        this.events.fireVetoableChange(evt);
    }

    protected void addPropertyChange(PropertyChangeEvent evt) {
        this.events.addPropertyChange(evt);
    }

    protected int[] createIdentityMap(Element[] els) {
        Object[] olds = this.getElements();
        return super.createIdentityMap(els, olds);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

