/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.BaseElementInfo;
import org.netbeans.modules.java.parser.ElementMatch;
import org.openide.src.Element;
import org.openide.src.SourceException;

public class ChildCollection {
    Collection children;
    ElementMatch.Finder[] finders;
    int[] ids;
    int[] results;
    int idIndex;
    Class componentClass;
    private static final int MIN_IDS = 15;

    public ChildCollection(ElementMatch.Finder[] finders, Class componentClass) {
        this.finders = finders;
        this.componentClass = componentClass;
    }

    public int[] getIDs() {
        return this.ids;
    }

    public int[] getResultMap() {
        return this.results;
    }

    protected Element[] createArray(int size) {
        return (Element[])Array.newInstance(this.componentClass, size);
    }

    public void addChild(BaseElementInfo el, int id) {
        if (this.children == null) {
            this.children = new LinkedList();
            if (id != -1) {
                this.ids = new int[15];
            }
        }
        this.children.add(el);
        if (this.ids != null) {
            if (this.ids.length == this.idIndex) {
                int[] newIDs = new int[this.ids.length * 2];
                System.arraycopy(this.ids, 0, newIDs, 0, this.ids.length);
                this.ids = newIDs;
            }
            this.ids[this.idIndex++] = id;
        }
    }

    private Element[] createAllChildren(Element parent, LangModel.Updater updater) throws SourceException {
        Element[] newElements = this.createArray(this.children.size());
        int i = 0;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            BaseElementInfo info = (BaseElementInfo)it.next();
            newElements[i] = info.createModelElement(parent, updater);
            ++i;
        }
        return newElements;
    }

    public Element[] updateChildren(Element parent, LangModel.Updater model, Element[] oldChildren) throws SourceException {
        if (oldChildren.length == 0) {
            return this.createAllChildren(parent, model);
        }
        ElementMatch match = new ElementMatch(oldChildren, this.children);
        int i = 0;
        while (i < this.finders.length) {
            match.reset();
            this.finders[i].findMatches(match);
            ++i;
        }
        int[] mapping = match.getResultMap();
        Element[] oldElements = match.getOldElements();
        Element[] newElements = this.createArray(this.children.size());
        Collection current = match.getInfos();
        Iterator it = current.iterator();
        this.results = mapping;
        int i2 = 0;
        while (it.hasNext()) {
            BaseElementInfo info = (BaseElementInfo)it.next();
            if (mapping == null || mapping[i2] == -1) {
                newElements[i2] = info.createModelElement(parent, model);
            } else {
                newElements[i2] = oldElements[mapping[i2]];
                info.updateElement(model, newElements[i2]);
            }
            ++i2;
        }
        return newElements;
    }

    public void mapChildren(Element[] n, Element[] map) {
        int i = 0;
        while (i < n.length) {
            map[this.ids[i]] = n[i];
            ++i;
        }
    }

    public Collection getChildren() {
        return this.children;
    }
}

