/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import javax.swing.text.Position;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.parser.BaseElementInfo;
import org.netbeans.modules.java.parser.ClassInfo;
import org.netbeans.modules.java.parser.FieldInfo;
import org.netbeans.modules.java.parser.ImportInfo;
import org.netbeans.modules.java.parser.InitializerInfo;
import org.netbeans.modules.java.parser.MethodInfo;
import org.netbeans.modules.java.parser.SourceInfo;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodParameter;
import org.openide.src.Type;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class DocumentModelBuilder
extends SourceInfo
implements ElementFactory {
    CloneableEditorSupport editSupp;
    char[] inputText;
    boolean computeHash;

    public DocumentModelBuilder(CloneableEditorSupport supp) {
        this.editSupp = supp;
    }

    protected void setContent(char[] content, boolean computeHash) {
        this.inputText = content;
        this.computeHash = computeHash;
    }

    public void createPackage(Identifier name, int begin, int end) {
        this.packageDecl = name;
        this.packageBounds = this.createStableBounds(begin, end);
    }

    public void createImport(Import im, int begin, int end) {
        PositionBounds bnds = this.createStableBounds(begin, end);
        ImportInfo info = new ImportInfo(im);
        info.wholeBounds = bnds;
        this.addImport(info);
    }

    public ElementFactory.Item createClass(boolean isInterface, int modifiers, Identifier name, Identifier superclass, Identifier[] interfaces) {
        ClassInfo info = new ClassInfo(name.getSourceName(), modifiers, !isInterface);
        info.superclass = superclass;
        info.superinterfaces = interfaces;
        info.fullName = name.getFullName();
        return info;
    }

    public ElementFactory.Item createConstructor(int modifiers, Identifier id, MethodParameter[] params, Identifier[] exceptions) {
        MethodInfo info = new MethodInfo(id.getSourceName(), modifiers);
        info.params = params;
        info.exceptions = exceptions;
        info.constructor = true;
        return info;
    }

    public ElementFactory.Item createField(int modifiers, Identifier name, Type type, String initializer) {
        FieldInfo info = new FieldInfo(name.getSourceName(), modifiers);
        info.type = type;
        info.initValue = initializer;
        return info;
    }

    public ElementFactory.Item createInitializer(int modifiers) {
        InitializerInfo info = new InitializerInfo(modifiers);
        return info;
    }

    public ElementFactory.Item createMethod(int modifiers, Identifier name, Type returnType, MethodParameter[] params, Identifier[] exceptions) {
        MethodInfo info = new MethodInfo(name.getSourceName(), modifiers);
        info.retType = returnType;
        info.params = params;
        info.exceptions = exceptions;
        info.constructor = false;
        return info;
    }

    public void markError(ElementFactory.Item item) {
    }

    public void setBodyBounds(ElementFactory.Item item, int begin, int end) {
        BaseElementInfo info = (BaseElementInfo)item;
        info.bodyBounds = this.createAbsorbingBounds(begin, end);
        if (this.computeHash && (info instanceof MethodInfo || info instanceof InitializerInfo)) {
            info.bodyContent = String.copyValueOf(this.inputText, begin, end - begin);
        }
    }

    public void setBounds(ElementFactory.Item item, int begin, int end) {
        BaseElementInfo info = (BaseElementInfo)item;
        info.wholeBounds = this.createStableBounds(begin, end);
    }

    public void setDocumentation(ElementFactory.Item item, int begin, int end, String text) {
        BaseElementInfo info = (BaseElementInfo)item;
        info.docText = text;
        info.docBounds = text != null && begin >= 0 && end > begin ? this.createStableBounds(begin, end) : null;
    }

    public void setFieldTypeBounds(ElementFactory.Item item, int begin, int end) {
        FieldInfo finfo = (FieldInfo)item;
        finfo.typeBounds = this.createStableBounds(begin, end);
    }

    public void setHeaderBounds(ElementFactory.Item item, int begin, int end) {
        BaseElementInfo info = (BaseElementInfo)item;
        info.headerBounds = this.createStableBounds(begin, end);
    }

    public void setParent(ElementFactory.Item child, ElementFactory.Item parent) {
        ((BaseElementInfo)child).parent = parent;
        if (parent == null) {
            this.addClass((ClassInfo)child);
        } else {
            ClassInfo parentInfo = (ClassInfo)parent;
            if (child instanceof InitializerInfo) {
                parentInfo.addMember(0, (BaseElementInfo)child);
            } else if (child instanceof FieldInfo) {
                parentInfo.addMember(1, (BaseElementInfo)child);
            } else if (child instanceof ClassInfo) {
                parentInfo.addMember(4, (BaseElementInfo)child);
            } else if (child instanceof MethodInfo) {
                MethodInfo minfo = (MethodInfo)child;
                parentInfo.addMember(minfo.constructor ? 2 : 3, (BaseElementInfo)child);
            }
        }
    }

    public void setPrecedingField(ElementFactory.Item item, ElementFactory.Item previous) {
        FieldInfo current;
        FieldInfo prev = (FieldInfo)previous;
        prev.nextField = current = (FieldInfo)item;
    }

    protected PositionBounds createStableBounds(int from, int to) {
        PositionRef posBegin = this.editSupp.createPositionRef(from, Position.Bias.Backward);
        PositionRef posEnd = this.editSupp.createPositionRef(to, Position.Bias.Forward);
        return new PositionBounds(posBegin, posEnd);
    }

    protected PositionBounds createAbsorbingBounds(int from, int to) {
        PositionRef posBegin = this.editSupp.createPositionRef(from, Position.Bias.Forward);
        PositionRef posEnd = this.editSupp.createPositionRef(to, Position.Bias.Backward);
        return new PositionBounds(posBegin, posEnd);
    }
}

