/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.java.settings.JavaSynchronizationSettings;
import org.netbeans.modules.java.tools.ElementFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ClassElementNode;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public class InheritanceSupport {
    public static final String PROP_CLASS = "class";
    public static final String PROP_INHERITED_CLASSES = "inheritedClasses";
    public static final String PROP_INHERITED_METHODS = "inheritedMethods";
    public static final String PROP_INTERFACES = "interfaces";
    private static final String JAVA_LANG_OBJECT_FQN = "java.lang.Object";
    private static Identifier JAVA_LANG_OBJECT = Identifier.create((String)"java.lang.Object");
    private static String NAME_ARRAY = InheritanceSupport.getString("NAME_ArrayOfPrimitives");
    private static String NAME_PARAM = InheritanceSupport.getString("NAME_Primitive");
    private static String NAME_OBJECT_VALUE = InheritanceSupport.getString("NAME_javaLangValue");
    private static String NAME_OBJECT = InheritanceSupport.getString("NAME_javaLangObject");
    private static String NAME_STRING = InheritanceSupport.getString("NAME_javaLangString");
    private static String NAME_CLASS_VALUE = InheritanceSupport.getString("NAME_javaLangClass");
    private static Map wellKnownClasses = new HashMap();
    ClassElement clazz;
    String clazzPackage;
    Map superInherited;
    Map allInherited;
    Map inheritedMethods;
    Map classInheritanceInfo;
    Map classCache = new HashMap(17);
    Set fakeSymbols = new HashSet(19);
    Set implementedInterfaces;
    Task hierarchyTask;
    Task methodTask;
    private PropertyChangeListener classPropertyListener;
    private PropertyChangeListener listenerHook;
    private static final Task FINISHED;
    private boolean superIsValid;
    private boolean interfacesAreValid;
    private boolean methodsAreValid;
    private static RequestProcessor wizardRP;
    private ArrayList listenerList = null;
    private static JavaSynchronizationSettings syncSettings;
    static /* synthetic */ Class class$org$netbeans$modules$java$tools$InheritanceSupport;
    static /* synthetic */ Class class$org$netbeans$modules$java$settings$JavaSynchronizationSettings;

    static String getString(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$tools$InheritanceSupport == null ? (class$org$netbeans$modules$java$tools$InheritanceSupport = InheritanceSupport.class$("org.netbeans.modules.java.tools.InheritanceSupport")) : class$org$netbeans$modules$java$tools$InheritanceSupport), (String)key);
    }

    public InheritanceSupport() {
    }

    public InheritanceSupport(ClassElement source) {
        this.setSourceClass(source);
        this.prepareHierarchy();
    }

    public void setSourceClass(ClassElement source) {
        ClassElement oldClass = this.clazz;
        this.clazz = source;
        this.clazzPackage = source.getName().getQualifier();
        this.listenerHook = new PropL();
        this.classPropertyListener = WeakListener.propertyChange((PropertyChangeListener)this.listenerHook, (Object)source);
        if (oldClass != null) {
            oldClass.removePropertyChangeListener(this.classPropertyListener);
        }
        source.addPropertyChangeListener(this.classPropertyListener);
        this.prepareHierarchy();
    }

    public ClassElement getSourceClass() {
        return this.clazz;
    }

    public void setPackage(String packName) {
        this.clazzPackage = packName;
        this.invalidateInheritanceSupport();
    }

    public boolean isSamePackage(Identifier name) {
        return name.getQualifier().equals(this.clazzPackage);
    }

    public boolean isSamePackage(ClassElement element) {
        ClassElement outer;
        while ((outer = element.getDeclaringClass()) != null) {
            element = outer;
        }
        return this.isSamePackage(element.getName());
    }

    private synchronized void resetSymbols() {
        this.classCache.values().removeAll(this.fakeSymbols);
        this.fakeSymbols.clear();
    }

    public synchronized Task prepareHierarchy() {
        if (this.hierarchyTask != null) {
            return this.hierarchyTask;
        }
        if (!this.superIsValid || !this.interfacesAreValid) {
            this.hierarchyTask = wizardRP.post((Runnable)new HierarchyProducer());
            return this.hierarchyTask;
        }
        return FINISHED;
    }

    public synchronized Task prepareMethods() {
        if (this.methodTask != null) {
            return this.methodTask;
        }
        if (!this.methodsAreValid) {
            this.methodTask = wizardRP.post((Runnable)new MethodListProducer());
            return this.methodTask;
        }
        return FINISHED;
    }

    public Map getInheritedFromSuper() {
        Map m = this.superInherited;
        if (m != null) {
            return m;
        }
        this.prepareHierarchy().waitFinished();
        return this.superInherited;
    }

    public Map getAllInherited() {
        Map m = this.allInherited;
        if (m != null) {
            return m;
        }
        this.prepareHierarchy().waitFinished();
        return this.allInherited;
    }

    public Collection getInheritedClasses() {
        return this.getAllInherited().values();
    }

    public Map getInheritedMethodMap() {
        Map m = this.inheritedMethods;
        if (m != null) {
            return m;
        }
        this.prepareMethods().waitFinished();
        return this.inheritedMethods;
    }

    public Collection getInheritedMethods() {
        return this.getInheritedMethodMap().values();
    }

    boolean isAccessibleMethod(MethodElement m) {
        ClassElement cls = m.getDeclaringClass();
        int modifs = cls.getModifiers();
        if ((modifs & 2) != 0 || (modifs & 7) == 0 && !this.isSamePackage(cls.getName())) {
            return false;
        }
        if (!cls.isClassOrInterface()) {
            return true;
        }
        modifs = m.getModifiers();
        if ((modifs & 2) != 0) {
            return false;
        }
        if ((modifs & 5) != 0) {
            return true;
        }
        return this.isSamePackage(cls.getName());
    }

    public boolean isAccessibleClass(ClassElement el) {
        return true;
    }

    private synchronized void invalidateInheritanceSupport() {
        this.superIsValid = false;
        this.invalidateDirectInheritance();
    }

    private synchronized void invalidateDirectInheritance() {
        this.interfacesAreValid = false;
        this.methodsAreValid = false;
        this.fireInheritanceChanged();
        this.prepareHierarchy();
    }

    public synchronized ClassElement getInterface(Identifier ident, boolean createEmpty) {
        return this.lookupClass(ident, false, createEmpty);
    }

    public synchronized ClassElement getClass(Identifier ident, boolean createEmpty) {
        return this.lookupClass(ident, true, createEmpty);
    }

    public Collection getOverridingMethods() {
        LinkedList<MethodElement> c = new LinkedList<MethodElement>();
        List<MethodElement> methods = Arrays.asList(this.clazz.getMethods());
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            MethodElement m = (MethodElement)it.next();
            if (!this.overrides(m)) continue;
            c.add(m);
        }
        return c;
    }

    public boolean overrides(MethodElement m) {
        MethodInfo info = (MethodInfo)this.getInheritedMethodMap().get(new MethodElement.Key(m));
        if (info == null) {
            return false;
        }
        return info.declared.size() > (info.declared.contains(this.clazz.getName().getFullName()) ? 1 : 0);
    }

    private ClassElement lookupClassElement(Identifier id) {
        ClassElement el = ClassElement.forName((String)id.getFullName());
        if (el != null) {
            return el;
        }
        if (id.getResolutionStatus() != 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.clazzPackage);
        sb.append('.');
        sb.append(id.getName());
        el = ClassElement.forName((String)sb.toString());
        if (el != null) {
            return el;
        }
        el = ClassElement.forName((String)("java.lang." + id.getName()));
        return el;
    }

    private ClassElement lookupClass(Identifier id, boolean isClass, boolean create) {
        ClassElement el = null;
        String fullName = id.getFullName();
        Reference ref = (Reference)this.classCache.get(fullName);
        if (ref != null) {
            el = (ClassElement)ref.get();
        }
        if (el != null) {
            return el;
        }
        el = this.lookupClassElement(id);
        if (el == null) {
            if (!create) {
                return null;
            }
            el = this.createElement(id, isClass);
        }
        this.classCache.put(id.getFullName(), new SoftReference<ClassElement>(el));
        return el;
    }

    private ClassElement createElement(Identifier id, boolean isClass) {
        ClassElement el = new ClassElement();
        try {
            el.setClassOrInterface(isClass);
            el.setName(id);
        }
        catch (SourceException e) {
            // empty catch block
        }
        return el;
    }

    private Map buildSuperHierarchy() {
        ClassElement sup;
        HashMap<String, ClassElement> inh = new HashMap<String, ClassElement>(17);
        HashSet excl = new HashSet();
        HashMap<String, ClassInfo> inhInfo = new HashMap<String, ClassInfo>(23);
        this.superIsValid = true;
        if (this.clazz.getSuperclass() != null) {
            sup = this.getClass(this.clazz.getSuperclass(), true);
            inh.put(this.clazz.getSuperclass().getFullName(), sup);
            this.addInheritedClasses(sup, inh, excl, inhInfo);
            InheritanceSupport inheritanceSupport = this;
            synchronized (inheritanceSupport) {
                this.implementedInterfaces = new HashSet<Identifier>(Arrays.asList(this.clazz.getInterfaces()));
            }
        } else {
            inh = new HashMap();
        }
        if (this.clazz.isClassOrInterface() && !inh.containsKey(JAVA_LANG_OBJECT_FQN)) {
            sup = this.getClass(JAVA_LANG_OBJECT, true);
            inh.put(JAVA_LANG_OBJECT_FQN, sup);
            inhInfo.put(JAVA_LANG_OBJECT_FQN, new ClassInfo(sup));
        }
        this.superInherited = inh;
        this.classInheritanceInfo = inhInfo;
        return inh;
    }

    private Map buildDirectHierarchy() {
        Map base = this.buildSuperHierarchy();
        HashMap<String, ClassElement> direct = new HashMap<String, ClassElement>(base.size());
        HashSet exclusions = new HashSet();
        direct.putAll(base);
        Identifier[] impls = this.clazz.getInterfaces();
        this.interfacesAreValid = true;
        int i = 0;
        while (i < impls.length) {
            if (!base.containsKey(impls[i].getFullName())) {
                ClassElement el = this.getInterface(impls[i], true);
                direct.put(impls[i].getFullName(), el);
                this.addInheritedClasses(el, direct, exclusions, this.classInheritanceInfo);
            }
            ++i;
        }
        this.allInherited = direct;
        this.fireInheritanceChanged();
        return direct;
    }

    ClassInfo addInheritedClasses(ClassElement cls, Map inheritanceMap, Set exclusions, Map classInfo) {
        Identifier[] interfaces;
        ClassElement inherited;
        Identifier superId = cls.getSuperclass();
        String superName = null;
        if (!this.superIsValid) {
            return new ClassInfo(cls);
        }
        ClassInfo info = new ClassInfo(cls);
        classInfo.put(cls.getName().getFullName(), info);
        if (superId != null && !superId.getFullName().equals("") && !inheritanceMap.containsKey(superName = superId.getFullName()) && !exclusions.contains(superName) && (inherited = this.getClass(superId, true)) != null && this.isAccessibleClass(cls)) {
            exclusions.add(superName);
            info.addSuperclass(superId);
            ClassInfo superInfo = this.addInheritedClasses(inherited, inheritanceMap, exclusions, classInfo);
            inheritanceMap.put(superName, inherited);
            info.addSuperclasses(superInfo.getSuperclasses());
        }
        if ((interfaces = cls.getInterfaces()) != null && interfaces.length > 0) {
            int i = 0;
            while (i < interfaces.length) {
                superId = interfaces[i];
                superName = superId.getFullName();
                if (!inheritanceMap.containsKey(superName) && !exclusions.contains(superName) && (inherited = this.getInterface(superId, true)) != null && this.isAccessibleClass(inherited)) {
                    inheritanceMap.put(superName, inherited);
                    info.addSuperclass(superId);
                    info.addSuperclasses(this.addInheritedClasses(inherited, inheritanceMap, exclusions, classInfo).getSuperclasses());
                }
                ++i;
            }
        }
        return info;
    }

    private void addMethods(ClassElement clazz, Map result, Set traversed) {
        MethodElement[] methods = clazz.getMethods();
        if (!this.isAccessibleClass(clazz)) {
            return;
        }
        int i = 0;
        while (i < methods.length) {
            MethodElement m = methods[i];
            int modifiers = m.getModifiers();
            if (!clazz.isClassOrInterface() || !Modifier.isPrivate(modifiers) && ((modifiers & 7) != 0 || this.isSamePackage(clazz.getName()))) {
                boolean declOnly = Modifier.isAbstract(modifiers) || !clazz.isClassOrInterface();
                MethodElement.Key k = new MethodElement.Key(methods[i]);
                if (!result.containsKey(k)) {
                    result.put(k, new MethodInfo(methods[i], k, clazz));
                } else {
                    ((MethodInfo)result.get(k)).addClass(clazz, declOnly);
                }
            }
            ++i;
        }
        traversed.add(clazz.getName().getFullName());
        Identifier id = clazz.getSuperclass();
        if (id == null && !clazz.getName().equals((Object)ClassElement.ROOT_OBJECT)) {
            id = ClassElement.ROOT_OBJECT;
        }
        if (id != null && !traversed.contains(id.getFullName())) {
            ClassElement s = this.getClass(id, true);
            this.addMethods(s, result, traversed);
        }
        Identifier[] ids = clazz.getInterfaces();
        int i2 = 0;
        while (i2 < ids.length) {
            if (!traversed.contains(ids[i2].getFullName())) {
                ClassElement itf = this.getInterface(ids[i2], true);
                this.addMethods(itf, result, traversed);
            }
            ++i2;
        }
    }

    private void buildMethodList() {
        HashSet traversed = new HashSet(17);
        HashMap result = new HashMap(23);
        this.addMethods(this.clazz, result, traversed);
        Identifier[] ids = this.clazz.getInterfaces();
        int i = 0;
        while (i < ids.length) {
            if (!traversed.contains(ids[i].getFullName())) {
                ClassElement itf = this.getInterface(ids[i], true);
                this.addMethods(itf, result, traversed);
            }
            ++i;
        }
        InheritanceSupport inheritanceSupport = this;
        synchronized (inheritanceSupport) {
            this.methodsAreValid = true;
            this.inheritedMethods = result;
        }
    }

    public synchronized void addHierarchyListener(HierarchyListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList();
        }
        this.listenerList.add(listener);
    }

    public synchronized void removeHierarchyListener(HierarchyListener listener) {
        ((AbstractCollection)this.listenerList).remove(listener);
    }

    private void fireInheritanceChanged() {
        Collection c;
        Map m = this.allInherited;
        InheritanceSupport inheritanceSupport = this;
        synchronized (inheritanceSupport) {
            if (this.listenerList == null) {
                return;
            }
            c = (Collection)this.listenerList.clone();
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            HierarchyListener l = (HierarchyListener)it.next();
            l.inheritedClassesComputed(m);
        }
    }

    private void fireInheritanceComputed() {
        Collection listeners;
        InheritanceSupport inheritanceSupport = this;
        synchronized (inheritanceSupport) {
            if (this.listenerList == null) {
                return;
            }
            listeners = (Collection)this.listenerList.clone();
        }
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            HierarchyListener l = (HierarchyListener)it.next();
            l.inheritanceChanged();
        }
    }

    public Node createClassElementNode(ClassElement el, Children ch, boolean writeable) {
        return new ClassElementNode(el, ch, writeable);
    }

    public static MethodElement completeParameters(MethodElement el, boolean cloned) {
        MethodParameter[] params = el.getParameters();
        HashSet<String> synthesized = new HashSet<String>();
        if (params == null || params.length == 0) {
            return el;
        }
        int i = 0;
        while (i < params.length) {
            MethodParameter p = params[i];
            if (p.getName() == null || p.getName().toString().equals("")) {
                String s;
                if (!cloned) {
                    el = (MethodElement)el.clone();
                    params = el.getParameters();
                    p = params[i];
                    cloned = true;
                }
                if (synthesized.contains(s = InheritanceSupport.createName(p.getType()))) {
                    s = s + i;
                } else {
                    synthesized.add(s);
                }
                p.setName(s);
            }
            if (p.isFinal()) {
                if (!cloned) {
                    el = (MethodElement)el.clone();
                    params = el.getParameters();
                    p = params[i];
                    cloned = true;
                }
                p.setFinal(false);
            }
            ++i;
        }
        return el;
    }

    private static String createName(Type t) {
        boolean array = false;
        if (t.isArray()) {
            array = true;
            while ((t = t.getElementType()).isArray()) {
            }
        }
        if (t.isPrimitive()) {
            if (array) {
                return NAME_ARRAY;
            }
            return NAME_PARAM;
        }
        String fullName = t.getClassName().getFullName();
        if (wellKnownClasses.containsKey(fullName)) {
            return (String)wellKnownClasses.get(fullName);
        }
        String lastComponent = t.getClassName().getName();
        int i = lastComponent.length() - 1;
        while (i > 0) {
            if (Character.isTitleCase(lastComponent.charAt(i))) break;
            --i;
        }
        String n = i < lastComponent.length() - 1 ? Character.toLowerCase(lastComponent.charAt(i)) + lastComponent.substring(i + 1) : lastComponent.toLowerCase();
        if (Utilities.isJavaIdentifier((String)n)) {
            return n;
        }
        return MessageFormat.format(InheritanceSupport.getString("NAME_typeParam"), n);
    }

    private static void expandTypes(ClassElement target, MethodElement m) throws SourceException {
        MethodParameter[] params = m.getParameters();
        boolean changed = false;
        int i = 0;
        while (i < params.length) {
            Type t2;
            Type t = params[i].getType();
            if (t != (t2 = InheritanceSupport.expandType(target, t))) {
                params[i] = new MethodParameter(params[i].getName(), t2, params[i].isFinal());
                changed = true;
            }
            ++i;
        }
        Identifier[] exceptions = m.getExceptions();
        SourceElement s = target.getSource();
        int i2 = 0;
        while (i2 < exceptions.length) {
            String q2;
            String q;
            Identifier id = exceptions[i2];
            if (!(id.getResolutionStatus() != 1 || id.getSourceName().equals(id.getFullName()) || "java.lang".equals(q = id.getQualifier()) || q == (q2 = target.getName().getQualifier()) || q != null && q.equals(q2) || s != null && (InheritanceSupport.importExists(s, id.getFullName(), false) || InheritanceSupport.importExists(s, id.getQualifier(), true)))) {
                exceptions[i2] = Identifier.create((String)id.getFullName());
                changed = true;
            }
            ++i2;
        }
        Type rt = InheritanceSupport.expandType(target, m.getReturn());
        if (rt != m.getReturn()) {
            changed = true;
        }
        if (!changed) {
            return;
        }
        m.setParameters(params);
        m.setExceptions(exceptions);
        m.setReturn(rt);
    }

    private static boolean importExists(SourceElement el, String id, boolean pack) {
        Import[] ims = el.getImports();
        int i = 0;
        while (i < ims.length) {
            Import im = ims[i];
            if (pack == im.isPackage() && im.getIdentifier().getFullName().equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Type expandType(ClassElement target, Type t) {
        if (t.isPrimitive()) {
            return t;
        }
        if (t.isArray()) {
            Type eltype = InheritanceSupport.expandType(target, t.getElementType());
            if (eltype == t.getElementType()) {
                return t;
            }
            return Type.createArray((Type)eltype);
        }
        if (t.isClass()) {
            Identifier id = t.getClassName();
            if (id.getResolutionStatus() != 1) {
                return t;
            }
            if (id.getSourceName().equals(id.getFullName())) {
                return t;
            }
            String q = id.getQualifier();
            if ("java.lang".equals(q)) {
                return t;
            }
            String q2 = target.getName().getQualifier();
            if (q == q2 || q != null && q.equals(q2)) {
                return t;
            }
            SourceElement s = target.getSource();
            if (s != null && (InheritanceSupport.importExists(s, id.getFullName(), false) || InheritanceSupport.importExists(s, id.getQualifier(), true))) {
                return t;
            }
            return Type.createClass((Identifier)Identifier.create((String)id.getFullName()));
        }
        return null;
    }

    public MethodElement overrideMethod(MethodElement source) throws SourceException {
        return this.overrideMethod(source, false);
    }

    public MethodElement overrideMethod(MethodElement source, boolean createSuper) throws SourceException {
        return InheritanceSupport.overrideMethod(this.getSourceClass(), source, createSuper, this.isImplemented(source));
    }

    public static MethodElement overrideMethod(ClassElement target, MethodElement source, boolean createBody, boolean superExists) throws SourceException {
        MethodElement me = (MethodElement)source.clone();
        me.getJavaDoc().clearJavaDoc();
        MethodElement m = InheritanceSupport.completeParameters(me, true);
        int mods = m.getModifiers() & 0xFFFFFADF;
        if (source.getDeclaringClass() != null && !source.getDeclaringClass().isClassOrInterface()) {
            mods |= 1;
        }
        m.setModifiers(mods);
        if (!createBody) {
            m.setExceptions(new Identifier[0]);
            m.setBody("\n");
        } else {
            m.setBody(InheritanceSupport.createSuperCall(m, superExists));
        }
        InheritanceSupport.expandTypes(target, m);
        target.addMethod(m);
        MethodParameter[] params = m.getParameters();
        Type[] types = new Type[params.length];
        int i = 0;
        while (i < types.length) {
            types[i] = params[i].getType();
            ++i;
        }
        MethodElement inserted = target.getMethod(m.getName(), types);
        return inserted;
    }

    protected static String createSuperCall(MethodElement target, boolean hasSuper) {
        String body;
        if (syncSettings == null) {
            syncSettings = (JavaSynchronizationSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$java$settings$JavaSynchronizationSettings == null ? (class$org$netbeans$modules$java$settings$JavaSynchronizationSettings = InheritanceSupport.class$("org.netbeans.modules.java.settings.JavaSynchronizationSettings")) : class$org$netbeans$modules$java$settings$JavaSynchronizationSettings), (boolean)true);
        }
        if (hasSuper) {
            MethodParameter[] params = target.getParameters();
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < params.length) {
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(params[i].getName());
                ++i;
            }
            String format = Type.VOID.equals((Object)target.getReturn()) ? InheritanceSupport.getString("FMT_CallSuper") : InheritanceSupport.getString("FMT_ReturnCallSuper");
            body = MessageFormat.format(format, target.getReturn(), target.getName(), str);
        } else {
            body = syncSettings.getGenerateReturnAsString(target.getReturn());
        }
        return body;
    }

    ClassInfo getClassInfo(ClassElement e) {
        ClassInfo info = (ClassInfo)this.classInheritanceInfo.get(e.getName().getFullName());
        if (info == null) {
            return new ClassInfo(e);
        }
        return info;
    }

    MethodInfo getMethodInfo(MethodElement m) {
        MethodElement.Key mk = new MethodElement.Key(m);
        MethodInfo minfo = (MethodInfo)this.getInheritedMethodMap().get(mk);
        if (minfo == null) {
            return new MethodInfo(m, mk, null);
        }
        return minfo;
    }

    boolean isImplemented(MethodElement m) {
        MethodInfo info = this.getMethodInfo(m);
        ClassElement def = info.getDefinition();
        if (def == null) {
            return false;
        }
        return def != this.clazz;
    }

    boolean isDeclaredFirst(MethodElement m, ClassElement e) {
        Set ancestors = this.getClassInfo(e).getSuperclasses();
        Set declarations = this.getMethodInfo(m).getDeclarations();
        Iterator it = declarations.iterator();
        while (it.hasNext()) {
            if (!ancestors.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    private void collectClassMethods(ClassElement cls, HashMap result, ElementFilter.Method f) {
        MethodElement[] methods = cls.getMethods();
        int i = 0;
        while (i < methods.length) {
            MethodElement m = methods[i];
            MethodElement.Key key = new MethodElement.Key(m);
            if (!result.containsKey(key) && f.accept(m)) {
                result.put(key, m);
            }
            ++i;
        }
    }

    private void collectClassMethods(ClassElement root, HashMap result, ElementFilter.Method f, boolean recurse, Set traversed) {
        ClassElement sc;
        String fullClassName = root.getName().getFullName();
        if (traversed.contains(fullClassName)) {
            return;
        }
        traversed.add(fullClassName);
        this.collectClassMethods(root, result, f);
        Identifier superId = root.getSuperclass();
        if (!recurse) {
            return;
        }
        if (superId != null && !"".equals(superId.getFullName())) {
            sc = this.getClass(superId, true);
            this.collectClassMethods(sc, result, f, recurse, traversed);
        }
        Identifier[] interfaceIds = root.getInterfaces();
        int i = 0;
        while (i < interfaceIds.length) {
            superId = interfaceIds[i];
            if (!root.isInterface() || !JAVA_LANG_OBJECT.equals((Object)superId.getFullName())) {
                sc = this.getInterface(superId, true);
                this.collectClassMethods(sc, result, f, recurse, traversed);
            }
            ++i;
        }
    }

    Collection collectMethods(Collection rootClasses, boolean deep, ElementFilter.Method filter) {
        return this.createMethodMap(rootClasses, deep, filter).values();
    }

    public Map createMethodMap(Collection rootClasses, boolean deep, ElementFilter.Method filter) {
        HashSet traversed = new HashSet();
        HashMap result = new HashMap(17);
        Iterator it = rootClasses.iterator();
        while (it.hasNext()) {
            this.collectClassMethods((ClassElement)it.next(), result, filter, deep, traversed);
        }
        return result;
    }

    public boolean isOverridable(MethodElement m) {
        if (!this.isAccessibleMethod(m)) {
            return false;
        }
        int mods = m.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        wellKnownClasses.put(JAVA_LANG_OBJECT_FQN, NAME_OBJECT);
        wellKnownClasses.put("java.lang.String", NAME_STRING);
        wellKnownClasses.put("java.lang.Float", NAME_OBJECT_VALUE);
        wellKnownClasses.put("java.lang.Double", NAME_OBJECT_VALUE);
        wellKnownClasses.put("java.lang.Long", NAME_OBJECT_VALUE);
        wellKnownClasses.put("java.lang.Class", NAME_CLASS_VALUE);
        FINISHED = Task.EMPTY;
        wizardRP = new RequestProcessor("JavaWizard query");
    }

    private class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Identifier newName;
            String packName;
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("superclass")) {
                InheritanceSupport.this.invalidateInheritanceSupport();
            } else if (propertyName.equals(InheritanceSupport.PROP_INTERFACES)) {
                if (this.checkInterfaces(InheritanceSupport.this.clazz.getInterfaces())) {
                    InheritanceSupport.this.invalidateDirectInheritance();
                }
            } else if ("name".equals(propertyName) && !(packName = (newName = (Identifier)evt.getNewValue()).getQualifier()).equals(InheritanceSupport.this.clazzPackage)) {
                InheritanceSupport.this.setPackage(packName);
            }
        }

        private boolean checkInterfaces(Identifier[] interfaces) {
            int found = 0;
            if (InheritanceSupport.this.implementedInterfaces == null) {
                return interfaces.length != 0;
            }
            int i = 0;
            while (i < interfaces.length) {
                if (!InheritanceSupport.this.implementedInterfaces.contains(interfaces[i])) {
                    return true;
                }
                ++found;
                ++i;
            }
            return found != InheritanceSupport.this.implementedInterfaces.size();
        }
    }

    public static interface HierarchyListener
    extends EventListener {
        public void inheritanceChanged();

        public void inheritedClassesComputed(Map var1);

        public void inheritedMethodsComputed(Collection var1);
    }

    private class HierarchyProducer
    implements Runnable {
        private HierarchyProducer() {
        }

        public void run() {
            boolean somethingChanged = false;
            while (true) {
                if (!InheritanceSupport.this.superIsValid) {
                    InheritanceSupport.this.buildSuperHierarchy();
                    somethingChanged = true;
                }
                if (!InheritanceSupport.this.interfacesAreValid) {
                    InheritanceSupport.this.buildDirectHierarchy();
                    somethingChanged = true;
                }
                InheritanceSupport inheritanceSupport = InheritanceSupport.this;
                synchronized (inheritanceSupport) {
                    if (InheritanceSupport.this.superIsValid && InheritanceSupport.this.interfacesAreValid) {
                        InheritanceSupport.this.hierarchyTask = null;
                        if (somethingChanged) {
                            InheritanceSupport.this.prepareMethods();
                        }
                        return;
                    }
                }
            }
        }
    }

    private class MethodListProducer
    implements Runnable {
        private MethodListProducer() {
        }

        public void run() {
            if (!InheritanceSupport.this.methodsAreValid) {
                InheritanceSupport.this.buildMethodList();
            }
            InheritanceSupport inheritanceSupport = InheritanceSupport.this;
            synchronized (inheritanceSupport) {
                InheritanceSupport.this.methodTask = null;
            }
        }
    }

    private class MethodInfo {
        private MethodElement.Key key;
        public MethodElement method;
        public Set declared;
        public ClassElement defined;
        public boolean overriden;

        MethodInfo(MethodElement m, MethodElement.Key k, ClassElement cl) {
            this.key = k;
            this.method = m;
            this.declared = new HashSet(17);
            if (cl != null) {
                this.addClass(cl, Modifier.isAbstract(m.getModifiers()) || !cl.isClassOrInterface());
            }
        }

        private void addClass(ClassElement cls, boolean declOnly) {
            this.declared.add(cls.getName().getFullName());
            if (!declOnly && this.defined == null) {
                this.defined = cls;
            }
        }

        public MethodElement.Key getKey() {
            return this.key;
        }

        public Set getDeclarations() {
            return this.declared;
        }

        public ClassElement getDefinition() {
            return this.defined;
        }
    }

    private class ClassInfo {
        Set allInherited;
        ClassElement element;

        ClassInfo(ClassElement cls) {
            this.element = cls;
        }

        void addSuperclasses(Collection superclasses) {
            if (this.allInherited == null) {
                this.allInherited = new HashSet(superclasses.size());
            }
            this.allInherited.addAll(superclasses);
        }

        void addSuperclass(Identifier superId) {
            if (this.allInherited == null) {
                this.allInherited = new HashSet(7);
            }
            this.allInherited.add(superId);
        }

        Set getSuperclasses() {
            if (this.allInherited == null) {
                this.allInherited = new HashSet();
            }
            return this.allInherited;
        }
    }
}

