/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.java.tools.ElementFilter;
import org.netbeans.modules.java.tools.ElementRenderer;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.tools.OverrideAction;
import org.netbeans.modules.java.tools.SuperclassList;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;

public class OverridePanelBase
extends JPanel
implements ListSelectionListener,
PropertyChangeListener {
    private static final Identifier JAVA_LANG_OBJECT = Identifier.create((String)"java.lang.Object");
    private InheritanceSupport support;
    private SuperclassList superclassList;
    private ListCellRenderer selectedRenderer;
    private ElementFilter.Method overrideFilter;
    private Comparator overrideComparator;
    private DefaultListModel overrideModel;
    private int buttonPanelWidth = -1;
    private boolean initialized;
    protected static final ElementFormat FORMAT_AVAILABLE = new ElementFormat(OverrideAction.getString("FMT_DefaultMethodFormat"));
    private JCheckBox onlyAbstract;
    private JList availableList;
    private JPanel firstPanel;
    private JPanel selectedPanel;
    private JButton selectAllMethods;
    private JButton overrideButton;
    private JPanel showOptions;
    private JCheckBox generateSuper;
    private JCheckBox includeInherited;
    private JPanel secondPanel;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane1;
    private JPanel jPanel4;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JList overrideList;
    private JPanel availablePanel;
    private JButton selectAll;
    private JPanel superclassHolder;
    private JPanel thirdPanel;
    private JButton removeButton;
    static /* synthetic */ Class class$org$netbeans$modules$java$tools$OverrideAction;

    public OverridePanelBase(InheritanceSupport support) {
        this.support = support;
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$java$tools$OverrideAction == null ? (class$org$netbeans$modules$java$tools$OverrideAction = OverridePanelBase.class$("org.netbeans.modules.java.tools.OverrideAction")) : class$org$netbeans$modules$java$tools$OverrideAction));
    }

    protected void initializeGUI() {
        if (this.initialized) {
            return;
        }
        this.initComponents();
        this.addEtchedBorder(this.firstPanel, OverrideAction.getString("LAB_InheritedClasses"));
        this.addEtchedBorder(this.secondPanel, OverrideAction.getString("LAB_OverridableMethods"));
        this.addEtchedBorder(this.thirdPanel, OverrideAction.getString("LAB_SelectedMethods"));
        this.showOptions.setBorder(new CompoundBorder(new TitledBorder(OverridePanelBase.getBundle().getString("LAB_Options")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.superclassList = new SuperclassList();
        this.superclassHolder.add((Component)this.superclassList, "Center");
        this.superclassList.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("selectedNodes".equals(name)) {
                    OverridePanelBase.this.refreshAvailableMethods();
                }
            }
        });
        this.selectedRenderer = new ElementRenderer(this.getAvailableMethodsFormat());
        this.overrideFilter = new DefaultMethodFilter();
        this.overrideComparator = new DefaultMethodComparator();
        this.overrideList.setCellRenderer(this.selectedRenderer);
        this.availableList.setCellRenderer(this.selectedRenderer);
        this.availableList.addListSelectionListener(this);
        this.availableList.addPropertyChangeListener(this);
        this.overrideList.addListSelectionListener(this);
        this.overrideList.addPropertyChangeListener(this);
        this.initAccessibility();
        Dimension d = this.jPanel3.getPreferredSize();
        this.buttonPanelWidth = d.width;
        d = this.jPanel4.getPreferredSize();
        if (this.buttonPanelWidth < d.width) {
            this.buttonPanelWidth = d.width;
        }
        d = this.jPanel2.getPreferredSize();
        if (this.buttonPanelWidth < d.width) {
            this.buttonPanelWidth = d.width;
        }
        this.initialized = true;
    }

    public boolean isGenerateSuperCall() {
        return this.generateSuper.isSelected();
    }

    protected ElementFormat getAvailableMethodsFormat() {
        return FORMAT_AVAILABLE;
    }

    public void addNotify() {
        this.superclassList.setData(this.support);
        this.overrideList.setModel(this.createOverrideModel());
        super.addNotify();
    }

    protected InheritanceSupport getSupport() {
        return this.support;
    }

    protected void setSupport(InheritanceSupport support) {
        this.support = support;
    }

    private void addEtchedBorder(JPanel p, String title) {
        TitledBorder titled = new TitledBorder(title);
        titled.setBorder(new EtchedBorder(1));
        p.setBorder(new CompoundBorder(titled, new EmptyBorder(new Insets(8, 8, 8, 8))));
    }

    protected ListModel createOverrideModel() {
        this.overrideModel = this.createFilterModel(this.support.getOverridingMethods(), this.overrideFilter, this.overrideComparator);
        return this.overrideModel;
    }

    protected Comparator getAvailableMethodsComparator() {
        return this.overrideComparator;
    }

    protected ElementFilter.Method getAvailableMethodsFilter(boolean includeInherited, final boolean filterAbstract) {
        if (includeInherited) {
            return new ElementFilter.Method(){

                public boolean accept(MethodElement m) {
                    boolean ok = OverridePanelBase.this.support.isOverridable(m);
                    if (filterAbstract) {
                        ok &= !OverridePanelBase.this.support.isImplemented(m);
                    }
                    return ok;
                }
            };
        }
        return new ElementFilter.Method(){

            public boolean accept(MethodElement m) {
                boolean ok;
                boolean bl = ok = OverridePanelBase.this.support.isOverridable(m) && OverridePanelBase.this.support.isDeclaredFirst(m, m.getDeclaringClass());
                if (filterAbstract) {
                    ok &= !OverridePanelBase.this.support.isImplemented(m);
                }
                return ok;
            }
        };
    }

    protected void refreshAvailableMethods() {
        boolean dive = this.includeInherited.isSelected();
        ElementFilter.Method f = this.getAvailableMethodsFilter(dive, this.onlyAbstract.isSelected());
        Collection selected = this.superclassList.getSelectedClasses();
        Collection methods = this.support.collectMethods(selected, dive, f);
        TreeSet sortedSet = new TreeSet(this.getAvailableMethodsComparator());
        sortedSet.addAll(methods);
        DefaultListModel availModel = new DefaultListModel();
        Iterator it = sortedSet.iterator();
        while (it.hasNext()) {
            availModel.addElement(it.next());
        }
        this.availableList.setModel(availModel);
    }

    protected DefaultListModel createFilterModel(Collection items, ElementFilter.Method filter, Comparator comparator) {
        DefaultListModel model = new DefaultListModel();
        TreeSet<MethodElement> sortedFiltered = new TreeSet<MethodElement>(comparator);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            MethodElement m = (MethodElement)it.next();
            if (!filter.accept(m)) continue;
            sortedFiltered.add(m);
        }
        it = sortedFiltered.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        return model;
    }

    protected void overrideMethod(MethodElement source) throws SourceException {
        int i = 0;
        while (i < this.overrideModel.getSize()) {
            if (this.overrideComparator.compare(this.overrideModel.getElementAt(i), source) < 0) break;
            ++i;
        }
        this.overrideModel.insertElementAt(source, i);
    }

    protected void removeMethod(MethodElement m) throws SourceException {
        this.overrideList.getSelectionModel().clearSelection();
        this.overrideModel.removeElement(m);
    }

    private void selectAllSuperclasses() {
        ExplorerManager m = this.superclassList.getExplorerManager();
        Node[] nodes = m.getExploredContext().getChildren().getNodes();
        try {
            m.setSelectedNodes(nodes);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void unselectAllSuperclasses() {
        ExplorerManager m = this.superclassList.getExplorerManager();
        Node[] nodes = new Node[]{};
        try {
            m.setSelectedNodes(nodes);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void removeSelectedMethods() {
        Object[] vals = this.overrideList.getSelectedValues();
        if (vals == null || vals.length == 0) {
            return;
        }
        try {
            int i = 0;
            while (i < vals.length) {
                MethodElement el = (MethodElement)vals[i];
                this.removeMethod(el);
                ++i;
            }
        }
        catch (SourceException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    protected void overrideSelectedMethods() {
        Object[] vals = this.availableList.getSelectedValues();
        if (vals == null || vals.length == 0) {
            return;
        }
        int i = 0;
        while (i < vals.length) {
            MethodElement el = (MethodElement)vals[i];
            try {
                this.overrideMethod(el);
            }
            catch (SourceException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
            ++i;
        }
    }

    private void initComponents() {
        this.firstPanel = new JPanel();
        this.superclassHolder = new JPanel();
        this.jPanel3 = new CommonSizePanel();
        this.selectAll = new JButton();
        this.secondPanel = new JPanel();
        this.availablePanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.availableList = new JList();
        this.jPanel2 = new CommonSizePanel();
        this.showOptions = new JPanel();
        this.includeInherited = new JCheckBox();
        this.onlyAbstract = new JCheckBox();
        this.selectAllMethods = new JButton();
        this.overrideButton = new JButton();
        this.thirdPanel = new JPanel();
        this.selectedPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.overrideList = new JList();
        this.jPanel4 = new CommonSizePanel();
        this.removeButton = new JButton();
        this.generateSuper = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(700, 550));
        this.firstPanel.setLayout(new GridBagLayout());
        this.superclassHolder.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.firstPanel.add((Component)this.superclassHolder, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setPreferredSize(new Dimension(124, 157));
        this.jPanel3.setMinimumSize(new Dimension(124, 33));
        this.selectAll.setToolTipText(OverridePanelBase.getBundle().getString("ACS_SelectAllAncestorsA11yDesc"));
        this.selectAll.setMnemonic(OverridePanelBase.getBundle().getString("CTL_selectAllAncestors").charAt(0));
        this.selectAll.setText(OverridePanelBase.getBundle().getString("BTN_SelectAllAncestors"));
        this.selectAll.setPreferredSize(new Dimension(90, 27));
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanelBase.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel3.add((Component)this.selectAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.firstPanel.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.5;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.firstPanel, gridBagConstraints);
        this.secondPanel.setLayout(new GridBagLayout());
        this.availablePanel.setLayout(new GridBagLayout());
        this.jScrollPane3.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane3.setViewportView(this.availableList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.availablePanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.secondPanel.add((Component)this.availablePanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.showOptions.setLayout(new BoxLayout(this.showOptions, 1));
        this.includeInherited.setToolTipText(OverridePanelBase.getBundle().getString("ACS_ShowInheritedMethodsA11yDesc"));
        this.includeInherited.setMnemonic(OverridePanelBase.getBundle().getString("CTL_includeInherited").charAt(0));
        this.includeInherited.setText(OverridePanelBase.getBundle().getString("BTN_ShowInheritedMethods"));
        this.includeInherited.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanelBase.this.includeInheritedActionPerformed(evt);
            }
        });
        this.showOptions.add(this.includeInherited);
        this.onlyAbstract.setToolTipText(OverridePanelBase.getBundle().getString("ACS_ShowOnlyAbstractMethodsA11yDesc"));
        this.onlyAbstract.setMnemonic(OverridePanelBase.getBundle().getString("CTL_onlyAbstract").charAt(0));
        this.onlyAbstract.setText(OverridePanelBase.getBundle().getString("BTN_ShowOnlyAbstractMethods"));
        this.onlyAbstract.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanelBase.this.onlyAbstractActionPerformed(evt);
            }
        });
        this.showOptions.add(this.onlyAbstract);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.jPanel2.add((Component)this.showOptions, gridBagConstraints);
        this.selectAllMethods.setToolTipText(OverridePanelBase.getBundle().getString("ACS_SelectAllAvailableMethodsA11yDesc"));
        this.selectAllMethods.setMnemonic(OverridePanelBase.getBundle().getString("CTL_selectAllMethods").charAt(0));
        this.selectAllMethods.setText(OverridePanelBase.getBundle().getString("BTN_SelectAllAvailableMethods"));
        this.selectAllMethods.setPreferredSize(new Dimension(90, 27));
        this.selectAllMethods.setEnabled(false);
        this.selectAllMethods.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanelBase.this.selectAllMethodsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.selectAllMethods, gridBagConstraints);
        this.overrideButton.setToolTipText(OverridePanelBase.getBundle().getString("ACS_OverrideMethodA11yDesc"));
        this.overrideButton.setMnemonic(OverridePanelBase.getBundle().getString("CTL_overrideButton").charAt(0));
        this.overrideButton.setText(OverridePanelBase.getBundle().getString("BTN_OverrideMethod"));
        this.overrideButton.setPreferredSize(new Dimension(90, 27));
        this.overrideButton.setEnabled(false);
        this.overrideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanelBase.this.overrideButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.overrideButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.secondPanel.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.add((Component)this.secondPanel, gridBagConstraints);
        this.thirdPanel.setLayout(new GridBagLayout());
        this.selectedPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane1.setViewportView(this.overrideList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.selectedPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.thirdPanel.add((Component)this.selectedPanel, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setPreferredSize(new Dimension(124, 157));
        this.jPanel4.setMinimumSize(new Dimension(124, 37));
        this.removeButton.setToolTipText(OverridePanelBase.getBundle().getString("ACS_RemoveOverridenMethodA11yDesc"));
        this.removeButton.setMnemonic(OverridePanelBase.getBundle().getString("CTL_removeButton").charAt(0));
        this.removeButton.setText(OverridePanelBase.getBundle().getString("BTN_RemoveOverridenMethod"));
        this.removeButton.setPreferredSize(new Dimension(90, 27));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanelBase.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.thirdPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.generateSuper.setToolTipText(OverridePanelBase.getBundle().getString("ACS_GenerateSuperCallA11yDesc"));
        this.generateSuper.setMnemonic(OverridePanelBase.getBundle().getString("CTL_generateSuper").charAt(0));
        this.generateSuper.setSelected(true);
        this.generateSuper.setText(OverridePanelBase.getBundle().getString("BTN_GenerateSuperCall"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.thirdPanel.add((Component)this.generateSuper, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        this.add((Component)this.thirdPanel, gridBagConstraints);
    }

    private void overrideButtonActionPerformed(ActionEvent evt) {
        this.overrideSelectedMethods();
    }

    private void onlyAbstractActionPerformed(ActionEvent evt) {
        this.refreshAvailableMethods();
    }

    private void includeInheritedActionPerformed(ActionEvent evt) {
        this.refreshAvailableMethods();
    }

    private void selectAllMethodsActionPerformed(ActionEvent evt) {
        ListSelectionModel m = this.availableList.getSelectionModel();
        m.setSelectionInterval(0, this.availableList.getModel().getSize() - 1);
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.selectAllSuperclasses();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object[] vals = this.overrideList.getSelectedValues();
        if (vals == null || vals.length == 0) {
            return;
        }
        try {
            int i = 0;
            while (i < vals.length) {
                MethodElement el = (MethodElement)vals[i];
                this.removeMethod(el);
                ++i;
            }
        }
        catch (SourceException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_OverrideTool"));
        this.superclassHolder.getAccessibleContext().setAccessibleName(OverridePanelBase.getBundle().getString("ACSN_superclassHolder"));
        this.superclassHolder.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_superclassHolder"));
        this.availableList.getAccessibleContext().setAccessibleName(OverridePanelBase.getBundle().getString("ACSN_availableList"));
        this.availableList.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_availableList"));
        this.overrideList.getAccessibleContext().setAccessibleName(OverridePanelBase.getBundle().getString("ACSN_overrideList"));
        this.overrideList.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_overrideList"));
        this.selectAll.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_selectAll"));
        this.includeInherited.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_includeInherited"));
        this.onlyAbstract.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_onlyAbstract"));
        this.selectAllMethods.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_selectAllMethods"));
        this.overrideButton.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_overrideButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_removeButton"));
        this.generateSuper.getAccessibleContext().setAccessibleDescription(OverridePanelBase.getBundle().getString("ACSD_generateSuper"));
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.availableList) {
            boolean status = !this.availableList.isSelectionEmpty();
            this.overrideButton.setEnabled(status);
        } else if (e.getSource() == this.overrideList) {
            boolean status = !this.overrideList.isSelectionEmpty();
            this.removeButton.setEnabled(status);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!"model".equals(evt.getPropertyName())) {
            return;
        }
        if (evt.getSource() == this.availableList) {
            ListModel m = this.availableList.getModel();
            boolean status = m.getSize() > 0;
            this.selectAllMethods.setEnabled(status);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CommonSizePanel
    extends JPanel {
        private CommonSizePanel() {
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (OverridePanelBase.this.buttonPanelWidth < 0) {
                return d;
            }
            d.width = OverridePanelBase.this.buttonPanelWidth;
            return d;
        }
    }

    private static class DefaultMethodComparator
    implements Comparator {
        private DefaultMethodComparator() {
        }

        public int compare(Object a, Object b) {
            MethodElement ma = (MethodElement)a;
            MethodElement mb = (MethodElement)b;
            if (ma == mb) {
                return 0;
            }
            int result = ma.getName().getSourceName().compareTo(mb.getName().getSourceName());
            if (result != 0) {
                return result;
            }
            result = ma.getParameters().length - mb.getParameters().length;
            if (result != 0) {
                return result;
            }
            MethodParameter[] paramA = ma.getParameters();
            MethodParameter[] paramB = mb.getParameters();
            int i = 0;
            while (i < paramA.length) {
                result = paramA[i].getFullString().compareTo(paramB[i].getFullString());
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }

        public boolean equals(Object ob) {
            return ob instanceof DefaultMethodComparator;
        }
    }

    private static class DefaultMethodFilter
    implements ElementFilter.Method {
        private DefaultMethodFilter() {
        }

        public boolean accept(MethodElement m) {
            return !Modifier.isAbstract(m.getModifiers());
        }
    }
}

