/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;

public class TreePathWalker
implements DocumentListener,
PropertyChangeListener {
    ExplorerManager manager;
    String delimiter;
    JTextComponent textComponent;
    boolean disableExplorer;
    public static final String DEFAULT_DELIMITER = ".";

    public TreePathWalker(ExplorerManager em) {
        this(em, DEFAULT_DELIMITER);
    }

    public TreePathWalker(ExplorerManager man, String delimiter) {
        this.delimiter = delimiter;
        this.manager = man;
        man.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setTextComponent(JTextComponent text) {
        if (this.textComponent != null) {
            this.textComponent.getDocument().removeDocumentListener(this);
        }
        this.textComponent = text;
        if (text != null) {
            text.getDocument().addDocumentListener(this);
        }
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void selectString(Document doc) {
        try {
            String s = doc.getText(0, doc.getLength());
            this.selectString(s);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
    }

    public final void insertUpdate(DocumentEvent documentEvent) {
        this.selectString(documentEvent.getDocument());
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
        this.selectString(documentEvent.getDocument());
    }

    private boolean nameMatches(Node child, String component) {
        return child.getName().startsWith(component);
    }

    private boolean namesEqual(Node child, String component) {
        return child.getName().equals(component);
    }

    private Enumeration enumerateComponents(String s) {
        return new StringTokenizer(s, this.getDelimiter());
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void selectString(String sel) {
        Enumeration components = this.enumerateComponents(sel);
        Node context = this.getExplorerManager().getRootContext();
        Node found = null;
        boolean exact = false;
        String suffix = "";
        boolean ambiguous = false;
        System.err.println("begin search");
        while (components.hasMoreElements()) {
            String comp = (String)components.nextElement();
            Enumeration children = context.getChildren().nodes();
            int compLen = comp.length();
            found = null;
            exact = false;
            ambiguous = false;
            System.err.println("got component: " + comp);
            suffix = null;
            while (children.hasMoreElements()) {
                Node ch = (Node)children.nextElement();
                String childName = ch.getName();
                if (!this.nameMatches(ch, comp)) continue;
                if (found != null) {
                    ambiguous = true;
                }
                if (!exact) {
                    found = ch;
                }
                if (this.namesEqual(ch, comp)) {
                    exact = true;
                    suffix = "";
                    continue;
                }
                String childSuffix = childName.substring(compLen);
                suffix = suffix == null ? childSuffix : this.commonPrefix(suffix, childSuffix);
            }
            if (found == null || ambiguous && !exact) break;
            context = found;
        }
        if (found == null) {
            return;
        }
        if (exact || !ambiguous) {
            this.selectNode(found);
            if (sel.endsWith(this.getDelimiter())) {
                this.expandNode(found);
            }
        }
        JTextComponent textComp = this.getTextComponent();
        if ("".equals(suffix) || textComp == null) {
            return;
        }
        this.appendSelectedString(textComp, suffix);
    }

    private void expandNode(Node n) {
        this.getExplorerManager().setExploredContext(n);
    }

    private void selectNode(Node n) {
        try {
            try {
                this.disableExplorer = true;
                this.getExplorerManager().setSelectedNodes(new Node[]{n});
            }
            catch (PropertyVetoException ex) {
                Object var4_3 = null;
                this.disableExplorer = false;
            }
            Object var4_2 = null;
            this.disableExplorer = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.disableExplorer = false;
            throw throwable;
        }
    }

    private void appendSelectedString(final JTextComponent comp, final String suffix) {
        if ("".equals(suffix)) {
            return;
        }
        final Document doc = comp.getDocument();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Caret c = comp.getCaret();
                    int docLength = doc.getLength();
                    doc.insertString(docLength, suffix, null);
                    int newLength = doc.getLength();
                    c.setDot(newLength);
                    c.moveDot(docLength);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private String commonPrefix(String first, String second) {
        int l2;
        int l1 = first.length();
        int maxl = l1 > (l2 = second.length()) ? l2 : l1;
        int i = 0;
        while (i < maxl) {
            if (first.charAt(i) != second.charAt(i)) {
                return first.substring(0, i);
            }
            ++i;
        }
        return maxl == l1 ? first : second;
    }

    private void displayNodePath(Node target) {
        String[] path = NodeOp.createPath((Node)target, (Node)this.getExplorerManager().getRootContext());
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            if (i > 0) {
                sb.append(this.getDelimiter());
            }
            sb.append(path[i]);
            ++i;
        }
        JTextComponent txt = this.getTextComponent();
        if (txt != null) {
            Document d = txt.getDocument();
            try {
                d.remove(0, d.getLength());
                d.insertString(0, sb.toString(), null);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.disableExplorer) {
            return;
        }
        String evName = propertyChangeEvent.getPropertyName();
        if ("selectedNodes".equals(evName)) {
            Node[] selNodes = this.getExplorerManager().getSelectedNodes();
            if (selNodes.length == 0) {
                return;
            }
            this.displayNodePath(selNodes[0]);
        }
    }
}

