/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.java.comparators.JavaElementComparator;
import org.netbeans.modules.java.tools.MultiDataContainer;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ElementFormat;
import org.openide.src.SourceElement;
import org.openide.src.nodes.ClassElementNode;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListener;

public final class PackageNode
extends AbstractNode {
    private static final String PACKAGE_ICON_BASE = "org/netbeans/modules/java/resources/package";
    private static final ElementFormat CLASS_ELEMENT_FORMAT = new ElementFormat("{C}");
    private static final Comparator CLASS_NAME_COMPARATOR = JavaElementComparator.createClassComparator(false, new int[]{4});

    public PackageNode(String packName, MultiDataContainer container) {
        super((Children)new PackageChildren(container));
        this.setName(packName);
        this.setIconBase(PACKAGE_ICON_BASE);
    }

    private static class PackageChildren
    extends Children.Keys
    implements PropertyChangeListener {
        MultiDataContainer container;
        Collection classElements;
        Collection parsingSources;
        PropertyChangeListener weakListener;
        static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

        PackageChildren(MultiDataContainer cont) {
            this.container = cont;
            this.classElements = new TreeSet(CLASS_NAME_COMPARATOR);
            this.parsingSources = new LinkedList();
            this.weakListener = WeakListener.propertyChange((PropertyChangeListener)this, null);
            cont.addPropertyChangeListener(this.weakListener);
        }

        public void addNotify() {
            this.refreshData();
        }

        protected Node[] createNodes(Object key) {
            String name;
            MultiDataContainer cont;
            if (key instanceof ClassElement) {
                Node n = this.createClassNode((ClassElement)key);
                if (n != null) {
                    return new Node[]{n};
                }
            } else if (key instanceof String && (cont = this.getPackageContainer(name = (String)key)) != null) {
                return new Node[]{this.createPackageNode((String)key, cont)};
            }
            return new Node[0];
        }

        private void sortInClasses(ClassElement[] cls) {
            PackageChildren packageChildren = this;
            synchronized (packageChildren) {
                this.classElements.addAll(Arrays.asList(cls));
            }
            this.refreshKeys();
        }

        private void refreshKeys() {
            Set containers = this.container.getContainers().keySet();
            ArrayList keys = new ArrayList(containers.size() + this.classElements.size());
            keys.addAll(containers);
            PackageChildren packageChildren = this;
            synchronized (packageChildren) {
                keys.addAll(this.classElements);
            }
            this.setKeys(keys);
        }

        protected final Node createClassNode(ClassElement c) {
            ClassElementNode node = new ClassElementNode(c, Children.LEAF, true);
            node.setElementFormat(CLASS_ELEMENT_FORMAT);
            return node;
        }

        protected final Node createPackageNode(String name, MultiDataContainer data) {
            return new PackageNode(name, data);
        }

        private MultiDataContainer getPackageContainer(String name) {
            return (MultiDataContainer)this.container.getContainers().get(name);
        }

        private void refreshData() {
            DataObject[] contents = this.container.getChildren();
            ArrayList myChildren = new ArrayList(contents.length);
            ArrayList<ClassElement> newClassElements = new ArrayList<ClassElement>(contents.length);
            int i = 0;
            while (i < contents.length) {
                SourceElement src;
                DataObject d = contents[i];
                SourceCookie ck = (SourceCookie)d.getCookie(class$org$openide$cookies$SourceCookie == null ? PackageChildren.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                if (ck != null && this.parsingSources.add(src = ck.getSource())) {
                    src.addPropertyChangeListener(this.weakListener);
                    if (src.getStatus() == 0) {
                        PrepareL l = new PrepareL(d, src);
                        src.prepare().addTaskListener((TaskListener)l);
                    } else {
                        PackageChildren packageChildren = this;
                        synchronized (packageChildren) {
                            newClassElements.addAll(Arrays.asList(src.getAllClasses()));
                        }
                    }
                }
                ++i;
            }
            PackageChildren packageChildren = this;
            synchronized (packageChildren) {
                this.classElements = newClassElements;
            }
            this.refreshKeys();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            String propName = evt.getPropertyName();
            if (source == this.container) {
                if ("containers".equals(propName) || "children".equals(propName)) {
                    this.refreshData();
                }
            } else if ("allClasses".equals(evt.getPropertyName())) {
                this.refreshData();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class PrepareL
        implements TaskListener {
            DataObject sourceDO;
            SourceElement srcElement;

            PrepareL(DataObject source, SourceElement src) {
                this.sourceDO = source;
                this.srcElement = src;
            }

            public void taskFinished(Task t) {
                t.removeTaskListener((TaskListener)this);
                PackageChildren.this.sortInClasses(this.srcElement.getAllClasses());
            }
        }
    }
}

