/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Modifier;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;

public class AccessLevelPanel
extends JPanel {
    public static final String PROP_ACCESS_LEVEL = "accessLevel";
    private JComboBox accessCombo;
    private JLabel accessLabel;

    public AccessLevelPanel(int allowed, int mod) {
        this.initComponents();
        this.initAccessibility();
        this.setAllowedAccessLevel(allowed);
        this.setAccessLevel(mod);
        this.accessLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Access_Level_Mnemonic").charAt(0));
    }

    public void setAllowedAccessLevel(int mod) {
        this.accessCombo.addItem("<default>");
        if (Modifier.isPublic(mod)) {
            this.accessCombo.addItem("public");
        }
        if (Modifier.isPrivate(mod)) {
            this.accessCombo.addItem("private");
        }
        if (Modifier.isProtected(mod)) {
            this.accessCombo.addItem("protected");
        }
    }

    public void setAccessLevel(int mod) {
        String item = Modifier.toString(mod);
        this.accessCombo.setSelectedItem("".equals(item) ? "<default>" : item);
    }

    public int getAccessLevel() {
        return this.toBin(this.accessCombo.getSelectedItem());
    }

    private int toBin(Object mod) {
        if ("public".equals(mod)) {
            return 1;
        }
        if ("private".equals(mod)) {
            return 2;
        }
        if ("protected".equals(mod)) {
            return 4;
        }
        return 0;
    }

    private void initAccessibility() {
        this.accessLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Access_LevelA11yDesc"));
        this.accessCombo.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_Access_LevelComboBoxA11yName"));
    }

    private void initComponents() {
        this.accessLabel = new JLabel();
        this.accessCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.accessLabel.setText(JavaWizardIterator.getString("LBL_Access_Level"));
        this.accessLabel.setLabelFor(this.accessCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.accessLabel, gridBagConstraints);
        this.accessCombo.setToolTipText(JavaWizardIterator.getString("ACS_Access_LevelComboBoxA11yDesc"));
        this.accessCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AccessLevelPanel.this.changeAccessLevel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.accessCombo, gridBagConstraints);
    }

    private void changeAccessLevel(ItemEvent evt) {
        super.firePropertyChange(PROP_ACCESS_LEVEL, null, null);
    }
}

