/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.ui.wizard.AccessLevelPanel;
import org.netbeans.modules.java.ui.wizard.ClassTypePanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.ModifierEditor;
import org.netbeans.modules.java.ui.wizard.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import org.openide.util.HelpCtx;

public class ClassCustomizer
extends JPanel
implements PropertyChangeListener {
    private ClassElement clazz;
    private static final String[] COMMON_TYPES = new String[]{"java.lang.Object", "java.awt.Component", "javax.swing.JComponent", "javax.swing.JPanel"};
    private boolean superclassChangeWarning = false;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel packageLabel;
    private JTextField packageField;
    private JLabel classDeclarationLabel;
    private JTextField classDeclarationField;
    private JPanel leftPanel;
    private JLabel superClassLabel;
    private JComboBox superclassCombo;
    private JLabel interfacesLabel;
    private AccessLevelPanel accessLevelPanel;
    private ClassTypePanel classTypePanel;
    private PropertyPanel interfacesPanel;

    public ClassCustomizer(ClassElement clazz) {
        this.initComponents();
        this.initAccessibility();
        this.interfacesPanel = new PropertyPanel((Object)new ClassElement(), "interfaces", 4);
        this.interfacesPanel.setToolTipText(JavaWizardIterator.getString("HINT_ClassInterfaces"));
        this.interfacesLabel.setLabelFor((Component)this.interfacesPanel);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.fill = 2;
        this.leftPanel.add((Component)this.interfacesPanel, gridBagConstraints1);
        this.nameLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Class_Name_Mnemonic").charAt(0));
        this.packageLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Package_Mnemonic").charAt(0));
        this.superClassLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Superclass_Mnemonic").charAt(0));
        this.classDeclarationLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Class_Declaration_Mnemonic").charAt(0));
        this.interfacesLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Interfaces_Implemented_Mnemonic").charAt(0));
    }

    private void initAccessibility() {
        this.nameLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ClassNameA11yDesc"));
        this.nameField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_ClassNameTextFieldA11yName"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_PackageA11yDesc"));
        this.packageField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_PackageTextFieldA11yName"));
        this.classDeclarationLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Class_DeclarationA11yDesc"));
        this.classDeclarationField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_Class_DeclarationTextFieldA11yName"));
        this.superClassLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_SuperclassA11yDesc"));
        this.superclassCombo.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_SuperclassComboBoxA11yName"));
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageField = new JTextField();
        this.classDeclarationLabel = new JLabel();
        this.classDeclarationField = new JTextField();
        this.leftPanel = new JPanel();
        this.superClassLabel = new JLabel();
        this.superclassCombo = new JComboBox<String>(COMMON_TYPES);
        this.interfacesLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_InheritanceWizardPanel"));
        this.nameLabel.setText(JavaWizardIterator.getString("LBL_Name"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints1);
        this.nameField.setToolTipText(JavaWizardIterator.getString("ACS_ClassNameTextFieldA11yDesc"));
        this.nameField.setEditable(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.nameField, gridBagConstraints1);
        this.packageLabel.setText(JavaWizardIterator.getString("LBL_Package"));
        this.packageLabel.setLabelFor(this.packageField);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.packageLabel, gridBagConstraints1);
        this.packageField.setToolTipText(JavaWizardIterator.getString("ACS_PackageTextFieldA11yDesc"));
        this.packageField.setEditable(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.packageField, gridBagConstraints1);
        this.classDeclarationLabel.setText(JavaWizardIterator.getString("LBL_Class_Declaration"));
        this.classDeclarationLabel.setLabelFor(this.classDeclarationField);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.classDeclarationLabel, gridBagConstraints1);
        this.classDeclarationField.setToolTipText(JavaWizardIterator.getString("ACS_Class_DeclarationTextFieldA11yDesc"));
        this.classDeclarationField.setEditable(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.classDeclarationField, gridBagConstraints1);
        this.leftPanel.setLayout(new GridBagLayout());
        this.superClassLabel.setText(JavaWizardIterator.getString("LBL_Superclass"));
        this.superClassLabel.setLabelFor(this.superclassCombo);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints2.anchor = 17;
        this.leftPanel.add((Component)this.superClassLabel, gridBagConstraints2);
        this.superclassCombo.setToolTipText(JavaWizardIterator.getString("ACS_SuperclassComboBoxA11yDesc"));
        this.superclassCombo.setEditable(true);
        this.superclassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassCustomizer.this.superclassComboActionPerformed(evt);
            }
        });
        this.superclassCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ClassCustomizer.this.superclassComboFocusLost(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints2.weightx = 1.0;
        this.leftPanel.add((Component)this.superclassCombo, gridBagConstraints2);
        this.interfacesLabel.setText(JavaWizardIterator.getString("LBL_Interfaces_Implemented"));
        this.interfacesLabel.setLabelFor((Component)this.interfacesPanel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints2.anchor = 17;
        this.leftPanel.add((Component)this.interfacesLabel, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 11);
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.leftPanel, gridBagConstraints1);
    }

    private void superclassComboFocusLost(FocusEvent evt) {
        this.updateSuperclass();
    }

    private void superclassComboActionPerformed(ActionEvent evt) {
        this.updateSuperclass();
    }

    private void updateSuperclass() throws IllegalArgumentException {
        Identifier superid = this.clazz.getSuperclass();
        String oldValueStr = superid == null ? "" : superid.getFullName();
        Object selItem = this.superclassCombo.getSelectedItem();
        if (selItem == null) {
            this.superclassCombo.setSelectedItem(oldValueStr);
            return;
        }
        String newValueStr = selItem.toString();
        if (!this.superclassChangeWarning) {
            if (superid != null && ClassElement.ROOT_OBJECT.equals((Object)superid) && this.warnSuperclassChange()) {
                this.superclassCombo.setSelectedItem(superid);
                return;
            }
            this.superclassChangeWarning = true;
        }
        boolean ok = false;
        try {
            if (!oldValueStr.equals(newValueStr)) {
                if (!"".equals(newValueStr) && !Util.isValidTypeIdentifier(newValueStr)) {
                    String msg = MessageFormat.format(Util.getString("FMTERR_InvalidIdentifier"), newValueStr);
                    IllegalArgumentException iae = new IllegalArgumentException("Illegal superclass name");
                    ErrorManager.getDefault().annotate((Throwable)iae, 256, iae.getMessage(), msg, null, null);
                    ErrorManager.getDefault().notify((Throwable)iae);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ClassCustomizer.this.superclassCombo.requestFocus();
                        }
                    });
                } else {
                    try {
                        Identifier id = newValueStr.equals("") ? null : Identifier.create((String)newValueStr);
                        this.clazz.setSuperclass(id);
                        ok = true;
                    }
                    catch (SourceException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JavaWizardIterator.getString("ERR_InvalidClassIdentifier"), 0));
        }
        if (!ok) {
            this.superclassCombo.setSelectedItem(oldValueStr);
        }
    }

    private void updateClassDeclaration() {
        String qualifier = this.clazz.getName().isQualified() ? this.clazz.getName().getQualifier() : JavaWizardIterator.getString("TXT_DefaultPackageName");
        this.packageField.setText(qualifier);
        this.nameField.setText(this.clazz.getName().getSourceName());
        String sumText = Modifier.toString(this.clazz.getModifiers());
        if (sumText.length() > 0) {
            sumText = sumText + " ";
        }
        sumText = this.clazz.isClass() ? sumText + "class " : sumText + "interface ";
        sumText = sumText + this.clazz.getName();
        if (this.clazz.getSuperclass() != null) {
            sumText = sumText + " extends " + this.clazz.getSuperclass().getName();
        }
        if (this.clazz.getInterfaces().length > 0) {
            sumText = sumText + (this.clazz.isClass() ? " implements " : " extends ");
            sumText = sumText + this.interfacesPanel.getPropertyEditor().getAsText();
        }
        this.classDeclarationField.setText(sumText);
    }

    private boolean warnSuperclassChange() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("name".equals(propName) || "superclass".equals(propName) || "modifiers".equals(propName) || "interfaces".equals(propName)) {
            this.updateClassDeclaration();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.clazz != null) {
            this.clazz.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.clazz != null) {
            this.clazz.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void setObject(ClassElement clazz) {
        PropertyPanel modifPanel;
        PropertyEditor propEdit;
        if (this.clazz == clazz) {
            return;
        }
        if (this.clazz != null) {
            this.clazz.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.clazz = clazz;
        if (this.clazz != null) {
            this.clazz.addPropertyChangeListener((PropertyChangeListener)this);
            this.updateClassDeclaration();
        }
        this.superclassCombo.setEnabled(clazz.isClass());
        String superName = clazz.isInterface() || clazz.getSuperclass() == null ? "" : clazz.getSuperclass().getFullName();
        this.superclassCombo.setSelectedItem(superName);
        this.interfacesPanel.setModel((PropertyModel)new DefaultPropertyModel((Object)clazz, "interfaces"));
        this.interfacesPanel.setChangeImmediate(false);
        this.interfacesPanel.getPropertyEditor().setValue(clazz.getInterfaces());
        if (this.accessLevelPanel != null) {
            this.remove(this.accessLevelPanel);
        }
        if (this.classTypePanel != null) {
            this.remove(this.classTypePanel);
        }
        if ((propEdit = (modifPanel = new PropertyPanel((PropertyModel)new TempPropertyModel(clazz, "modifiers", clazz.isInterface()), 2)).getPropertyEditor()) instanceof ModifierEditor) {
            this.accessLevelPanel = ((ModifierEditor)propEdit).getAccessLevelPanel();
            this.classTypePanel = (ClassTypePanel)((ModifierEditor)propEdit).getModifierPanel();
        }
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.fill = 3;
        this.add((Component)this.classTypePanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        this.leftPanel.add((Component)this.accessLevelPanel, gridBagConstraints1);
    }

    public static class InterfaceModifierEditor
    extends ModifierEditor {
        public InterfaceModifierEditor() {
            super(new AccessLevelPanel(1, 0), new ClassTypePanel(true));
        }
    }

    public static class ClassModifierEditor
    extends ModifierEditor {
        public ClassModifierEditor() {
            super(new AccessLevelPanel(1, 0), new ClassTypePanel(false));
        }
    }

    static class TempPropertyModel
    extends DefaultPropertyModel {
        boolean inter;
        static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor;
        static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor;

        public TempPropertyModel(Object bean, String propertyName, boolean inter) throws IllegalArgumentException {
            super(bean, propertyName);
            this.inter = inter;
        }

        public Class getPropertyEditorClass() {
            Class clazz = this.inter ? (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor = TempPropertyModel.class$("org.netbeans.modules.java.ui.wizard.ClassCustomizer$InterfaceModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor) : (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor = TempPropertyModel.class$("org.netbeans.modules.java.ui.wizard.ClassCustomizer$ClassModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor);
            return clazz;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

