/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.wizard.ClassCustomizer;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class ClassPanel
extends JPanel
implements JavaPanel {
    private JavaWizardData wizardData;
    private ClassCustomizer classCustomizer;
    private JLabel headLabel;

    public void initialize(JavaWizardData data) {
        this.wizardData = data;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.initComponents();
        this.classCustomizer = new ClassCustomizer(this.wizardData.getCustomizedClass());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.classCustomizer, gridBagConstraints1);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_ClassPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ClassPanelA11yDesc"));
        this.headLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Basic_class_characteristicsA11yDesc"));
    }

    private void initComponents() {
        this.headLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_ImplementInterface"));
        this.headLabel.setText(JavaWizardIterator.getString("LBL_Basic_class_characteristics"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.headLabel, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        this.classCustomizer.setObject(this.wizardData.getCustomizedClass());
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.wizard.ClassProperties");
    }

    public void readSettings(Object settings) {
        if (settings instanceof TemplateWizard) {
            TemplateWizard wizardInstance = (TemplateWizard)settings;
            DataObject dobj = null;
            DataFolder target = null;
            try {
                target = wizardInstance.getTargetFolder();
                dobj = wizardInstance.getTemplate();
            }
            catch (IOException ex) {
                // empty catch block
            }
            String name = wizardInstance.getTargetName();
            if (dobj == null || target == null) {
                throw new IllegalStateException("Expected target folder & template, got null(s)");
            }
            String fullTarget = target.getPrimaryFile().getPackageNameExt('.', '.');
            if (!Util.isValidPackageName(fullTarget)) {
                String msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalFolderName"), target.getPrimaryFile().getPackageNameExt('/', '.'), fullTarget);
                throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Illegal folder name"), 256, null, msg, null, null);
            }
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)target.getPrimaryFile(), (String)dobj.getName(), (String)"java");
            } else if (!Utilities.isJavaIdentifier((String)name)) {
                String msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalTargetName"), name);
                throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Illegal target name"), 256, null, msg, null, null);
            }
            this.wizardData.setTemplate(dobj);
            this.wizardData.setTarget(target.getPrimaryFile(), name);
            this.classCustomizer.setObject(this.wizardData.getCustomizedClass());
        }
    }

    public void storeSettings(Object settings) {
    }

    public boolean isValid() {
        return true;
    }
}

