/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.AccessLevelPanel;
import org.netbeans.modules.java.ui.wizard.FieldTypePanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.ModifierEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.TypeEditor;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class FieldCustomizer
extends JPanel
implements Runnable {
    static final FieldElement EMPTY_ELEMENT = new FieldElement();
    private FieldElement field;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel typeLabel;
    private JPanel leftPanel;
    private JLabel initialLabel;
    private PropertyPanel modifPanel;
    private PropertyPanel initPanel;
    private PropertyPanel typePanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldTypeEditor;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldModifierEditor;

    public FieldCustomizer(FieldElement field) {
        this.field = field != null ? field : EMPTY_ELEMENT;
        this.initComponents();
        this.nameField.setText(this.field.getName().toString());
        this.nameField.setToolTipText(JavaWizardIterator.getString("ACS_FieldNameTextFieldA11yDesc"));
        this.typePanel = new PropertyPanel((PropertyModel)new TempPropertyModel(this.field, "type", class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldTypeEditor == null ? (class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldTypeEditor = FieldCustomizer.class$("org.netbeans.modules.java.ui.wizard.FieldCustomizer$FieldTypeEditor")) : class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldTypeEditor), 4);
        this.typeLabel.setLabelFor((Component)this.typePanel);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        this.leftPanel.add((Component)this.typePanel, gridBagConstraints1);
        this.initPanel = new PropertyPanel((Object)this.field, "initValue", 4);
        this.initialLabel.setLabelFor((Component)this.initPanel);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.leftPanel.add((Component)this.initPanel, gridBagConstraints1);
        this.modifPanel = new PropertyPanel((PropertyModel)new TempPropertyModel(this.field, "modifiers", class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldModifierEditor = FieldCustomizer.class$("org.netbeans.modules.java.ui.wizard.FieldCustomizer$FieldModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldModifierEditor), 2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.fill = 3;
        this.add((Component)this.modifPanel, gridBagConstraints1);
        this.initialLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Initial_Value_Mnemonic").charAt(0));
        this.typeLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Type_Mnemonic").charAt(0));
        this.nameLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Field_Name_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.nameLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_FieldNameA11yDesc"));
        this.nameField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_FieldNameTextFieldA11yName"));
        this.typeLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_FieldTypeA11yDesc"));
        this.initialLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_FieldInitial_ValueA11yDesc"));
    }

    private void initComponents() {
        this.leftPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.typeLabel = new JLabel();
        this.initialLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_AddFieldsWizardPanel"));
        this.leftPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText(JavaWizardIterator.getString("LBL_Name"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setToolTipText(JavaWizardIterator.getString("ACS_FieldNameTextFieldA11yDesc"));
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldCustomizer.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FieldCustomizer.this.nameFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.leftPanel.add((Component)this.nameField, gridBagConstraints);
        this.typeLabel.setText(JavaWizardIterator.getString("LBL_Type"));
        this.typeLabel.setLabelFor((Component)this.typePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.initialLabel.setText(JavaWizardIterator.getString("LBL_Initial_Value"));
        this.initialLabel.setLabelFor((Component)this.initPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.initialLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.leftPanel, gridBagConstraints);
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.changeName();
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        if (!evt.isTemporary()) {
            this.changeName();
        }
    }

    private void changeName() {
        if (this.field == EMPTY_ELEMENT) {
            return;
        }
        String newName = this.nameField.getText();
        String oldName = this.field.getName().toString();
        Throwable x = null;
        boolean ok = false;
        if (Utilities.isJavaIdentifier((String)newName)) {
            if (!oldName.equals(newName)) {
                Identifier id = Identifier.create((String)newName);
                try {
                    this.field.setName(id);
                    ok = true;
                }
                catch (SourceException e) {
                    x = e;
                }
            }
        } else {
            x = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate(x, 256, null, JavaWizardIterator.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        if (x != null) {
            ErrorManager.getDefault().notify(x);
        }
        if (!ok) {
            this.nameField.setText(oldName);
        }
    }

    public void setEnabled(boolean enable) {
        this.nameField.setEnabled(enable);
        this.modifPanel.setEnabled(enable);
        this.initPanel.setEnabled(enable);
        this.typePanel.setEnabled(enable);
        super.setEnabled(enable);
    }

    public void setObject(FieldElement field) {
        if (this.field == field) {
            return;
        }
        this.field = field != null ? field : EMPTY_ELEMENT;
        this.resetPanels();
        this.revalidate();
    }

    private void resetPanels() {
        this.nameField.setText(this.field.getName().toString());
        this.typePanel.setModel((PropertyModel)new TempPropertyModel(this.field, "type", class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldTypeEditor == null ? (class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldTypeEditor = FieldCustomizer.class$("org.netbeans.modules.java.ui.wizard.FieldCustomizer$FieldTypeEditor")) : class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldTypeEditor));
        this.initPanel.setModel((PropertyModel)new DefaultPropertyModel((Object)this.field, "initValue"));
        this.modifPanel.setModel((PropertyModel)new TempPropertyModel(this.field, "modifiers", class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldModifierEditor = FieldCustomizer.class$("org.netbeans.modules.java.ui.wizard.FieldCustomizer$FieldModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$FieldCustomizer$FieldModifierEditor));
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public Component getComponent() {
        return this;
    }

    void requestNameFocus() {
        int len = this.nameField.getText().length();
        this.nameField.setCaretPosition(0);
        this.nameField.moveCaretPosition(len);
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.nameField.requestFocus();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            EMPTY_ELEMENT.setType(Type.INT);
            EMPTY_ELEMENT.setModifiers(2);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    public static class FieldTypeEditor
    extends TypeEditor {
        public String[] getTags() {
            ArrayList<String> tags = new ArrayList<String>(Arrays.asList(super.getTags()));
            ((AbstractCollection)tags).remove("void");
            return tags.toArray(new String[tags.size()]);
        }
    }

    public static class FieldModifierEditor
    extends ModifierEditor {
        public FieldModifierEditor() {
            super(new AccessLevelPanel(7, 0), new FieldTypePanel());
        }
    }

    static class TempPropertyModel
    extends DefaultPropertyModel {
        Class editor;

        public TempPropertyModel(Object bean, String propertyName, Class editorClass) throws IllegalArgumentException {
            super(bean, propertyName);
            this.editor = editorClass;
        }

        public Class getPropertyEditorClass() {
            return this.editor;
        }
    }
}

